/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.seismic;

import gov.noaa.tsunami.cmt.seismic.Plane;
import gov.noaa.tsunami.cmt.seismic.Vector;
import gov.noaa.tsunami.cmt.view.Matrix;
import java.util.Arrays;
import java.util.Comparator;

public class Tensor {
    private static Comparator<Vector> eigenComparator = (v1, v2) -> -Double.compare(v1.eigenvalue(), v2.eigenvalue());
    private static final double _D2R = Math.PI / 180;
    private static final double _R2D = 57.29577951308232;
    private double mrr;
    private double mtt;
    private double mpp;
    private double mtp;
    private double mrp;
    private double mrt;
    private final Type type;
    private double moment;
    private double moment_log10;
    private double magnitude;
    private double Mw;
    public final Vector T;
    public final Vector N;
    public final Vector P;
    private Vector[] eigen = null;
    private Matrix matrix = null;
    private final Plane NP1;
    private final Plane NP2;

    public double getMrr() {
        return this.mrr;
    }

    public double getMtt() {
        return this.mtt;
    }

    public double getMpp() {
        return this.mpp;
    }

    public double getMtp() {
        return this.mtp;
    }

    public double getMrp() {
        return this.mrp;
    }

    public double getMrt() {
        return this.mrt;
    }

    public double getMw() {
        return this.Mw;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double magnitude) {
        this.magnitude = magnitude;
    }

    public Tensor(double mrr, double mtt, double mpp, double mtp, double mrp, double mrt, Type type) {
        this.mrr = mrr;
        this.mtt = mtt;
        this.mpp = mpp;
        this.mtp = mtp;
        this.mrp = mrp;
        this.mrt = mrt;
        this.type = type;
        this.moment = Math.sqrt(0.5 * (mrr * mrr + mtt * mtt + mpp * mpp + 2.0 * (mrt * mrt + mrp * mrp + mtp * mtp)));
        this.moment_log10 = Math.log(this.moment) / Math.log(10.0);
        this.magnitude = 0.6666666666666666 * (this.moment_log10 - 9.1);
        this.Mw = 0.6666666666666666 * this.moment_log10 - 10.7;
        this.matrix = new Matrix(new double[]{mtt, -mtp, mrt, -mtp, mpp, -mrp, mrt, -mrp, mrr}, 3, 3);
        this.eigen = this.matrix.jacobi(100);
        Arrays.sort(this.eigen, eigenComparator);
        this.T = this.eigen[0];
        this.N = this.eigen[1];
        this.P = this.eigen[2];
        Vector l = this.T.subtract(this.P).unit();
        Vector n = this.T.add(this.P).unit();
        this.NP1 = Tensor.calculatePlane(l, n);
        this.NP2 = Tensor.calculatePlane(n, l);
    }

    private static Plane calculatePlane(Vector v1in, Vector v2in) {
        Vector v1 = v1in.unit();
        Vector v2 = v2in.unit();
        if (v1.z() > 0.0) {
            v1 = v1.multiply(-1.0);
            v2 = v2.multiply(-1.0);
        }
        Vector zv = Vector.cross(v2, v1);
        return new Plane(Tensor.range(Math.atan2(-v1.x(), v1.y()), 0.0, Math.PI * 2) * 57.29577951308232, Math.acos(-v1.z()) * 57.29577951308232, Math.atan2(-v2.z(), zv.z()) * 57.29577951308232);
    }

    private static double range(double value, double min, double max) {
        double span = max - min;
        while (value < min) {
            value += span;
        }
        while (value >= max) {
            value -= span;
        }
        return value;
    }

    public static Tensor fromStrikeDipRake(double strike, double dip, double rake, double moment) {
        double s = strike * (Math.PI / 180);
        double ss = Math.sin(s);
        double cs = Math.cos(s);
        double s2s = Math.sin(2.0 * s);
        double c2s = Math.cos(2.0 * s);
        double d = dip * (Math.PI / 180);
        double sd = Math.sin(d);
        double cd = Math.cos(d);
        double s2d = Math.sin(2.0 * d);
        double c2d = Math.cos(2.0 * d);
        double r = (rake % 90.0 != 0.0 ? rake : rake + 1.0E-15) * (Math.PI / 180);
        double sr = Math.sin(r);
        double cr = Math.cos(r);
        double mxx = -1.0 * (sd * cr * s2s + s2d * sr * ss * ss);
        double mxy = sd * cr * c2s + s2d * sr * s2s * 0.5;
        double mxz = -1.0 * (cd * cr * cs + c2d * sr * ss);
        double myy = sd * cr * s2s - s2d * sr * cs * cs;
        double myz = -1.0 * (cd * cr * ss - c2d * sr * cs);
        double mzz = s2d * sr;
        return new Tensor(mzz * moment, mxx * moment, myy * moment, -mxy * moment, -myz * moment, mxz * moment, Type.UNKNOWN);
    }

    public Plane NP1() {
        return this.NP1;
    }

    public Plane NP2() {
        return this.NP2;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "Tensor [(mrr=" + this.mrr + ", mtt=" + this.mtt + ", mpp=" + this.mpp + ", mtp=" + this.mtp + ", mrp=" + this.mrp + ", mrt=" + this.mrt + ")\ntype=" + (Object)((Object)this.type) + "\nmoment=" + this.moment + "\nMw=" + this.Mw + "\nmagnitude=" + this.magnitude + "\nT=" + this.T + "\nN=" + this.N + "\nP=" + this.P + "\nNP1=" + this.NP1 + "\nNP2=" + this.NP2 + "]";
    }

    public static enum Type {
        ORIGIN,
        PHASE_DATA,
        MOMENT_TENSOR,
        FOCAL_MECHANISM,
        FINITE_FAULT,
        SCITECH_LINK,
        UNKNOWN;

    }
}

