/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.seismic;

public class Vector {
    private final double x;
    private final double y;
    private final double z;
    private final double eigenvalue;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.eigenvalue = Double.NaN;
    }

    public Vector(double x, double y, double z, double ev) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.eigenvalue = ev;
    }

    public static Vector add(Vector v1, Vector v2) {
        return new Vector(v1.x + v2.x, v1.y + v2.y, v1.z + v2.z);
    }

    public Vector add(Vector v2) {
        return Vector.add(this, v2);
    }

    public static double angle(Vector v1, Vector v2) {
        return Math.acos(Vector.dot(v1, v2) / (v1.magnitude() * v2.magnitude()));
    }

    public double azimuth() {
        return this.x == 0.0 && this.y == 0.0 ? 0.0 : 1.5707963267948966 - Math.atan2(this.y, this.x);
    }

    public static Vector cross(Vector v1, Vector v2) {
        return new Vector(v1.y * v2.z - v2.y * v1.z, v1.z * v2.x - v2.z * v1.x, v1.x * v2.y - v2.x * v1.y);
    }

    public static double dot(Vector v1, Vector v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public double dot(Vector v2) {
        return Vector.dot(this, v2);
    }

    public static boolean equals(Vector v1, Vector v2) {
        return v1.x == v2.x && v1.y == v2.y && v1.z == v2.z;
    }

    public boolean equals(Object o) {
        return o instanceof Vector && Vector.equals(this, (Vector)o);
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector multiply(double n) {
        return new Vector(this.x * n, this.y * n, this.z * n);
    }

    public double plunge() {
        return Math.asin(this.z / this.magnitude());
    }

    public Vector rotate(Vector axis, double theta, Vector origin) {
        double a = origin.x;
        double b = origin.y;
        double c = origin.z;
        double u = axis.x;
        double v = axis.y;
        double w = axis.z;
        double cosT = Math.cos(theta);
        double sinT = Math.sin(theta);
        double au = a * u;
        double av = a * v;
        double aw = a * w;
        double bu = b * u;
        double bv = b * v;
        double bw = b * w;
        double cu = c * u;
        double cv = c * v;
        double cw = c * w;
        double uu = u * u;
        double ux = u * this.x;
        double uy = u * this.y;
        double uz = u * this.z;
        double vv = v * v;
        double vx = v * this.x;
        double vy = v * this.y;
        double vz = v * this.z;
        double ww = w * w;
        double wx = w * this.x;
        double wy = w * this.y;
        double wz = w * this.z;
        return new Vector((a * (vv + ww) - u * (bv + cw - ux - vy - wz)) * (1.0 - cosT) + this.x * cosT + (-cv + bw - wy + vz) * sinT, (b * (uu + ww) - v * (au + cw - ux - vy - wz)) * (1.0 - cosT) + this.y * cosT + (cu - aw + wx - uz) * sinT, (c * (uu + vv) - w * (au + bv - ux - vy - wz)) * (1.0 - cosT) + this.z * cosT + (-bu + av - vx + uy) * sinT);
    }

    public static Vector subtract(Vector v1, Vector v2) {
        return new Vector(v1.x - v2.x, v1.y - v2.y, v1.z - v2.z);
    }

    public Vector subtract(Vector v2) {
        return Vector.subtract(this, v2);
    }

    public Vector unit() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            throw new IllegalStateException("unit: cannot convert zero vector to unit vector");
        }
        return this.multiply(1.0 / mag);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double eigenvalue() {
        return this.eigenvalue;
    }

    public int hashCode() {
        return Double.hashCode(this.x) ^ Double.hashCode(this.y) ^ Double.hashCode(this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

