/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.view;

import gov.noaa.tsunami.cmt.seismic.Plane;
import gov.noaa.tsunami.cmt.seismic.Tensor;
import gov.noaa.tsunami.cmt.seismic.Vector;
import gov.noaa.tsunami.cmt.view.Canvas;
import gov.noaa.tsunami.cmt.view.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BeachBallView {
    final Options options;
    private static final double D2R = Math.PI / 180;
    private static final double EPSILON = 1.0E-16;
    private static final double MERGE_THRESHOLD = 0.02;
    private static final double SPLIT_THRESHOLD = 1.4835298641951802;

    public BeachBallView(Options opt) {
        this.options = opt;
    }

    private static double zeroTo2Pi(double value) {
        double twoPi = Math.PI * 2;
        while (value < 0.0) {
            value += twoPi;
        }
        while (value >= twoPi) {
            value -= twoPi;
        }
        return value;
    }

    private static AxisCache axisCache(Vector axis) {
        double azimuth = 1.5707963267948966 - axis.azimuth();
        double plunge = axis.plunge();
        if (plunge < 0.0) {
            plunge *= -1.0;
            azimuth += Math.PI;
        }
        azimuth = BeachBallView.zeroTo2Pi(azimuth);
        return new AxisCache(axis.eigenvalue(), azimuth, Math.cos(azimuth), Math.sin(azimuth), plunge, Math.cos(plunge), Math.sin(plunge));
    }

    private static Polygon completePolygon(Polygon polygon) {
        if (polygon.x.size() == 360) {
            return polygon;
        }
        double az1 = polygon.startAz.az;
        double az2 = polygon.endAz.az;
        ArrayList<Double> x = polygon.x;
        ArrayList<Double> y = polygon.y;
        if (az1 - az2 > Math.PI) {
            az1 -= Math.PI * 2;
        }
        if (az2 - az1 > Math.PI) {
            az1 += Math.PI * 2;
        }
        if (az1 < az2) {
            for (double az = az2 - Math.PI / 180; az > az1; az -= Math.PI / 180) {
                x.add(Math.sin(az));
                y.add(Math.cos(az));
            }
        } else {
            for (double az = az2 + Math.PI / 180; az < az1; az += Math.PI / 180) {
                x.add(Math.sin(az));
                y.add(Math.cos(az));
            }
        }
        return polygon;
    }

    private static final double orEpsilon(double v) {
        return Double.isFinite(v) && v != 0.0 ? v : 1.0E-16;
    }

    private static PolyList getPolygons(Tensor tensor) {
        AxisCache t = BeachBallView.axisCache(tensor.T);
        AxisCache n = BeachBallView.axisCache(tensor.N);
        AxisCache p = BeachBallView.axisCache(tensor.P);
        ArrayList<Az> azes = new ArrayList<Az>();
        PolyList polygons = new PolyList();
        double vi = (t.v + n.v + p.v) / 3.0;
        t.v -= vi;
        n.v -= vi;
        p.v -= vi;
        double f = BeachBallView.orEpsilon(-n.v / t.v);
        double iso = BeachBallView.orEpsilon(vi / t.v);
        boolean swapColors = false;
        for (int i = 0; i < 360; ++i) {
            double fir = (double)i * (Math.PI / 180);
            double sfi = Math.sin(fir);
            double cfi = Math.cos(fir);
            double s2alphan = (2.0 + 2.0 * iso) / (3.0 + (1.0 - 2.0 * f) * Math.cos(2.0 * fir));
            if (Math.abs(1.0 - s2alphan) <= 1.0E-16) {
                s2alphan = 1.0;
            }
            if (s2alphan > 1.0) {
                AxisCache tmp = t;
                t = p;
                p = tmp;
                swapColors = !swapColors;
                f = BeachBallView.orEpsilon(-n.v / t.v);
                iso = BeachBallView.orEpsilon(vi / t.v);
                s2alphan = (2.0 + 2.0 * iso) / (3.0 + (1.0 - 2.0 * f) * Math.cos(2.0 * fir));
            }
            double alphan = Math.asin(Math.sqrt(s2alphan));
            double s = Math.sin(alphan);
            double c = Math.cos(alphan);
            double xz = c * t.sp + s * sfi * n.sp + s * cfi * p.sp;
            double xn = c * t.cp * t.ca + s * sfi * n.cp * n.ca + s * cfi * p.cp * p.ca;
            double xe = c * t.cp * t.sa + s * sfi * n.cp * n.sa + s * cfi * p.cp * p.sa;
            double az = 0.0;
            double takeoff = 0.0;
            if (Math.abs(xn) < 1.0E-16 && Math.abs(xe) < 1.0E-16) {
                az = 0.0;
                takeoff = 0.0;
            } else {
                az = BeachBallView.zeroTo2Pi(Math.atan2(xe, xn));
                takeoff = Math.acos(xz / Math.sqrt(xz * xz + xn * xn + xe * xe));
                if (takeoff > 1.5707963267948966) {
                    az = BeachBallView.zeroTo2Pi(az + Math.PI);
                    takeoff = Math.PI - takeoff;
                }
            }
            azes.add(new Az(az, takeoff));
        }
        Polygon polygon = null;
        for (int i = 0; i < azes.size(); ++i) {
            Az az = (Az)azes.get(i);
            double r = Math.sqrt(2.0) * Math.sin(az.takeoff / 2.0);
            double x = r * Math.sin(az.az);
            double y = r * Math.cos(az.az);
            if (polygon != null) {
                Az azp = (Az)azes.get(i == 0 ? azes.size() - 1 : i - 1);
                if (Math.abs(Math.abs(az.az - azp.az) - Math.PI) < 0.17453292519943295 && az.takeoff > 1.4835298641951802 && azp.takeoff > 1.4835298641951802 && polygon != null) {
                    polygon.endAz = azp;
                    polygons.add(polygon);
                    polygon = null;
                }
            }
            if (polygon == null) {
                polygon = new Polygon();
                polygon.startAz = az;
            }
            polygon.x.add(x);
            polygon.y.add(y);
        }
        polygon.endAz = (Az)azes.get(azes.size() - 1);
        polygons.add(polygon);
        polygons = BeachBallView.mergePolygons(polygons);
        polygons.forEach(BeachBallView::completePolygon);
        polygons.swapColors = swapColors;
        return polygons;
    }

    private static PolyList mergePolygons(PolyList polygons) {
        if (polygons.size() == 1) {
            return polygons;
        }
        for (int i = 0; i < polygons.size(); ++i) {
            int nextI = i == polygons.size() - 1 ? 0 : i + 1;
            Polygon p1 = (Polygon)polygons.get(i);
            ArrayList<Double> p1x = p1.x;
            ArrayList<Double> p1y = p1.y;
            Polygon p2 = (Polygon)polygons.get(nextI);
            ArrayList<Double> p2x = p2.x;
            ArrayList<Double> p2y = p2.y;
            if (!(Math.abs(p1x.get(p1x.size() - 1) - p2x.get(0)) < 0.02) || !(Math.abs(p1y.get(p1y.size() - 1) - p2y.get(0)) < 0.02)) continue;
            p1x.addAll(p2x);
            p1y.addAll(p2y);
            p1.endAz = p2.endAz;
            polygons.remove(nextI);
        }
        return polygons;
    }

    public void render(Canvas canvas, Tensor tensor) {
        BeachBallView.render(canvas, tensor, this.options);
    }

    public static void render(Canvas canvas, Tensor tensor, Options optx) {
        canvas.clear();
        final Options opt1 = optx;
        ArrayList azimuthLabels = new ArrayList();
        if (opt1.isLabelPlanes()) {
            Arrays.asList(tensor.NP1(), tensor.NP2()).forEach(np -> {
                final double azimuth = np.strike() * (Math.PI / 180);
                final String text = "(" + String.format("%.0f", np.strike()) + ", " + String.format("%.0f", np.dip()) + ", " + String.format("%.0f", np.rake()) + ")";
                azimuthLabels.add(new HashMap<String, Object>(){
                    private static final long serialVersionUID = 8271322233850813020L;
                    {
                        this.put("azimuth", azimuth);
                        this.put("font", opt1.getLabelPlanesFont());
                        this.put("text", text);
                    }
                });
            });
        }
        Options opt2 = opt1;
        for (Map l2 : azimuthLabels) {
            opt2 = BeachBallView.makeRoomForAzimuthLabel(canvas, l2, opt2);
        }
        PolyList polygons = BeachBallView.getPolygons(tensor);
        if (polygons.swapColors) {
            Color tmp = opt2.getBgColor();
            opt2 = opt2.withBgColor(opt2.getFillColor());
            opt2 = opt2.withFillColor(tmp);
        }
        Options options = opt2;
        double x = options.projectX(0.0);
        double y = options.projectY(0.0);
        canvas.circle(x, y, options.getRadius() * 2.0, options.getLineColor(), options.getBgColor());
        polygons.forEach(p -> canvas.polygon(p.x.stream().mapToDouble(v -> options.projectX((double)v)).toArray(), p.y.stream().mapToDouble(v -> options.projectY((double)v)).toArray(), options.getLineColor(), options.getFillColor()));
        if (options.isPlotPlanes()) {
            Arrays.asList(tensor.NP1(), tensor.NP2()).forEach(np -> {
                Line line = BeachBallView.getPlaneLine(np);
                canvas.line(line.x.stream().mapToDouble(v -> options.projectX((double)v)).toArray(), line.y.stream().mapToDouble(v -> options.projectY((double)v)).toArray(), options.getLineColor());
            });
        }
        canvas.circle(x, y, options.getRadius() * 2.0, options.getLineColor(), null);
        if (options.isLabelAxes()) {
            BeachBallView.labelAxis(canvas, tensor.P, "P", options);
            BeachBallView.labelAxis(canvas, tensor.T, "T", options);
        }
        if (options.isPlotAxes()) {
            Point point = BeachBallView.getVectorPoint(tensor.P);
            canvas.circle(options.projectX(point.x), options.projectY(point.y), options.getAxisSize(), Color.WHITE, Color.BLACK);
            point = BeachBallView.getVectorPoint(tensor.T);
            canvas.circle(options.projectX(point.x), options.projectY(point.y), options.getAxisSize(), Color.BLACK, Color.WHITE);
        }
        azimuthLabels.forEach(l -> BeachBallView.labelAzimuth(canvas, l, options));
    }

    private static void labelAxis(Canvas canvas, Vector axis, String text, Options options) {
        Point point = BeachBallView.getVectorPoint(axis);
        canvas.text(text, options.getLabelAxesFont(), options.projectX(point.x), options.projectY(point.y), null, Color.BLACK, "center");
    }

    private static void labelAzimuth(Canvas canvas, Map<String, Object> label, Options options) {
        if (!label.containsKey("size")) {
            label = BeachBallView.computeAzimuthLabel(canvas, label, options);
        }
        Line tick = (Line)label.get("tick");
        canvas.line(tick.x.stream().mapToDouble(v -> options.projectX((double)v)).toArray(), tick.y.stream().mapToDouble(v -> options.projectY((double)v)).toArray(), Color.BLACK);
        canvas.text((String)label.get("text"), (Font)label.get("font"), options.projectX((Double)label.get("x")), options.projectY((Double)label.get("y")), null, Color.BLACK, (String)label.get("align"));
    }

    private static Map<String, Object> computeAzimuthLabel(Canvas canvas, Map<String, Object> label, Options options) {
        Point point = BeachBallView.getPoint((Double)label.get("azimuth"), 0.0);
        double x = point.x;
        double y = point.y;
        String align = x < 0.0 ? "right" : "left";
        Rectangle2D size = canvas.measureText((String)label.get("text"), (Font)label.get("font"));
        double labelOffset = (options.getRadius() + 10.0) / options.getRadius();
        double tickLength = (options.getRadius() + 5.0) / options.getRadius();
        label.put("align", align);
        label.put("size", size);
        label.put("tick", new Line(new double[]{x, x * tickLength}, new double[]{y, y * tickLength}));
        label.put("x", x * labelOffset);
        label.put("y", y * labelOffset);
        if (y < 0.0) {
            label.put("y", y * (options.getRadius() + 10.0 + Math.abs(y) * size.getHeight() / 2.0) / options.getRadius());
        }
        return label;
    }

    private static Options makeRoomForAzimuthLabel(Canvas canvas, Map<String, Object> l, Options opt) {
        Options options = opt;
        Map<String, Object> label = l;
        if (!label.containsKey("size")) {
            label = BeachBallView.computeAzimuthLabel(canvas, label, options);
        }
        double x = options.projectX((Double)label.get("x"));
        double y = options.projectY((Double)label.get("y"));
        Rectangle2D size = (Rectangle2D)label.get("size");
        double bottom = 0.0;
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        bottom = y - size.getHeight();
        top = y + size.getHeight();
        if (label.get("align").equals("left")) {
            left = x;
            right = x + size.getWidth();
        } else {
            left = x - size.getWidth();
            right = x;
        }
        bottom = bottom < 0.0 ? Math.abs(bottom) : 0.0;
        top = top > options.getHeight() ? (top -= options.getHeight()) : 0.0;
        left = left < 0.0 ? Math.abs(left) : 0.0;
        right = right > options.getWidth() ? (right -= options.getWidth()) : 0.0;
        options = options.withWidth(options.getWidth() + left + right);
        options = options.withX0(options.getX0() + left);
        options = options.withHeight(options.getHeight() + top + bottom);
        options = options.withY0(options.getY0() + top);
        return options;
    }

    private static Point getVectorPoint(Vector vector) {
        return BeachBallView.getPoint(1.5707963267948966 - vector.azimuth(), vector.plunge());
    }

    private static Point getPoint(double azimuth, double plunge) {
        double az = azimuth;
        double p = plunge;
        if (p < 0.0) {
            p *= -1.0;
            az += Math.PI;
        }
        az = BeachBallView.zeroTo2Pi(az);
        double r = Math.sqrt(1.0 - Math.sin(p));
        return new Point(r * Math.sin(az), r * Math.cos(az));
    }

    private static Line getPlaneLine(Plane np) {
        boolean vertical;
        double strike = np.strike() * (Math.PI / 180);
        double dip = np.dip() * (Math.PI / 180);
        ArrayList<Double> x = new ArrayList<Double>();
        ArrayList<Double> y = new ArrayList<Double>();
        boolean bl = vertical = Math.abs(dip - 1.5707963267948966) < 1.0E-16;
        if (vertical) {
            x.add(Math.sin(strike));
            x.add(Math.sin(strike + Math.PI));
            y.add(Math.cos(strike));
            y.add(Math.cos(strike + Math.PI));
        } else {
            double tanDip = Math.tan(dip);
            int count = 0;
            double j = 1.7453292519943296E-5;
            while (j <= Math.PI) {
                dip = Math.atan(tanDip * Math.sin(j));
                Point point = BeachBallView.getPoint(strike + j, dip);
                x.add(point.x);
                y.add(point.y);
                j = (double)(++count) * (Math.PI / 180);
            }
        }
        return new Line(x, y);
    }

    private static class PolyList
    extends ArrayList<Polygon> {
        private static final long serialVersionUID = -2377675737326210154L;
        boolean swapColors = false;

        private PolyList() {
        }
    }

    private static class Az {
        final double az;
        final double takeoff;

        private Az(double az, double takeoff) {
            this.az = az;
            this.takeoff = takeoff;
        }
    }

    private static class Point {
        final double x;
        final double y;

        private Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Polygon {
        ArrayList<Double> x = new ArrayList();
        ArrayList<Double> y = new ArrayList();
        Az startAz;
        Az endAz;

        private Polygon() {
        }
    }

    private static class Line {
        final ArrayList<Double> x;
        final ArrayList<Double> y;

        private Line(double[] x, double[] y) {
            this(Arrays.stream(x).mapToObj(d -> d).collect(Collectors.toList()), Arrays.stream(y).mapToObj(d -> d).collect(Collectors.toList()));
        }

        private Line(List<Double> x, List<Double> y) {
            this.x = new ArrayList<Double>(x);
            this.y = new ArrayList<Double>(y);
        }
    }

    private static class AxisCache {
        double v;
        final double ca;
        final double sa;
        final double cp;
        final double sp;

        private AxisCache(double v, double a, double ca, double sa, double p, double cp, double sp) {
            this.v = v;
            this.ca = ca;
            this.sa = sa;
            this.cp = cp;
            this.sp = sp;
        }
    }
}

