/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class Canvas {
    private final Graphics2D graphics;
    int polycount = 0;

    public Canvas(Graphics2D g) {
        this.graphics = g;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_GASP);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public void clear() {
    }

    public void circle(double x, double y, double d, Color lineColor) {
        this.circle(x, y, d, lineColor, null);
    }

    public void line(double[] x, double[] y, Color lineColor) {
        Path2D.Double gp = new Path2D.Double();
        gp.moveTo(x[0], y[0]);
        for (int i = 1; i < x.length; ++i) {
            gp.lineTo(x[i], y[i]);
        }
        this.graphics.setColor(lineColor);
        this.graphics.draw(gp);
    }

    public void circle(double x, double y, double axisSize, Color lineColor, Color fill) {
        if (fill != null) {
            this.graphics.setColor(fill);
            this.graphics.fillArc((int)(x - axisSize / 2.0), (int)(y - axisSize / 2.0), (int)axisSize, (int)axisSize, 0, 360);
        }
        if (lineColor != null) {
            this.graphics.setColor(lineColor);
            this.graphics.drawArc((int)(x - axisSize / 2.0), (int)(y - axisSize / 2.0), (int)axisSize, (int)axisSize, 0, 360);
        }
    }

    public void polygon(double[] x, double[] y, Color lineColor, Color fillColor) {
        if (this.polycount != 0) {
            ++this.polycount;
            return;
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x[0], y[0]);
        for (int i = 1; i < x.length; ++i) {
            gp.lineTo(x[i], y[i]);
        }
        gp.closePath();
        if (fillColor != null) {
            this.graphics.setColor(fillColor);
            this.graphics.fill(gp);
        }
        if (lineColor != null) {
            this.graphics.setColor(lineColor);
            this.graphics.draw(gp);
        }
    }

    public void text(String text, Font labelAxesFont, double x, double y, Color color, Color textColor, String string) {
        this.graphics.setFont(labelAxesFont);
        Rectangle2D m = this.measureText(text, labelAxesFont);
        double tx = x;
        switch (string) {
            case "center": {
                tx = x - m.getWidth() / 2.0;
                break;
            }
            case "right": {
                tx = x - m.getWidth();
                break;
            }
            default: {
                tx = x;
            }
        }
        this.graphics.setColor(textColor);
        this.graphics.drawString(text, (int)tx, (int)y);
    }

    public Rectangle2D measureText(String text, Font labelAxesFont) {
        return this.graphics.getFontMetrics(labelAxesFont).getStringBounds(text, this.graphics);
    }
}

