/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.view;

import gov.noaa.tsunami.cmt.seismic.Vector;
import java.util.ArrayList;

public class Matrix {
    private final double[] data;
    private final int m;
    private final int n;

    public Matrix(double[] data, int m, int n) {
        this.data = data;
        this.m = m;
        this.n = n;
    }

    private static double[] col(double[] data, int m, int n, int col) {
        double[] values = new double[m];
        if (col < 0 || col >= n) {
            throw new Error("column " + col + " out of range [0," + n + ")");
        }
        if (n == 1) {
            return (double[])data.clone();
        }
        for (int row = 0; row < m; ++row) {
            values[row] = data[Matrix.index(m, n, row, col)];
        }
        return values;
    }

    public double[] col(int col) {
        return Matrix.col(this.data, this.m, this.n, col);
    }

    public double[] diagonal() {
        int len = Math.min(this.m, this.n);
        double[] diag = new double[len];
        for (int i = 0; i < len; ++i) {
            diag[i] = this.data[Matrix.index(this.m, this.n, i, i)];
        }
        return diag;
    }

    public double get(int row, int col) {
        return this.data[Matrix.index(this.m, this.n, row, col)];
    }

    public static Matrix identity(int n) {
        double[] values = new double[n * n];
        int count = 0;
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < n; ++col) {
                values[count++] = row == col ? 1 : 0;
            }
        }
        return new Matrix(values, n, n);
    }

    private static int index(int m, int n, int row, int col) {
        return n * row + col;
    }

    public Vector[] jacobi(int maxRotations) {
        boolean changed;
        Matrix v = null;
        double[] e = null;
        if (this.m != this.n) {
            throw new Error("Jacobi only works on symmetric, square matrices");
        }
        double[] a = (double[])this.data.clone();
        e = this.diagonal();
        v = Matrix.identity(this.n);
        double rotations = 0.0;
        do {
            changed = false;
            for (int p = 0; p < this.n; ++p) {
                for (int q = p + 1; q < this.n; ++q) {
                    double api;
                    int pi;
                    double aiq;
                    int iq;
                    int ip;
                    int i;
                    double app = e[p];
                    double aqq = e[q];
                    double apq = a[this.n * p + q];
                    double phi = 0.5 * Math.atan2(2.0 * apq, aqq - app);
                    double c = Math.cos(phi);
                    double s = Math.sin(phi);
                    double app1 = c * c * app - 2.0 * s * c * apq + s * s * aqq;
                    double aqq1 = s * s * app + 2.0 * s * c * apq + c * c * aqq;
                    if (app1 == app && aqq1 == aqq) continue;
                    changed = true;
                    rotations += 1.0;
                    e[p] = app1;
                    e[q] = aqq1;
                    a[this.n * p + q] = 0.0;
                    for (i = 0; i < p; ++i) {
                        ip = this.n * i + p;
                        iq = this.n * i + q;
                        double aip = a[ip];
                        aiq = a[iq];
                        a[ip] = c * aip - s * aiq;
                        a[iq] = c * aiq + s * aip;
                    }
                    for (i = p + 1; i < q; ++i) {
                        pi = this.n * p + i;
                        iq = this.n * i + q;
                        api = a[pi];
                        aiq = a[iq];
                        a[pi] = c * api - s * aiq;
                        a[iq] = c * aiq + s * api;
                    }
                    for (i = q + 1; i < this.n; ++i) {
                        pi = this.n * p + i;
                        int qi = this.n * q + i;
                        api = a[pi];
                        double aqi = a[qi];
                        a[pi] = c * api - s * aqi;
                        a[qi] = c * aqi + s * api;
                    }
                    for (i = 0; i < this.n; ++i) {
                        ip = this.n * i + p;
                        iq = this.n * i + q;
                        double vip = v.data[ip];
                        double viq = v.data[iq];
                        v.data[ip] = c * vip - s * viq;
                        v.data[iq] = c * viq + s * vip;
                    }
                }
            }
        } while (changed && rotations < (double)maxRotations);
        if (changed) {
            throw new Error("failed to converge");
        }
        ArrayList<Vector> vectors = new ArrayList<Vector>();
        for (int i = 0; i < this.n; ++i) {
            double[] col = Matrix.col(v.data, this.m, this.n, i);
            vectors.add(new Vector(col[0], col[1], col[2], e[i]));
        }
        return vectors.toArray(new Vector[vectors.size()]);
    }

    private static double[] row(double[] data, int m, int n, int row) {
        double[] values = new double[n];
        if (row < 0 || row >= m) {
            throw new Error("row " + row + " out of range [0," + m + ")");
        }
        int count = 0;
        for (int col = 0; col < n; ++col) {
            values[count++] = data[Matrix.index(m, n, row, col)];
        }
        return values;
    }

    public double[] row(int row) {
        return Matrix.row(this.data, this.m, this.n, row);
    }

    public String toString() {
        int lastRow = this.m - 1;
        int lastCol = this.n - 1;
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        for (int row = 0; row < this.m; ++row) {
            for (int col = 0; col < this.n; ++col) {
                buf.append(this.data[this.n * row + col]).append(col != lastCol || row != lastRow ? ", " : "");
            }
            if (row == lastRow) continue;
            buf.append("\n ");
        }
        buf.append("]");
        return buf.toString();
    }

    public Matrix transpose() {
        double[] values = new double[this.data.length];
        int count = 0;
        for (int col = 0; col < this.n; ++col) {
            for (int row = 0; row < this.m; ++row) {
                values[count++] = this.data[Matrix.index(this.m, this.n, row, col)];
            }
        }
        return new Matrix(values, this.n, this.m);
    }
}

