/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmt.view;

import java.awt.Color;
import java.awt.Font;

public class Options {
    private final double axisSize;
    private final Color bgColor;
    private final Color fillColor;
    private final double height;
    private final boolean labelAxes;
    private final Font labelAxesFont;
    private final boolean labelPlanes;
    private final Font labelPlanesFont;
    private final Color lineColor;
    private final double lineWidth;
    private final boolean plotAxes;
    private final boolean plotPlanes;
    private final int size;
    private final double width;
    private final double x0;
    private final double y0;

    private Options() {
        this(0.0, new Color(255, 255, 255), new Color(113, 170, 252), true, new Font("SansSerif", 0, 24), true, new Font("SansSerif", 0, 14), Color.BLACK, 0.25, true, true, 240, 0.0, 0.0, 0.0, 0.0);
    }

    public Options(double axisSize, Color bgColor, Color fillColor, boolean labelAxes, Font labelAxesFont, boolean labelPlanes, Font labelPlanesFont, Color lineColor, double lineWidth, boolean plotAxes, boolean plotPlanes, int size, double height, double width, double x0, double y0) {
        this.axisSize = axisSize;
        this.bgColor = bgColor;
        this.fillColor = fillColor;
        this.height = height;
        this.labelAxes = labelAxes;
        this.labelAxesFont = labelAxesFont;
        this.labelPlanes = labelPlanes;
        this.labelPlanesFont = labelPlanesFont;
        this.lineColor = lineColor;
        this.lineWidth = lineWidth;
        this.plotAxes = plotAxes;
        this.plotPlanes = plotPlanes;
        this.size = size;
        this.width = width;
        this.x0 = x0;
        this.y0 = y0;
    }

    private static double truthyOr(double v, double o) {
        return Options.truthy(v) ? v : o;
    }

    private static boolean truthy(double v) {
        return Double.isFinite(v) && v != 0.0;
    }

    public static Options defaults() {
        return new Options();
    }

    public String toString() {
        return "Options [axisSize=" + this.axisSize + ",\n bgColor=" + this.bgColor + ",\n fillColor=" + this.fillColor + ",\n height=" + this.height + ",\n labelAxes=" + this.labelAxes + ",\n labelAxesFont=" + this.labelAxesFont + ",\n labelPlanes=" + this.labelPlanes + ",\n labelPlanesFont=" + this.labelPlanesFont + ",\n lineColor=" + this.lineColor + ",\n lineWidth=" + this.lineWidth + ",\n plotAxes=" + this.plotAxes + ",\n plotPlanes=" + this.plotPlanes + ",\n size=" + this.size + ",\n width=" + this.width + ",\n x0=" + this.x0 + ",\n y0=" + this.y0 + "]";
    }

    public double projectX(double x) {
        return this.getX0() + this.getRadius() * x;
    }

    public double projectY(double y) {
        return this.getHeight() - (this.getY0() + this.getRadius() * y);
    }

    public double getAxisSize() {
        return Options.truthyOr(this.axisSize, (int)(this.getRadius() / 12.5));
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public double getHeight() {
        return Options.truthyOr(this.height, this.size);
    }

    public boolean isLabelAxes() {
        return this.labelAxes;
    }

    public Font getLabelAxesFont() {
        return this.labelAxesFont;
    }

    public boolean isLabelPlanes() {
        return this.labelPlanes;
    }

    public Font getLabelPlanesFont() {
        return this.labelPlanesFont;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public boolean isPlotAxes() {
        return this.plotAxes;
    }

    public boolean isPlotPlanes() {
        return this.plotPlanes;
    }

    public double getRadius() {
        return (this.size - 2) / 2;
    }

    public int getSize() {
        return this.size;
    }

    public double getWidth() {
        return Options.truthyOr(this.width, this.size);
    }

    public double getX0() {
        return Options.truthyOr(this.x0, this.getWidth() / 2.0);
    }

    public double getY0() {
        return Options.truthyOr(this.y0, this.getHeight() / 2.0);
    }

    public Options withBgColor(Color bgColor) {
        return new Options(this.axisSize, bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withFillColor(Color fillColor) {
        return new Options(this.axisSize, this.bgColor, fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withHeight(double height) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, height, this.width, this.x0, this.y0);
    }

    public Options withLabelAxes(boolean labelAxes) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withLabelAxesFont(Font labelAxesFont) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withLabelPlanes(boolean labelPlanes) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withLabelPlanesFont(Font labelPlanesFont) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withLineColor(Color lineColor) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withLineWidth(double lineWidth) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withPlotAxes(boolean plotAxes) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withPlotPlanes(boolean plotPlanes) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, plotPlanes, this.size, this.height, this.width, this.x0, this.y0);
    }

    public Options withSize(int size) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, size, this.height, this.width, this.x0, this.y0);
    }

    public Options withWidth(double width) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, width, this.x0, this.y0);
    }

    public Options withX0(double x0) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, x0, this.y0);
    }

    public Options withY0(double y0) {
        return new Options(this.axisSize, this.bgColor, this.fillColor, this.labelAxes, this.labelAxesFont, this.labelPlanes, this.labelPlanesFont, this.lineColor, this.lineWidth, this.plotAxes, this.plotPlanes, this.size, this.height, this.width, this.x0, y0);
    }
}

