/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.tools;

import gov.noaa.tsunami.tools.AltCompression;
import gov.noaa.tsunami.tools.encode.CompressionResult;
import gov.noaa.tsunami.tools.encode.NioSEncode;
import gov.noaa.tsunami.utility.nc.NCUtil;
import gov.noaa.tsunami.utility.thread.NamingThreadFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class MTGlobalCompressor {
    protected static Logger log = Logger.getLogger("gov.noaa.tsunami.tools");

    public static void altCompress(File src, File outdir) throws IOException, InterruptedException, InvalidRangeException {
        MTGlobalCompressor.altCompress(src, outdir, null);
    }

    public static void altCompress(File src, File outdir, Integer quant) throws IOException, InterruptedException, InvalidRangeException {
        String vName;
        int q;
        final boolean dynamicQ = quant == null;
        int n = q = quant != null ? quant : -1;
        if (!dynamicQ && q < 1) {
            throw new IllegalArgumentException("Quantization must be greater than or equal to  1");
        }
        long start = System.currentTimeMillis();
        File outFile = new File(outdir, src.getName());
        if (outFile.equals(src)) {
            throw new IllegalArgumentException("source file cannot be the same as target file");
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        System.out.println("\n Start Variable Quantization Compression at " + new Date());
        System.out.println("  InFile: " + src);
        System.out.println(" OutFile: " + outFile);
        NetcdfFile inCDF = NetcdfFile.open(src.getAbsolutePath());
        String fieldVarName = MTGlobalCompressor.extractFieldVarName(inCDF);
        if (fieldVarName == null) {
            throw new IllegalStateException("No field Variable found");
        }
        AltOutputter altOutputter = new AltOutputter(outdir, NCUtil.findNcDimension(inCDF, "lon", true).getLength(), NCUtil.findNcDimension(inCDF, "lat", true).getLength(), dynamicQ, q);
        InMemoryAccessor inMemory = new InMemoryAccessor(inCDF, fieldVarName, altOutputter);
        inMemory.call();
        altOutputter.close();
        File blobFile = altOutputter.blobFile;
        if (blobFile.length() != (long)((int)blobFile.length())) {
            throw new IllegalStateException("File is longer than 32 bit int");
        }
        NetcdfFileWriteable outCDF = NetcdfFileWriteable.createNew(outFile.getAbsolutePath());
        double[] times = (double[])NCUtil.findNcVariable(inCDF, "time").read().copyTo1DJavaArray();
        NCUtil.closeUnlimitedDimensions(inCDF);
        NCUtil.copyGlobalAttributes(inCDF, outCDF, (Map<String, Object>)new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 3406927273831646808L;
            {
                this.put("Conventions", "CF-1.6,SIFT_Global_2.0" + (dynamicQ ? "_Dynamic" : ""));
                this.put("Quantization", new Integer(q));
            }
        });
        NCUtil.copyDimensions(inCDF, outCDF);
        Dimension[] blobDim = new Dimension[]{outCDF.addDimension("index", (int)blobFile.length())};
        Dimension[] sesDims = new Dimension[]{NCUtil.findNcDimension(inCDF, "lat", true), NCUtil.findNcDimension(inCDF, "lon", true)};
        Variable v = outCDF.addVariable("start", DataType.INT, sesDims);
        v.addAttribute(new Attribute("long_name", "Starting Index"));
        v.addAttribute(new Attribute("_FillValue", -1));
        v.addAttribute(new Attribute("missing_value", -1));
        v = outCDF.addVariable("end", DataType.INT, sesDims);
        v.addAttribute(new Attribute("long_name", "Ending Index"));
        v.addAttribute(new Attribute("_FillValue", -1));
        v.addAttribute(new Attribute("missing_value", -1));
        for (Variable var : inCDF.getVariables()) {
            vName = var.getFullNameEscaped();
            if (vName.equals("ha") || vName.equals("ua") || vName.equals("va")) continue;
            NCUtil.createOutputVariable(outCDF, var);
        }
        v = outCDF.addVariable(fieldVarName, DataType.BYTE, blobDim);
        if (fieldVarName.equals("ha")) {
            v.addAttribute(new Attribute("long_name", "Wave Amplitude"));
            v.addAttribute(new Attribute("standard_name", "sea_surface_height_above_geoid"));
            v.addAttribute(new Attribute("units", "cm"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
            v.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        } else if (fieldVarName.equals("ua")) {
            v.addAttribute(new Attribute("long_name", "Velocity Component along Longitude"));
            v.addAttribute(new Attribute("standard_name", "barotropic_eastward_sea_water_velocity"));
            v.addAttribute(new Attribute("units", "cm/sec"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
            v.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        } else if (fieldVarName.equals("va")) {
            v.addAttribute(new Attribute("long_name", "Velocity Component along Latitude"));
            v.addAttribute(new Attribute("standard_name", "barotropic_northward_sea_water_velocity"));
            v.addAttribute(new Attribute("units", "cm/sec"));
            v.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
            v.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        }
        outCDF.create();
        for (Variable inVar : inCDF.getVariables()) {
            vName = inVar.getFullNameEscaped();
            if (vName.equals("start") || vName.equals("end") || vName.equals("start_time") || vName.equals("ha") || vName.equals("ua") || vName.equals("va")) continue;
            System.out.print("  writing: " + vName);
            Array vData = null;
            try {
                if (vName.equals("time")) {
                    outCDF.write(vName, Array.factory(times));
                    continue;
                }
                vData = inVar.read();
                outCDF.write(vName, vData);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e);
            }
        }
        long btstart = System.currentTimeMillis();
        try (FileInputStream fis = new FileInputStream(blobFile);){
            byte[] ba = new byte[(int)blobFile.length()];
            fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, blobFile.length()).get(ba);
            Array bytes = Array.factory(DataType.BYTE, null, ByteBuffer.wrap(ba));
            outCDF.write(fieldVarName, bytes);
        }
        long btend = System.currentTimeMillis();
        try {
            outCDF.write("start", Array.factory(altOutputter.outStart));
            outCDF.write("end", Array.factory(altOutputter.outEnd));
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
        finally {
            outCDF.flush();
            outCDF.close();
        }
        System.out.println("\n Data volume: new vs. old: " + 25.0 * (double)altOutputter.storedTotal.get() / (double)altOutputter.dataTotal.get() + "%");
        double dx = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println("\n Finish at " + new Date());
        System.out.println(" time = " + dx + " seconds (" + dx / 60.0 + " minutes)\n");
        blobFile.delete();
    }

    public static void standardCompress(File src, File outdir, final float quant) throws IOException, InterruptedException, InvalidRangeException {
        String vName;
        long start = System.currentTimeMillis();
        File outFile = new File(outdir, src.getName() + "_std");
        if (outFile.equals(src)) {
            throw new IllegalArgumentException("source file cannot be the same as target file");
        }
        if (outFile.exists()) {
            outFile.delete();
        }
        System.out.println("\n Start Standard Compression at " + new Date());
        System.out.println("  InFile: " + src);
        System.out.println(" OutFile: " + outFile);
        NetcdfFile inCDF = NetcdfFile.open(src.getAbsolutePath());
        String fieldVarName = MTGlobalCompressor.extractFieldVarName(inCDF);
        if (fieldVarName == null) {
            throw new IllegalStateException("No field Variable found");
        }
        StandardOutputter stdOutputter = new StandardOutputter(outdir, NCUtil.findNcDimension(inCDF, "lon", true).getLength(), NCUtil.findNcDimension(inCDF, "lat", true).getLength(), quant);
        InMemoryAccessor inMemory = new InMemoryAccessor(inCDF, fieldVarName, stdOutputter);
        inMemory.call();
        stdOutputter.close();
        File blobFile = stdOutputter.blobFile;
        if (blobFile.length() != (long)((int)blobFile.length())) {
            throw new IllegalStateException("File is longer than 32 bit int");
        }
        NetcdfFileWriteable outCDF = NetcdfFileWriteable.createNew(outFile.getAbsolutePath());
        double[] times = (double[])NCUtil.findNcVariable(inCDF, "time").read().copyTo1DJavaArray();
        NCUtil.closeUnlimitedDimensions(inCDF);
        NCUtil.copyGlobalAttributes(inCDF, outCDF, (Map<String, Object>)new LinkedHashMap<String, Object>(){
            private static final long serialVersionUID = 3406927273831646808L;
            {
                this.put("Conventions", "CF-1.6,SIFT_Global_2.0_Standard");
                this.put("Quantization", new Float(quant));
            }
        });
        NCUtil.copyDimensions(inCDF, outCDF);
        Dimension[] blobDim = new Dimension[]{outCDF.addDimension("index", (int)blobFile.length())};
        Dimension[] sesDims = new Dimension[]{NCUtil.findNcDimension(inCDF, "lat", true), NCUtil.findNcDimension(inCDF, "lon", true)};
        Variable v = outCDF.addVariable("start", DataType.INT, sesDims);
        v.addAttribute(new Attribute("long_name", "Starting Index"));
        v.addAttribute(new Attribute("_FillValue", -1));
        v.addAttribute(new Attribute("missing_value", -1));
        v = outCDF.addVariable("end", DataType.INT, sesDims);
        v.addAttribute(new Attribute("long_name", "Ending Index"));
        v.addAttribute(new Attribute("_FillValue", -1));
        v.addAttribute(new Attribute("missing_value", -1));
        v = outCDF.addVariable("start_time", DataType.INT, sesDims);
        v.addAttribute(new Attribute("long_name", "Time of Starting Index"));
        v.addAttribute(new Attribute("_FillValue", -1));
        v.addAttribute(new Attribute("missing_value", -1));
        for (Variable var : inCDF.getVariables()) {
            vName = var.getFullNameEscaped();
            if (vName.equals("ha") || vName.equals("ua") || vName.equals("va")) continue;
            NCUtil.createOutputVariable(outCDF, var);
        }
        outCDF.addVariable(fieldVarName, DataType.BYTE, blobDim);
        outCDF.create();
        for (Variable inVar : inCDF.getVariables()) {
            vName = inVar.getFullNameEscaped();
            if (vName.equals("start") || vName.equals("end") || vName.equals("start_time") || vName.equals("ha") || vName.equals("ua") || vName.equals("va")) continue;
            System.out.print("  writing: " + vName);
            Array vData = null;
            try {
                if (vName.equals("time")) {
                    outCDF.write(vName, Array.factory(times));
                    continue;
                }
                vData = inVar.read();
                outCDF.write(vName, vData);
            }
            catch (InvalidRangeException e) {
                throw new IOException(e);
            }
        }
        long btstart = System.currentTimeMillis();
        try (FileInputStream fis = new FileInputStream(blobFile);){
            byte[] ba = new byte[(int)blobFile.length()];
            fis.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, blobFile.length()).get(ba);
            Array bytes = Array.factory(DataType.BYTE, null, ByteBuffer.wrap(ba));
            outCDF.write(fieldVarName, bytes);
        }
        long btend = System.currentTimeMillis();
        try {
            outCDF.write("start", Array.factory(stdOutputter.outStart));
            outCDF.write("end", Array.factory(stdOutputter.outEnd));
            outCDF.write("start_time", Array.factory(stdOutputter.offset));
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
        finally {
            outCDF.flush();
            outCDF.close();
        }
        System.out.println("\n Data volume: new vs. old: " + 25.0 * (double)stdOutputter.storedTotal.get() / (double)stdOutputter.dataTotal.get() + "%");
        double dx = (double)(System.currentTimeMillis() - start) / 1000.0;
        System.out.println("\n Finish at " + new Date());
        System.out.println(" time = " + dx + " seconds (" + dx / 60.0 + " minutes)\n");
        blobFile.delete();
    }

    private static String extractFieldVarName(NetcdfFile inCDF) {
        for (Variable var : inCDF.getVariables()) {
            String vName = var.getFullNameEscaped();
            if (!vName.equals("ha") && !vName.equals("ua") && !vName.equals("va")) continue;
            return vName;
        }
        return null;
    }

    private static float[] inplaceLessThanEPSToNaN(float[] data, float eps) {
        boolean notNan = false;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < eps) {
                data[i] = Float.NaN;
                continue;
            }
            notNan = true;
        }
        return (float[])(notNan ? data : null);
    }

    private static void usage() {
        System.err.println("Usage: ");
        System.err.println("compdb [-s] [-q <decimal places for variable compression, quantization for standard> ] out_dir inFile1 inFile2 infile3 ...");
        System.err.println("Defaults to dynamic compression.  Use the -s switch for standard compression.");
    }

    public static void main(String[] args) throws InterruptedException, InvalidRangeException {
        File outdir;
        if (args.length < 2) {
            MTGlobalCompressor.usage();
            return;
        }
        int offset = 0;
        Integer q = null;
        Float quant = new Float(0.001f);
        boolean standard = false;
        PrintStream filterOut = new PrintStream(System.err){

            @Override
            public void println(String l) {
                if (!l.startsWith("SLF4J")) {
                    super.println(l);
                }
            }
        };
        System.setErr(filterOut);
        if ("-s".equals(args[offset])) {
            standard = true;
            ++offset;
        }
        if ("-q".equals(args[offset])) {
            ++offset;
            try {
                if (standard) {
                    quant = Float.valueOf(args[offset]);
                } else {
                    q = Integer.valueOf(args[offset]);
                }
                ++offset;
            }
            catch (NumberFormatException fne) {
                if (standard) {
                    System.err.println("-q must have an decimal fraction (eg .001) ");
                } else {
                    System.err.println("-q must have an integer equal to or greater than 3 and less than or equal to 10");
                }
                MTGlobalCompressor.usage();
                return;
            }
        }
        if ((outdir = new File(args[offset])).exists() || outdir.mkdirs()) {
            if (!outdir.isDirectory()) {
                System.err.println(outdir + " is not a directory");
                MTGlobalCompressor.usage();
                return;
            }
        } else {
            System.err.println(outdir + " is not a directory");
            MTGlobalCompressor.usage();
            return;
        }
        if (++offset >= args.length) {
            System.err.println("missing file to compress");
            MTGlobalCompressor.usage();
            return;
        }
        try {
            for (int i = offset; i < args.length; ++i) {
                if (standard) {
                    MTGlobalCompressor.standardCompress(new File(args[i]), outdir, quant.floatValue());
                    continue;
                }
                MTGlobalCompressor.altCompress(new File(args[i]), outdir, q);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static abstract class IX {
        public static final int MAXIMUM_INDEX = 65535;

        private IX() {
        }

        public static int y(int i) {
            return i >> 16 & 0xFFFF;
        }

        public static int x(int i) {
            return i & 0xFFFF;
        }

        public static int index(int x, int y) {
            return (y & 0xFFFF) << 16 | x & 0xFFFF;
        }
    }

    private static final class CompressionBlock
    implements Comparable<CompressionBlock> {
        public final int index;
        public float[] data;
        public byte[] compressed;
        public int offset = -1;

        public CompressionBlock(int index, float[] data) {
            this.index = index;
            this.data = data;
        }

        @Override
        public int compareTo(CompressionBlock o) {
            return this.index - o.index;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object o) {
            return o instanceof CompressionBlock && this.index == ((CompressionBlock)o).index;
        }
    }

    public static class InMemoryAccessor
    implements Callable<Void> {
        private float fill = -1.0E34f;
        private float eps = this.fill + 1.4E-44f;
        private int nlat;
        private int nlon;
        private int ntime;
        private float[][] max;
        private Variable fieldVar;
        private Outputter outputter;
        private final boolean uorv;

        InMemoryAccessor(NetcdfFile inCDF, String fieldVarName, Outputter outputter) throws IOException {
            this.fieldVar = inCDF.findVariable(fieldVarName);
            this.uorv = !"ha".equals(fieldVarName);
            this.nlat = NCUtil.findNcDimension(inCDF, "lat", true).getLength();
            this.nlon = NCUtil.findNcDimension(inCDF, "lon", true).getLength();
            this.ntime = NCUtil.findNcDimension(inCDF, "time", true).getLength();
            System.out.println("nlat = " + this.nlat + ", nlon = " + this.nlon + ", ntime = " + this.ntime);
            int[] origin = new int[]{0, 0, 0};
            int[] shape = new int[]{1, this.nlat, this.nlon};
            Variable mv = inCDF.findVariable(fieldVarName);
            try {
                this.max = (float[][])mv.read(origin, shape).reduce().copyToNDJavaArray();
            }
            catch (InvalidRangeException ire) {
                throw new IOException(ire);
            }
            Attribute att = mv.findAttribute("missing_value");
            if (att != null) {
                this.fill = att.getNumericValue().floatValue();
            }
            if (this.max == null) {
                throw new IllegalStateException("failed to find max Variable");
            }
            this.outputter = outputter;
        }

        @Override
        public Void call() throws InterruptedException, IOException {
            int i;
            int j;
            long start;
            long last;
            int[] readOrigin = new int[3];
            int[] readShape = new int[]{1, this.nlat, this.nlon};
            int total = 0;
            int partial = 0;
            long now = last = (start = System.currentTimeMillis());
            long delta = 0L;
            float[][][] enchilada = new float[this.nlat][this.nlon][];
            float[][][] slice = null;
            float[] chunk = null;
            System.out.print("begin allocation...");
            for (j = 0; j < this.nlat; ++j) {
                for (i = 0; i < this.nlon; ++i) {
                    if (this.max[j][i] == this.fill) continue;
                    enchilada[j][i] = new float[this.ntime];
                }
            }
            now = System.currentTimeMillis();
            System.out.print("done " + (now - start) + "ms\nbegin read");
            start = System.currentTimeMillis();
            for (int k = 0; k < this.ntime; ++k) {
                readOrigin[0] = k;
                try {
                    slice = (float[][][])this.fieldVar.read(readOrigin, readShape).copyToNDJavaArray();
                    if (k % 500 == 0) {
                        System.out.print(" " + k + "/" + this.ntime);
                    }
                    for (int j2 = 0; j2 < this.nlat; ++j2) {
                        chunk = slice[0][j2];
                        float[][] ej = enchilada[j2];
                        for (int i2 = 0; i2 < this.nlon; ++i2) {
                            if (ej[i2] == null) continue;
                            ej[i2][k] = chunk[i2];
                        }
                    }
                    continue;
                }
                catch (InvalidRangeException e1) {
                    throw new IOException(e1);
                }
            }
            now = System.currentTimeMillis();
            System.out.println("done " + (now - start) + " ms\nbegin compression");
            start = System.currentTimeMillis();
            for (j = 0; j < this.nlat; ++j) {
                now = System.currentTimeMillis();
                delta = now - last;
                last = now;
                partial = 0;
                for (i = 0; i < this.nlon; ++i) {
                    if (this.max[j][i] == this.fill) {
                        this.outputter.compressAndWrite(i, j, null);
                    } else {
                        ++total;
                        ++partial;
                        this.outputter.compressAndWrite(i, j, MTGlobalCompressor.inplaceLessThanEPSToNaN(enchilada[j][i], this.eps));
                    }
                    enchilada[j][i] = null;
                }
            }
            now = System.currentTimeMillis();
            System.out.println("done " + (now - start));
            return null;
        }
    }

    private static interface Outputter {
        public void compressAndWrite(int var1, int var2, float[] var3) throws InterruptedException;
    }

    public static class MTInMemoryAccessor
    implements Callable<Void>,
    Closeable {
        private float fill = -1.0E34f;
        private float eps = this.fill + 1.4E-44f;
        private int nlat;
        private int nlon;
        private int ntime;
        private float[][] max;
        private Variable fieldVar;
        private AltOutputter altOutputter;
        private final boolean uorv;
        private final AtomicInteger timeRemaining;
        private final ExecutorService exec = Executors.newCachedThreadPool(new NamingThreadFactory(true));
        private final ArrayBlockingQueue<IndexedSlice> sliceQueue = new ArrayBlockingQueue(100);
        private Collection<Future<Void>> swapperFutures = new ArrayList<Future<Void>>();

        MTInMemoryAccessor(NetcdfFile inCDF, String fieldVarName, AltOutputter altOutputter) throws IOException {
            this.fieldVar = inCDF.findVariable(fieldVarName);
            this.uorv = !"ha".equals(fieldVarName);
            this.nlat = NCUtil.findNcDimension(inCDF, "lat", true).getLength();
            this.nlon = NCUtil.findNcDimension(inCDF, "lon", true).getLength();
            this.ntime = NCUtil.findNcDimension(inCDF, "time", true).getLength();
            this.timeRemaining = new AtomicInteger(this.ntime);
            System.out.println("nlat = " + this.nlat + ", nlon = " + this.nlon + ", ntime = " + this.ntime);
            int[] origin = new int[]{0, 0, 0};
            int[] shape = new int[]{1, this.nlat, this.nlon};
            Variable mv = inCDF.findVariable(fieldVarName);
            try {
                this.max = (float[][])mv.read(origin, shape).reduce().copyToNDJavaArray();
            }
            catch (InvalidRangeException ire) {
                throw new IOException(ire);
            }
            Attribute att = mv.findAttribute("missing_value");
            if (att != null) {
                this.fill = att.getNumericValue().floatValue();
            }
            if (this.max == null) {
                throw new IllegalStateException("failed to find max Variable");
            }
            this.altOutputter = altOutputter;
            for (int i = 0; i < 7; ++i) {
                this.swapperFutures.add(this.exec.submit(new Swapper()));
            }
        }

        @Override
        public Void call() throws InterruptedException, IOException {
            long start;
            long last;
            int[] readOrigin = new int[3];
            int[] readShape = new int[]{1, this.nlat, this.nlon};
            int total = 0;
            int partial = 0;
            long now = last = (start = System.currentTimeMillis());
            long delta = 0L;
            float[][][] enchilada = new float[this.nlat][this.nlon][];
            float[][][] slice = null;
            System.out.print("begin allocation ");
            for (int j = 0; j < this.nlat; ++j) {
                for (int i = 0; i < this.nlon; ++i) {
                    if (this.max[j][i] == this.fill) continue;
                    enchilada[j][i] = new float[this.ntime];
                }
            }
            now = System.currentTimeMillis();
            System.out.print("done " + (now - start) + " ms\nbegin read");
            start = System.currentTimeMillis();
            for (int k = 0; k < this.ntime; ++k) {
                readOrigin[0] = k;
                try {
                    slice = (float[][][])this.fieldVar.read(readOrigin, readShape).copyToNDJavaArray();
                    if (k % 100 == 0) {
                        System.out.println(k + "/" + this.ntime);
                    }
                    this.sliceQueue.put(new IndexedSlice(k, slice, enchilada));
                    continue;
                }
                catch (InvalidRangeException e1) {
                    throw new IOException(e1);
                }
            }
            now = System.currentTimeMillis();
            System.out.println(" done " + (now - start) + " ms\nwait for swap");
            start = System.currentTimeMillis();
            for (Future<Void> f : this.swapperFutures) {
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            this.exec.shutdown();
            now = System.currentTimeMillis();
            System.out.print("done " + (now - start) + "ms\nbegin compression");
            start = System.currentTimeMillis();
            for (int j = 0; j < this.nlat; ++j) {
                now = System.currentTimeMillis();
                delta = now - last;
                last = now;
                partial = 0;
                for (int i = 0; i < this.nlon; ++i) {
                    if (this.max[j][i] == this.fill) {
                        this.altOutputter.compressAndWrite(i, j, null);
                    } else {
                        ++total;
                        ++partial;
                        this.altOutputter.compressAndWrite(i, j, MTGlobalCompressor.inplaceLessThanEPSToNaN(enchilada[j][i], this.eps));
                    }
                    enchilada[j][i] = null;
                }
            }
            now = System.currentTimeMillis();
            System.out.println("done " + (now - start));
            return null;
        }

        @Override
        public void close() {
        }

        private class Swapper
        implements Callable<Void> {
            private Swapper() {
            }

            @Override
            public Void call() {
                while (MTInMemoryAccessor.this.timeRemaining.get() > 0) {
                    try {
                        IndexedSlice is = (IndexedSlice)MTInMemoryAccessor.this.sliceQueue.poll(1L, TimeUnit.SECONDS);
                        if (is == null) continue;
                        MTInMemoryAccessor.this.timeRemaining.decrementAndGet();
                        for (int j = 0; j < MTInMemoryAccessor.this.nlat; ++j) {
                            float[] chunk = is.slice[0][j];
                            float[][] ej = is.target[j];
                            for (int i = 0; i < MTInMemoryAccessor.this.nlon; ++i) {
                                if (ej[i] == null) continue;
                                ej[i][is.ix] = chunk[i];
                            }
                        }
                    }
                    catch (InterruptedException e) {
                    }
                }
                return null;
            }
        }

        private static class IndexedSlice {
            public final int ix;
            public final float[][][] slice;
            public final float[][][] target;

            public IndexedSlice(int ix, float[][][] data, float[][][] t) {
                this.ix = ix;
                this.slice = data;
                this.target = t;
            }
        }
    }

    private static class AltOutputter
    implements Closeable,
    Outputter {
        private final int[][] outStart;
        private final int[][] outEnd;
        private final boolean dynamicQ;
        private final int q;
        private CompressionBlock[][] compressionBlocks;
        private ArrayBlockingQueue<CompressionBlock> compressionQueue = new ArrayBlockingQueue(1000);
        private Semaphore writeAvailable = new Semaphore(0);
        private final AtomicInteger blocksRemaining;
        private final AtomicLong dataTotal = new AtomicLong(0L);
        private final AtomicInteger storedTotal = new AtomicInteger(0);
        private final ExecutorService exec = Executors.newCachedThreadPool(new NamingThreadFactory(true));
        private Future<Void> writerFuture;
        private Collection<Future<Void>> compressorFutures = new ArrayList<Future<Void>>();
        private final File blobFile;

        private AltOutputter(File path, int nlon, int nlat, boolean dynamicQ, int q) {
            int i;
            this.blocksRemaining = new AtomicInteger(nlat * nlon);
            this.outStart = new int[nlat][nlon];
            this.outEnd = new int[nlat][nlon];
            for (i = 0; i < this.outStart.length; ++i) {
                Arrays.fill(this.outStart[i], -1);
            }
            for (i = 0; i < this.outEnd.length; ++i) {
                Arrays.fill(this.outEnd[i], -1);
            }
            this.dynamicQ = dynamicQ;
            this.q = q;
            File t = new File(path, UUID.randomUUID().toString());
            while (t.exists()) {
                t = new File(path, UUID.randomUUID().toString());
            }
            this.blobFile = t;
            this.blobFile.deleteOnExit();
            this.compressionBlocks = new CompressionBlock[nlat][nlon];
            this.writerFuture = this.exec.submit(new Writer());
            for (int i2 = 0; i2 < Runtime.getRuntime().availableProcessors() - 1; ++i2) {
                this.compressorFutures.add(this.exec.submit(new Compressor()));
            }
        }

        @Override
        public void compressAndWrite(int i, int j, float[] data) throws InterruptedException {
            this.compressionQueue.put(new CompressionBlock(IX.index(i, j), data));
        }

        @Override
        public void close() {
            try {
                this.writerFuture.get();
            }
            catch (InterruptedException | ExecutionException e1) {
                e1.printStackTrace();
            }
            for (Future<Void> f : this.compressorFutures) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            this.exec.shutdown();
        }

        private class Compressor
        implements Callable<Void> {
            private Compressor() {
            }

            @Override
            public Void call() {
                while (AltOutputter.this.blocksRemaining.get() > 0) {
                    try {
                        CompressionBlock cb = (CompressionBlock)AltOutputter.this.compressionQueue.poll(1L, TimeUnit.SECONDS);
                        if (cb == null) continue;
                        AltOutputter.this.blocksRemaining.decrementAndGet();
                        if (cb.data != null) {
                            cb.compressed = AltOutputter.this.dynamicQ ? AltCompression.encodeDynamic(cb.data) : AltCompression.encode(cb.data, AltOutputter.this.q);
                            AltOutputter.this.dataTotal.addAndGet(cb.data.length);
                        }
                        ((AltOutputter)AltOutputter.this).compressionBlocks[IX.y((int)cb.index)][IX.x((int)cb.index)] = cb;
                        AltOutputter.this.writeAvailable.release();
                    }
                    catch (InterruptedException e) {}
                }
                return null;
            }
        }

        private class Writer
        implements Callable<Void> {
            private Writer() {
            }

            @Override
            public Void call() throws IOException {
                try (RandomAccessFile raf = new RandomAccessFile(AltOutputter.this.blobFile, "rw");){
                    for (int j = 0; j < AltOutputter.this.compressionBlocks.length; ++j) {
                        CompressionBlock[] cblat = AltOutputter.this.compressionBlocks[j];
                        for (int i = 0; i < cblat.length; ++i) {
                            while (cblat[i] == null) {
                                try {
                                    AltOutputter.this.writeAvailable.tryAcquire(1L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (cblat[i].compressed != null) {
                                ((AltOutputter)AltOutputter.this).outStart[j][i] = (int)raf.getFilePointer();
                                raf.write(cblat[i].compressed);
                                ((AltOutputter)AltOutputter.this).outEnd[j][i] = (int)raf.getFilePointer() - 1;
                                AltOutputter.this.storedTotal.addAndGet(cblat[i].compressed.length);
                            }
                            cblat[i] = null;
                        }
                        ((AltOutputter)AltOutputter.this).compressionBlocks[j] = null;
                    }
                }
                return null;
            }
        }
    }

    private static class StandardOutputter
    implements Closeable,
    Outputter {
        private final int[][] outStart;
        private final int[][] outEnd;
        private final int[][] offset;
        private final float q;
        private CompressionBlock[][] compressionBlocks;
        private ArrayBlockingQueue<CompressionBlock> compressionQueue = new ArrayBlockingQueue(1000);
        private Semaphore writeAvailable = new Semaphore(0);
        private final AtomicInteger blocksRemaining;
        private final AtomicLong dataTotal = new AtomicLong(0L);
        private final AtomicInteger storedTotal = new AtomicInteger(0);
        private final ExecutorService exec = Executors.newCachedThreadPool(new NamingThreadFactory(true));
        private Future<Void> writerFuture;
        private Collection<Future<Void>> compressorFutures = new ArrayList<Future<Void>>();
        private final File blobFile;

        private StandardOutputter(File path, int nlon, int nlat, float q) {
            int i;
            this.blocksRemaining = new AtomicInteger(nlat * nlon);
            this.outStart = new int[nlat][nlon];
            this.outEnd = new int[nlat][nlon];
            this.offset = new int[nlat][nlon];
            for (i = 0; i < this.outStart.length; ++i) {
                Arrays.fill(this.outStart[i], -1);
            }
            for (i = 0; i < this.outEnd.length; ++i) {
                Arrays.fill(this.outEnd[i], -1);
            }
            this.q = q;
            File t = new File(path, UUID.randomUUID().toString());
            while (t.exists()) {
                t = new File(path, UUID.randomUUID().toString());
            }
            this.blobFile = t;
            this.blobFile.deleteOnExit();
            this.compressionBlocks = new CompressionBlock[nlat][nlon];
            this.writerFuture = this.exec.submit(new Writer());
            for (int i2 = 0; i2 < Runtime.getRuntime().availableProcessors() - 1; ++i2) {
                this.compressorFutures.add(this.exec.submit(new Compressor()));
            }
        }

        @Override
        public void compressAndWrite(int i, int j, float[] data) throws InterruptedException {
            this.compressionQueue.put(new CompressionBlock(IX.index(i, j), data));
        }

        @Override
        public void close() {
            try {
                this.writerFuture.get();
            }
            catch (InterruptedException | ExecutionException e1) {
                e1.printStackTrace();
            }
            for (Future<Void> f : this.compressorFutures) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            this.exec.shutdown();
        }

        private class Compressor
        implements Callable<Void> {
            private Compressor() {
            }

            @Override
            public Void call() {
                while (StandardOutputter.this.blocksRemaining.get() > 0) {
                    try {
                        CompressionBlock cb = (CompressionBlock)StandardOutputter.this.compressionQueue.poll(1L, TimeUnit.SECONDS);
                        if (cb == null) continue;
                        StandardOutputter.this.blocksRemaining.decrementAndGet();
                        if (cb.data != null) {
                            CompressionResult cr = NioSEncode.encode(cb.data, StandardOutputter.this.q);
                            if (cr != null) {
                                cb.compressed = cr.data;
                                cb.offset = cr.startZeros;
                            }
                            StandardOutputter.this.dataTotal.addAndGet(cb.data.length);
                        }
                        ((StandardOutputter)StandardOutputter.this).compressionBlocks[IX.y((int)cb.index)][IX.x((int)cb.index)] = cb;
                        StandardOutputter.this.writeAvailable.release();
                    }
                    catch (InterruptedException e) {}
                }
                return null;
            }
        }

        private class Writer
        implements Callable<Void> {
            private Writer() {
            }

            @Override
            public Void call() throws IOException {
                try (RandomAccessFile raf = new RandomAccessFile(StandardOutputter.this.blobFile, "rw");){
                    for (int j = 0; j < StandardOutputter.this.compressionBlocks.length; ++j) {
                        CompressionBlock[] cblat = StandardOutputter.this.compressionBlocks[j];
                        for (int i = 0; i < cblat.length; ++i) {
                            while (cblat[i] == null) {
                                try {
                                    StandardOutputter.this.writeAvailable.tryAcquire(1L, TimeUnit.SECONDS);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (cblat[i].compressed != null) {
                                ((StandardOutputter)StandardOutputter.this).outStart[j][i] = (int)raf.getFilePointer();
                                raf.write(cblat[i].compressed);
                                ((StandardOutputter)StandardOutputter.this).outEnd[j][i] = (int)raf.getFilePointer() - 1;
                                StandardOutputter.this.storedTotal.addAndGet(cblat[i].compressed.length);
                                ((StandardOutputter)StandardOutputter.this).offset[j][i] = cblat[i].offset;
                            }
                            cblat[i] = null;
                        }
                        ((StandardOutputter)StandardOutputter.this).compressionBlocks[j] = null;
                    }
                }
                return null;
            }
        }
    }
}

