/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.tools.decode;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NioSDecode {
    private static final int BUFFER_LEN = 6000;
    public static final float DEFAULT_FILL_VALUE = -1.0E34f;

    private NioSDecode() {
    }

    public static float[] decode(byte[] store, float quant) {
        return NioSDecode.decode(ByteBuffer.wrap(store), quant, -1.0E34f);
    }

    public static float[] decode(ByteBuffer bb, float quant) {
        return NioSDecode.decode(bb, quant, -1.0E34f);
    }

    public static float[] decode(byte[] store, int offset, int length, float quant) {
        return NioSDecode.decode(ByteBuffer.wrap(store, offset, length), quant, -1.0E34f);
    }

    public static float[] decode(byte[] store, int offset, int length, float quant, float fillvalue) {
        return NioSDecode.decode(ByteBuffer.wrap(store, offset, length), quant, fillvalue);
    }

    public static float[] decode(ByteBuffer bb, float quant, float fillvalue) {
        int[] ndata = new int[6000];
        int nnn = NioSDecode.unpackStore(bb, ndata);
        float[] out = new float[nnn];
        float u1 = 0.0f;
        float u2 = 0.0f;
        for (int i = 0; i < nnn; ++i) {
            if (ndata[i] < -2147483647) {
                out[i] = fillvalue;
                continue;
            }
            out[i] = quant * (float)ndata[i] + 2.0f * u1 - u2;
            u2 = u1;
            u1 = out[i];
        }
        return out;
    }

    private static int unpackStore(ByteBuffer bb, int[] ndata) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        byte dd = 0;
        int idata = 0;
        while (bb.position() < bb.limit()) {
            int len = bb.getShort();
            if (len >= ndata.length) {
                throw new IllegalArgumentException("Record is too long:" + len);
            }
            switch (bb.get()) {
                case 0: {
                    int i;
                    int jout = (len + 1) / 2;
                    for (i = 0; i < jout; ++i) {
                        dd = bb.get();
                        ndata[idata + 2 * i] = dd >> 4;
                        ndata[idata + 2 * i + 1] = (dd & 0xF) - 8;
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = bb.get();
                    }
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = bb.getShort();
                    }
                    break;
                }
                case 4: {
                    int i;
                    for (i = 0; i < len; ++i) {
                        ndata[idata + i] = bb.getInt();
                    }
                    break;
                }
            }
            idata += len;
        }
        if (bb.position() != bb.limit()) {
            System.out.println("Decoding Error 1");
        }
        return idata;
    }
}

