/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.tools.encode;

public class EncodeTest {
    private static final int COUNT = 100000000;

    public EncodeTest() {
        int i;
        int c = 0;
        int val = -7;
        int[] ret = new int[2];
        for (int i2 = 0; i2 < 1000000; ++i2) {
            ret[0] = i2 + 2;
            ret[1] = i2 + 4;
        }
        long start = System.currentTimeMillis();
        for (int i3 = 0; i3 < 100000000; ++i3) {
            int a;
            int b = val % 16;
            ret[0] = a = (val - b) / 16;
            ret[1] = b - 8;
            ++c;
        }
        long delta = System.currentTimeMillis() - start;
        System.out.println("delta = " + delta + ",   c = " + c);
        System.out.println("decode: in = " + val + " out = " + ret[0] + ", " + ret[1]);
        start = System.currentTimeMillis();
        for (int i4 = 0; i4 < 100000000; ++i4) {
            ret[0] = val >> 4;
            ret[1] = (val & 0xF) - 8;
            ++c;
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("\ndelta = " + delta + ",   c = " + c);
        System.out.println("decode2: in = " + val + " out = " + ret[0] + ", " + ret[1]);
        start = System.currentTimeMillis();
        byte res = 0;
        int a = ret[0];
        int b = ret[1];
        for (i = 0; i < 100000000; ++i) {
            res = (byte)(a * 16 + b + 8);
            ++c;
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("\ndelta = " + delta + ",   c = " + c);
        System.out.println("encode: in = " + ret[0] + ", " + ret[1] + ", out = " + res);
        start = System.currentTimeMillis();
        for (i = 0; i < 100000000; ++i) {
            res = (byte)(a << 4 | b + 8 & 0xF);
            ++c;
        }
        delta = System.currentTimeMillis() - start;
        System.out.println("\ndelta = " + delta + ",   c = " + c);
        System.out.println("encode2: in = " + ret[0] + ", " + ret[1] + ", out = " + res);
    }

    public static void main(String[] args) {
        new EncodeTest();
    }

    private byte encode(int a, int b) {
        return (byte)(a * 16 + b + 8);
    }

    private byte encode2(int a, int b) {
        return (byte)(a << 4 | b + 8 & 0xF);
    }

    private int[] decode(byte val) {
        int a;
        int[] ret = new int[2];
        int b = val % 16;
        ret[0] = a = (val - b) / 16;
        ret[1] = b - 8;
        return ret;
    }

    private int[] decode2(byte val) {
        int[] ret = new int[]{val >> 4, (val & 0xF) - 8};
        return ret;
    }
}

