/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.tools.encode;

import gov.noaa.tsunami.tools.encode.CompressionResult;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class NioSEncode {
    public static final float DEFAULT_EPS = -1.0E34f;
    private static final int NOUT_MIN = 3;
    private static final int HBYTE_MAX = 7;
    private static final int HBYTE_MIN = -8;

    private NioSEncode() {
    }

    public static CompressionResult encode(float[] rr, float quant) {
        return NioSEncode.encode(rr, quant, -1.0E34f);
    }

    public static CompressionResult encode(float[] rr, float quant, float eps) {
        int i;
        int nr = rr.length;
        int[] nn = new int[nr];
        int[] nBts = new int[nr];
        int[] nValues = new int[nr];
        int startZeros = 0;
        int cntr = 0;
        int bt = 0;
        int nout = 0;
        double u1 = 0.0;
        double u2 = 0.0;
        double inv_quant = 1.0f / quant;
        boolean check_zero = true;
        for (i = 0; i < rr.length; ++i) {
            int nnn;
            if (rr[i] >= eps) {
                double diff = (double)rr[i] + u2 - 2.0 * u1;
                double x = diff * inv_quant;
                nnn = (int)(x + Math.signum(x) * 0.5);
                double u0 = (double)(quant * (float)nnn) + 2.0 * u1 - u2;
                u2 = u1;
                u1 = u0;
            } else {
                nnn = Integer.MIN_VALUE;
            }
            if (check_zero) {
                if (nnn == 0) {
                    ++startZeros;
                    continue;
                }
                check_zero = false;
            }
            nn[i - startZeros] = nnn;
            int nbt = 4;
            if (nnn <= Short.MAX_VALUE && nnn >= Short.MIN_VALUE) {
                nbt = 2;
                if (nnn <= 127 && nnn >= -128) {
                    nbt = 1;
                    if (nnn <= 7 && nnn >= -8) {
                        nbt = 0;
                    }
                }
            }
            if (nbt > bt && nout >= 3) {
                nValues[cntr] = nout;
                nBts[cntr] = bt;
                ++cntr;
                nout = 0;
            }
            if (nbt < bt) {
                nValues[cntr] = nout;
                nBts[cntr] = bt;
                ++cntr;
                nout = 0;
            }
            bt = nbt;
            ++nout;
        }
        if (startZeros >= nr) {
            return new CompressionResult(-1, new byte[0]);
        }
        i = nr - startZeros - 1;
        while (nout != 0 && nn[i] == 0) {
            --i;
            --nout;
        }
        if (nout > 0) {
            nValues[cntr] = nout;
            nBts[cntr] = bt;
        } else {
            --cntr;
        }
        int istart = 0;
        i = 0;
        ByteBuffer bb = ByteBuffer.allocate(rr.length * 8);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        while (i <= cntr) {
            nout = 0;
            bt = nBts[i];
            while (i <= cntr && nBts[i] == bt) {
                nout += nValues[i];
                ++i;
            }
            int iend = istart + nout - 1;
            switch (bt) {
                case 0: {
                    int k;
                    bb.putShort((short)nout);
                    bb.put((byte)0);
                    for (k = istart; k <= iend; k += 2) {
                        int a = nn[k];
                        int b = k < iend ? nn[k + 1] : 0;
                        bb.put((byte)(16 * a + b + 8));
                    }
                    break;
                }
                case 1: {
                    int k;
                    bb.putShort((short)nout);
                    bb.put((byte)1);
                    for (k = istart; k <= iend; ++k) {
                        bb.put((byte)nn[k]);
                    }
                    break;
                }
                case 2: {
                    int k;
                    bb.putShort((short)nout);
                    bb.put((byte)2);
                    for (k = istart; k <= iend; ++k) {
                        bb.putShort((short)nn[k]);
                    }
                    break;
                }
                case 4: {
                    int k;
                    bb.putShort((short)nout);
                    bb.put((byte)4);
                    for (k = istart; k <= iend; ++k) {
                        bb.putInt(nn[k]);
                    }
                    break;
                }
            }
            istart = iend + 1;
        }
        byte[] result = new byte[bb.position()];
        bb.flip();
        bb.get(result);
        return new CompressionResult(startZeros, result);
    }
}

