/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.tools;

import gov.noaa.tsunami.analysis.TravelTime;
import gov.noaa.tsunami.tools.AltCompression;
import gov.noaa.tsunami.tools.decode.NioSDecode;
import gov.noaa.tsunami.utility.nc.NCUtil;
import gov.noaa.tsunami.utility.units.Length;
import gov.noaa.tsunami.utility.units.Unit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;

public class propcomb {
    public static final Logger log = Logger.getLogger("gov.noaa.tsunami.tools");
    public static boolean debug = false;
    private static boolean fullGridExtents = true;
    private static double minLon = 540.0;
    private static double maxLon = -540.0;
    private static double minLat = 90.0;
    private static double maxLat = -90.0;
    private static boolean fullTimeInterval = true;
    private static double minTime = 100.0;
    private static double maxTime = -100.0;
    private static double tsLon;
    private static double tsLat;
    private static boolean timeSeries;
    private static File gridFile;
    private static boolean honly;
    private static String outFilePattern;
    private static File outDir;
    private static File propDir;
    private static boolean copyBathymetry;
    private static Variable bathVar;
    private static boolean includeDef;
    private static boolean readDef;
    private static Variable defVar;
    private static boolean noTimeVars;
    private static boolean forceNetcdf4;
    private static int decimator;
    private static boolean includeTTime;
    private static Variable ttimeVar;
    private static boolean includeMaxAmp;
    private static Variable maxVar;
    private static String history;
    private static GregorianCalendar eventTime;
    private static SimpleDateFormat sdf;
    private static SimpleDateFormat sdfo;
    private static SimpleDateFormat histDF;
    private static DecimalFormat dfxx;
    private static boolean verbose;
    private static String inversion;
    private static double Mw;
    private static Map<String, Double> sourceMap;
    private static Map<String, String> fileMap;
    private static ArrayList<Float> epiLat;
    private static ArrayList<Float> epiLon;
    private static NetcdfFileWriter ncout;
    private static final Pattern[] namePatterns;
    private static final int[][] namePatternIndexes;

    private static int parseInversion() {
        sourceMap.clear();
        fileMap.clear();
        int num = 0;
        String[] sa = inversion.split("(?<!\\*)\\+|(?<!\\*)(?=-)");
        for (int i = 0; i < sa.length; ++i) {
            if (sa[i].trim().equals("")) continue;
            String[] alphaAndSource = sa[i].split("\\*");
            if (alphaAndSource.length == 2) {
                double alpha;
                String source;
                block6: {
                    source = "";
                    alpha = 0.0;
                    try {
                        if (alphaAndSource[0].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                            alpha = Double.parseDouble(alphaAndSource[0].trim());
                            source = alphaAndSource[1].trim();
                            break block6;
                        }
                        if (alphaAndSource[1].matches("\\s*^[-+]?[0-9.]+\\s*")) {
                            alpha = Double.parseDouble(alphaAndSource[1].trim());
                            source = alphaAndSource[0].trim();
                            break block6;
                        }
                        return 0;
                    }
                    catch (NumberFormatException nfe) {
                        return 0;
                    }
                }
                sourceMap.put(source, alpha);
                ++num;
                continue;
            }
            return 0;
        }
        return num;
    }

    private static boolean findPropFiles() {
        String val;
        if (propDir == null && !(propDir = (val = System.getenv("PROPDBDIR")) != null ? new File(val) : new File("/home/nctr_data/propdb/compressed")).exists()) {
            System.err.println("Can't find PropDB directory at: " + propDir.getPath());
            return false;
        }
        String fn = "";
        for (String name : sourceMap.keySet()) {
            if (new File(propDir, name).exists()) {
                if (!name.endsWith("ha.nc")) continue;
                fn = name.replaceAll("ha.nc", "");
                if (verbose) {
                    System.out.println("Found prop file: " + name);
                }
                fileMap.put(name, fn);
                continue;
            }
            if (new File(propDir, name + "ha.nc").exists()) {
                fn = name;
                if (verbose) {
                    System.out.println("Found prop file prefix: " + name);
                }
                fileMap.put(name, fn);
                continue;
            }
            String stname = propcomb.getStandardName(name);
            if (stname.equals("")) {
                return false;
            }
            String zone = stname.substring(0, 2);
            String col = stname.substring(stname.length() - 1);
            int row = Integer.parseInt(stname.replaceAll(zone, "").replaceAll(col, ""));
            fn = String.format("%s_%03d_%s_", zone, row, col);
            if (fn.equals("")) {
                return false;
            }
            if (new File(propDir, fn + "ha.nc").exists()) {
                if (verbose) {
                    System.out.println("Found prop file in standard name format: " + fn + "ha.nc");
                }
                fileMap.put(name, fn);
                continue;
            }
            return false;
        }
        Mw = propcomb.getMagnitude();
        return true;
    }

    private static double getMagnitude() {
        double mag = 0.0;
        double totalMom = 0.0;
        try {
            for (Map.Entry<String, Double> e : sourceMap.entrySet()) {
                NetcdfFile nc = NetcdfFile.open(propDir.getPath() + File.separator + fileMap.get(e.getKey()) + "ha.nc");
                double slip = nc.findGlobalAttributeIgnoreCase("slip").getNumericValue().doubleValue();
                double length = nc.findGlobalAttributeIgnoreCase("source_length").getNumericValue().doubleValue();
                double width = nc.findGlobalAttributeIgnoreCase("source_width").getNumericValue().doubleValue();
                totalMom += Math.abs(e.getValue()) * propcomb.getSeismicMoment(slip, length, width);
                nc.close();
            }
        }
        catch (Exception ignore) {
            return 0.0;
        }
        return 0.6666666666666666 * (Math.log(totalMom) / Math.log(10.0)) - 10.7;
    }

    private static double getSeismicMoment(double slip, double length, double width) {
        double u = 4.0E11;
        return Math.abs(slip) / 0.01 * (u * length * width * 1.0E10);
    }

    public static String getStandardName(String name) {
        name = name.trim().toLowerCase();
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < namePatterns.length; ++i) {
            Matcher m = namePatterns[i].matcher(name);
            if (!m.matches()) continue;
            for (int gidx : namePatternIndexes[i]) {
                sb.append(m.group(gidx));
            }
            return sb.toString();
        }
        return name;
    }

    public static boolean setPropDir(String pdir) {
        propDir = new File(pdir);
        return propDir.exists();
    }

    public static boolean setInversion(String inv) {
        inversion = inv;
        if (propcomb.parseInversion() < 1) {
            return false;
        }
        return propcomb.findPropFiles();
    }

    public static void setOutputFileNamePattern(String outputFileNamePattern) {
        outFilePattern = outputFileNamePattern;
    }

    public static void setOutputDirectory(String oDir) {
        outDir = new File(oDir);
    }

    public static void includeBathymetry() {
        copyBathymetry = true;
    }

    public static void setNoDeform() {
        includeDef = false;
    }

    public static void includeTravelTime() {
        includeTTime = true;
        readDef = true;
    }

    public static void includeMaxAmp() {
        includeMaxAmp = true;
    }

    public static void setVerbose() {
        verbose = true;
    }

    public static void setNoTimeVars() {
        noTimeVars = true;
    }

    public static void setNetcdf3() {
        forceNetcdf4 = false;
    }

    public static boolean getTimeSeries(double lon, double lat) {
        timeSeries = true;
        tsLon = lon;
        tsLat = lat;
        return propcomb.getTimeSeries();
    }

    public static boolean calcHA() {
        try {
            propcomb.createLinComb("ha");
        }
        catch (IOException ex) {
            System.err.println("Error creating linear combo file:");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean calcUA() {
        try {
            propcomb.createLinComb("ua");
        }
        catch (IOException ex) {
            System.err.println("Error creating linear combo file:");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean calcVA() {
        try {
            propcomb.createLinComb("va");
        }
        catch (IOException ex) {
            System.err.println("Error creating linear combo file:");
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void setExtents(double minLongitude, double maxLongitude, double minLatitude, double maxLatitude) {
        fullGridExtents = false;
        minLon = minLongitude;
        maxLon = maxLongitude;
        minLat = minLatitude;
        maxLat = maxLatitude;
    }

    public static boolean readExtents(String gridFileName) {
        gridFile = new File(gridFileName);
        if (!gridFile.exists()) {
            System.err.println("Can't file grid file for extents: " + gridFileName);
            return false;
        }
        boolean result = propcomb.readExtents();
        if (verbose) {
            System.out.println("Extents from file: " + gridFileName);
            System.out.println("minLon: " + minLon + " maxLon: " + maxLon);
            System.out.println("minLat: " + minLat + " maxLat: " + maxLat);
        }
        return result;
    }

    private static boolean readExtents() {
        double[] lats;
        double[] lons;
        fullGridExtents = false;
        try {
            NetcdfFile nc = NetcdfFile.open(gridFile.getPath());
            lons = (double[])nc.findVariable("lon").read().copyTo1DJavaArray();
            lats = (double[])nc.findVariable("lat").read().copyTo1DJavaArray();
        }
        catch (IOException ignore) {
            try {
                FileReader fr = new FileReader(gridFile);
                BufferedReader br = new BufferedReader(fr);
                try {
                    int i;
                    String inputLine = br.readLine();
                    if (inputLine == null) {
                        return false;
                    }
                    String[] inputArray = inputLine.trim().split("\\s+");
                    int nLon = Integer.parseInt(inputArray[0]);
                    int nLat = Integer.parseInt(inputArray[1]);
                    lons = new double[nLon];
                    lats = new double[nLat];
                    for (i = 0; i < nLon; ++i) {
                        lons[i] = Double.parseDouble(br.readLine());
                    }
                    for (i = 0; i < nLat; ++i) {
                        lats[i] = Double.parseDouble(br.readLine());
                    }
                }
                catch (IOException | NumberFormatException ex) {
                    return false;
                }
            }
            catch (FileNotFoundException ignore2) {
                return false;
            }
        }
        minLon = lons[0];
        maxLon = lons[lons.length - 1];
        if (minLon < 0.0 || maxLon < 0.0) {
            minLon += 360.0;
            maxLon += 360.0;
        }
        minLat = Math.min(lats[0], lats[lats.length - 1]);
        maxLat = Math.max(lats[0], lats[lats.length - 1]);
        return true;
    }

    private static void createLinComb(String varname) throws IOException {
        String fn;
        boolean firstSource = true;
        double[] gridlons = null;
        double[] gridlats = null;
        double[] times = null;
        double[] otimes = null;
        double[] lons = null;
        double[] lats = null;
        NetcdfFile nc = null;
        Variable var = null;
        ArrayFloat.D3 vfd3 = null;
        ArrayFloat.D2 marrayDef = null;
        ArrayFloat.D2 marrayBath = null;
        ArrayFloat.D2 marrayTT = null;
        ArrayFloat.D2 marrayMax = null;
        int nTime = 0;
        int nLat = 0;
        int nLon = 0;
        int tsize = 0;
        int tend = 0;
        int tstart = 0;
        int jsize = 0;
        int jend = 0;
        int jstart = 0;
        int isize = 0;
        int iend = 0;
        int istart = 0;
        int gjsize = 0;
        int gjend = 0;
        int gjstart = 0;
        int gisize = 0;
        int giend = 0;
        int gistart = 0;
        if (varname.equals("ha")) {
            epiLat.clear();
            epiLon.clear();
            for (Map.Entry<String, String> e : fileMap.entrySet()) {
                fn = propDir.getPath() + File.separator + e.getValue() + varname + ".nc";
                nc = NetcdfFile.open(fn);
                Attribute att = nc.findGlobalAttribute("Source_Latitude");
                if (att != null) {
                    epiLat.add(Float.valueOf(att.getNumericValue().floatValue()));
                }
                if ((att = nc.findGlobalAttribute("Source_Longitude")) != null) {
                    epiLon.add(Float.valueOf(att.getNumericValue().floatValue()));
                }
                nc.close();
            }
        }
        for (Map.Entry<String, String> e : fileMap.entrySet()) {
            double alpha = sourceMap.get(e.getKey());
            fn = propDir.getPath() + File.separator + e.getValue() + varname + ".nc";
            nc = NetcdfFile.open(fn);
            if (firstSource) {
                firstSource = false;
                Variable lonVar = NCUtil.findNcVariable(nc, "LON");
                double[] sourceLons = (double[])((ArrayDouble.D1)lonVar.read()).copyTo1DJavaArray();
                Variable latVar = NCUtil.findNcVariable(nc, "LAT");
                double[] sourceLats = (double[])((ArrayDouble.D1)latVar.read()).copyTo1DJavaArray();
                if (sourceLons[0] < 0.0) {
                    int i = 0;
                    while (i < sourceLons.length) {
                        int n = i++;
                        sourceLons[n] = sourceLons[n] + 360.0;
                    }
                }
                Variable timeVar = NCUtil.findNcVariable(nc, "TIME");
                times = (double[])timeVar.read().copyTo1DJavaArray();
                String msg = "finding Latitude/Longitude indices...";
                nLon = sourceLons.length;
                nLat = sourceLats.length;
                nTime = times.length;
                Attribute att = nc.findGlobalAttribute("Output_Grid_Interval");
                decimator = 1;
                if (att != null) {
                    decimator = att.getNumericValue().intValue();
                }
                if (fullGridExtents) {
                    minLon = sourceLons[0];
                    maxLon = sourceLons[sourceLons.length - 1];
                    minLat = sourceLats[0];
                    maxLat = sourceLats[sourceLats.length - 1];
                    iend = nLon - 1;
                    isize = nLon;
                    jend = nLat - 1;
                    jsize = nLat;
                    if (varname.equals("ha") && (readDef || copyBathymetry)) {
                        gridlons = (double[])NCUtil.findNcVariable(nc, "grid_lon").read().get1DJavaArray(Double.TYPE);
                        gridlats = (double[])NCUtil.findNcVariable(nc, "grid_lat").read().get1DJavaArray(Double.TYPE);
                        gisize = gridlons.length;
                        gjsize = gridlats.length;
                        giend = gisize - 1;
                        gjend = gjsize - 1;
                    }
                } else {
                    if (sourceLats.length <= 2 || sourceLons.length <= 2 || minLat < sourceLats[1] || maxLat > sourceLats[sourceLats.length - 2] || minLon < sourceLons[1] || maxLon > sourceLons[sourceLons.length - 2]) {
                        String errmsg = "Error: Requesting a region outside the propagation grid for source " + e.getKey() + ", minLon: " + sourceLons[0] + ", maxLon: " + sourceLons[sourceLons.length - 1] + ", minLat: " + sourceLats[0] + ", maxLat: " + sourceLats[sourceLats.length - 1];
                        System.out.println(errmsg);
                        throw new IOException(errmsg);
                    }
                    while (sourceLons[istart] < minLon) {
                        ++istart;
                    }
                    iend = istart = istart >= 2 ? istart - 2 : 0;
                    while (sourceLons[iend] < maxLon) {
                        ++iend;
                    }
                    int n = iend = iend < sourceLons.length - 2 ? iend + 1 : sourceLons.length - 1;
                    while (sourceLats[jstart] < minLat) {
                        ++jstart;
                    }
                    jend = jstart = jstart > 2 ? jstart - 2 : 0;
                    while (sourceLats[jend] < maxLat) {
                        ++jend;
                    }
                    jend = jend < sourceLats.length - 2 ? jend + 1 : sourceLats.length - 1;
                    isize = iend - istart + 1;
                    jsize = jend - jstart + 1;
                    if (varname.equals("ha") && (readDef || copyBathymetry)) {
                        double[] gsourceLons = (double[])NCUtil.findNcVariable(nc, "grid_lon").read().get1DJavaArray(Double.TYPE);
                        double[] gsourceLats = (double[])NCUtil.findNcVariable(nc, "grid_lat").read().get1DJavaArray(Double.TYPE);
                        if (gsourceLons[0] < 0.0) {
                            int i = 0;
                            while (i < gsourceLons.length) {
                                int n2 = i++;
                                gsourceLons[n2] = gsourceLons[n2] + 360.0;
                            }
                        }
                        gjsize = 0;
                        gjend = 0;
                        gjstart = 0;
                        gisize = 0;
                        giend = 0;
                        gistart = 0;
                        while (gistart + decimator < istart * decimator) {
                            gistart += decimator;
                        }
                        while (giend < iend * decimator) {
                            giend += decimator;
                        }
                        while (gjstart + decimator < jstart * decimator) {
                            gjstart += decimator;
                        }
                        while (gjend < jend * decimator) {
                            gjend += decimator;
                        }
                        gisize = giend - gistart;
                        gjsize = gjend - gjstart;
                        gridlons = new double[gisize];
                        for (int i = 0; i < gisize; ++i) {
                            gridlons[i] = gsourceLons[gistart + i];
                        }
                        gridlats = new double[gjsize];
                        for (int j = 0; j < gjsize; ++j) {
                            gridlats[j] = gsourceLats[gjstart + j];
                        }
                    }
                }
                if (fullTimeInterval) {
                    tend = tsize = nTime;
                    otimes = times;
                } else {
                    for (tstart = 1; tstart < times.length; ++tstart) {
                        if (!(times[tstart] >= minTime)) continue;
                        --tstart;
                        break;
                    }
                    for (tend = 1; tend < times.length - 1 && !(times[tend - 1] > maxTime); ++tend) {
                    }
                    tsize = tend - tstart;
                    otimes = new double[tsize];
                    for (int i = 0; i < tsize; ++i) {
                        otimes[i] = times[i + tstart];
                    }
                }
                if (debug) {
                    System.out.println("axis indices: ");
                    System.out.println("istart: " + istart + " iend: " + iend + " isize: " + isize + " nLon: " + nLon);
                    System.out.println("jstart: " + jstart + " jend: " + jend + " jsize: " + jsize + " nLat: " + nLat);
                    System.out.println("tstart: " + tstart + " tend: " + tend + " tsize: " + tsize + " nTime: " + nTime);
                    System.out.println("lat(jstart): " + sourceLats[jstart] + "  lat(jend): " + sourceLats[jend]);
                    System.out.println("lon(istart): " + sourceLons[istart] + "  lons(iend): " + sourceLons[iend]);
                    System.out.println("time(tstart): " + times[tstart] + " time(tend): " + times[tend]);
                }
                lons = new double[isize];
                for (int i = 0; i < isize; ++i) {
                    lons[i] = sourceLons[istart + i];
                }
                lats = new double[jsize];
                for (int j = 0; j < jsize; ++j) {
                    lats[j] = sourceLats[jstart + j];
                }
                if ((long)tsize * (long)jsize * (long)isize > 0x7FFFFFFAL) {
                    throw new IOException("File size too big: the ability to create decompressed files larger than 2GB does not yet exist.\nConsider requesting smaller extents, either in lat/lon, or in time.");
                }
                if (verbose) {
                    System.out.println("Creating output file for: " + varname);
                }
                var = propcomb.createNetcdf(nc, varname, lons, lats, gridlons, gridlats, otimes);
                vfd3 = new ArrayFloat.D3(tsize, jsize, isize);
                if (varname.equals("ha")) {
                    if (copyBathymetry) {
                        marrayBath = new ArrayFloat.D2(gjsize, gisize);
                        Variable varBathIn = NCUtil.findNcVariable(nc, "bathymetry");
                        if (varBathIn != null) {
                            int[] origin = new int[]{gjstart, gistart};
                            int[] shape = new int[]{gjsize, gisize};
                            try {
                                marrayBath = (ArrayFloat.D2)varBathIn.read(origin, shape);
                            }
                            catch (InvalidRangeException ex) {
                                System.err.println("Error reading bathymetry: no bathymetry will be added to output.");
                            }
                        }
                    }
                    if (readDef) {
                        marrayDef = new ArrayFloat.D2(gjsize, gisize);
                        MAMath.setDouble(marrayDef, 0.0);
                    }
                    if (includeMaxAmp) {
                        marrayMax = new ArrayFloat.D2(jsize, isize);
                        MAMath.setDouble(marrayMax, 0.0);
                    }
                    if (includeTTime) {
                        marrayTT = new ArrayFloat.D2(jsize, isize);
                        MAMath.setDouble(marrayTT, 0.0);
                    }
                }
            } else {
                if (NCUtil.findNcDimension(nc, "LON").getLength() != nLon || NCUtil.findNcDimension(nc, "LAT").getLength() != nLat) {
                    throw new IOException("The source files are not all on the same propagation grid");
                }
                if (NCUtil.findNcDimension(nc, "TIME").getLength() != nTime) {
                    throw new IOException("The source files are not all on the same propagation grid (time axis mismatch)");
                }
            }
            if (verbose) {
                System.out.print("Reading source file: " + fn);
            }
            if (propcomb.isCompressed(nc)) {
                propcomb.decompressSource(varname, nc, vfd3, alpha, istart, isize, jstart, jsize, tstart, tsize);
            } else {
                propcomb.addSource(varname, nc, vfd3, alpha, istart, isize, jstart, jsize, tstart, tsize);
            }
            if (varname.equals("ha") && readDef) {
                propcomb.addDeform(nc, marrayDef, alpha, gistart, gisize, gjstart, gjsize);
            }
            nc.close();
        }
        try {
            if (verbose) {
                System.out.println("Writing output...");
            }
            if (!noTimeVars) {
                ncout.write(var, vfd3);
            }
            if (varname.equals("ha")) {
                if (copyBathymetry) {
                    ncout.write(bathVar, marrayBath);
                }
                if (includeDef) {
                    ncout.write(defVar, marrayDef);
                }
                if (includeMaxAmp) {
                    propcomb.addMax(ncout, vfd3, marrayMax);
                }
                if (includeTTime) {
                    propcomb.addTTime(ncout, vfd3, marrayDef, marrayTT, otimes, lats, lons);
                }
            }
            ncout.close();
            if (verbose) {
                System.out.println("...done writing output for: " + varname);
            }
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex);
        }
    }

    private static void addDeform(NetcdfFile nc, ArrayFloat.D2 vfd2, double alpha, int gistart, int gisize, int gjstart, int gjsize) throws IOException {
        Variable def = NCUtil.findNcVariable(nc, "deformation");
        int[] origin = new int[]{gjstart, gistart};
        int[] shape = new int[]{gjsize, gisize};
        float holder = 0.0f;
        try {
            ArrayFloat.D2 afd2 = (ArrayFloat.D2)def.read(origin, shape);
            for (int j = 0; j < gjsize; ++j) {
                for (int i = 0; i < gisize; ++i) {
                    holder = afd2.get(j, i);
                    vfd2.set(j, i, vfd2.get(j, i) + (float)alpha * holder);
                }
            }
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex);
        }
    }

    private static void addMax(NetcdfFileWriter ncout, ArrayFloat.D3 vfd3, ArrayFloat.D2 marrayMax) throws IOException, InvalidRangeException {
        float holder = 0.0f;
        float mholder = 0.0f;
        int[] shape = vfd3.getShape();
        for (int j = 0; j < shape[1]; ++j) {
            for (int i = 0; i < shape[2]; ++i) {
                mholder = marrayMax.get(j, i);
                for (int t = 0; t < shape[0]; ++t) {
                    holder = vfd3.get(t, j, i);
                    if (holder == -1.0E34f) {
                        mholder = holder;
                        break;
                    }
                    mholder = mholder > holder ? mholder : holder;
                }
                marrayMax.set(j, i, mholder);
            }
        }
        if (verbose) {
            System.out.println("Maximum wave amplitude: " + MAMath.getMaximum(vfd3) + " [cm].");
        }
        ncout.write(maxVar, marrayMax);
    }

    private static void addTTime(NetcdfFileWriter ncout, ArrayFloat.D3 vfd3, ArrayFloat.D2 marrayDef, ArrayFloat.D2 marrayTT, double[] times, double[] lats, double[] lons) throws IOException, InvalidRangeException {
        double maxDeformation = -1.0 * MAMath.getMinimum(marrayDef);
        float holder = 0.0f;
        float localDef = 0.0f;
        int[] shape = vfd3.getShape();
        int jsize = shape[1];
        int isize = shape[2];
        shape[1] = 1;
        shape[2] = 1;
        int[] origin = new int[vfd3.getRank()];
        if (verbose) {
            System.out.println("Maximum deformation: " + maxDeformation + " [m].");
        }
        double sumAlpha = 0.0;
        for (Double alpha : sourceMap.values()) {
            sumAlpha += Math.abs(alpha);
        }
        double quantThreshold = TravelTime.getDefaultQuantizationThreshold(sumAlpha);
        for (int j = 0; j < jsize; ++j) {
            for (int i = 0; i < isize; ++i) {
                localDef = -1.0f * marrayDef.get(j * decimator, i * decimator);
                origin[1] = j;
                origin[2] = i;
                ArrayFloat.D1 tsarr = (ArrayFloat.D1)vfd3.section(origin, shape);
                double maxTimeSeries = MAMath.getMaximum(tsarr);
                double maxAmpThreshold = TravelTime.getMaxAmplitudeThreshold(maxTimeSeries, Length.centimeter);
                double defThreshold = TravelTime.getDeformationThreshold(maxDeformation, new Double(localDef), Length.meter, maxTimeSeries, Length.centimeter);
                int ttIndex = TravelTime.getTravelTimeIndice((float[])tsarr.copyTo1DJavaArray(), (Unit<Length>)Length.centimeter, quantThreshold, maxAmpThreshold, defThreshold);
                if (ttIndex == -1) {
                    marrayTT.set(j, i, -1.0E34f);
                    continue;
                }
                marrayTT.set(j, i, (float)times[ttIndex] / 3600.0f);
            }
        }
        ncout.write(ttimeVar, marrayTT);
    }

    public static boolean isCompressed(NetcdfFile nc) {
        Attribute att = nc.findGlobalAttribute("Quantization");
        return att != null;
    }

    public static boolean isDynamic(NetcdfFile nc) {
        Attribute att = nc.findGlobalAttribute("Quantization");
        if (att.isString()) {
            return true;
        }
        Number quant = att.getNumericValue();
        return quant instanceof Integer;
    }

    public static void addSource(String varName, NetcdfFile nc, ArrayFloat.D3 vfd3, double alpha, int istart, int isize, int jstart, int jsize, int tstart, int tsize) throws IOException {
        Variable var = NCUtil.findNcVariable(nc, varName);
        int[] origin = new int[]{0, jstart, istart};
        int[] shape = new int[]{tsize, jsize, isize};
        float holder = 0.0f;
        try {
            ArrayFloat.D3 afd3 = (ArrayFloat.D3)var.read(origin, shape);
            for (int t = 0; t < tsize; ++t) {
                for (int j = 0; j < jsize; ++j) {
                    for (int i = 0; i < isize; ++i) {
                        holder = afd3.get(t, j, i);
                        if (holder == -1.0E34f) {
                            holder = 0.0f;
                        }
                        vfd3.set(t, j, i, vfd3.get(t, j, i) + (float)alpha * holder);
                    }
                }
            }
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex);
        }
    }

    private static void decompressSource(String varName, NetcdfFile nc, ArrayFloat.D3 vfd3, double alpha, int istart, int isize, int jstart, int jsize, int tstart, int tsize) throws IOException {
        Variable var = NCUtil.findNcVariable(nc, varName);
        var.getDimension(0).setUnlimited(false);
        int[][] start = (int[][])nc.findVariable("start").read().copyToNDJavaArray();
        int[][] end = (int[][])nc.findVariable("end").read().copyToNDJavaArray();
        int[][] start_time = null;
        int[] origin = new int[1];
        int[] shape = new int[1];
        Number quant = nc.findGlobalAttribute("Quantization").getNumericValue();
        boolean dynamic = propcomb.isDynamic(nc);
        if (dynamic) {
            if (verbose) {
                System.out.println(" (dynamic quantization)");
            }
        } else {
            start_time = (int[][])nc.findVariable("start_time").read().copyToNDJavaArray();
            if (verbose) {
                System.out.println(" (standard, quant: " + quant.floatValue() + ")");
            }
        }
        int stime = 0;
        int endidx = 0;
        try {
            for (int j = 0; j < jsize; ++j) {
                for (int i = 0; i < isize; ++i) {
                    int t;
                    origin[0] = start[j + jstart][i + istart];
                    shape[0] = end[j + jstart][i + istart] - origin[0] + 1;
                    if (origin[0] == -1) {
                        for (int t2 = 0; t2 < tsize; ++t2) {
                            vfd3.set(t2, j, i, 0.0f);
                        }
                        continue;
                    }
                    byte[] store = (byte[])var.read(origin, shape).copyTo1DJavaArray();
                    if (store.length > 0) {
                        float[] data;
                        if (dynamic) {
                            data = AltCompression.decode(store);
                            stime = 0;
                        } else {
                            data = NioSDecode.decode(store, quant.floatValue());
                            stime = start_time[j + jstart][i + istart];
                        }
                        endidx = stime + data.length;
                        if (endidx > tsize) {
                            endidx = tsize;
                        }
                        if (origin[0] >= 0) {
                            for (t = stime; t < endidx; ++t) {
                                vfd3.set(t, j, i, (float)alpha * data[t - stime] + vfd3.get(t, j, i));
                            }
                            continue;
                        }
                        for (t = 0; t < tsize; ++t) {
                            vfd3.set(t, j, i, 0.0f);
                        }
                        continue;
                    }
                    for (t = 0; t < tsize; ++t) {
                        vfd3.set(t, j, i, 0.0f);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Exception decoding compressed file ", ex);
            throw new IOException("NetCDF file is not a valid compressed source file");
        }
    }

    public static double getMinDX(double[] lonslats) {
        double dx = 0.0;
        double mindx = 100000.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            mindx = dx < mindx ? dx : mindx;
        }
        return mindx;
    }

    public static double getMaxDX(double[] lonslats) {
        double dx = 0.0;
        double maxdx = 0.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            maxdx = dx > maxdx ? dx : maxdx;
        }
        return maxdx;
    }

    public static String getResLabel(double res) {
        String reslabel = "";
        reslabel = dfxx.format(res) + " deg";
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcmin";
        }
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcsec";
        }
        return reslabel;
    }

    private static Variable createNetcdf(NetcdfFile ncfile, String varName, double[] lons, double[] lats, double[] glons, double[] glats, double[] times) throws IOException {
        ArrayList<Dimension> dims2;
        String units = "centimeters/second";
        String longname = "Velocity Component along Latitude";
        String outSuffix = "v.nc";
        if ("ha".equals(varName)) {
            units = "centimeters";
            longname = "Wave Amplitude";
            outSuffix = "h.nc";
        } else if ("ua".equals(varName)) {
            longname = "Velocity Component along Longitude";
            outSuffix = "u.nc";
        }
        if (outFilePattern.equals("")) {
            outFilePattern = "linCo";
        }
        String outfn = outDir.getPath() + File.separator + outFilePattern + outSuffix;
        new File(outfn).delete();
        double size = (double)lons.length * (double)lats.length * (double)times.length * 4.0;
        if (forceNetcdf4 || size > 4.294967296E9) {
            Nc4Chunking ch = Nc4ChunkingStrategy.factory(Nc4Chunking.Strategy.standard, 1, true);
            ncout = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf4, outfn);
        } else {
            ncout = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, outfn);
        }
        Dimension londim = ncout.addDimension(null, "lon", lons.length);
        Dimension latdim = ncout.addDimension(null, "lat", lats.length);
        Dimension glondim = null;
        Dimension glatdim = null;
        if (varName.equals("ha") && (includeDef || copyBathymetry)) {
            glondim = ncout.addDimension(null, "grid_lon", glons.length);
            glatdim = ncout.addDimension(null, "grid_lat", glats.length);
        }
        Dimension timedim = ncout.addDimension(null, "time", times.length);
        Dimension[] dim3 = new Dimension[]{timedim, latdim, londim};
        String spcx = "even";
        double mindx = propcomb.getMinDX(lons);
        double maxdx = propcomb.getMaxDX(lons);
        if (maxdx - mindx > 0.001) {
            spcx = "uneven";
        }
        String spcy = "even";
        double mindy = propcomb.getMinDX(lats);
        double maxdy = propcomb.getMaxDX(lats);
        if (maxdy - mindy > 0.001) {
            spcy = "uneven";
        }
        Variable lonvar = ncout.addVariable(null, "lon", DataType.DOUBLE, Arrays.asList(londim));
        ncout.addVariableAttribute(lonvar, new Attribute("long_name", "longitude"));
        ncout.addVariableAttribute(lonvar, new Attribute("units", "degrees_east"));
        ncout.addVariableAttribute(lonvar, new Attribute("point_spacing", spcx));
        if ("even".equals(spcx)) {
            ncout.addVariableAttribute(lonvar, new Attribute("resolution", propcomb.getResLabel(mindx)));
        } else {
            ncout.addVariableAttribute(lonvar, new Attribute("resolution_min", propcomb.getResLabel(mindx)));
            ncout.addVariableAttribute(lonvar, new Attribute("resolution_max", propcomb.getResLabel(maxdx)));
        }
        Variable latvar = ncout.addVariable(null, "lat", DataType.DOUBLE, Arrays.asList(latdim));
        ncout.addVariableAttribute(latvar, new Attribute("long_name", "latitude"));
        ncout.addVariableAttribute(latvar, new Attribute("units", "degrees_north"));
        ncout.addVariableAttribute(latvar, new Attribute("point_spacing", spcy));
        if ("even".equals(spcy)) {
            ncout.addVariableAttribute(latvar, new Attribute("resolution", propcomb.getResLabel(mindy)));
        } else {
            ncout.addVariableAttribute(latvar, new Attribute("resolution_min", propcomb.getResLabel(mindy)));
            ncout.addVariableAttribute(latvar, new Attribute("resolution_max", propcomb.getResLabel(maxdy)));
        }
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        Variable crVar = ncout.addVariable(null, "crs", DataType.INT, dimList);
        crVar.addAttribute(new Attribute("grid_mapping_name", "latitude_longitude"));
        crVar.addAttribute(new Attribute("longitude_of_prime_meridian", 0.0));
        crVar.addAttribute(new Attribute("semi_major_axis", 6378137.0));
        crVar.addAttribute(new Attribute("inverse_flattening", 298.257223563));
        crVar.addAttribute(new Attribute("crs_wkt", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        crVar.addAttribute(new Attribute("spatial_ref", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        Variable glonvar = null;
        Variable glatvar = null;
        if (varName.equals("ha") && (includeDef || copyBathymetry)) {
            spcx = "even";
            mindx = propcomb.getMinDX(glons);
            maxdx = propcomb.getMaxDX(glons);
            if (maxdx - mindx > 0.001) {
                spcx = "uneven";
            }
            glonvar = ncout.addVariable(null, "grid_lon", DataType.DOUBLE, Arrays.asList(glondim));
            ncout.addVariableAttribute(glonvar, new Attribute("long_name", "Grid Longitude"));
            ncout.addVariableAttribute(glonvar, new Attribute("units", "degrees_east"));
            ncout.addVariableAttribute(glonvar, new Attribute("point_spacing", spcx));
            if ("even".equals(spcx)) {
                ncout.addVariableAttribute(glonvar, new Attribute("resolution", propcomb.getResLabel(mindx)));
            } else {
                ncout.addVariableAttribute(glonvar, new Attribute("resolution_min", propcomb.getResLabel(mindx)));
                ncout.addVariableAttribute(glonvar, new Attribute("resolution_max", propcomb.getResLabel(maxdx)));
            }
            spcy = "even";
            mindy = propcomb.getMinDX(glats);
            maxdy = propcomb.getMaxDX(glats);
            if (maxdy - mindy > 0.001) {
                spcy = "uneven";
            }
            glatvar = ncout.addVariable(null, "grid_lat", DataType.DOUBLE, Arrays.asList(glatdim));
            ncout.addVariableAttribute(glatvar, new Attribute("long_name", "Grid Latitude"));
            ncout.addVariableAttribute(glatvar, new Attribute("units", "degrees_north"));
            ncout.addVariableAttribute(glatvar, new Attribute("point_spacing", spcy));
            if ("even".equals(spcy)) {
                ncout.addVariableAttribute(glatvar, new Attribute("resolution", propcomb.getResLabel(mindy)));
            } else {
                ncout.addVariableAttribute(glatvar, new Attribute("resolution_min", propcomb.getResLabel(mindy)));
                ncout.addVariableAttribute(glatvar, new Attribute("resolution_max", propcomb.getResLabel(maxdy)));
            }
            ArrayList<Dimension> gdims2 = new ArrayList<Dimension>();
            gdims2.add(glatdim);
            gdims2.add(glondim);
            if (copyBathymetry) {
                bathVar = ncout.addVariable(null, "bathymetry", DataType.FLOAT, gdims2);
                ncout.addVariableAttribute(bathVar, new Attribute("long_name", "Grid Bathymetry"));
                ncout.addVariableAttribute(bathVar, new Attribute("units", "meters"));
                ncout.addVariableAttribute(bathVar, new Attribute("grid_mapping", "crs"));
                ncout.addVariableAttribute(bathVar, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
                ncout.addVariableAttribute(bathVar, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
            }
            if (includeDef) {
                defVar = ncout.addVariable(null, "deformation", DataType.FLOAT, gdims2);
                ncout.addVariableAttribute(defVar, new Attribute("long_name", "Grid Deformation"));
                ncout.addVariableAttribute(defVar, new Attribute("units", "meters"));
                ncout.addVariableAttribute(defVar, new Attribute("grid_mapping", "crs"));
                ncout.addVariableAttribute(defVar, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
                ncout.addVariableAttribute(defVar, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
            }
        }
        if (includeMaxAmp && varName.equals("ha")) {
            dims2 = new ArrayList<Dimension>();
            dims2.add(latdim);
            dims2.add(londim);
            maxVar = ncout.addVariable(null, "max_height", DataType.FLOAT, dims2);
            ncout.addVariableAttribute(maxVar, new Attribute("long_name", "Maximum Wave Amplitude"));
            ncout.addVariableAttribute(maxVar, new Attribute("units", "cm"));
            ncout.addVariableAttribute(maxVar, new Attribute("grid_mapping", "crs"));
            ncout.addVariableAttribute(maxVar, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
            ncout.addVariableAttribute(maxVar, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
        }
        if (includeTTime && varName.equals("ha")) {
            dims2 = new ArrayList();
            dims2.add(latdim);
            dims2.add(londim);
            ttimeVar = ncout.addVariable(null, "travel_time", DataType.FLOAT, dims2);
            ncout.addVariableAttribute(ttimeVar, new Attribute("long_name", "Travel Time"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("units", "hours"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("grid_mapping", "crs"));
            ncout.addVariableAttribute(ttimeVar, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
            ncout.addVariableAttribute(ttimeVar, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
        }
        Variable var = null;
        Variable timevar = null;
        if (!noTimeVars) {
            timevar = ncout.addVariable(null, "time", DataType.DOUBLE, Arrays.asList(timedim));
            ncout.addVariableAttribute(timevar, new Attribute("long_name", "time"));
            ncout.addVariableAttribute(timevar, new Attribute("Calendar", "standard"));
            if (eventTime == null) {
                ncout.addVariableAttribute(timevar, new Attribute("units", "seconds"));
            } else {
                ncout.addVariableAttribute(timevar, new Attribute("units", "seconds since " + sdfo.format(eventTime.getTime())));
            }
            var = ncout.addVariable(null, varName, DataType.FLOAT, Arrays.asList(dim3));
            ncout.addVariableAttribute(var, new Attribute("long_name", longname));
            ncout.addVariableAttribute(var, new Attribute("units", units));
            ncout.addVariableAttribute(var, new Attribute("grid_mapping", "crs"));
            ncout.addVariableAttribute(var, new Attribute("missing_value", Float.valueOf(-1.0E34f)));
            ncout.addVariableAttribute(var, new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        }
        List<Attribute> attlist = ncfile.getGlobalAttributes();
        for (Attribute att : attlist) {
            if (att.getName().equals("Quantization")) continue;
            ncout.addGroupAttribute(null, att);
        }
        ncout.addGroupAttribute(null, new Attribute("history", history));
        ncout.addGroupAttribute(null, new Attribute("inversion", inversion));
        if (eventTime != null) {
            ncout.addGroupAttribute(null, new Attribute("Event_Date", sdf.format(eventTime.getTime())));
        }
        if (Mw != 0.0) {
            ncout.addGroupAttribute(null, new Attribute("magnitude", dfxx.format(Mw)));
        }
        if (varName.equals("ha")) {
            Float ave = Float.valueOf(0.0f);
            for (Float lo : epiLon) {
                ave = Float.valueOf(ave.floatValue() + lo.floatValue());
            }
            ncout.addGroupAttribute(null, new Attribute("Source_Longitude_Combined", Float.valueOf(ave.floatValue() / (float)epiLon.size())));
            ave = Float.valueOf(0.0f);
            for (Float la : epiLat) {
                ave = Float.valueOf(ave.floatValue() + la.floatValue());
            }
            ncout.addGroupAttribute(null, new Attribute("Source_Latitude_Combined", Float.valueOf(ave.floatValue() / (float)epiLat.size())));
        }
        try {
            ncout.create();
        }
        catch (Exception uoe) {
            System.err.println("\n\nNetCDF4 library not found!");
            System.err.println("Try using '-3' or requesting smaller extents (using -x), or small time interval (-i).");
            System.err.println("Or export LD_LIBRARY_PATH=/path/to/netcdf4libs");
            System.err.println("Hint: on Macs with Matlab installed, try:");
            System.err.println("export DYLD_LIBRARY_PATH=/Applications/MATLAB_R2015b.app/bin/maci64");
            System.err.println("or, on linux, try:");
            System.err.println("export LD_LIBRARY_PATH=/usr/local/netcdf/lib\n\n");
            throw new IOException(uoe);
        }
        try {
            ncout.write(lonvar, Array.factory(lons));
            ncout.write(latvar, Array.factory(lats));
            if ((includeDef || copyBathymetry) && varName.equals("ha")) {
                ncout.write(glonvar, Array.factory(glons));
                ncout.write(glatvar, Array.factory(glats));
            }
            if (!noTimeVars) {
                ncout.write(timevar, Array.factory(times));
            }
            ncout.flush();
        }
        catch (InvalidRangeException ex) {
            log.log(Level.SEVERE, null, ex);
            throw new IOException(ex);
        }
        return var;
    }

    private static boolean getTimeSeries() {
        boolean firstSource = true;
        NetcdfFile nc = null;
        double alpha = 0.0;
        int nTime = 0;
        int nLat = 0;
        int nLon = 0;
        int jndx = 0;
        int indx = 0;
        float[] eta = null;
        double[] times = null;
        try {
            int i;
            for (Map.Entry<String, String> e : fileMap.entrySet()) {
                int[] shape;
                int[] origin;
                alpha = sourceMap.get(e.getKey());
                String fn = propDir.getPath() + File.separator + e.getValue() + "ha.nc";
                nc = NetcdfFile.open(fn);
                if (firstSource) {
                    firstSource = false;
                    double[] lons = (double[])NCUtil.findNcVariable(nc, "lon").read().get1DJavaArray(Double.TYPE);
                    double[] lats = (double[])NCUtil.findNcVariable(nc, "lat").read().get1DJavaArray(Double.TYPE);
                    if (tsLon < lons[0] || tsLat < lats[0] || tsLon > lons[lons.length - 1] || tsLat > lats[lats.length - 1]) {
                        System.err.println("Requested point, lon: " + tsLon + " lat: " + tsLat + "is");
                        System.err.println("outside PropDB extents:");
                        System.err.println("minLon: " + lons[0] + " maxLon: " + lons[lons.length - 1]);
                        System.err.println("minLat: " + lats[0] + " maxLat: " + lats[lats.length - 1]);
                        return false;
                    }
                    nLon = lons.length;
                    nLat = lats.length;
                    times = (double[])NCUtil.findNcVariable(nc, "TIME").read().copyTo1DJavaArray();
                    nTime = times.length;
                    eta = new float[nTime];
                    while (lons[indx] < tsLon) {
                        ++indx;
                    }
                    indx = indx < 1 ? 1 : indx;
                    int n = indx = lons[indx] - tsLon > tsLon - lons[indx - 1] ? indx - 1 : indx;
                    while (lats[jndx] < tsLat) {
                        ++jndx;
                    }
                    jndx = jndx < 1 ? 1 : jndx;
                    int n2 = jndx = lats[jndx] - tsLat > tsLat - lats[jndx - 1] ? jndx - 1 : jndx;
                    if (verbose) {
                        System.out.println("axis indices (zero-based): ");
                        System.out.println("lon-index: " + indx + " closest lon: " + lons[indx]);
                        System.out.println("lat-index: " + jndx + " closest lat: " + lats[jndx]);
                        System.out.println("Mw: " + dfxx.format(Mw));
                    }
                } else if (NCUtil.findNcDimension(nc, "LON").getLength() != nLon || NCUtil.findNcDimension(nc, "LAT").getLength() != nLat || NCUtil.findNcDimension(nc, "TIME").getLength() != nTime) {
                    System.err.println("The source files are not all on the same propagation grid");
                    return false;
                }
                float[] etain = new float[nTime];
                if (propcomb.isCompressed(nc)) {
                    origin = new int[]{jndx, indx};
                    shape = new int[]{1, 1};
                    int[] start = (int[])nc.findVariable("start").read(origin, shape).copyTo1DJavaArray();
                    int[] end = (int[])nc.findVariable("end").read(origin, shape).copyTo1DJavaArray();
                    end[0] = end[0] - start[0] + 1;
                    if (start[0] == -1) {
                        System.err.println("No data at this point (missing value)... try nearby points.");
                        return false;
                    }
                    byte[] store = (byte[])NCUtil.findNcVariable(nc, "ha").read(start, end).copyTo1DJavaArray();
                    if (propcomb.isDynamic(nc)) {
                        if (debug) {
                            System.out.println("Dynamic compression");
                        }
                        etain = AltCompression.decode(store);
                    } else {
                        int stime = nc.findVariable("start_time").read(origin, shape).getInt(0);
                        float quant = nc.findGlobalAttribute("Quantization").getNumericValue().floatValue();
                        float[] data = NioSDecode.decode(store, quant);
                        if (debug) {
                            System.out.println("Standard compression. quant: " + quant);
                            System.out.println("start: " + start[0] + " end: " + end[0]);
                            System.out.println("stime: " + stime + " data.length: " + data.length);
                            System.out.println("stime+data.length: " + (stime + data.length) + " nTime:" + nTime);
                        }
                        for (int i2 = stime; i2 < stime + data.length; ++i2) {
                            etain[i2] = data[i2 - stime];
                        }
                    }
                } else {
                    if (debug) {
                        System.out.println("Uncompressed source");
                    }
                    origin = new int[]{0, jndx, indx};
                    shape = new int[]{nTime, 1, 1};
                    etain = (float[])NCUtil.findNcVariable(nc, "ha").read(origin, shape).get1DJavaArray(Float.TYPE);
                }
                for (i = 0; i < nTime; ++i) {
                    int n = i;
                    eta[n] = eta[n] + (float)alpha * etain[i];
                }
            }
            DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
            DecimalFormat dfxxxxxx = new DecimalFormat("0.000000");
            if (outFilePattern.equals("")) {
                System.out.println("# Timeseries from source: " + inversion);
                System.out.println("# Mw: " + dfxx.format(Mw));
                System.out.println("# Lat: " + dfxxxxx.format(tsLat) + " Lon: " + dfxxxxx.format(tsLon) + " i-index: " + indx + " j-index: " + jndx);
                System.out.println("# time (hrs from event) height (cm)");
                for (int i3 = 0; i3 < nTime; ++i3) {
                    System.out.println(dfxxxxx.format((double)(times[i3] / 3600.0)) + " " + dfxxxxxx.format((double)eta[i3]));
                }
            } else {
                PrintWriter pw = new PrintWriter(new File(outDir, outFilePattern));
                pw.println("# Timeseries from source: " + inversion);
                pw.println("# Mw: " + dfxx.format(Mw));
                pw.println("# Lat: " + dfxxxxx.format(tsLat) + " Lon: " + dfxxxxx.format(tsLon) + " i-index: " + indx + " j-index: " + jndx);
                pw.println("# time (hrs from event) height (cm)");
                for (i = 0; i < nTime; ++i) {
                    pw.println(dfxxxxx.format((double)(times[i] / 3600.0)) + " " + dfxxxxxx.format((double)eta[i]));
                }
                pw.close();
            }
        }
        catch (IOException | InvalidRangeException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void usage() {
        System.err.println("propcomb: decompresses and creates linear combinations of PropDB files.");
        System.err.println("Usage:");
        System.err.println("propcomb [options] alpha1*source1+alpha2*source2+...");
        System.err.println("where [options] can be:");
        System.err.println("-x [minLon maxLon minLat maxLat] lat/lon extents defaults to full grid)");
        System.err.println("-i [startTime endTime] time interval, in hours (defaults to full time axis)");
        System.err.println("-g [bathymetry grid file name (for extents)]");
        System.err.println("-o [output directory (defaults to \".\")]");
        System.err.println("-p [output filename pattern (eg, \"WestPac\") defaults to \"linCo\"]\n    use this to set output filename for time series output ('-s' switch)");
        System.err.println("-h produce \"h\" file only (defaults to h, u, and v files)");
        System.err.println("-l [propagation files directory] (if switch not set, looks for env var \"PROPDBDIR\")");
        System.err.println("-d deformation: produce linearly-combined deformation variable (this is now the default! see -f)");
        System.err.println("-f no deformation: suppress the linearly-combined deformation variable");
        System.err.println("-t travel time: add computed travel time variable (defaults to no travel_time variable)");
        System.err.println("-m max amp: add maximum amplitude variable (defaults to no max_height variable)");
        System.err.println("-n no ha: suppress the output of time-dependant variables (useful for producing max-amp figures)");
        System.err.println("-b bathymetry: copy bathymetry to output file (uses first source file)");
        System.err.println("-s [lon lat] produce time series at the specified longitude and latitude (closest grid  point).\n    If filename pattern is set ('-o' and '-p' switches), it outputs to a file, otherwise uses stdout.");
        System.err.println("-e event: date/time for event-relative time axis units = seconds since 'YYYY-MM-DDThh:mm:ssZ' (default copied from file)");
        System.err.println("-3 netcdf3: attempt to create classic netcdf3 version files. Note file size must be < 4Gb");
        System.err.println("-v produce verbose text output\n");
        System.err.println("Examples:\n");
        System.out.println("  for only HA, with travel time, max amp, for NW Pacific, try: ");
        System.err.println("propcomb -v -t -m -h -x 121 200 0 60 -e '2011-03-11T05:46:24Z' 4.66*ki24b+12.23*ki25b+26.31*ki26a+21.27*ki26b+22.75*ki27a+4.98*ki27b");
        System.out.println("  for getting extents for a file, with deformation, try: ");
        System.out.println("propcomb -v -d -g FA_HI_2min_20120418.ssl 3.720*cs66a+3.720*cs66b+3.720*cs67a+3.720*cs67z+3.720*cs68a+3.720*cs68z");
        System.err.println("  for using a custom MOST prop file (must be on same grid as other files):");
        System.err.println("propcomb -v -x 200 240 30 50 -l /path/to/files 1.0*<filenameprefix>");
        System.err.println("(where <filenameprefix> is the filename minus the 'ha.nc', 'ua.nc' and 'va.nc'");
        System.err.println("  for getting a time series at a location (e.g. DART 52406 location for Tohoku event):");
        System.err.println("propcomb -s 165.002 -5.293 4.66*ki24b+12.23*ki25b+26.31*ki26a+21.27*ki26b+22.75*ki27a+4.98*ki27b");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            propcomb.usage();
            return;
        }
        long sTime = System.currentTimeMillis();
        StringBuffer sb = new StringBuffer();
        sb.append(histDF.format(new Date()));
        sb.append("propcomb");
        for (String s : args) {
            sb.append(" ");
            sb.append(s);
        }
        history = sb.toString();
        PrintStream filterOut = new PrintStream(System.err){

            @Override
            public void println(String l) {
                if (!l.startsWith("SLF4J")) {
                    super.println(l);
                }
            }
        };
        System.setErr(filterOut);
        if (verbose) {
            // empty if block
        }
        int offset = 0;
        while (offset < args.length && args[offset].startsWith("-")) {
            String arg;
            if ("-x".equals(arg = args[offset++])) {
                if (gridFile != null) {
                    System.err.println("Specify either -x and extents, or -g and grid frile to get extents, not both.");
                    System.exit(-7);
                }
                if (offset + 4 < args.length) {
                    try {
                        minLon = Double.parseDouble(args[offset++]);
                        maxLon = Double.parseDouble(args[offset++]);
                        minLat = Double.parseDouble(args[offset++]);
                        maxLat = Double.parseDouble(args[offset++]);
                        if (minLon < 0.0 || maxLon < 0.0) {
                            minLon += 360.0;
                            maxLon += 360.0;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Arguments with the -x switch must be 4 numbers: minLon maxLon minLat maxLat");
                        System.exit(-1);
                    }
                }
                fullGridExtents = false;
                continue;
            }
            if ("-i".equals(arg)) {
                try {
                    minTime = Double.parseDouble(args[offset++]) * 3600.0;
                    maxTime = Double.parseDouble(args[offset++]) * 3600.0;
                }
                catch (NumberFormatException nfe) {
                    System.err.println("Arguments with the -i switch must be 2 numbers: startTime endTime (in hours).");
                    System.exit(19);
                }
                fullTimeInterval = false;
                continue;
            }
            if ("-g".equals(arg)) {
                if (minLon != 540.0) {
                    System.err.println("Specify either -x and extents, or -g and grid file to get extents, not both.");
                    System.exit(-7);
                }
                if (!(gridFile = new File(args[offset++])).exists()) {
                    System.err.println("Bathymetry grid file for extents: " + gridFile.getPath() + " does not exist.");
                    System.exit(-2);
                }
                fullGridExtents = false;
                continue;
            }
            if ("-p".equals(arg)) {
                outFilePattern = args[offset++];
                continue;
            }
            if ("-o".equals(arg)) {
                if ((outDir = new File(args[offset++])).exists()) continue;
                System.err.println("Output directory: " + outDir.getPath() + " does not exist.");
                System.exit(-3);
                continue;
            }
            if ("-s".equals(arg)) {
                timeSeries = true;
                tsLon = Double.parseDouble(args[offset++]);
                tsLat = Double.parseDouble(args[offset++]);
                continue;
            }
            if ("-e".equals(arg)) {
                try {
                    Date d = sdf.parse(args[offset++]);
                    eventTime = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    eventTime.setTime(d);
                }
                catch (ParseException ex) {
                    log.log(Level.SEVERE, "Error parsing event date.", ex);
                    System.err.println("Error parsing event date: " + args[offset] + ".  Please use ISO format: 'YYYY-MM-DDThh:mm:ssZ'");
                    System.exit(-5);
                }
                continue;
            }
            if ("-l".equals(arg)) {
                propDir = new File(args[offset++]);
                continue;
            }
            if ("-h".equals(arg)) {
                honly = true;
                continue;
            }
            if ("-d".equals(arg)) {
                includeDef = true;
                readDef = true;
                continue;
            }
            if ("-f".equals(arg)) {
                includeDef = false;
                readDef = false;
                continue;
            }
            if ("-t".equals(arg)) {
                includeTTime = true;
                readDef = true;
                continue;
            }
            if ("-m".equals(arg)) {
                includeMaxAmp = true;
                continue;
            }
            if ("-n".equals(arg)) {
                noTimeVars = true;
                continue;
            }
            if ("-v".equals(arg)) {
                verbose = true;
                continue;
            }
            if ("-b".equals(arg)) {
                copyBathymetry = true;
                continue;
            }
            if (!"-3".equals(arg)) continue;
            forceNetcdf4 = false;
        }
        if (offset == args.length) {
            --offset;
        }
        inversion = "";
        String m = "";
        while (offset < args.length) {
            inversion = inversion + m + args[offset++];
            m = m.equals("*") ? "+" : "*";
        }
        if (propcomb.parseInversion() < 1) {
            System.err.println("Unable to parse inversion string: " + inversion);
            System.exit(-8);
        }
        if (verbose) {
            System.out.println("Parsed inversion: ");
            for (Map.Entry<String, Double> e : sourceMap.entrySet()) {
                System.out.println(e.getKey() + ": " + e.getValue());
            }
        }
        if (!propcomb.findPropFiles()) {
            System.err.println("Can't find sources specified in inversion in the Propagation Database: " + propDir.getPath());
            System.exit(-9);
        }
        if (timeSeries) {
            if (propcomb.getTimeSeries()) {
                System.exit(0);
            } else {
                System.err.println("Can't find requested time series");
                System.exit(-11);
            }
        }
        if (gridFile != null) {
            propcomb.readExtents();
        } else if (minLon != 540.0) {
            // empty if block
        }
        if (verbose) {
            System.out.println("Options:");
            System.out.println("Output directory: " + outDir.getPath());
            if (outFilePattern.equals("")) {
                System.out.println("Output file pattern: linCo{h,u,v}.nc");
            } else {
                System.out.println("Output file pattern: " + outFilePattern);
            }
            System.out.println("Propagation Database directory: " + propDir.getPath());
            System.out.println("Solution/Inversion: " + inversion);
            System.out.println("Mw: " + dfxx.format(Mw));
            if (includeMaxAmp) {
                System.out.println("Max amp included");
            }
            if (includeTTime) {
                System.out.println("Travel time included");
            }
            if (noTimeVars) {
                System.out.println("No time-dependent variables (ha/ua/va)");
            }
            if (!forceNetcdf4) {
                System.out.println("netCDF 3 file requested.");
            }
        }
        try {
            propcomb.createLinComb("ha");
            if (!honly) {
                propcomb.createLinComb("ua");
                propcomb.createLinComb("va");
            }
        }
        catch (IOException ioe) {
            if (verbose) {
                log.log(Level.SEVERE, "Error combining files", ioe);
                ioe.printStackTrace();
            }
            System.exit(-10);
        }
        if (verbose) {
            long elapsedTime = System.currentTimeMillis() - sTime;
            System.out.println("Done.  Elapsed time: " + dfxx.format((double)elapsedTime / 1000.0) + " [sec].");
        }
        System.exit(0);
    }

    static {
        timeSeries = false;
        gridFile = null;
        honly = false;
        outFilePattern = "";
        outDir = new File(".");
        propDir = null;
        copyBathymetry = false;
        bathVar = null;
        includeDef = true;
        readDef = true;
        defVar = null;
        noTimeVars = false;
        forceNetcdf4 = true;
        decimator = 0;
        includeTTime = false;
        ttimeVar = null;
        includeMaxAmp = false;
        maxVar = null;
        history = "";
        eventTime = null;
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        sdfo = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss XXX", Locale.US);
        histDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z: ");
        dfxx = new DecimalFormat("0.00");
        verbose = false;
        inversion = "";
        Mw = 0.0;
        sourceMap = new LinkedHashMap<String, Double>();
        fileMap = new LinkedHashMap<String, String>();
        epiLat = new ArrayList();
        epiLon = new ArrayList();
        ncout = null;
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        sdfo.setTimeZone(TimeZone.getTimeZone("GMT"));
        namePatterns = new Pattern[]{Pattern.compile("([a-z]{2})(?:sz)?([0-9]+)([a-z])"), Pattern.compile("([a-z]{2})(?:sz)?([a-z])([0-9]+)"), Pattern.compile("([a-z]{2})_([0-9]+)([a-z])")};
        namePatternIndexes = new int[][]{{1, 2, 3}, {1, 3, 2}, {1, 2, 3}};
    }
}

