/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.most;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class most2netcdf {
    public static final Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static double[] lons;
    private static double[] lats;
    private static double[] deps;
    private static int nLon;
    private static int nLat;
    private static File gridFile;
    private static BufferedReader openFile;
    private static NetcdfFile nc;
    private static double bathymetryInvert;
    private static float nodata;
    private static boolean fliplat;
    private static double minLat;
    private static double maxLat;
    private static double minLon;
    private static double maxLon;
    private static double evennessCutoff;
    private static String history;
    private static boolean quiet;
    private static DecimalFormat dfxx;
    private static SimpleDateFormat sdf;
    private static SimpleDateFormat histDF;
    private static Map<String, Attribute> attMap;

    private static void readBathymetryGrid(File gridF) throws IOException {
        gridFile = gridF;
        most2netcdf.readGridHeaders();
        double minDepth = Double.POSITIVE_INFINITY;
        double maxDepth = Double.NEGATIVE_INFINITY;
        deps = new double[nLat * nLon];
        if (openFile == null && nc == null) {
            most2netcdf.readGridHeaders();
        }
        if (nc != null) {
            int i;
            int j;
            Variable ba = nc.findVariable("bathy");
            if (ba == null) {
                ba = nc.findVariable("BATHY");
            }
            if (ba == null) {
                ba = nc.findVariable("bathymetry");
            }
            if (ba == null) {
                ba = nc.findVariable("BATHYMETRY");
            }
            if (ba == null) {
                ba = nc.findVariable("depth");
            }
            if (ba == null) {
                ba = nc.findVariable("DEPTH");
            }
            Array data = ba.read();
            if (fliplat) {
                for (j = 0; j < nLat; ++j) {
                    for (i = 0; i < nLon; ++i) {
                        most2netcdf.deps[most2netcdf.nLat * i + (most2netcdf.nLat - 1 - j)] = data.getDouble(nLon * j + i);
                    }
                }
            } else {
                for (j = 0; j < nLat; ++j) {
                    for (i = 0; i < nLon; ++i) {
                        most2netcdf.deps[most2netcdf.nLat * i + j] = data.getDouble(nLon * j + i);
                    }
                }
            }
            maxDepth = MAMath.getMaximum(data);
            minDepth = MAMath.getMinimum(data);
            List<Attribute> attList = nc.getGlobalAttributes();
            for (Attribute att : attList) {
                attMap.put(att.getShortName(), att);
            }
            nc.close();
        } else {
            double dv = 0.0;
            if (fliplat) {
                log.fine("flipping lats on z");
            }
            for (int j = 0; j < nLat; ++j) {
                String line = openFile.readLine();
                if (line == null) {
                    throw new IOException("Error reading bathy grid.");
                }
                String[] lineArr = line.trim().split("\\s+");
                if (lineArr.length != nLon) {
                    throw new IOException("Error reading bathy grid.");
                }
                try {
                    for (int i = 0; i < nLon; ++i) {
                        dv = Double.parseDouble(lineArr[i]);
                        if (fliplat) {
                            most2netcdf.deps[most2netcdf.nLat * i + j] = dv;
                        } else {
                            most2netcdf.deps[most2netcdf.nLat * i + (most2netcdf.nLat - 1 - j)] = dv;
                        }
                        minDepth = dv < minDepth ? dv : minDepth;
                        maxDepth = dv > maxDepth ? dv : maxDepth;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Error reading bathy grid.");
                }
            }
        }
        log.fine("Bathy file: " + gridFile.getName() + " first bathy values of first two rows: " + deps[0] + ", " + deps[nLat]);
        if (openFile != null) {
            openFile.close();
        }
        openFile = null;
        nc = null;
        minLon = Math.min(lons[0], lons[lons.length - 1]);
        maxLon = Math.max(lons[0], lons[lons.length - 1]);
        minLat = Math.min(lats[0], lats[lats.length - 1]);
        maxLat = Math.max(lats[0], lats[lats.length - 1]);
    }

    private static void readGridHeaders() throws IOException {
        try {
            nc = NetcdfFile.open(gridFile.getPath());
            Variable v = nc.findVariable("lon");
            if (v == null) {
                v = nc.findVariable("LON");
            }
            if (v == null) {
                throw new IOException("can't find lon variable");
            }
            lons = (double[])v.read().copyTo1DJavaArray();
            v = nc.findVariable("lat");
            if (v == null) {
                v = nc.findVariable("LAT");
            }
            if (v == null) {
                throw new IOException("can't find lat variable");
            }
            lats = (double[])v.read().copyTo1DJavaArray();
            nLon = lons.length;
            nLat = lats.length;
        }
        catch (Exception ignore) {
            FileReader fr = new FileReader(gridFile);
            BufferedReader br = new BufferedReader(fr);
            br.mark(4096);
            String inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("no content found in input file");
            }
            br.reset();
            if (inputLine.toLowerCase().startsWith("ncols")) {
                most2netcdf.readAsciiRasterHeader(br);
            } else {
                most2netcdf.readMOSTFormatHeader(br);
            }
            openFile = br;
        }
        if (lons[0] > 460.0 || lons[0] < -360.0) {
            throw new IOException("This grid file appears to be in projected coordinates (eg UTM, State Plane). Please use geodetic (latitude/longitude) coordinates.");
        }
        if (lons[0] < 0.0 || lons[lons.length - 1] < 0.0) {
            int i = 0;
            while (i < lons.length) {
                int n = i++;
                lons[n] = lons[n] + 360.0;
            }
        }
        if (lats[0] > lats[1]) {
            log.warning("MOST Grid latitude not in image format (top-down), flipping");
            fliplat = true;
            int left = 0;
            for (int right = lats.length - 1; left < right; ++left, --right) {
                double temp = lats[left];
                most2netcdf.lats[left] = lats[right];
                most2netcdf.lats[right] = temp;
            }
        }
        log.log(Level.INFO, "Loaded bathymetry file: {0}\nnLon: {1} nLat: {2}", new Object[]{gridFile.toString(), lons.length, lats.length});
    }

    private static void readAsciiRasterHeader(BufferedReader br) throws IOException {
        int i;
        double cellsize;
        double yllcorner;
        double yshift;
        double xllcorner;
        double xshift;
        String inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        String[] inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("ncols")) {
            throw new IOException("error reading ASCII raster grid file: expected 'ncols' token");
        }
        try {
            nLon = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("error reading ASCII raster grid file: invalid 'ncols' value: " + ex.getMessage());
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("nrows")) {
            throw new IOException("error reading ASCII raster grid file: expected 'nrows' token");
        }
        try {
            nLat = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("error reading ASCII raster grid file: invalid 'nrows' value: " + ex.getMessage());
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("xllcorner")) {
            xshift = 0.5;
        } else if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("xllcenter")) {
            xshift = 0.0;
        } else {
            throw new IOException("error reading ASCII raster grid file: expected 'xllcenter' or 'xllcorner' tokens");
        }
        try {
            xllcorner = Double.parseDouble(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("yllcorner")) {
            yshift = 0.5;
        } else if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("yllcenter")) {
            yshift = 0.0;
        } else {
            throw new IOException("error reading ASCII raster grid file: expected 'yllcenter' or 'yllcorner' tokens");
        }
        try {
            yllcorner = Double.parseDouble(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+");
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("cellsize")) {
            throw new IOException("error reading ASCII raster grid file: expected 'cellsize' token");
        }
        try {
            cellsize = Float.parseFloat(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        xllcorner += xshift * cellsize;
        yllcorner += yshift * cellsize;
        lons = new double[nLon];
        lats = new double[nLat];
        for (i = 0; i < nLon; ++i) {
            most2netcdf.lons[i] = xllcorner + (double)i * cellsize;
        }
        for (i = 0; i < nLat; ++i) {
            most2netcdf.lats[i] = yllcorner + (double)i * cellsize;
        }
        br.mark(16384);
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        nodata = Float.parseFloat(inputArray[1]);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("nodata_value")) {
            br.reset();
        }
    }

    private static void readMOSTFormatHeader(BufferedReader br) throws IOException {
        String inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading MOST grid file: unexpected EOF");
        }
        try {
            String[] inputArray = inputLine.trim().split("\\s+");
            nLon = Integer.parseInt(inputArray[0]);
            nLat = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("This does not appear to be a MOST format file");
        }
        lons = new double[nLon];
        lats = new double[nLat];
        for (int i = 0; i < nLon; ++i) {
            inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("error reading MOST grid axes: unexpected EOF");
            }
            try {
                most2netcdf.lons[i] = Double.parseDouble(inputLine.trim());
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IOException("error parsing MOST grid axes: not in MOST format?");
            }
        }
        for (int j = nLat - 1; j >= 0; --j) {
            inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("error reading MOST grid axes: unexpected EOF");
            }
            try {
                most2netcdf.lats[j] = Double.parseDouble(inputLine.trim());
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IOException("error parsing MOST grid axes: not in MOST format?");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsMOST(File oFile) throws IOException {
        if (!quiet) {
            System.out.println("\nWARNING: converting from netCDF to MOST Grid file format results in lost metadata!");
            System.out.println("These are the metadata attributes in the netCDF file.  Please archive them appropriately:\n");
            for (Attribute att : attMap.values()) {
                DataType type = att.getDataType();
                if (type == DataType.DOUBLE || type == DataType.FLOAT) {
                    System.out.println(att.getShortName() + ": " + att.getNumericValue().toString());
                    continue;
                }
                if (type != DataType.STRING) continue;
                System.out.println(att.getShortName() + ": " + att.getStringValue());
            }
        }
        NumberFormat coordFormat = NumberFormat.getNumberInstance(Locale.US);
        coordFormat.setMaximumFractionDigits(15);
        coordFormat.setGroupingUsed(false);
        NumberFormat depthFormat = NumberFormat.getNumberInstance(Locale.US);
        depthFormat.setMaximumFractionDigits(3);
        depthFormat.setGroupingUsed(false);
        try (FileWriter pw = new FileWriter(oFile);){
            int j;
            pw.write(" " + nLon + " " + nLat + "\n");
            for (int i = 0; i < nLon; ++i) {
                pw.write(coordFormat.format(lons[i]));
                pw.write(10);
            }
            for (j = nLat - 1; j >= 0; --j) {
                pw.write(coordFormat.format(lats[j]));
                pw.write(10);
            }
            for (j = nLat - 1; j >= 0; --j) {
                for (int i = 0; i < nLon; ++i) {
                    pw.write(32);
                    pw.write(depthFormat.format(bathymetryInvert * deps[nLat * i + j]));
                }
                pw.write(10);
            }
        }
    }

    public static double getMinDX(double[] lonslats) {
        double dx = 0.0;
        double mindx = 100000.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            mindx = dx < mindx ? dx : mindx;
        }
        return mindx;
    }

    public static double getMaxDX(double[] lonslats) {
        double dx = 0.0;
        double maxdx = 0.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            maxdx = dx > maxdx ? dx : maxdx;
        }
        return maxdx;
    }

    public static double getAveDX(double[] lonslats) {
        double dx = 0.0;
        double sumdx = 0.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            sumdx += dx;
        }
        return sumdx / ((double)lonslats.length - 1.0);
    }

    public static String getResLabel(double res) {
        String reslabel = "";
        reslabel = dfxx.format(res) + " deg";
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcmin";
        }
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcsec";
        }
        return reslabel;
    }

    public static void saveAsNetCDF(File ncFile) throws IOException {
        double epsy;
        NetcdfFileWriter ncfw = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, ncFile.getPath(), null);
        Dimension lonDim = ncfw.addDimension(null, "lon", lons.length);
        Dimension latDim = ncfw.addDimension(null, "lat", lats.length);
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        dimList.add(lonDim);
        Variable lonVar = ncfw.addVariable(null, "lon", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        Variable latVar = ncfw.addVariable(null, "lat", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        dimList.add(lonDim);
        Variable bathVar = ncfw.addVariable(null, "bathy", DataType.FLOAT, dimList);
        dimList.clear();
        Variable crVar = ncfw.addVariable(null, "crs", DataType.INT, dimList);
        String spcx = "even";
        double mindx = most2netcdf.getMinDX(lons);
        double maxdx = most2netcdf.getMaxDX(lons);
        double epsx = evennessCutoff * (mindx + maxdx) / 2.0;
        if (maxdx - mindx > epsx) {
            spcx = "uneven";
        }
        String spcy = "even";
        double mindy = most2netcdf.getMinDX(lats);
        double maxdy = most2netcdf.getMaxDX(lats);
        if (maxdy - mindy > (epsy = evennessCutoff * (mindy + maxdy) / 2.0)) {
            spcy = "uneven";
        }
        lonVar.addAttribute(new Attribute("long_name", "Longitude"));
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("point_spacing", spcx));
        if ("even".equals(spcx)) {
            lonVar.addAttribute(new Attribute("resolution", most2netcdf.getResLabel(most2netcdf.getAveDX(lons))));
        } else {
            lonVar.addAttribute(new Attribute("resolution_min", most2netcdf.getResLabel(mindx)));
            lonVar.addAttribute(new Attribute("resolution_max", most2netcdf.getResLabel(maxdx)));
        }
        latVar.addAttribute(new Attribute("long_name", "Latitude"));
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("point_spacing", spcy));
        if ("even".equals(spcy)) {
            latVar.addAttribute(new Attribute("resolution", most2netcdf.getResLabel(most2netcdf.getAveDX(lats))));
        } else {
            latVar.addAttribute(new Attribute("resolution_min", most2netcdf.getResLabel(mindy)));
            latVar.addAttribute(new Attribute("resolution_max", most2netcdf.getResLabel(maxdy)));
        }
        crVar.addAttribute(new Attribute("grid_mapping_name", "latitude_longitude"));
        crVar.addAttribute(new Attribute("longitude_of_prime_meridian", 0.0));
        crVar.addAttribute(new Attribute("semi_major_axis", 6378137.0));
        crVar.addAttribute(new Attribute("inverse_flattening", 298.257223563));
        crVar.addAttribute(new Attribute("crs_wkt", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        crVar.addAttribute(new Attribute("spatial_ref", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]"));
        bathVar.addAttribute(new Attribute("long_name", "Grid Bathymetry"));
        bathVar.addAttribute(new Attribute("standard_name", "sea_floor_depth_below_geoid"));
        bathVar.addAttribute(new Attribute("units", "meters"));
        bathVar.addAttribute(new Attribute("positive", "down"));
        bathVar.addAttribute(new Attribute("grid_mapping", "crs"));
        bathVar.addAttribute(new Attribute("VerticalDatum", "urn:x-noaa:def:datum:noaa::MHW"));
        bathVar.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        bathVar.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
        ncfw.addGroupAttribute(null, new Attribute("Conventions", "CF-1.6,ACDD-1.3"));
        for (Map.Entry<String, Attribute> e : attMap.entrySet()) {
            ncfw.addGroupAttribute(null, e.getValue());
        }
        ncfw.addGroupAttribute(null, new Attribute("geospatial_lat_min", minLat));
        ncfw.addGroupAttribute(null, new Attribute("geospatial_lat_max", maxLat));
        ncfw.addGroupAttribute(null, new Attribute("geospatial_lon_min", minLon));
        ncfw.addGroupAttribute(null, new Attribute("geospatial_lon_max", maxLon));
        ncfw.addGroupAttribute(null, new Attribute("geospatial_vertical_positive", "down"));
        ncfw.addGroupAttribute(null, new Attribute("geospatial_bounds_vertical_crs", "EPSG:5868"));
        ncfw.create();
        try {
            ncfw.write(lonVar, Array.factory(lons));
            ncfw.write(latVar, Array.factory(lats));
            ArrayFloat.D2 depsarr = new ArrayFloat.D2(nLat, nLon);
            for (int j = 0; j < nLat; ++j) {
                for (int i = 0; i < nLon; ++i) {
                    depsarr.set(j, i, (float)(bathymetryInvert * deps[nLat * i + j]));
                }
            }
            ncfw.write(bathVar, depsarr);
        }
        catch (InvalidRangeException ex) {
            log.log(Level.SEVERE, "Error creating bathy netcdf file", ex);
            throw new IOException(ex);
        }
        ncfw.close();
    }

    private static void initializeMetadata() {
        attMap = new LinkedHashMap<String, Attribute>();
        attMap.put("title", new Attribute("title", "MOST model bathymetry grid"));
        attMap.put("summary", new Attribute("summary", "MOST model Bathymetry grid"));
        attMap.put("keywords", new Attribute("keywords", "MOST, tsunami, bathymetry, nested grid, grid, inundation model"));
        attMap.put("source", new Attribute("source", "Original DEMs used in this grid"));
        attMap.put("institution", new Attribute("institution", "US-Department of Commerce/National Oceanic and Atmospheric Administration/ Oceanic and Atmospheric Research/Pacific Marine Environmental Laboratory/ NOAA Center for Tsunami Research"));
        attMap.put("references", new Attribute("references", "http://nctr.pmel.noaa.gov/sim.html"));
        attMap.put("history", new Attribute("history", history));
        attMap.put("id", new Attribute("id", "doi:"));
        attMap.put("version", new Attribute("version", "1.0"));
        attMap.put("date_created", new Attribute("date_created", sdf.format(new Date())));
        attMap.put("grid_level", new Attribute("grid_level", "X"));
        attMap.put("model_type", new Attribute("model_type", "Xxxxxxx"));
        attMap.put("region_code", new Attribute("region_code", "X"));
        attMap.put("model_code", new Attribute("model_code", "XXX"));
        attMap.put("model_name", new Attribute("model_name", "xxxxxxxx"));
        attMap.put("model_long_name", new Attribute("model_long_name", "Xxxxxxx Xxxx, XX"));
    }

    private static void getInteractiveMetadata() {
        System.out.println("\nEnter new values for metadata (or press \"return\" to accept default value):\n");
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String input = "";
        for (Map.Entry<String, Attribute> e : attMap.entrySet()) {
            Attribute att = e.getValue();
            DataType type = att.getDataType();
            if (type == DataType.DOUBLE || type == DataType.FLOAT) {
                input = att.getNumericValue().toString();
            } else if (type == DataType.STRING) {
                input = att.getStringValue();
            }
            System.out.println(e.getKey() + ": " + input);
            System.out.print("new value (or return): ");
            try {
                input = br.readLine();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "Error reading metadata, exiting.", ex);
                System.exit(-3);
            }
            if ("".equals(input)) continue;
            try {
                double d = Double.parseDouble(input);
                att = new Attribute(e.getKey(), d);
            }
            catch (NumberFormatException nfe) {
                att = new Attribute(e.getKey(), input);
            }
            attMap.put(e.getKey(), att);
        }
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void editAttribute(String attname) {
        Attribute att = attMap.get(attname);
        if (att == null) {
            System.err.println("Can't find attribute: " + attname);
            System.out.println("Attributes are: ");
            for (Attribute anatt : attMap.values()) {
                DataType type = anatt.getDataType();
                if (type == DataType.DOUBLE || type == DataType.FLOAT) {
                    System.out.println(anatt.getShortName() + ": " + anatt.getNumericValue().toString());
                    continue;
                }
                if (type != DataType.STRING) continue;
                System.out.println(anatt.getShortName() + ": " + anatt.getStringValue());
            }
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            String input = "";
            DataType type = att.getDataType();
            if (type == DataType.DOUBLE || type == DataType.FLOAT) {
                input = att.getNumericValue().toString();
            } else if (type == DataType.STRING) {
                input = att.getStringValue();
            }
            System.out.println(att.getShortName() + ": " + input);
            System.out.print("new value (or return): ");
            try {
                input = br.readLine();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, "Error reading metadata, exiting.", ex);
                System.exit(-3);
            }
            if (!"".equals(input)) {
                try {
                    double d = Double.parseDouble(input);
                    att = new Attribute(att.getShortName(), d);
                }
                catch (NumberFormatException nfe) {
                    att = new Attribute(att.getShortName(), input);
                }
                attMap.put(att.getShortName(), att);
            }
        }
    }

    private static void parseXML(File xmlfile) {
        try {
            DocumentBuilder dBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = dBuilder.parse(xmlfile);
            Element eel = (Element)doc.getElementsByTagName("gmd:MD_DataIdentification").item(0);
            String ti = eel.getElementsByTagName("gmd:title").item(0).getChildNodes().item(1).getTextContent();
            attMap.put("title", new Attribute("title", ti));
            String da = eel.getElementsByTagName("gco:Date").item(0).getTextContent();
            attMap.put("date_created", new Attribute("date_created", da));
            String ab = eel.getElementsByTagName("gmd:abstract").item(0).getChildNodes().item(1).getTextContent();
            attMap.put("summary", new Attribute("summary", ab));
            NodeList nList = doc.getElementsByTagName("gmd:sourceCitation");
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (int i = 0; i < nList.getLength(); ++i) {
                eel = (Element)nList.item(i);
                sb.append(sep);
                sb.append(eel.getElementsByTagName("gmd:title").item(0).getChildNodes().item(1).getTextContent());
                sep = ", ";
            }
            attMap.put("source", new Attribute("source", sb.toString()));
        }
        catch (IOException | ParserConfigurationException | SAXException ioe) {
            log.log(Level.SEVERE, "Error parsing XML file: " + xmlfile.getPath() + ", exiting.", ioe);
            System.exit(-4);
        }
    }

    private static void usage() {
        System.err.println("\nUsage: Converts MOST grid file format to MOST netCDF file (or back to grid format).");
        System.err.println("most2netcdf [-i] [-a attribute name] [-x XMLmetadatafile] [-d cutoff %] <inputfile> [<outputfile>]");
        System.err.println("If <inputfile> is MOST grid (text) format, it converts to netCDF and saves in <outputfile>");
        System.err.println("If <inputfile> is netCDF, it converts to text format.");
        System.err.println("If <outputfile> argument is missing, it uses the filename <inputfile> with");
        System.err.println("  extension either \"most\" (for text), or \".nc\" (for netCDF)");
        System.err.println("Use the \"-i\" switch to interactively add metadata.");
        System.err.println("Use the \"-a\" switch to edit an individual metadata attribute (e.g., \"most2netcdf -a source <gridfile>\").");
        System.err.println("Use the \"-x\" switch to specify a metadata file in XML format.");
        System.err.println("Use the \"-z\" switch to invert (positive-up to positive-down, or vice-versa).");
        System.err.println("Use the \"-v\" switch to produce verbose text output.");
        System.err.println("Use the \"-q\" switch to suppress all text output.");
        System.err.println("Use the \"-d\" switch to set the % cutoff for determining even axes (e.g., enter \"-d 0.05\" for a 5% cutoff).");
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            most2netcdf.usage();
            return;
        }
        int offset = 0;
        boolean interactive = false;
        boolean editatt = false;
        String attname = "";
        boolean parsexml = false;
        boolean reverse = false;
        boolean verbose = false;
        File xmlfile = null;
        File infile = null;
        File outfile = null;
        StringBuffer sb = null;
        log.setLevel(Level.ALL);
        PrintStream filterOut = new PrintStream(System.err){

            @Override
            public void println(String l) {
                if (!l.startsWith("SLF4J")) {
                    super.println(l);
                }
            }
        };
        System.setErr(filterOut);
        while (offset < args.length && args[offset].startsWith("-")) {
            String arg;
            if ("-i".equals(arg = args[offset++])) {
                interactive = true;
                continue;
            }
            if ("-a".equals(arg)) {
                editatt = true;
                if (offset < args.length) {
                    attname = args[offset++];
                    continue;
                }
                System.err.println("\nError: Missing attribute name to edit.");
                most2netcdf.usage();
                System.exit(-13);
                continue;
            }
            if ("-x".equals(arg)) {
                if (interactive) {
                    System.err.println("\nError: You must choose either \"interactive\" (-i), or \"xml\" (-x), not both.");
                    most2netcdf.usage();
                    System.exit(-2);
                }
                parsexml = true;
                if (offset < args.length) {
                    if ((xmlfile = new File(args[offset++])).exists()) continue;
                    System.err.println("\nError: Can't find xml metadata file to parse: " + xmlfile.getPath() + "");
                    most2netcdf.usage();
                    System.exit(-12);
                    continue;
                }
                System.err.println("\nError: Missing XML file argument.");
                most2netcdf.usage();
                System.exit(-14);
                continue;
            }
            if ("-v".equals(arg)) {
                verbose = true;
                log.setLevel(Level.ALL);
                continue;
            }
            if ("-z".equals(arg)) {
                bathymetryInvert = -1.0;
                continue;
            }
            if ("-q".equals(arg)) {
                verbose = false;
                quiet = true;
                continue;
            }
            if (!"-d".equals(arg)) continue;
            if (offset < args.length) {
                evennessCutoff = Double.parseDouble(args[offset++]);
                continue;
            }
            System.err.println("\nError: Missing cutoff percent, e.g. \"-d 0.05\" for default 5% cutoff");
        }
        if (offset < args.length) {
            if (!(infile = new File(args[offset++])).exists()) {
                System.err.println("\nError: Can't find grid file to convert: " + infile.getPath() + "\n");
                System.exit(-14);
            }
        } else {
            System.err.println("\nError: Please supply an input filename to convert: unable to parse input filename.");
            most2netcdf.usage();
            System.exit(-13);
        }
        if (offset < args.length && (outfile = new File(args[offset++])).exists()) {
            System.out.print("\nWARNING!  Output file exists!  Overwrite? (y/n): ");
            Scanner scanner = new Scanner(System.in);
            String response = scanner.next();
            if (!response.toLowerCase().equals("y")) {
                System.exit(0);
            }
        }
        if (outfile == null) {
            int i;
            String ext = ".nc";
            if (infile.getPath().endsWith(ext)) {
                ext = ".most";
            }
            outfile = (i = infile.getPath().lastIndexOf(".")) > 0 ? new File(infile.getPath().substring(0, i) + ext) : new File(infile.getPath() + ext);
        }
        boolean bl = reverse = !outfile.getPath().endsWith(".nc");
        if (verbose) {
            System.out.println("\nInput file: " + infile.getPath());
            System.out.println("Output file: " + outfile.getPath() + " exists: " + outfile.exists());
            if (reverse) {
                System.out.println("Output format: text");
            } else {
                System.out.println("Output format: netCDF");
            }
            System.out.println("Interactive: " + interactive);
            System.out.println("Edit attribute: " + editatt);
            System.out.println("Parse XML: " + parsexml);
        }
        try {
            most2netcdf.initializeMetadata();
            most2netcdf.readBathymetryGrid(infile);
        }
        catch (IOException ioe) {
            System.err.println("\nError reading file: " + infile.getPath() + "\n");
            System.exit(-1);
        }
        try {
            sb = new StringBuffer();
            sb.append(histDF.format(new Date()));
            sb.append("most2netcdf");
            for (String s : args) {
                sb.append(" ");
                sb.append(s);
            }
            if (attMap.get("history").getStringValue().equals("")) {
                attMap.put("history", new Attribute("history", sb.toString()));
            } else {
                attMap.put("history", new Attribute("history", sb.toString() + "\n" + attMap.get("history").getStringValue()));
            }
            if (reverse) {
                if (outfile.getPath().equals(infile.getPath())) {
                    System.err.println("\nError: You must specify an output file when converting from netCDF to MOST grid format.\n");
                    System.exit(-5);
                }
                most2netcdf.saveAsMOST(outfile);
                System.exit(0);
            }
        }
        catch (IOException ioe) {
            System.err.println("\nError writing MOST ascii file: " + infile.getPath() + "\n");
            System.exit(-1);
        }
        if (interactive) {
            most2netcdf.getInteractiveMetadata();
        }
        if (editatt) {
            most2netcdf.editAttribute(attname);
        }
        if (parsexml) {
            most2netcdf.parseXML(xmlfile);
        }
        try {
            most2netcdf.saveAsNetCDF(outfile);
            if (!(interactive || parsexml || editatt || quiet)) {
                System.out.println("\nThe conversion was successfull, but PLEASE CONSIDER ADDING METADATA TO THIS FILE!");
                System.out.println("It is particularly important to save the \"source\" attribute, which");
                System.out.println("identifies the original DEMs you used to create this grid.");
                System.out.println("Default metadata has been added, but you can add details");
                System.out.println("either by re-running most2netcdf with the \"-i\" switch,");
                System.out.println("or by editing individual attributes with the \"-a\" switch.");
                System.out.println("To view the attributes in the file, use the command: ncdump -h <netcdf file name>\n");
            }
        }
        catch (IOException ioe) {
            System.err.println("\nError writing MOST netcdf file: " + infile.getPath() + "\n");
            System.exit(-1);
        }
    }

    static {
        deps = null;
        gridFile = null;
        openFile = null;
        nc = null;
        bathymetryInvert = 1.0;
        fliplat = false;
        evennessCutoff = 0.05;
        history = "";
        quiet = false;
        dfxx = new DecimalFormat("0.00");
        sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        histDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z: ");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] %2$s %n            [%4$-7s] %5$s%6$s %n");
    }
}

