/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.nc;

import java.util.LinkedHashSet;
import java.util.Map;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class NCUtil {
    public static void copyGlobalAttributes(NetcdfFile sourceNcFile, NetcdfFileWriteable targetNcFile, Map<String, Object> override) {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (override != null) {
            names.addAll(override.keySet());
        }
        for (Attribute attr : sourceNcFile.getGlobalAttributes()) {
            names.add(attr.getName());
        }
        for (String name : names) {
            if (override != null && override.containsKey(name)) {
                Object val = override.get(name);
                if (val == null) continue;
                if (val instanceof String) {
                    targetNcFile.addGlobalAttribute(name, (String)val);
                    continue;
                }
                if (val instanceof Number) {
                    targetNcFile.addGlobalAttribute(name, (Number)val);
                    continue;
                }
                if (val instanceof Array) {
                    targetNcFile.addGlobalAttribute(name, (Array)val);
                    continue;
                }
                if (!val.getClass().isArray()) continue;
                targetNcFile.addGlobalAttribute(name, Array.factory(val));
                continue;
            }
            Attribute attr = sourceNcFile.findGlobalAttribute(name);
            if (attr == null) continue;
            if (attr.isString()) {
                targetNcFile.addGlobalAttribute(attr.getName(), attr.getStringValue());
                continue;
            }
            if (attr.isArray()) {
                targetNcFile.addGlobalAttribute(attr.getName(), attr.getValues());
                continue;
            }
            targetNcFile.addGlobalAttribute(attr.getName(), attr.getNumericValue());
        }
    }

    public static void copyDimensions(NetcdfFile sourceNcFile, NetcdfFileWriteable targetNcFile) {
        for (Dimension d : sourceNcFile.getDimensions()) {
            targetNcFile.addDimension(d.getName(), d.getLength());
        }
    }

    public static Dimension findNcDimension(NetcdfFile ncfile, String dimName, boolean ignoreCase) {
        Dimension rv = ncfile.findDimension(dimName);
        if (rv != null) {
            return rv;
        }
        if (ignoreCase) {
            for (Dimension d : ncfile.getDimensions()) {
                if (!d.getName().equalsIgnoreCase(dimName)) continue;
                return d;
            }
        }
        return null;
    }

    public static Dimension findNcDimension(NetcdfFile ncfile, String dimName) {
        return NCUtil.findNcDimension(ncfile, dimName, true);
    }

    public static Variable findNcVariable(NetcdfFile ncfile, String varName, boolean ignoreCase) {
        Variable rv = ncfile.findVariable(varName);
        if (rv != null) {
            return rv;
        }
        if (ignoreCase) {
            for (Variable v : ncfile.getVariables()) {
                if (!v.getName().equalsIgnoreCase(varName)) continue;
                return v;
            }
        }
        return rv;
    }

    public static Variable findNcVariable(NetcdfFile ncfile, String varName) {
        return NCUtil.findNcVariable(ncfile, varName, true);
    }

    public static void closeUnlimitedDimensions(NetcdfFile ncfile) {
        for (Dimension d : ncfile.getDimensions()) {
            d.setUnlimited(false);
        }
    }

    public static void createOutputVariable(NetcdfFileWriteable targetNcFile, Variable srcVar) {
        String varName = srcVar.getFullNameEscaped();
        targetNcFile.addVariable(varName, srcVar.getDataType(), srcVar.getDimensions());
        for (Attribute attr : srcVar.getAttributes()) {
            if (attr.isString()) {
                targetNcFile.addVariableAttribute(varName, attr.getName(), attr.getStringValue());
                continue;
            }
            targetNcFile.addVariableAttribute(varName, attr.getName(), attr.getNumericValue());
        }
    }

    public static void createOutputVariable(NetcdfFileWriteable targetNcFile, Variable srcVar, Dimension[] dims) {
        String varName = srcVar.getFullNameEscaped();
        targetNcFile.addVariable(varName, srcVar.getDataType(), dims);
        for (Attribute attr : srcVar.getAttributes()) {
            if (attr.isString()) {
                targetNcFile.addVariableAttribute(varName, attr.getName(), attr.getStringValue());
                continue;
            }
            targetNcFile.addVariableAttribute(varName, attr.getName(), attr.getNumericValue());
        }
    }
}

