/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.thread;

import gov.noaa.tsunami.utility.thread.ThreadNameable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class NamingThreadFactory
implements ThreadFactory {
    private final Namer namer;
    private final boolean daemon;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public NamingThreadFactory(String prefix, boolean daemon, Thread.UncaughtExceptionHandler eh) {
        this.namer = new PrefixedSerialNamer(prefix);
        this.daemon = daemon;
        this.exceptionHandler = eh == null ? new LoggingUncaughtExceptionHandler() : eh;
    }

    public NamingThreadFactory(Namer namer, boolean daemon, Thread.UncaughtExceptionHandler eh) {
        this.namer = namer == null ? new ClassNameNamer() : namer;
        this.daemon = daemon;
        this.exceptionHandler = eh == null ? new LoggingUncaughtExceptionHandler() : eh;
    }

    public NamingThreadFactory(boolean daemon, Thread.UncaughtExceptionHandler eh) {
        this((Namer)null, daemon, eh);
    }

    public NamingThreadFactory(String prefix, boolean daemon) {
        this.namer = new PrefixedSerialNamer(prefix);
        this.daemon = daemon;
        this.exceptionHandler = new LoggingUncaughtExceptionHandler();
    }

    public NamingThreadFactory(Namer namer, boolean daemon) {
        this.namer = namer == null ? new ClassNameNamer() : namer;
        this.daemon = daemon;
        this.exceptionHandler = new LoggingUncaughtExceptionHandler();
    }

    public NamingThreadFactory(boolean daemon) {
        this((Namer)null, daemon);
    }

    @Override
    public final Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setDaemon(this.daemon);
        t.setName(this.namer.getNextName(r));
        if (this.exceptionHandler != null) {
            t.setUncaughtExceptionHandler(this.exceptionHandler);
        } else {
            t.setUncaughtExceptionHandler(new LoggingUncaughtExceptionHandler());
        }
        return t;
    }

    private static class LoggingUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private LoggingUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger.getLogger(LoggingUncaughtExceptionHandler.class.getName()).severe(t.getName() + "\n" + e.getMessage() + "\n");
        }
    }

    public static final class ThreadNameableNamer
    implements Namer {
        @Override
        public String getNextName(Runnable r) {
            if (r instanceof ThreadNameable) {
                return ((ThreadNameable)((Object)r)).getPreferredThreadName();
            }
            return String.valueOf(r);
        }
    }

    public static class ClassNameNamer
    implements Namer {
        @Override
        public String getNextName(Runnable r) {
            return r.getClass().getName();
        }
    }

    private static class PrefixedSerialNamer
    implements Namer {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final String prefix;

        PrefixedSerialNamer(String s) {
            this.prefix = s;
        }

        @Override
        public String getNextName(Runnable r) {
            return this.prefix + "-" + this.counter.incrementAndGet();
        }
    }

    public static interface Namer {
        public String getNextName(Runnable var1);
    }
}

