/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Conversion;
import gov.noaa.tsunami.utility.units.Length;
import gov.noaa.tsunami.utility.units.Unit;
import java.util.Objects;

public class Area
implements Unit<Area> {
    private static final long serialVersionUID = 6540989292085587903L;
    private static final Area baseUnit = new Area(Length.meter);
    private final Unit<Length> basis;
    private final double factor;
    private static final String suffix = "^2";
    private final String symbol;

    private Area(Unit<Length> unit) {
        this.basis = unit;
        this.factor = this.basis.getFactor() * this.basis.getFactor();
        this.symbol = this.basis.getSymbol() + suffix;
    }

    public static Area of(Unit<Length> unit) {
        return new Area(unit);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Area getBase() {
        return baseUnit;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public double relationTo(Unit<Area> t) {
        return t == this ? 1.0 : this.factor / t.getFactor();
    }

    @Override
    public double convertTo(Unit<Area> t, double d) {
        return Conversion.convert(this, t, d);
    }

    @Override
    public double[] copyConvertTo(Unit<Area> t, double[] d) {
        return Conversion.copyConvert(this, t, d);
    }

    @Override
    public double[] inPlaceConvertTo(Unit<Area> t, double[] d) {
        return Conversion.convertInPlace(this, t, d);
    }

    @Override
    public String name() {
        return "square " + this.basis.name();
    }

    public static Area fromSymbol(String prop) {
        if (prop == null) {
            return null;
        }
        if (!prop.endsWith(suffix)) {
            return null;
        }
        Length l = Length.fromSymbol(prop.replace(suffix, ""));
        return l == null ? null : Area.of(l);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Unit && Objects.equals(this.symbol, ((Unit)o).getSymbol());
    }

    public String toString() {
        return this.symbol;
    }
}

