/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Unit;
import java.math.BigDecimal;
import java.util.Arrays;

public class Conversion {
    public static <U extends Unit<U>> long convert(Unit<U> source, Unit<U> target, long in) {
        return source == target ? in : (long)(source.relationTo(target) * (double)in);
    }

    public static <U extends Unit<U>> int convert(Unit<U> source, Unit<U> target, int in) {
        return source == target ? in : (int)(source.relationTo(target) * (double)in);
    }

    public static <U extends Unit<U>> short convert(Unit<U> source, Unit<U> target, short in) {
        return (short)(source == target ? (double)in : source.relationTo(target) * (double)in);
    }

    public static <U extends Unit<U>> byte convert(Unit<U> source, Unit<U> target, byte in) {
        return (byte)(source == target ? (double)in : source.relationTo(target) * (double)in);
    }

    public static <U extends Unit<U>> double convert(Unit<U> source, Unit<U> target, double in) {
        return source == target ? in : source.relationTo(target) * in;
    }

    public static <U extends Unit<U>> float convert(Unit<U> source, Unit<U> target, float in) {
        return source == target ? in : (float)source.relationTo(target) * in;
    }

    public static <U extends Unit<U>> BigDecimal convert(Unit<U> source, Unit<U> target, BigDecimal in) {
        return source == target ? in : in.multiply(new BigDecimal(source.relationTo(target)));
    }

    public static <U extends Unit<U>> long[] convertInPlace(Unit<U> source, Unit<U> target, long[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = (long)((double)in[i] * rel);
        }
        return in;
    }

    public static <U extends Unit<U>> int[] convertInPlace(Unit<U> source, Unit<U> target, int[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = (int)((double)in[i] * rel);
        }
        return in;
    }

    public static <U extends Unit<U>> short[] convertInPlace(Unit<U> source, Unit<U> target, short[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = (short)((double)in[i] * rel);
        }
        return in;
    }

    public static <U extends Unit<U>> byte[] convertInPlace(Unit<U> source, Unit<U> target, byte[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = (byte)((double)in[i] * rel);
        }
        return in;
    }

    public static <U extends Unit<U>> double[] convertInPlace(Unit<U> source, Unit<U> target, double[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = in[i] * rel;
        }
        return in;
    }

    public static <U extends Unit<U>> float[] convertInPlace(Unit<U> source, Unit<U> target, float[] in) {
        if (in == null) {
            return null;
        }
        if (source == target) {
            return in;
        }
        double rel = source.relationTo(target);
        for (int i = 0; i < in.length; ++i) {
            in[i] = (float)((double)in[i] * rel);
        }
        return in;
    }

    public static <U extends Unit<U>> long[] copyConvert(Unit<U> source, Unit<U> target, long[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }

    public static <U extends Unit<U>> int[] copyConvert(Unit<U> source, Unit<U> target, int[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }

    public static <U extends Unit<U>> short[] copyConvert(Unit<U> source, Unit<U> target, short[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }

    public static <U extends Unit<U>> byte[] copyConvert(Unit<U> source, Unit<U> target, byte[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }

    public static <U extends Unit<U>> double[] copyConvert(Unit<U> source, Unit<U> target, double[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }

    public static <U extends Unit<U>> float[] copyConvert(Unit<U> source, Unit<U> target, float[] in) {
        if (in == null || source == target) {
            return in;
        }
        return Conversion.convertInPlace(source, target, Arrays.copyOf(in, in.length));
    }
}

