/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Conversion;
import gov.noaa.tsunami.utility.units.Unit;

public enum Information implements Unit<Information>
{
    BYTE("B", 1L),
    KILOBYTE("KB", 1000L),
    MEGABYTE("MB", 1000000L),
    GIGABYTE("GB", 1000000000L),
    TERABYTE("TB", 1000000000000L),
    PETABYTE("PB", 1000000000000000L),
    EXABYTE("EB", 1000000000000000000L),
    ZETABYTE("ZB", Long.MAX_VALUE),
    YOTTABYTE("YB", Long.MAX_VALUE),
    KIBIBYTE("KiB", 1024L),
    MEBIBYTE("MiB", 0x100000L),
    GIBIBYTE("GiB", 0x40000000L),
    TEBIBYTE("TiB", 256L),
    PEBIBYTE("PiB", 262144L),
    EXBIBYTE("EiB", 0x10000000L),
    ZEBIBYTE("ZiB", 64L),
    YOBIBYTE("YiB", 65536L);

    private final String symbol;
    private long factor;

    private Information(String symbol, long factor) {
        this.symbol = symbol;
        this.factor = factor;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    public Information getBase() {
        return BYTE;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public double relationTo(Unit<Information> t) {
        return t == this ? 1.0 : (double)this.factor / t.getFactor();
    }

    @Override
    public double convertTo(Unit<Information> t, double d) {
        return t == this ? d : d * this.relationTo(t);
    }

    @Override
    public double[] copyConvertTo(Unit<Information> t, double[] d) {
        return Conversion.copyConvert(this, t, d);
    }

    @Override
    public double[] inPlaceConvertTo(Unit<Information> t, double[] d) {
        return Conversion.convertInPlace(this, t, d);
    }

    public static Information guessFromSymbol(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        String sx = s.trim();
        for (Information data : Information.values()) {
            if (!sx.equals(data.symbol)) continue;
            return data;
        }
        for (Information data : Information.values()) {
            if (!sx.equals(data.symbol.substring(0, data.symbol.length() - 1))) continue;
            return data;
        }
        for (Information data : Information.values()) {
            if (!sx.equals(data.symbol.substring(0, 1))) continue;
            return data;
        }
        return null;
    }

    public static void main(String[] args) {
        for (Information data : Information.values()) {
            Information d = Information.guessFromSymbol(data.getSymbol());
            System.out.println(data + " " + d);
            d = Information.guessFromSymbol(data.getSymbol().replaceAll("B", ""));
            System.out.println(data.getSymbol().replaceAll("B", "") + " " + data + " " + d);
        }
    }
}

