/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Unit;
import java.util.Arrays;

public enum Length implements Unit<Length>
{
    meter(1.0, "m"),
    planck_length(1.616252E-35, "lP"),
    millimeter(0.001, "mm"),
    centimeter(0.01, "cm"),
    kilometer(1000.0, "km"),
    lightyear(Length.kilometer.factor * 9.4607304725808E12, "ly"),
    inch(0.0254, "in"),
    foot(Length.inch.factor * 12.0, "ft"),
    mile(Length.foot.factor * 5280.0, "mi");

    public final double factor;
    public final String symbol;
    public static final Length base;

    public Length getBase() {
        return meter;
    }

    private Length(double f, String s) {
        this.factor = f;
        this.symbol = s;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public double relationTo(Unit<Length> l) {
        return l == this ? 1.0 : this.factor / l.getFactor();
    }

    public String toString() {
        return this.symbol;
    }

    @Override
    public double convertTo(Unit<Length> t, double d) {
        return t == this ? d : d * this.relationTo(t);
    }

    @Override
    public double[] copyConvertTo(Unit<Length> l, double[] d) {
        if (d == null) {
            return null;
        }
        double[] ret = Arrays.copyOf(d, d.length);
        if (l != this) {
            double rel = this.relationTo(l);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] * rel;
            }
        }
        return ret;
    }

    @Override
    public double[] inPlaceConvertTo(Unit<Length> t, double[] d) {
        if (d == null || t == this) {
            return d;
        }
        double rel = this.relationTo(t);
        int i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] * rel;
        }
        return d;
    }

    public static Length fromSymbol(String prop) {
        if (prop == null) {
            return null;
        }
        for (Length l : Length.values()) {
            if (!l.symbol.equalsIgnoreCase(prop.trim()) && !l.name().equalsIgnoreCase(prop.trim())) continue;
            return l;
        }
        return null;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    static {
        base = meter;
    }
}

