/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Conversion;
import gov.noaa.tsunami.utility.units.One;
import gov.noaa.tsunami.utility.units.Unit;
import gov.noaa.tsunami.utility.units.Units;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Measurement<U extends Unit<U>>
extends Number
implements Comparable<Measurement<U>> {
    private static final long serialVersionUID = -8079175274381599863L;
    private final BigDecimal number;
    private final Unit<U> unit;

    public Measurement(byte n, Unit<U> u) {
        this.number = new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(byte b, Unit<U> u) {
        return new Measurement<U>(b, u);
    }

    public Measurement(short n, Unit<U> u) {
        this.number = new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(short n, Unit<U> u) {
        return new Measurement<U>(n, u);
    }

    public Measurement(int n, Unit<U> u) {
        this.number = new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(int n, Unit<U> u) {
        return new Measurement<U>(n, u);
    }

    public Measurement(long n, Unit<U> u) {
        this.number = new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(long n, Unit<U> u) {
        return new Measurement<U>(n, u);
    }

    public Measurement(float n, Unit<U> u) {
        this.number = Float.isNaN(n) || Float.isInfinite(n) ? null : new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(float f, Unit<U> u) {
        return new Measurement<U>(f, u);
    }

    public Measurement(double n, Unit<U> u) {
        this.number = Double.isNaN(n) || Double.isInfinite(n) ? null : new BigDecimal(n);
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(double d, Unit<U> u) {
        return new Measurement<U>(d, u);
    }

    public Measurement(BigDecimal n, Unit<U> u) {
        this.number = new BigDecimal(n.toString());
        this.unit = u;
    }

    public static <U extends Unit<U>> Measurement<U> of(BigDecimal n, Unit<U> u) {
        return new Measurement<U>(n, u);
    }

    @Override
    public int intValue() {
        return this.number == null ? 0 : this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number == null ? 0L : this.number.longValue();
    }

    public int hashCode() {
        return (this.number == null ? 0 : this.number.hashCode()) ^ this.unit.hashCode();
    }

    @Override
    public float floatValue() {
        return this.number == null ? Float.NaN : this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number == null ? Double.NaN : this.number.doubleValue();
    }

    @Override
    public byte byteValue() {
        return this.number == null ? (byte)0 : this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number == null ? (short)0 : this.number.shortValue();
    }

    public boolean equals(Object obj) {
        return obj instanceof Measurement && Objects.equals(this.number, ((Measurement)obj).number) && this.unit.equals(((Measurement)obj).unit);
    }

    public Measurement<U> convertTo(Unit<U> u) {
        return this.number == null ? new Measurement<U>(Double.NaN, u) : new Measurement<U>(Conversion.convert(this.unit, u, this.number), u);
    }

    public String toString() {
        return String.valueOf(this.number == null ? Double.valueOf(Double.NaN) : this.number + this.unit.getSymbol());
    }

    public Unit<U> getUnit() {
        return this.unit;
    }

    @Override
    public int compareTo(Measurement<U> o) {
        if (this.number == null) {
            if (o.number == null) {
                return 0;
            }
            return 1;
        }
        if (o.number == null) {
            return -1;
        }
        return this.unit.equals(o.unit) ? this.number.compareTo(o.number) : this.number.compareTo(o.convertTo(this.unit).number);
    }

    public boolean lessThan(Measurement<U> o) {
        return this.compareTo(o) < 0;
    }

    public boolean greaterThan(Measurement<U> o) {
        return this.compareTo(o) > 0;
    }

    public boolean lessThanOrEqual(Measurement<U> o) {
        return this.compareTo(o) <= 0;
    }

    public boolean greaterThanOrEquals(Measurement<U> o) {
        return this.compareTo(o) >= 0;
    }

    public boolean isNaN() {
        return this.number == null;
    }

    public static <U extends Unit<U>> Measurement<U> nan(Unit<U> unit) {
        return new Measurement<U>(Double.NaN, unit);
    }

    public static <U extends Unit<U>> Measurement<U> valueOf(String s, Unit<U> u) {
        Pattern p = Pattern.compile("(.*)([0-9])(" + u.getSymbol() + ")");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            return new Measurement<U>(new BigDecimal(m.group(1) + m.group(2)), u);
        }
        return null;
    }

    public static <U extends Unit<U>> Measurement<U> valueOf(String s) {
        Pattern p = Pattern.compile("(.*)([0-9])([a-zA-Z/]+)$");
        Matcher m = p.matcher(s);
        if (m.matches()) {
            Unit u = Units.fromSymbol(m.group(3));
            return u == null ? null : new Measurement<U>(new BigDecimal(m.group(1) + m.group(2)), u);
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(Double.compare(Double.NaN, 1.0));
        System.out.println(Double.compare(1.0, Double.NaN));
        System.out.println(Double.compare(Double.NaN, Double.NaN));
        System.out.println(new Double(Double.NaN).compareTo(1.0));
        System.out.println(new TreeSet<Double>(Arrays.asList(Double.NaN, 1.0, 2.0)));
        System.out.println(new TreeSet<Double>(Arrays.asList(Double.NaN, -1.0, -2.0)));
        System.out.println(new TreeSet<Double>(Arrays.asList(Double.NaN, Double.MAX_VALUE)));
        System.out.println(new Measurement<One>(Double.NaN, One.one).isNaN());
        System.out.println(new Measurement<One>(Float.NaN, (Unit<One>)One.one).isNaN());
    }
}

