/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Length;
import gov.noaa.tsunami.utility.units.Time;
import gov.noaa.tsunami.utility.units.Unit;
import java.util.Arrays;

public class Speed
implements Unit<Speed> {
    private static final long serialVersionUID = 5670545593628307847L;
    public final Length numerator;
    public final Time denominator;
    public final String symbol;
    public static final Speed base = new Speed(Length.meter, Time.second);
    public final double factor;

    public Speed(Length n, Time t) {
        this.numerator = n;
        this.denominator = t;
        this.factor = n.getFactor() / t.getFactor();
        this.symbol = this.numerator.getSymbol() + "/" + this.denominator.getSymbol();
    }

    @Override
    public double convertTo(Unit<Speed> t, double d) {
        return this.equals(t) ? d : d * this.relationTo(t);
    }

    @Override
    public double[] copyConvertTo(Unit<Speed> t, double[] d) {
        if (d == null) {
            return null;
        }
        double[] ret = Arrays.copyOf(d, d.length);
        if (!this.equals(t)) {
            double rel = this.relationTo(t);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] * rel;
            }
        }
        return ret;
    }

    public Speed getBase() {
        return base;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public double[] inPlaceConvertTo(Unit<Speed> t, double[] d) {
        if (d == null || t == this) {
            return d;
        }
        double rel = this.relationTo(t);
        int i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] * rel;
        }
        return d;
    }

    @Override
    public String name() {
        return this.numerator.name() + " per " + this.denominator.name();
    }

    @Override
    public double relationTo(Unit<Speed> t) {
        return this.equals(t) ? 1.0 : this.factor / t.getFactor();
    }

    public String toString() {
        return this.symbol;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Speed && this.numerator.equals(((Speed)o).numerator) && this.denominator.equals(((Speed)o).denominator);
    }

    public int hashCode() {
        return this.numerator.hashCode() ^ this.denominator.hashCode();
    }

    public static Speed fromSymbol(String s) {
        if (s == null || s.trim().length() == 0 || s.indexOf("/") == -1) {
            return null;
        }
        String[] sa = s.trim().split("/");
        if (sa.length != 2) {
            return null;
        }
        Length l = Length.fromSymbol(sa[0]);
        if (l == null) {
            return null;
        }
        Time t = Time.fromSymbol(sa[1]);
        if (t == null) {
            return null;
        }
        return new Speed(l, t);
    }
}

