/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.utility.units;

import gov.noaa.tsunami.utility.units.Unit;
import java.util.Arrays;

public enum Time implements Unit<Time>
{
    second(1.0, "s"),
    millisecond(0.001, "ms"),
    nanosecond(1.0E-9, "ns"),
    minute(60.0, "min"),
    hour(3600.0, "hrs"),
    day(86400.0, "day");

    public final double factor;
    public final String symbol;
    public static final Time base;

    public Time getBase() {
        return second;
    }

    private Time(double f, String s) {
        this.factor = f;
        this.symbol = s;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public double relationTo(Unit<Time> t) {
        return t == this ? 1.0 : this.factor / t.getFactor();
    }

    @Override
    public double convertTo(Unit<Time> t, double d) {
        return t == this ? d : d * this.relationTo(t);
    }

    @Override
    public double[] copyConvertTo(Unit<Time> t, double[] d) {
        if (d == null) {
            return null;
        }
        double[] ret = Arrays.copyOf(d, d.length);
        if (t != this) {
            double rel = this.relationTo(t);
            int i = 0;
            while (i < ret.length) {
                int n = i++;
                ret[n] = ret[n] * rel;
            }
        }
        return ret;
    }

    @Override
    public double[] inPlaceConvertTo(Unit<Time> t, double[] d) {
        if (d == null || t == this) {
            return d;
        }
        double rel = this.relationTo(t);
        int i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] * rel;
        }
        return d;
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    public static Time fromSymbol(String s) {
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        for (Time t : Time.values()) {
            if (!t.symbol.equalsIgnoreCase(s.trim())) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.symbol;
    }

    static {
        base = second;
    }
}

