/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.dart;

import gov.noaa.tsunami.websift.dart.BuoyDatum;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class Buoy
implements Serializable,
Comparable<Buoy> {
    private String stationID;
    private String name;
    private double latitude;
    private double longitude;
    private final ArrayList<BuoyDatum> buoyData = new ArrayList();
    private static final DecimalFormat fmt = new DecimalFormat("0.000");
    private Date sEventTime;
    private Date eEventTime;
    private Ellipse2D.Double userCircle;
    private Point2D.Double userPt;
    private boolean isSelected = false;
    private double distanceFromEpicenter = -1.0;
    private long deploymentDate = 0L;
    private long recoveryDate = 0L;

    public Buoy() {
        this.stationID = "none";
        this.name = "none";
        this.latitude = 9999.0;
        this.longitude = 9999.0;
        this.sEventTime = null;
        this.eEventTime = null;
    }

    public Buoy(String stationID, String name, double latitude, double longitude, String ignored) {
        this.stationID = stationID;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude < 0.0 ? 360.0 + longitude : longitude;
        this.sEventTime = null;
        this.eEventTime = null;
    }

    public synchronized void addBuoyData(BuoyDatum newData) {
        this.buoyData.add(newData);
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
    }

    public void setSelectedOn() {
        this.isSelected = true;
    }

    public void setSelectedOff() {
        this.isSelected = false;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean hasData() {
        return this.eEventTime != null && this.sEventTime != null;
    }

    public void setUserPt(Point2D.Double p) {
        this.userCircle = new Ellipse2D.Double(p.x, p.y, 5.0, 5.0);
        this.userPt = p;
        this.userPt.x += 4.0;
        this.userPt.y -= 1.0;
    }

    public Ellipse2D.Double getUserCircle() {
        return this.userCircle;
    }

    public Point2D.Double getUserPt() {
        return this.userPt;
    }

    public void setDistanceFromEpicenter(double d) {
        this.distanceFromEpicenter = d;
    }

    public double getDistanceFromEpicenter() {
        return this.distanceFromEpicenter;
    }

    public synchronized String getStationID() {
        return this.stationID;
    }

    public synchronized double getLongitude() {
        return this.longitude;
    }

    public synchronized double getLatitude() {
        return this.latitude;
    }

    public void setDeploymentDate(long l) {
        this.deploymentDate = l;
    }

    public long getDeploymentDate() {
        return this.deploymentDate;
    }

    public void setRecoveryDate(long l) {
        this.recoveryDate = l;
    }

    public long getRecoveryDate() {
        return this.recoveryDate;
    }

    public synchronized Date getStartEventTime() {
        return this.sEventTime;
    }

    public synchronized Date getEndEventTime() {
        return this.eEventTime;
    }

    public synchronized ArrayList<BuoyDatum> getBuoyData() {
        return this.buoyData;
    }

    public synchronized boolean hasEventData(Date startTime, Date endTime) {
        Collections.sort(this.buoyData);
        this.sEventTime = null;
        this.eEventTime = null;
        for (BuoyDatum buoyDatum : this.buoyData) {
            if (buoyDatum.getType() <= 1 || !buoyDatum.getDate().after(startTime) || !buoyDatum.getDate().before(endTime)) continue;
            if (this.sEventTime == null || this.sEventTime.after(buoyDatum.getDate())) {
                this.sEventTime = buoyDatum.getDate();
            }
            if (this.eEventTime != null && !this.eEventTime.before(buoyDatum.getDate())) continue;
            this.eEventTime = buoyDatum.getDate();
        }
        return this.hasData();
    }

    public synchronized boolean updateDatum(BuoyDatum tempDatum, double h1, double h2) {
        boolean isUpdated = false;
        Collections.sort(this.buoyData);
        for (BuoyDatum buoyDatum : this.buoyData) {
            if (buoyDatum.compareTo(tempDatum) != 0) continue;
            buoyDatum.setHeight(1, h1);
            buoyDatum.setHeight(2, h2);
            isUpdated = true;
            break;
        }
        return isUpdated;
    }

    public synchronized BuoyDatum findBuoyDatum(long tempSecs) {
        Collections.sort(this.buoyData);
        for (BuoyDatum buoyDatum : this.buoyData) {
            if (buoyDatum.getSeconds() != tempSecs || buoyDatum.getType() <= 1) continue;
            return buoyDatum;
        }
        return null;
    }

    public String toString() {
        return "\nBuoy ID:" + this.stationID + " Name: " + this.name + " Latitude: " + fmt.format(this.latitude) + " Longitude: " + fmt.format(this.longitude) + " Lines of data: " + this.buoyData.size();
    }

    @Override
    public int compareTo(Buoy o) {
        int result = -1;
        double otherDist = o.getDistanceFromEpicenter();
        result = otherDist < this.distanceFromEpicenter ? 1 : (otherDist > this.distanceFromEpicenter ? -1 : 0);
        return result;
    }
}

