/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.dart;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class BuoyDatum
implements Serializable,
Comparable<BuoyDatum> {
    private int type = 9;
    private final double[] height = new double[]{-1.0E34, -1.0E34, -1.0E34};
    private double hrsFromEvent = -999.0;
    private final Calendar datumDate = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
    private static final DecimalFormat fmt2 = new DecimalFormat("00");
    private static final DecimalFormat fmt3 = new DecimalFormat("#.000");

    public BuoyDatum() {
    }

    public BuoyDatum(String line, Long eventTime) {
        int year = 1970;
        int month = 1;
        int day = 1;
        int hr = 0;
        int min = 0;
        int sec = 0;
        int type = 1;
        double h0 = -1.0E34;
        double h1 = -1.0E34;
        double h2 = -1.0E34;
        String[] arr = line.split("\\s+");
        try {
            year = Integer.parseInt(arr[0]);
            month = Integer.parseInt(arr[1]);
            day = Integer.parseInt(arr[2]);
            hr = Integer.parseInt(arr[3]);
            min = Integer.parseInt(arr[4]);
            sec = Integer.parseInt(arr[5]);
            type = Integer.parseInt(arr[6]);
            h0 = Double.parseDouble(arr[7]);
            h1 = Double.parseDouble(arr[8]);
            h2 = Double.parseDouble(arr[9]);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.set(year, month, day, hr, min, sec, type, h0, h1, h2);
        if (eventTime != null) {
            this.hrsFromEvent = (double)(this.datumDate.getTimeInMillis() - eventTime) / 3600000.0;
        }
    }

    public BuoyDatum(long datumTime, long eventTime) {
        this.datumDate.setTimeInMillis(datumTime);
        this.hrsFromEvent = (double)(this.datumDate.getTimeInMillis() - eventTime) / 3600000.0;
    }

    public BuoyDatum(int year, int month, int day, int hh, int mm, int ss, int type, double height) {
        this.set(year, month, day, hh, mm, ss, type, height, -1.0E34, -1.0E34);
    }

    private void set(int year, int month, int day, int hh, int mm, int ss, int type, double height, double h1, double h2) {
        this.datumDate.set(year, month - 1, day, hh, mm, ss);
        this.type = type;
        this.height[0] = height;
        this.height[1] = h1;
        this.height[2] = h2;
    }

    public void setHeight(int heighttype, double height) {
        this.height[heighttype] = height;
    }

    public double getHeight(int heighttype) {
        return this.height[heighttype];
    }

    public double getHeight() {
        return this.getHeight(0);
    }

    public double getHeight1() {
        return this.getHeight(1);
    }

    public double getHeight2() {
        return this.getHeight(2);
    }

    public Date getDate() {
        return this.datumDate.getTime();
    }

    public int getMinutes() {
        return this.datumDate.get(12);
    }

    public int getCalendarSec() {
        return this.datumDate.get(13);
    }

    public Calendar getCalendar() {
        return this.datumDate;
    }

    public long getSeconds() {
        return this.datumDate.getTimeInMillis() / 1000L;
    }

    public void setEventDate(long millis) {
        this.hrsFromEvent = (double)(this.datumDate.getTimeInMillis() - millis) / 3600000.0;
    }

    public double getHoursFromEvent() {
        return this.hrsFromEvent;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return this.datumDate.get(1) + " " + fmt2.format(this.datumDate.get(2) + 1) + " " + fmt2.format(this.datumDate.get(5)) + " " + fmt2.format(this.datumDate.get(11)) + " " + fmt2.format(this.datumDate.get(12)) + " " + fmt2.format(this.datumDate.get(13)) + " " + this.getType() + " " + fmt3.format(this.getHeight(0));
    }

    public String toString2() {
        return this.toString() + " " + fmt3.format(this.getHeight(1)) + " " + fmt3.format(this.getHeight(2));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BuoyDatum)) {
            return false;
        }
        return this.getDate().getTime() == ((BuoyDatum)obj).getDate().getTime();
    }

    public int hashCode() {
        return this.getDate().hashCode();
    }

    @Override
    public int compareTo(BuoyDatum other) {
        if (this.getDate().getTime() == other.getDate().getTime()) {
            return 0;
        }
        return this.getDate().getTime() < other.getDate().getTime() ? -1 : 1;
    }

    public static double[] getHeightArray(BuoyDatum[] arr, int heighttype) {
        double[] r = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            r[i] = arr[i].getHeight(heighttype);
        }
        return r;
    }

    public static long[] getEpochSecondsArray(BuoyDatum[] arr) {
        long[] r = new long[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            r[i] = arr[i].getSeconds();
        }
        return r;
    }

    public static double[] getEpochSecondsDoubleArray(BuoyDatum[] arr) {
        double[] r = new double[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            r[i] = arr[i].getSeconds();
        }
        return r;
    }

    public static BuoyDatum[] filterByType(BuoyDatum[] arr, int type) {
        ArrayList<BuoyDatum> r = new ArrayList<BuoyDatum>();
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].getType() != type) continue;
            r.add(arr[i]);
        }
        return r.toArray(new BuoyDatum[r.size()]);
    }
}

