/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.MapCanvas;
import gov.noaa.tsunami.websift.ee.UniqueListModel;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jdesktop.layout.GroupLayout;

public class AddSourceDialog
extends JDialog
implements ActionListener {
    private static final int WAITING = 0;
    private static final int ADJUSTING = 1;
    private int updateStatus = 0;
    private MapCanvas map;
    private UniqueListModel<UnitSource> availListModel;
    private String propFolder = "";
    private ArrayList<UnitSource> boxes;
    private UniqueListModel<UnitSource> selectedListModel;
    private JButton browseButton;
    private JButton closeButton;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList jList1;
    private JList jList2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public AddSourceDialog(Frame parent, MapCanvas mp, boolean modal) {
        super(parent, modal);
        this.initComponents();
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddSourceDialog.this.doClose();
            }
        };
        this.addWindowListener(l);
        this.map = mp;
        this.updateSources();
        this.map.addActionListener(this);
    }

    public void updateSources() {
        ArrayList<UnitSource> availVec = new ArrayList<UnitSource>();
        ArrayList<UnitSource> selVec = new ArrayList<UnitSource>();
        this.boxes = this.map.getSources();
        for (int i = 0; i < this.boxes.size(); ++i) {
            UnitSource aSource = this.boxes.get(i).copy();
            if (aSource.isActive()) {
                selVec.add(aSource);
                continue;
            }
            availVec.add(aSource);
        }
        Collections.sort(availVec);
        Collections.sort(selVec);
        this.availListModel = new UniqueListModel(availVec);
        this.selectedListModel = new UniqueListModel(selVec);
        this.jList1.setModel(this.availListModel);
        this.jList2.setModel(this.selectedListModel);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jLabel2 = new JLabel();
        this.closeButton = new JButton();
        this.browseButton = new JButton();
        this.jButton3 = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Available");
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/websift/ee/images/rt_arrow.png")));
        this.jButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/gov/noaa/tsunami/websift/ee/images/lf_arrow.png")));
        this.jButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jList2.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        this.jLabel2.setText("Selected");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(57, 57, 57).add(this.jLabel1)).add(this.jScrollPane1)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2).add(this.jButton2).add(this.jButton1)).addPreferredGap(0).add(this.jScrollPane2)).add(2, jPanel1Layout.createSequentialGroup().add(this.jLabel2).add(78, 78, 78))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel2).add(this.jLabel1)).add(6, 6, 6).add(jPanel1Layout.createParallelGroup(1, false).add(this.jScrollPane2).add(this.jScrollPane1, -2, 407, -2))).add(jPanel1Layout.createSequentialGroup().add(177, 177, 177).add(this.jButton1).addPreferredGap(0).add(this.jButton2))).addContainerGap()));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.browseButton.setText("Add Custom Source");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.jButton3.setText("Delete all Sources");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.jButton3ActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Cities");
        this.jCheckBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddSourceDialog.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, layout.createSequentialGroup().addContainerGap().add(this.jCheckBox1).add(18, 18, 18).add(this.browseButton).add(18, 18, 18).add(this.jButton3).addPreferredGap(0, 32, Short.MAX_VALUE).add(this.closeButton).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jPanel1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.closeButton).add(this.browseButton).add(this.jButton3).add(this.jCheckBox1)).addContainerGap()));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.removeFromSelected();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.addToSelected();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(this, "This will temporarily add a custom source to ComMIT.\nTo permanently add, copy it to the ComMIT/prop folder", "Adding Custom Propagation File", 2, 2) == 0) {
            JFileChooser chooser = new JFileChooser(this.propFolder);
            chooser.setDialogTitle("Load Custom Propagation File");
            chooser.setFileFilter(new FileNameExtensionFilter("MOST Prop files", "nc"));
            chooser.setFileSelectionMode(2);
            chooser.setMultiSelectionEnabled(true);
            int result = chooser.showOpenDialog(this);
            if (result == 0) {
                File[] fs = chooser.getSelectedFiles();
                for (int i = 0; i < fs.length; ++i) {
                    UnitSource us = null;
                    try {
                        us = new UnitSource(new File(fs[i].getAbsolutePath()));
                    }
                    catch (IOException ignore) {
                        try {
                            us = new UnitSource(fs[i].getAbsolutePath());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    if (us == null) continue;
                    PropagationDatabase propdb = PropagationDatabase.getInstance();
                    propdb.addUnitSource(us);
                    this.map.setSources(propdb.getUnitSources());
                    this.map.setActive(us.getName());
                    this.selectedListModel.insertElement(us);
                }
            }
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.removeAllFromSelected();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBox1.isSelected()) {
            this.map.useCities(true);
        } else {
            this.map.useCities(false);
        }
    }

    private void updateActiveSources() {
    }

    private void addToSelected() {
        int[] indices = this.jList1.getSelectedIndices();
        this.updateStatus = 1;
        for (int i = 0; i < indices.length; ++i) {
            UnitSource aSource = this.availListModel.get(indices[i]);
            aSource.setActive(true);
            this.map.setActive(aSource.getName());
            this.selectedListModel.insertElement(aSource);
        }
        this.availListModel.removeIndices(indices);
        if (indices.length > 0 && this.availListModel.getSize() > indices[0]) {
            this.jList1.setSelectedIndex(indices[0]);
        }
        this.updateStatus = 0;
    }

    public void addPropFolder(String propFolder) {
        this.propFolder = propFolder;
    }

    private void removeFromSelected() {
        int[] indices = this.jList2.getSelectedIndices();
        this.updateStatus = 1;
        for (int i = 0; i < indices.length; ++i) {
            UnitSource aSource = this.selectedListModel.get(indices[i]);
            aSource.setActive(false);
            this.map.setActive(aSource.getName());
            this.availListModel.insertElement(aSource);
        }
        this.selectedListModel.removeIndices(indices);
        if (indices.length > 0 && this.selectedListModel.getSize() > indices[0]) {
            this.jList2.setSelectedIndex(indices[0]);
        }
        this.updateStatus = 0;
    }

    private void removeAllFromSelected() {
        int[] indices = new int[this.selectedListModel.getSize()];
        this.updateStatus = 1;
        for (int i = 0; i < this.selectedListModel.getSize(); ++i) {
            UnitSource aSource = this.selectedListModel.getElementAt(i);
            aSource.setActive(false);
            this.map.setActive(aSource.getName());
            this.availListModel.insertElement(aSource);
            indices[i] = i;
        }
        this.selectedListModel.removeIndices(indices);
        this.updateStatus = 0;
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        UnitSource aSource;
        int i;
        if (this.updateStatus == 1) {
            return;
        }
        String sn = e.getActionCommand();
        for (i = 0; i < this.selectedListModel.size(); ++i) {
            aSource = this.selectedListModel.get(i);
            if (!aSource.getName().equals(sn)) continue;
            aSource.setActive(false);
            this.availListModel.insertElement(aSource);
            this.selectedListModel.remove(i);
            return;
        }
        for (i = 0; i < this.availListModel.size(); ++i) {
            aSource = this.availListModel.get(i);
            if (!aSource.getName().equals(sn)) continue;
            aSource.setActive(true);
            this.selectedListModel.insertElement(aSource);
            this.availListModel.remove(i);
            return;
        }
    }
}

