/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class CertificateAmendment {
    public static final Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static final EmbeddedCertAmend[] CERT_AMEND = new EmbeddedCertAmend[0];
    private static final NativeCertAmend[] PLATFORM_CERT_AMEND = new NativeCertAmend[]{new NativeCertAmend("DST Root CA X3", "DST Root CA X3", "DST_Root_CA_X3.pem", "0687260331a72403d909f105e69bcf0d32e1bd2493ffc6d9206d11bcd6770739", "https://acme-v02.api.letsencrypt.org"), new NativeCertAmend("Staat der Nederlanden Root CA - G2", "Staat der Nederlanden Root CA - G2", "Staat_der_Nederlanden_Root_CA_-_G2.crt", "668c83947da63b724bece1743c31a0e6aed0db8ec5b31be377bb784f91b6716f", "https://roottest-g2.pkioverheid.nl"), new NativeCertAmend("Government of Netherlands G3", "Staat der Nederlanden Root CA - G3", "Staat_der_Nederlanden_Root_CA_-_G3.crt", "3c4fb0b95ab8b30032f432b86f535fe172c185d0fd39865837cf36187fa6f428", "https://roottest-g3.pkioverheid.nl"), new NativeCertAmend("Certigna", "Certigna", "Certigna.crt", "e3b6a2db2ed7ce48842f7ac53241c7b71d54144bfb40c11f3f1d0b42f5eea12d", "https://www.certigna.fr"), new NativeCertAmend("CA Disig Root R2", "CA Disig Root R2", "CA_Disig_Root_R2.pem", "e23d4a036d7b70e9f595b1422079d2b91edfbb1fb651a0633eaa8a9dc5f80703", "https://eidas.disig.sk"), new NativeCertAmend("Government Root Certification Authority", "Government Root Certification Authority", "Taiwan_GRCA.pem", "7600295eefe85b9e1fd624db76062aaaae59818a54d2774cd4c0b2c01131e1b3", "https://grca.nat.gov.tw")};
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException, GeneralSecurityException {
        CertificateAmendment.addMissingCertificates(Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts"));
    }

    public static void addMissingCertificates(Path cacertsPath) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream is = Files.newInputStream(cacertsPath, new OpenOption[0]);){
            keyStore.load(is, "changeit".toCharArray());
        }
        catch (SecurityException e) {
            log.log(Level.SEVERE, "Unable to load keystore", e);
            return;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        boolean certificateAdded = false;
        try {
            for (NativeCertAmend certAmend : PLATFORM_CERT_AMEND) {
                X509Certificate cert = CertificateAmendment.getX509Certificate(certAmend);
                if (!CertificateAmendment.checkAndAddCertificate(md, cert, certAmend, keyStore)) continue;
                certificateAdded = true;
            }
        }
        catch (IOException | IllegalStateException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.warning("Can't create certificate for OSM: " + e.getMessage());
        }
        if (certificateAdded) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
        }
    }

    public static X509Certificate getX509Certificate(NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        String os = System.getProperty("os.name");
        if (os.toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            KeyStore ks = KeyStore.getInstance("Windows-ROOT");
            ks.load(null, null);
            Certificate result = ks.getCertificate(certAmend.getWinAlias());
            if (result instanceof X509Certificate) {
                return (X509Certificate)result;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            Enumeration<String> aliases = ks.aliases();
            while (aliases.hasMoreElements()) {
                result = ks.getCertificate(aliases.nextElement());
                if (!(result instanceof X509Certificate) || !certAmend.getSha256().equalsIgnoreCase(CertificateAmendment.toHexString(md.digest(result.getEncoded())))) continue;
                return (X509Certificate)result;
            }
        } else if (os.toLowerCase(Locale.ENGLISH).startsWith("mac os x")) {
            try {
                String pem = CertificateAmendment.execOutput(Arrays.asList("security", "find-certificate", "-c", certAmend.getMacAlias(), "-p", "/System/Library/Keychains/SystemRootCertificates.keychain"), 100L, TimeUnit.SECONDS);
                return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(pem.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IllegalArgumentException | InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
        return null;
    }

    public static String execOutput(List<String> command, long timeout, TimeUnit unit) throws IOException, ExecutionException, InterruptedException {
        Path out = Files.createTempFile("tsucat_exec_", ".txt", new FileAttribute[0]);
        Process p = new ProcessBuilder(command).redirectErrorStream(true).redirectOutput(out.toFile()).start();
        if (!p.waitFor(timeout, unit) || p.exitValue() != 0) {
            throw new ExecutionException(command.toString(), null);
        }
        String msg = String.join((CharSequence)"\n", Files.readAllLines(out)).trim();
        try {
            Files.delete(out);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "cant execute command: " + command, e);
        }
        return msg;
    }

    private static boolean checkAndAddCertificate(MessageDigest md, X509Certificate cert, CertAmend certAmend, KeyStore keyStore) throws CertificateEncodingException, KeyStoreException, InvalidAlgorithmParameterException {
        if (cert != null) {
            String sha256 = CertificateAmendment.toHexString(md.digest(cert.getEncoded()));
            if (!certAmend.sha256.equals(sha256)) {
                throw new IllegalStateException("Error adding certificate " + certAmend + " - certificate fingerprint mismatch. Expected " + certAmend.sha256 + ", was " + sha256);
            }
            if (CertificateAmendment.certificateIsMissing(keyStore, cert)) {
                log.log(Level.INFO, "Adding certificate for TLS connections: {0}", cert.getSubjectX500Principal().getName());
                String alias = "tsucat:" + certAmend.filename;
                keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        return false;
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len == 0) {
            return "";
        }
        char[] hexChars = new char[len * 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            byte v = bytes[i];
            hexChars[j++] = HEX_ARRAY[(v & 0xF0) >> 4];
            hexChars[j++] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate crt) throws KeyStoreException, InvalidAlgorithmParameterException {
        PKIXParameters params = new PKIXParameters(keyStore);
        String id = crt.getSubjectX500Principal().getName();
        for (TrustAnchor ta : params.getTrustAnchors()) {
            X509Certificate cert = ta.getTrustedCert();
            if (!Objects.equals(id, cert.getSubjectX500Principal().getName())) continue;
            return false;
        }
        return true;
    }

    public static class NativeCertAmend
    extends CertAmend {
        private final String winAlias;
        private final String macAlias;
        private final String httpsWebSite;

        NativeCertAmend(String winAlias, String macAlias, String filename, String sha256, String httpsWebSite) {
            super(filename, sha256);
            this.winAlias = Objects.requireNonNull(winAlias);
            this.macAlias = Objects.requireNonNull(macAlias);
            this.httpsWebSite = Objects.requireNonNull(httpsWebSite);
        }

        public final String getWinAlias() {
            return this.winAlias;
        }

        public final String getMacAlias() {
            return this.macAlias;
        }

        public String getWebSite() {
            return this.httpsWebSite;
        }

        public String toString() {
            String result = this.winAlias;
            if (!this.winAlias.equals(this.macAlias)) {
                result = result + " / " + this.macAlias;
            }
            return result;
        }
    }

    public static class EmbeddedCertAmend
    extends CertAmend {
        private final String url;

        EmbeddedCertAmend(String url, String filename, String sha256) {
            super(filename, sha256);
            this.url = Objects.requireNonNull(url);
        }

        public final String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }
    }

    public static class CertAmend {
        private final String filename;
        private final String sha256;

        protected CertAmend(String filename, String sha256) {
            this.filename = Objects.requireNonNull(filename);
            this.sha256 = Objects.requireNonNull(sha256);
        }

        public final String getFilename() {
            return this.filename;
        }

        public final String getSha256() {
            return this.sha256;
        }
    }
}

