/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Objects;

public class City
implements Comparable {
    private String name = "";
    private double lat = 0.0;
    private double lon = 0.0;
    private String fips = "";
    private String adm2 = "";
    private double pop = 0.0;
    private Point2D.Double userPt = new Point2D.Double();
    private Ellipse2D.Double userCircle;

    public City(String name, double lat, double lon, String fips, String adm2, double pop) {
        this.name = name;
        this.lon = lon < 0.0 ? lon + 360.0 : lon;
        this.lat = lat;
        this.fips = fips;
        this.adm2 = adm2;
        this.pop = pop;
    }

    public void setUserPt(Point2D.Double p) {
        this.userCircle = new Ellipse2D.Double(p.x, p.y, 3.0, 3.0);
        this.userPt = p;
        this.userPt.x += 0.01;
        this.userPt.y -= 0.01;
    }

    public void setRadius(double r) {
        this.userCircle.width = r;
        this.userCircle.height = r;
    }

    public Ellipse2D.Double getUserCircle() {
        return this.userCircle;
    }

    public Point2D.Double getUserPt() {
        return this.userPt;
    }

    public String getName() {
        return this.name;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public String getFIPS() {
        return this.fips;
    }

    public String getADM2() {
        return this.adm2;
    }

    public double getPopulation() {
        return this.pop;
    }

    public int compareTo(Object obj) {
        double d2;
        City that = (City)obj;
        double d1 = this.getPopulation();
        if (d1 > (d2 = that.getPopulation())) {
            return -1;
        }
        if (d1 < d2) {
            return 1;
        }
        int res = this.getName().compareTo(that.getName());
        if (res == 0) {
            res = this.fips.compareTo(that.fips);
        }
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        City other = (City)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lat) != Double.doubleToLongBits(other.lat)) {
            return false;
        }
        if (Double.doubleToLongBits(this.lon) != Double.doubleToLongBits(other.lon)) {
            return false;
        }
        if (!Objects.equals(this.fips, other.fips)) {
            return false;
        }
        if (!Objects.equals(this.adm2, other.adm2)) {
            return false;
        }
        return Double.doubleToLongBits(this.pop) == Double.doubleToLongBits(other.pop);
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.name);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.lat) ^ Double.doubleToLongBits(this.lat) >>> 32);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.lon) ^ Double.doubleToLongBits(this.lon) >>> 32);
        hash = 59 * hash + Objects.hashCode(this.fips);
        hash = 59 * hash + Objects.hashCode(this.adm2);
        hash = 59 * hash + (int)(Double.doubleToLongBits(this.pop) ^ Double.doubleToLongBits(this.pop) >>> 32);
        return hash;
    }
}

