/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.File;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ColorLUT {
    private Logger log = Logger.getLogger("gov.noaa.tsunami");
    WritableRaster raster;
    double[][] data;
    Color[][] colors = null;
    int[] r;
    int[] g;
    int[] b;
    int[] a;
    double dataMin;
    double dataMax;
    int nx;
    int ny;
    double rangeMin = 0.0;
    double rangeMax = 500.0;
    double[] range = null;

    public void setLog(Logger l) {
        this.log = l;
    }

    public void setColormapRachel() {
        int[] rr = new int[]{255, 127, 0, 8, 17, 34, 51, 119, 187, 204, 221, 238, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 253, 251, 249, 247, 245, 243, 241, 239, 237, 235, 233, 231, 229, 227, 226, 224, 222, 220, 218, 216, 214, 212, 210, 208, 206, 204, 202, 200, 198, 197, 195, 193, 191, 189, 187, 185, 183, 181, 179, 177, 175, 173, 171, 170, 168, 166, 164, 162, 160, 158, 156, 154, 152, 150, 148, 146, 144, 142, 141, 139, 137, 135, 133, 131, 129, 127, 129, 131, 132, 134, 136, 138, 140, 142, 143, 145, 147, 149, 151, 153, 154, 156, 158, 160, 162, 163, 165, 167, 169, 171, 173, 174, 176, 178, 180, 182, 183, 185, 187, 189, 191, 193, 194, 196, 198, 200, 202, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 204, 200, 197, 194, 190, 187, 184, 181, 177, 174, 171, 167, 164, 161, 158, 154, 151, 148, 144, 141, 138, 135, 131, 128, 125, 122, 121, 121, 121, 120, 120, 120, 120, 119, 119, 119, 119, 118, 118, 118, 117, 117, 117, 117, 116, 116, 116, 116, 115, 115, 115, 115, 114, 114, 114, 113, 113, 113, 113, 112, 112, 112, 112, 111, 111, 111, 110, 110, 110, 110, 109, 109, 109, 109, 108, 108, 108, 108, 107, 107, 107, 106, 106, 106, 106, 105, 106, 106, 106, 106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 112, 112, 112, 112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 115, 115, 115, 116, 116, 116, 116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 118, 118, 118, 118, 118, 118, 118, 119, 119, 119, 119, 119, 119, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 125, 126, 125, 124, 124, 123, 123, 122, 121, 121, 120, 120, 119, 118, 118, 117, 117, 116, 115, 115, 114, 114, 113, 112, 112, 111, 111, 110, 109, 109, 108, 108, 107, 106, 106, 105, 105, 104, 104, 103, 102, 102, 101, 101, 100, 99, 99, 98, 98, 97, 96, 96, 95, 95, 94, 93, 93, 92, 92, 91, 90, 90, 89, 89, 88, 87, 87, 86, 86, 85, 84, 84, 83, 83, 82, 82, 81, 80, 80, 79, 79, 78, 77, 77, 76, 76, 75, 74, 74, 73, 73, 72, 71, 71, 70, 70, 69, 68, 68, 67, 67, 66, 65, 65, 64, 64, 63, 63, 62, 61, 61, 60, 60, 59, 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 52, 52, 51, 51, 50, 49, 49, 48, 48, 47, 46, 46, 45, 45, 44, 43, 43, 42, 42, 41, 41, 40, 39, 39, 38, 38, 37, 36, 36, 35, 35, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 24, 24, 23, 23, 22, 21, 21, 20, 20, 19, 19, 18, 17, 17, 16, 16, 15, 14, 14, 13, 13, 12, 11, 11, 10, 10, 9, 8, 8, 7, 7, 6, 5, 5, 4, 4, 3, 2, 2, 1, 1, 0, 0};
        int[] gr = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 248, 241, 234, 227, 221, 214, 207, 200, 193, 186, 180, 173, 166, 163, 161, 158, 155, 152, 149, 147, 144, 141, 138, 136, 133, 130, 127, 124, 122, 119, 116, 113, 111, 108, 105, 102, 99, 97, 94, 91, 88, 86, 83, 80, 77, 74, 72, 69, 66, 63, 61, 58, 55, 52, 49, 47, 44, 41, 38, 36, 33, 30, 27, 24, 22, 19, 16, 13, 11, 8, 5, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 7, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 15, 15, 15, 14, 14, 14, 14, 13, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 3, 3, 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 125, 124, 124, 123, 123, 122, 121, 121, 120, 120, 119, 118, 118, 117, 117, 116, 115, 115, 114, 114, 113, 112, 112, 111, 111, 110, 109, 109, 108, 108, 107, 106, 106, 105, 105, 104, 104, 103, 102, 102, 101, 101, 100, 99, 99, 98, 98, 97, 96, 96, 95, 95, 94, 93, 93, 92, 92, 91, 90, 90, 89, 89, 88, 87, 87, 86, 86, 85, 84, 84, 83, 83, 82, 82, 81, 80, 80, 79, 79, 78, 77, 77, 76, 76, 75, 74, 74, 73, 73, 72, 71, 71, 70, 70, 69, 68, 68, 67, 67, 66, 65, 65, 64, 64, 63, 63, 62, 61, 61, 60, 60, 59, 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 52, 52, 51, 51, 50, 49, 49, 48, 48, 47, 46, 46, 45, 45, 44, 43, 43, 42, 42, 41, 41, 40, 39, 39, 38, 38, 37, 36, 36, 35, 35, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 24, 24, 23, 23, 22, 21, 21, 20, 20, 19, 19, 18, 17, 17, 16, 16, 15, 14, 14, 13, 13, 12, 11, 11, 10, 10, 9, 8, 8, 7, 7, 6, 5, 5, 4, 4, 3, 2, 2, 1, 1, 0, 0};
        int[] br = new int[]{255, 255, 255, 221, 187, 119, 51, 34, 17, 12, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 7, 10, 14, 18, 21, 25, 29, 32, 36, 40, 43, 47, 51, 54, 58, 61, 65, 69, 72, 76, 80, 83, 87, 91, 94, 98, 102, 105, 109, 112, 116, 120, 123, 127, 131, 134, 138, 142, 145, 149, 153, 155, 158, 161, 164, 167, 170, 172, 175, 178, 181, 184, 187, 189, 192, 195, 198, 201, 204, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 225, 223, 221, 219, 217, 215, 213, 211, 209, 207, 205, 203, 201, 199, 197, 195, 193, 191, 189, 187, 185, 183, 181, 179, 177, 175, 173, 171, 168, 166, 164, 162, 160, 158, 156, 154, 152, 150, 148, 146, 144, 142, 140, 138, 136, 134, 132, 130, 128, 126, 124, 122, 120, 118, 116, 114, 111, 109, 107, 105, 106, 106, 106, 106, 106, 106, 106, 107, 107, 107, 107, 107, 107, 108, 108, 108, 108, 108, 108, 108, 109, 109, 109, 109, 109, 109, 110, 110, 110, 110, 110, 110, 110, 111, 111, 111, 111, 111, 111, 112, 112, 112, 112, 112, 112, 112, 113, 113, 113, 113, 113, 113, 114, 114, 114, 114, 114, 114, 114, 115, 115, 115, 115, 115, 115, 116, 116, 116, 116, 116, 116, 116, 117, 117, 117, 117, 117, 117, 118, 118, 118, 118, 118, 118, 118, 119, 119, 119, 119, 119, 119, 120, 120, 120, 120, 120, 120, 120, 121, 121, 121, 121, 121, 121, 122, 122, 122, 122, 122, 122, 122, 123, 123, 123, 123, 123, 123, 124, 124, 124, 124, 124, 124, 124, 125, 125, 125, 125, 125, 125, 126, 125, 124, 124, 123, 123, 122, 121, 121, 120, 120, 119, 118, 118, 117, 117, 116, 115, 115, 114, 114, 113, 112, 112, 111, 111, 110, 109, 109, 108, 108, 107, 106, 106, 105, 105, 104, 104, 103, 102, 102, 101, 101, 100, 99, 99, 98, 98, 97, 96, 96, 95, 95, 94, 93, 93, 92, 92, 91, 90, 90, 89, 89, 88, 87, 87, 86, 86, 85, 84, 84, 83, 83, 82, 82, 81, 80, 80, 79, 79, 78, 77, 77, 76, 76, 75, 74, 74, 73, 73, 72, 71, 71, 70, 70, 69, 68, 68, 67, 67, 66, 65, 65, 64, 64, 63, 63, 62, 61, 61, 60, 60, 59, 58, 58, 57, 57, 56, 55, 55, 54, 54, 53, 52, 52, 51, 51, 50, 49, 49, 48, 48, 47, 46, 46, 45, 45, 44, 43, 43, 42, 42, 41, 41, 40, 39, 39, 38, 38, 37, 36, 36, 35, 35, 34, 33, 33, 32, 32, 31, 30, 30, 29, 29, 28, 27, 27, 26, 26, 25, 24, 24, 23, 23, 22, 21, 21, 20, 20, 19, 19, 18, 17, 17, 16, 16, 15, 14, 14, 13, 13, 12, 11, 11, 10, 10, 9, 8, 8, 7, 7, 6, 5, 5, 4, 4, 3, 2, 2, 1, 1, 0, 0};
        int[] ar = new int[]{0, 75, 125, 178, 181, 183, 185, 187, 189, 190, 191, 193, 194, 195, 196, 196, 197, 198, 199, 200, 200, 201, 202, 202, 203, 203, 204, 204, 205, 205, 206, 206, 207, 207, 208, 208, 208, 209, 209, 210, 210, 210, 211, 211, 211, 212, 212, 212, 213, 213, 213, 213, 214, 214, 214, 215, 215, 215, 215, 216, 216, 216, 216, 217, 217, 217, 217, 217, 218, 218, 218, 218, 219, 219, 219, 219, 219, 220, 220, 220, 220, 220, 221, 221, 221, 221, 221, 221, 222, 222, 222, 222, 222, 222, 223, 223, 223, 223, 223, 223, 224, 224, 224, 224, 224, 224, 224, 225, 225, 225, 225, 225, 225, 225, 226, 226, 226, 226, 226, 226, 226, 227, 227, 227, 227, 227, 227, 227, 227, 228, 228, 228, 228, 228, 228, 228, 228, 229, 229, 229, 229, 229, 229, 229, 229, 229, 230, 230, 230, 230, 230, 230, 230, 230, 230, 231, 231, 231, 231, 231, 231, 231, 231, 231, 231, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 233, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 234, 235, 235, 235, 235, 235, 235, 235, 235, 235, 235, 235, 235, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 236, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 237, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 238, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 239, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 240, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 241, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 242, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 243, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 244, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 245, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 246, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 247, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 248, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255};
        this.r = rr;
        this.g = gr;
        this.b = br;
        this.a = ar;
    }

    public int[] swap(int[] x) {
        for (int i = 0; i < x.length / 2; ++i) {
            int tmp = x[i];
            x[i] = x[x.length - 1 - i];
            x[x.length - 1 - i] = tmp;
        }
        return x;
    }

    public double[] swap(double[] x) {
        for (int i = 0; i < x.length / 2; ++i) {
            double tmp = x[i];
            x[i] = x[x.length - 1 - i];
            x[x.length - 1 - i] = tmp;
        }
        return x;
    }

    public void setColormapRedBlue() {
        int[] red = new int[]{10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 22, 32, 43, 53, 64, 75, 85, 96, 106, 117, 140, 163, 187, 210, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 183, 146, 110, 74};
        int[] green = new int[]{36, 34, 31, 29, 26, 24, 21, 19, 16, 14, 11, 28, 45, 62, 79, 96, 112, 129, 146, 163, 180, 192, 205, 217, 229, 255, 255, 204, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{106, 121, 136, 151, 166, 180, 195, 210, 225, 240, 255, 255, 254, 253, 253, 253, 252, 251, 251, 251, 250, 250, 250, 250, 250, 255, 255, 204, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        int[] alpha = new int[red.length];
        for (int i = 0; i < alpha.length; ++i) {
            alpha[i] = 255;
        }
        double[] vals = new double[]{-500.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -90.0, -80.0, -70.0, -60.0, -50.0, -40.0, -30.0, -20.0, -10.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 500.0};
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
        this.range = vals;
    }

    public void setColormapTweb() {
        int[] ro = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 235, 214, 194, 173, 153, 133, 112, 92, 71, 255};
        int[] go = new int[]{26, 51, 77, 102, 128, 153, 179, 204, 230, 255, 245, 235, 224, 214, 204, 194, 184, 174, 163, 255};
        int[] bo = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 51, 77, 102, 128, 153, 179, 204, 230, 255};
        int[] ao = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 200, 180, 0};
        this.r = this.swap(ro);
        this.g = this.swap(go);
        this.b = this.swap(bo);
        this.a = this.swap(ao);
        double[] ranges = new double[]{400.0, 300.0, 200.0, 100.0, 90.0, 80.0, 70.0, 60.0, 50.0, 40.0, 30.0, 20.0, 10.0, 8.0, 6.0, 4.0, 2.0, 1.0, 0.1, -5000.0};
        this.range = this.swap(ranges);
    }

    public void setColormapPTWC() {
        int[] ro = new int[]{227, 234, 241, 243, 0, 130, 61, 19, 255};
        int[] go = new int[]{37, 12, 126, 248, 244, 183, 106, 71, 255};
        int[] bo = new int[]{188, 0, 0, 0, 0, 244, 204, 141, 255};
        int[] ao = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 0};
        this.r = ro;
        this.g = go;
        this.b = bo;
        this.a = ao;
    }

    public int getPTWCa(double val) {
        return this.argb2int(255, 6, 70, 132);
    }

    public int getPTWCb(double val) {
        return this.argb2int(255, 46, 104, 201);
    }

    public int getPTWCc(double val) {
        int ro = (int)this.scale(val, 5.0, 10.0, 106.0, 145.0);
        int go = (int)this.scale(val, 5.0, 10.0, 136.0, 198.0);
        int bo = (int)this.scale(val, 5.0, 10.0, 224.0, 255.0);
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC01(double val) {
        int ro = (int)this.scale(val, 0.0, 10.0, 0.0, 137.0);
        int go = (int)this.scale(val, 0.0, 10.0, 62.0, 189.0);
        int bo = (int)this.scale(val, 0.0, 10.0, 126.0, 255.0);
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC02(double val) {
        int ro = 0;
        int go = (int)this.scale(val, 10.0, 25.0, 124.0, 255.0);
        int bo = 0;
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC03(double val) {
        int ro = (int)this.scale(val, 25.0, 50.0, 124.0, 255.0);
        int go = (int)this.scale(val, 25.0, 50.0, 124.0, 255.0);
        int bo = 0;
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC04(double val) {
        int ro = (int)this.scale(val, 50.0, 75.0, 124.0, 255.0);
        int go = (int)this.scale(val, 50.0, 75.0, 68.0, 124.0);
        int bo = 0;
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC05(double val) {
        int ro = (int)this.scale(val, 75.0, 100.0, 124.0, 255.0);
        int go = 0;
        int bo = 0;
        return this.argb2int(255, ro, go, bo);
    }

    public int getPTWC06(double val) {
        int ro = 255;
        int go = (int)this.scale(val, 100.0, 300.0, 255.0, 0.0);
        int bo = 255;
        return this.argb2int(255, ro, go, bo);
    }

    private int argb2int(int A, int R, int G, int B) {
        int val = (A & 0xFF) << 24 | (R & 0xFF) << 16 | (G & 0xFF) << 8 | B & 0xFF;
        return val;
    }

    private int rgb2int(int R, int G, int B) {
        int val = (R & 0xFF) << 16 | (G & 0xFF) << 8 | B & 0xFF;
        return val;
    }

    public static int getAlpha(int c) {
        return c >>> 24 & 0xFF;
    }

    public static int getRed(int c) {
        return c >>> 16 & 0xFF;
    }

    public static int getGreen(int c) {
        return c >>> 8 & 0xFF;
    }

    public static int getBlue(int c) {
        return c & 0xFF;
    }

    private double scale(double val, double inmin, double inmax, double omin, double omax) {
        return (val - inmin) * (omax - omin) / (inmax - inmin) + omin;
    }

    public BufferedImage getImagePTWCorig() {
        this.setColormapPTWC();
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int val = 0;
        boolean indx = false;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                val = this.data[j][i] > 300.0 ? this.argb2int(255, 255, 50, 200) : (this.data[j][i] > 100.0 ? this.getPTWC06(this.data[j][i]) : (this.data[j][i] > 75.0 ? this.getPTWC05(this.data[j][i]) : (this.data[j][i] > 50.0 ? this.getPTWC04(this.data[j][i]) : (this.data[j][i] > 25.0 ? this.getPTWC03(this.data[j][i]) : (this.data[j][i] > 10.0 ? this.getPTWC02(this.data[j][i]) : (this.data[j][i] > 0.1 ? this.getPTWC01(this.data[j][i]) : this.argb2int(0, 255, 255, 255)))))));
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public BufferedImage getImagePTWC() {
        this.setColormapPTWC();
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int val = 0;
        boolean indx = false;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                val = this.data[j][i] > 300.0 ? this.argb2int(255, 255, 50, 200) : (this.data[j][i] > 100.0 ? this.getPTWC06(this.data[j][i]) : (this.data[j][i] > 75.0 ? this.getPTWC05(this.data[j][i]) : (this.data[j][i] > 50.0 ? this.getPTWC04(this.data[j][i]) : (this.data[j][i] > 25.0 ? this.getPTWC03(this.data[j][i]) : (this.data[j][i] > 10.0 ? this.getPTWC02(this.data[j][i]) : (this.data[j][i] > 5.0 ? this.getPTWCc(this.data[j][i]) : (this.data[j][i] > 1.0 ? this.getPTWCb(this.data[j][i]) : (this.data[j][i] > 0.05 ? this.getPTWCa(this.data[j][i]) : this.argb2int(0, 255, 255, 255)))))))));
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public BufferedImage getImagePTWCsmallmag() {
        this.setColormapPTWC();
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int val = 0;
        boolean indx = false;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                val = this.data[j][i] > 150.0 ? this.argb2int(255, 255, 50, 200) : (this.data[j][i] > 40.0 ? this.argb2int(255, 255, (int)this.scale(this.data[j][i], 40.0, 150.0, 255.0, 0.0), 255) : (this.data[j][i] > 30.0 ? this.argb2int(255, (int)this.scale(this.data[j][i], 30.0, 40.0, 124.0, 255.0), 0, 0) : (this.data[j][i] > 20.0 ? this.argb2int(255, (int)this.scale(this.data[j][i], 20.0, 30.0, 124.0, 255.0), (int)this.scale(this.data[j][i], 20.0, 30.0, 68.0, 124.0), 0) : (this.data[j][i] > 10.0 ? this.argb2int(255, (int)this.scale(this.data[j][i], 10.0, 20.0, 124.0, 255.0), (int)this.scale(this.data[j][i], 10.0, 20.0, 124.0, 255.0), 0) : (this.data[j][i] > 5.0 ? this.argb2int(255, 0, (int)this.scale(this.data[j][i], 5.0, 10.0, 124.0, 255.0), 0) : (this.data[j][i] > 0.0 ? this.argb2int(255, (int)this.scale(this.data[j][i], 0.0, 5.0, 0.0, 137.0), (int)this.scale(this.data[j][i], 0.0, 5.0, 62.0, 189.0), (int)this.scale(this.data[j][i], 0.0, 5.0, 126.0, 255.0)) : this.argb2int(0, 255, 255, 255)))))));
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public void setData(double[][] d) {
        this.colors = null;
        this.data = d;
        this.ny = d.length;
        this.nx = d[0].length;
        this.dataMin = Double.MAX_VALUE;
        this.dataMax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                this.dataMin = this.data[j][i] < this.dataMin ? this.data[j][i] : this.dataMin;
                this.dataMax = this.data[j][i] > this.dataMax ? this.data[j][i] : this.dataMax;
            }
        }
    }

    public void setColorRange(double min, double max) {
        this.rangeMin = min;
        this.rangeMax = max;
    }

    public Color[][] getColors() {
        if (this.colors != null) {
            return this.colors;
        }
        this.colors = new Color[this.ny][this.nx];
        if (this.range == null) {
            int indx = 0;
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    indx = (int)Math.floor((double)(this.r.length - 1) * ((this.data[j][i] - this.rangeMin) / (this.rangeMax - this.rangeMin)));
                    indx = indx > this.r.length - 1 ? this.r.length - 1 : indx;
                    this.colors[j][i] = new Color(this.r[indx], this.g[indx], this.b[indx], this.a[indx]);
                }
            }
        } else {
            int indx = 0;
            for (int i = 0; i < this.nx; ++i) {
                for (int j = 0; j < this.ny; ++j) {
                    indx = this.getIndex(this.data[j][i], this.range);
                    this.colors[j][i] = indx == -1 ? Color.WHITE : new Color(this.r[indx], this.g[indx], this.b[indx], this.a[indx]);
                }
            }
        }
        return this.colors;
    }

    public BufferedImage getImage(double[] ranges) {
        return ranges == null ? this.getImageFullRange() : this.getImageIndexed(ranges);
    }

    public BufferedImage getImageFullRange() {
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int val = 0;
        int indx = 0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                indx = (int)Math.floor((double)(this.r.length - 1) * ((this.data[j][i] - this.rangeMin) / (this.rangeMax - this.rangeMin)));
                indx = indx > this.r.length - 1 ? this.r.length - 1 : indx;
                val = (this.a[indx] & 0xFF) << 24 | (this.r[indx] & 0xFF) << 16 | (this.g[indx] & 0xFF) << 8 | (this.b[indx] & 0xFF) << 0;
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public BufferedImage getImageTweb() {
        this.setColormapTweb();
        return this.getImageIndexed(this.range);
    }

    public BufferedImage getImageRachel() {
        this.setColormapRachel();
        this.setColorRange(0.0, 200.0);
        return this.getImageFullRange();
    }

    public BufferedImage getImageIndexed() {
        return this.getImageIndexed(this.range);
    }

    public BufferedImage getImageIndexedRGB() {
        return this.getImageIndexedRGB(this.range);
    }

    public BufferedImage getImageIndexed(double[] ranges) {
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int val = 0;
        int indx = 0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                indx = this.getIndex(this.data[j][i], ranges);
                val = indx == -1 ? this.argb2int(0, 0, 0, 0) : this.argb2int(this.a[indx], this.r[indx], this.g[indx], this.b[indx]);
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public BufferedImage getImageIndexedRGB(double[] ranges) {
        BufferedImage im = new BufferedImage(this.nx, this.ny, 1);
        int val = 0;
        int indx = 0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                indx = this.getIndex(this.data[j][i], ranges);
                val = indx == -1 ? this.rgb2int(0, 0, 0) : this.rgb2int(this.r[indx], this.g[indx], this.b[indx]);
                im.setRGB(i, this.ny - j - 1, val);
            }
        }
        return im;
    }

    public BufferedImage getPTWCStandard() {
        int[] colors = new int[]{Color.HSBtoRGB(0.5833333f, 1.0f, 0.5f), Color.HSBtoRGB(0.33333334f, 1.0f, 1.0f), Color.HSBtoRGB(0.16666667f, 1.0f, 1.0f), Color.HSBtoRGB(0.083333336f, 1.0f, 1.0f), Color.HSBtoRGB(0.0f, 0.25f, 1.0f), Color.HSBtoRGB(0.0f, 1.0f, 1.0f), Color.HSBtoRGB(0.0f, 1.0f, 0.75f)};
        double sub30 = 30.0;
        double sub100 = 100.0;
        double super300 = 300.0;
        int i = 1;
        while (Double.compare(sub30, 30.0) == 0) {
            sub30 = 30.0 - Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        i = 1;
        while (Double.compare(sub100, 100.0) == 0) {
            sub100 = 100.0 - Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        i = 1;
        while (Double.compare(super300, 300.0) == 0) {
            super300 = 300.0 + Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        double[] vals = new double[]{0.0, sub30, 30.0, sub100, 100.0, 300.0, 300.0 + super300};
        return this.getImageIndexedInterp(vals, colors);
    }

    public BufferedImage getImageIndexedInterp(double[] ranges, int[] colors) {
        BufferedImage im = new BufferedImage(this.nx, this.ny, 2);
        int indx = 0;
        float frac = 0.0f;
        int c = 0;
        for (int i = 0; i < this.nx; ++i) {
            for (int j = 0; j < this.ny; ++j) {
                indx = this.getIndex(this.data[j][i], ranges);
                if (this.data[j][i] <= ranges[0] || this.data[j][i] >= ranges[ranges.length - 1]) {
                    frac = 1.0f;
                    c = colors[indx];
                } else {
                    frac = (float)((this.data[j][i] - ranges[indx]) / (ranges[indx + 1] - ranges[indx]));
                    c = ColorLUT.interpolateColors(colors[indx], colors[indx + 1], frac);
                }
                if (this.data[j][i] == 0.0) {
                    c &= 0xFFFFFF;
                }
                im.setRGB(i, this.ny - j - 1, c);
            }
        }
        return im;
    }

    public static int interpolateColors(int c1, int c2, float frac) {
        return (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 24 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 24 & 0xFF) * frac))) & 0xFF) << 24 | (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 16 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 16 & 0xFF) * frac))) & 0xFF) << 16 | (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 8 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 8 & 0xFF) * frac))) & 0xFF) << 8 | Math.max(0, Math.min(255, Math.round((float)(c1 & 0xFF) * (1.0f - frac) + (float)(c2 & 0xFF) * frac))) & 0xFF;
    }

    public int getIndex(double val, double[] values) {
        if (val <= values[0]) {
            return 0;
        }
        for (int i = 1; i < values.length; ++i) {
            if (!(val >= values[i - 1]) || !(val < values[i])) continue;
            return i - 1;
        }
        return val >= values[values.length - 1] ? values.length - 1 : -1;
    }

    public static BufferedImage brighten(BufferedImage im, float br) {
        BufferedImage outIm = null;
        RescaleOp op = new RescaleOp(new float[]{br, br, br, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        outIm = op.filter(im, null);
        return outIm;
    }

    public static void main(String[] args) throws Exception {
        ColorLUT lut = new ColorLUT();
        int nx = 24;
        int ny = 240;
        int nl = 8;
        double[] start = new double[]{0.0, 3.3333, 6.6666, 10.0, 25.0, 50.0, 75.0, 100.0, 300.0};
        double[][] data = new double[ny][nx];
        for (int l = 0; l < nl; ++l) {
            double a = start[l];
            double b = start[l + 1];
            for (int j = 0; j < ny / nl; ++j) {
                double val = a + (double)j * (b - a) / 29.0;
                System.out.println("val: " + val);
                for (int i = 0; i < nx; ++i) {
                    data[l * (ny / nl) + j][i] = val;
                }
            }
        }
        lut.setData(data);
        BufferedImage im = lut.getImagePTWC();
        ImageIO.write((RenderedImage)im, "png", new File("colormap.png"));
    }
}

