/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.dart.Buoy;
import gov.noaa.tsunami.websift.ee.AddSourceDialog;
import gov.noaa.tsunami.websift.ee.City;
import gov.noaa.tsunami.websift.ee.EventEditorConstants;
import gov.noaa.tsunami.websift.ee.MapCanvas;
import gov.noaa.tsunami.websift.ee.NewEventDialog;
import gov.noaa.tsunami.websift.ee.SourceInfoFrame;
import gov.noaa.tsunami.websift.ee.SourceTableAlphaEditor;
import gov.noaa.tsunami.websift.ee.SourceTableModel;
import gov.noaa.tsunami.websift.events.CountryBoundaries;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.PropGrid;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.PropagationDatabaseException;
import gov.noaa.tsunami.websift.propdb.Range2D;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.SourceScenario;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;

public class EventEditor2
extends JPanel
implements EventEditorConstants,
ActionListener,
CellEditorListener,
FocusListener,
PropertyChangeListener,
ListSelectionListener {
    public static boolean DEBUG = true;
    protected static Logger log = Logger.getLogger(EventEditor2.class.getPackage().getName());
    private static MapCanvas map;
    private String propFolder = "";
    private SourceTableModel tableModel;
    private double totalMagnitude;
    private int editMode;
    private int selectMode;
    private SourceCombo sourceComboMulti;
    private SourceCombo sourceComboSingle;
    private static final NumberFormatter magFormat;
    private static final NumberFormatter magFormatEdit;
    private Rectangle2D.Double defaultRegion;
    private final Map<String, Rectangle2D.Double> regionHash;
    private static final PropagationDatabase propdb;
    private ArrayList<City> cities = new ArrayList();
    private AddSourceDialog addSourceDialog = null;
    private SourceInfoFrame sourceInfoWindow;
    private JButton addDelButton;
    private ButtonGroup buttonGroup1;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private JFormattedTextField magFormattedTextField;
    private JPanel mapPanel;
    private JMenuItem removeAllMenuItem;
    private JMenuItem showInfoMenuItem;
    private JPopupMenu sourceTablePopupMenu;

    public EventEditor2() {
        log.info("EE main constructor");
        propdb.setLogger(log);
        this.initComponents();
        map = new MapCanvas(400, 200);
        map.setMark(44);
        map.setMarkSize(30.0);
        map.setMarkColor(new Color(246, 255, 133));
        map.setBoxesColor(new Color(189, 255, 215));
        map.setMode(1);
        map.setSources(propdb.getUnitSources());
        map.addActionListener(this);
        map.setFocusable(true);
        map.addPropertyChangeListener(this);
        map.setLogger(log);
        this.mapPanel.add((Component)map, "Center");
        this.mapPanel.setFocusable(true);
        this.tableModel = new SourceTableModel();
        this.tableModel.setEditableColumns(new int[]{2});
        this.jTable1.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.jTable1.setModel(this.tableModel);
        this.jTable1.setDefaultEditor(Double.class, new SourceTableAlphaEditor());
        this.jTable1.getDefaultEditor(this.jTable1.getColumnClass(2)).addCellEditorListener(this);
        this.jTable1.setDefaultRenderer(Double.class, new Number2DRenderer());
        this.jTable1.getColumnModel().getColumn(0).setMinWidth(7);
        this.jTable1.getColumnModel().getColumn(1).setMinWidth(7);
        this.jTable1.getColumnModel().getColumn(2).setMinWidth(12);
        this.jTable1.getColumnModel().getColumn(0).setPreferredWidth(8);
        this.jTable1.getColumnModel().getColumn(1).setPreferredWidth(8);
        this.jTable1.getColumnModel().getColumn(2).setPreferredWidth(24);
        this.jTable1.setRowHeight(24);
        this.jTable1.setFont(new Font("Lucida Grande", 0, 14));
        this.jTable1.getSelectionModel().addListSelectionListener(this);
        this.totalMagnitude = 7.5;
        this.magFormattedTextField.setValue(this.totalMagnitude);
        this.magFormattedTextField.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.magFormattedTextField.addFocusListener(this);
        this.editMode = 0;
        this.selectMode = 1;
        this.defaultRegion = new Rectangle2D.Double(80.0, -30.0, 60.0, 60.0);
        this.regionHash = new LinkedHashMap<String, Rectangle2D.Double>(20);
        this.regionHash.put("US W Coast", new Rectangle2D.Double(228.0, 30.0, 16.0, 25.0));
        this.regionHash.put("US E Coast", new Rectangle2D.Double(270.0, 20.0, 45.0, 30.0));
        this.regionHash.put("BC Canada", new Rectangle2D.Double(220.0, 46.0, 20.0, 14.0));
        this.regionHash.put("Aleutian", new Rectangle2D.Double(175.0, 45.0, 45.0, 15.0));
        this.regionHash.put("Hawaii", new Rectangle2D.Double(197.0, 18.0, 10.0, 7.0));
        this.regionHash.put("C America", new Rectangle2D.Double(242.0, 0.0, 40.0, 30.0));
        this.regionHash.put("S America", new Rectangle2D.Double(270.0, -70.0, 25.0, 70.0));
        this.regionHash.put("SW Pacific", new Rectangle2D.Double(157.0, -70.0, 43.0, 60.0));
        this.regionHash.put("Japan", new Rectangle2D.Double(135.0, 30.0, 15.0, 17.0));
        this.regionHash.put("Kuril", new Rectangle2D.Double(142.0, 39.0, 33.0, 19.0));
        this.regionHash.put("Indonesia", new Rectangle2D.Double(90.0, -15.0, 45.0, 30.0));
        this.regionHash.put("N Pacific", new Rectangle2D.Double(120.0, 10.0, 150.0, 52.0));
        this.regionHash.put("S Pacific", new Rectangle2D.Double(120.0, -70.0, 172.0, 80.0));
        this.regionHash.put("N Atlantic", new Rectangle2D.Double(270.0, 10.0, 75.0, 50.0));
        this.regionHash.put("S Atlantic", new Rectangle2D.Double(257.0, -75.0, 120.0, 75.0));
        this.regionHash.put("Indian", new Rectangle2D.Double(35.0, -35.0, 120.0, 60.0));
        Vector<String> cbmv = new Vector<String>();
        cbmv.add("to Site");
        cbmv.add("to Selected");
        cbmv.addAll(this.regionHash.keySet());
        cbmv.add("World");
        this.jComboBox1.setModel(new DefaultComboBoxModel(cbmv));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.sourceTablePopupMenu = new JPopupMenu();
        this.showInfoMenuItem = new JMenuItem();
        JMenuItem removeSourceMenuItem = new JMenuItem();
        this.removeAllMenuItem = new JMenuItem();
        this.mapPanel = new JPanel();
        this.addDelButton = new JButton();
        this.jComboBox1 = new JComboBox();
        this.jLabel1 = new JLabel();
        this.magFormattedTextField = new JFormattedTextField(new DefaultFormatterFactory(magFormat, magFormat, magFormatEdit));
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.showInfoMenuItem.setText("Show Seismic Info");
        this.showInfoMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventEditor2.this.showInfoMenuItemActionPerformed(evt);
            }
        });
        this.sourceTablePopupMenu.add(this.showInfoMenuItem);
        removeSourceMenuItem.setText("Remove");
        removeSourceMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventEditor2.this.removeSourceMenuItemActionPerformed(evt);
            }
        });
        this.sourceTablePopupMenu.add(removeSourceMenuItem);
        this.removeAllMenuItem.setText("Remove All");
        this.removeAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventEditor2.this.removeAllMenuItemActionPerformed(evt);
            }
        });
        this.sourceTablePopupMenu.add(this.removeAllMenuItem);
        this.setBackground(Color.white);
        this.mapPanel.setBackground(new Color(255, 255, 255));
        this.mapPanel.setMinimumSize(new Dimension(80, 80));
        this.mapPanel.setPreferredSize(new Dimension(400, 400));
        this.mapPanel.setLayout(new BorderLayout());
        this.addDelButton.setText("Add/Del");
        this.addDelButton.setMargin(new Insets(1, 10, 2, 10));
        this.addDelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventEditor2.this.addDelButtonActionPerformed(evt);
            }
        });
        this.jComboBox1.setMaximumRowCount(20);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Large Elephants"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventEditor2.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Total Magnitude:");
        this.magFormattedTextField.setColumns(4);
        this.magFormattedTextField.setHorizontalAlignment(0);
        this.magFormattedTextField.setText("5.0");
        this.magFormattedTextField.setFocusLostBehavior(0);
        this.magFormattedTextField.setFont(new Font("Lucida Grande", 0, 14));
        this.magFormattedTextField.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EventEditor2.this.magFormattedTextFieldPropertyChange(evt);
            }
        });
        this.jLabel2.setText("Mw");
        this.jTable1.setFont(new Font("Lucida Grande", 0, 14));
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Name", "% Mag", " Alpha    "}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Double.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                EventEditor2.this.sourceTableMouseHandler(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventEditor2.this.sourceTableMouseHandler(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.mapPanel, -1, 528, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.magFormattedTextField, -2, -1, -2).addPreferredGap(0).add(this.jLabel2).add(47, 47, 47)).add(2, layout.createSequentialGroup().add(this.addDelButton).addPreferredGap(0).add(this.jComboBox1, -2, 163, -2).addContainerGap()).add(2, layout.createSequentialGroup().add(this.jScrollPane1, -2, 302, -2).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(this.mapPanel, -1, 485, Short.MAX_VALUE).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel2).add(this.magFormattedTextField, -2, -1, -2).add(this.jLabel1)).addPreferredGap(0).add(this.jScrollPane1, -2, 0, Short.MAX_VALUE).add(5, 5, 5).add(layout.createParallelGroup(3).add(this.addDelButton).add(this.jComboBox1, -2, -1, -2)).addContainerGap()));
    }

    private void magFormattedTextFieldPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("value")) {
            this.totalMagnitude = ((Number)this.magFormattedTextField.getValue()).doubleValue();
            if (this.magFormattedTextField.isFocusOwner()) {
                log.info("setting table sourceCombo total magnitude");
                this.tableModel.getSourceCombo().setMomentMagnitude(this.totalMagnitude);
                this.tableModel.fireTableDataChanged();
            }
            this.fireActionPerformed();
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        String region = (String)this.jComboBox1.getSelectedItem();
        this.jumpToFromCB(region);
    }

    private void addDelButtonActionPerformed(ActionEvent evt) {
        if (this.addSourceDialog == null) {
            this.addSourceDialog = new AddSourceDialog(null, map, false);
            this.addSourceDialog.addPropFolder(this.propFolder);
            this.addSourceDialog.setLocationRelativeTo(this);
        }
        this.addSourceDialog.updateSources();
        this.addSourceDialog.setVisible(true);
    }

    private void removeSourceMenuItemActionPerformed(ActionEvent evt) {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0) {
            UnitSource us = (UnitSource)this.tableModel.getData().get(row);
            this.tableModel.deleteSource(us.getName());
            map.setActive(us.getName());
        }
    }

    private void sourceTableMouseHandler(MouseEvent evt) {
        int row;
        if (evt.isPopupTrigger() && (row = this.jTable1.rowAtPoint(evt.getPoint())) >= 0) {
            this.jTable1.getSelectionModel().setSelectionInterval(row, row);
            this.sourceTablePopupMenu.show(this.jTable1, evt.getX(), evt.getY());
        }
    }

    private void showInfoMenuItemActionPerformed(ActionEvent evt) {
        int row = this.jTable1.getSelectedRow();
        if (row >= 0) {
            UnitSource us = (UnitSource)this.tableModel.getData().get(row);
            if (this.sourceInfoWindow == null) {
                this.sourceInfoWindow = new SourceInfoFrame();
            }
            this.sourceInfoWindow.setSource(us);
            this.sourceInfoWindow.setLocationRelativeTo(map);
            this.sourceInfoWindow.setVisible(true);
            this.sourceInfoWindow.setAlwaysOnTop(true);
            map.repaint();
        }
    }

    private void removeAllMenuItemActionPerformed(ActionEvent evt) {
        this.clearActiveSources();
    }

    public void setBackgroundImage(URL imageUrl, Rectangle2D.Double rec) {
        map.setBackgroundImage(imageUrl, rec);
    }

    public void clearBackgroundImage() {
        map.clearBackgroundImage();
    }

    public void setLoggerConfigurationLocal() {
        try {
            LogManager.getLogManager().readConfiguration(this.getClass().getResourceAsStream("consoleLogging.conf"));
            log.setLevel(Level.ALL);
        }
        catch (IOException | SecurityException ex) {
            log.log(Level.WARNING, "Can't load consoleLogging.conf file, only limited log levels logged", ex);
        }
    }

    public void setLogger(Logger l) {
        log = l;
        map.setLogger(l);
        propdb.setLogger(l);
    }

    public void setBuoyLocs(List<Buoy> v) {
        if (v == null) {
            v = new ArrayList<Buoy>();
        }
        map.setBuoyLocs(v);
    }

    public void plotBuoyLocsOn() {
        map.plotBuoyLocsOn();
    }

    public void plotBuoyLocsOff() {
        map.plotBuoyLocsOff();
    }

    public void setPropFolder(String pf) {
        this.propFolder = pf;
    }

    public void useCities(boolean c) {
        map.useCities(c);
    }

    public void useCountries(boolean c) {
        map.useCountries(c);
    }

    public void plotPlaces(boolean p) {
        map.useCities(p);
        map.useCountries(p);
    }

    public boolean addShape(Shape s, Color c) {
        if (s == null) {
            return false;
        }
        map.addShape(s, c);
        return true;
    }

    public void clearShapes() {
        map.clearShapes();
    }

    public void plotShapes(boolean b) {
        map.plotShapes(b);
    }

    public String getMapSize() {
        Dimension d = map.getSize();
        return d.width + " " + d.height;
    }

    public MapCanvas getMap() {
        return map;
    }

    public void jumpTo(String region) {
        this.jComboBox1.setSelectedItem(region);
    }

    public void jumpToFromCB(String region) {
        Rectangle2D.Double rect = null;
        if (region.equals("to Site")) {
            rect = this.defaultRegion;
        } else if (region.equals("to Selected")) {
            rect = this.getRegionFromSourceCombo();
        } else if (region.equals("World")) {
            this.zoomToFull();
        } else {
            rect = this.regionHash.get(region);
        }
        if (rect != null) {
            this.zoomTo(rect.x, rect.x + rect.width, rect.y, rect.y + rect.height);
        }
    }

    public void jumpToCurrentSite() {
        this.jComboBox1.setSelectedIndex(0);
    }

    public void drawSitesOn() {
        map.drawSitesOn();
    }

    public void drawSitesOff() {
        map.drawSitesOff();
    }

    public void addPropFolder(String directory) {
        this.propFolder = directory;
    }

    public void setDatabaseLocations(List<String> v, boolean g) throws IOException {
        this.setDatabaseLocations(v, null, g);
    }

    public void setDatabaseLocations(String s, boolean g) throws IOException {
        this.setDatabaseLocations(Collections.singletonList(s), null, g);
    }

    public void setDatabaseLocations(String s, String u, String p, boolean g) throws IOException {
        propdb.addDatabaseLocation(s, u, p, g);
        map.setSources(propdb.getUnitSources());
        map.repaint();
    }

    public void setDatabaseLocations(List<String> v, String p, boolean g) throws IOException {
        propdb.setDatabaseLocations(v, p, g);
        map.setSources(propdb.getUnitSources());
        map.repaint();
    }

    public void addDatabaseLocation(String location, String proxy, boolean global) throws IOException {
        propdb.addDatabaseLocation(location, proxy, global);
        map.setSources(propdb.getUnitSources());
        map.repaint();
    }

    public void addDatabaseLocation(String location, boolean global) throws IOException {
        this.addDatabaseLocation(location, null, global);
    }

    public void clearUnitSources() {
        propdb.clearUnitSources();
        map.setSources(propdb.getUnitSources());
    }

    public void updateSource(UnitSource aSource) {
        map.updateSource(aSource);
    }

    public void sortSourcesByName() {
        map.sortSourcesByName();
    }

    public void setActive(SourceCombo sc) {
        if (sc == null) {
            return;
        }
        try {
            this.sourceComboMulti = new SourceCombo(sc, propdb);
        }
        catch (PropagationDatabaseException ex) {
            log.log(Level.SEVERE, null, ex);
        }
        this.sourceComboSingle = new SourceCombo();
        if (this.sourceComboMulti.getNumberOfSources() > 0) {
            UnitSource aSource = this.sourceComboMulti.getClosestSource().copy();
            aSource.setMagnitude(this.sourceComboMulti.getMomentMagnitude());
            this.sourceComboSingle.addSource(aSource);
        }
        if (this.selectMode == 0) {
            map.setActive(this.sourceComboSingle);
            this.tableModel.setSourceCombo(this.sourceComboSingle);
        } else if (this.selectMode == 1) {
            map.setActive(this.sourceComboMulti);
            this.tableModel.setSourceCombo(this.sourceComboMulti);
        }
        this.repaintMap();
        this.totalMagnitude = sc.getMomentMagnitude();
        this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        if (sc.getClosestSource() != null) {
            map.setMostRecentlyClicked(sc.getClosestSource());
        }
    }

    public void setActive(String s) {
        SourceCombo sc = this.getSourceComboFromString(s);
        if (sc.getNumberOfSources() > 0) {
            this.setActive(sc);
        } else {
            this.clearActiveSources();
        }
    }

    public void clearActiveSources() {
        this.tableModel.clear();
        map.setActive(new ArrayList<UnitSource>());
        this.setMagnitude(0.0);
    }

    public UnitSource getSourceFromName(String name) {
        return propdb.getUnitSource(name);
    }

    public UnitSource getMostRecentlyClicked() {
        return map.getMostRecentlyClicked();
    }

    public ArrayList<UnitSource> getSources() {
        return new ArrayList<UnitSource>(map.getSources());
    }

    public void clearHighlightedSources() {
        ArrayList<UnitSource> sources = map.getSources();
        for (UnitSource s : sources) {
            s.setHighlight(false);
        }
    }

    public void setSources(ArrayList<UnitSource> sources) {
        map.setSources(sources);
    }

    public int addPropGrid(PropGrid propGrid) {
        return map.addPropGrid(propGrid);
    }

    public void clearPropGrids() {
        map.clearPropGrids();
    }

    public void drawGrids(boolean drawGrids) {
        map.drawGrids(drawGrids);
    }

    public void setEditMode(int editMode) {
        this.editMode = editMode;
    }

    public void setEditModeOff() {
        this.tableModel.setEditableColumns(new int[]{100});
        this.magFormattedTextField.setEditable(false);
    }

    public void setEditModeOn() {
        this.tableModel.setEditableColumns(new int[]{2});
        this.magFormattedTextField.setEditable(true);
    }

    public SourceCombo getActiveSourceCombo() {
        return this.tableModel.getSourceCombo();
    }

    public void useCroppedSources(InputStream is) throws IOException {
        propdb.useCroppedSources(is);
        map.setSources(propdb.getUnitSources());
        map.repaint();
    }

    public void removeCroppedSources() {
        propdb.removeCroppedSources();
        map.setSources(propdb.getUnitSources());
        map.repaint();
    }

    private Rectangle2D.Double getRegionFromSourceCombo() {
        Vector sv = this.tableModel.getData();
        if (sv.isEmpty()) {
            return this.defaultRegion;
        }
        double minLon = 400.0;
        double maxLon = -400.0;
        double minLat = 400.0;
        double maxLat = -400.0;
        for (UnitSource aSource : sv) {
            minLon = aSource.getLongitude() < minLon ? aSource.getLongitude() : minLon;
            minLat = aSource.getLatitude() < minLat ? aSource.getLatitude() : minLat;
            maxLon = aSource.getLongitude() > maxLon ? aSource.getLongitude() : maxLon;
            maxLat = aSource.getLatitude() > maxLat ? aSource.getLatitude() : maxLat;
        }
        return new Rectangle2D.Double(minLon -= 5.0, minLat -= 5.0, (maxLon += 5.0) - minLon, (maxLat += 5.0) - minLat);
    }

    public Range2D getRubberbandRegion() {
        return map.getRubberbandRegion();
    }

    public void setRubberbanding(boolean b) {
        map.setRubberbanding(b);
    }

    public Range2D getRegion() {
        return map.getRegion();
    }

    public Range2D getCurrentSiteRegion() {
        return new Range2D(this.defaultRegion.x, this.defaultRegion.y, this.defaultRegion.width, this.defaultRegion.height);
    }

    public void setRegion(Range2D region) {
        this.zoomTo(region);
    }

    public void setEpicenter(double lon, double lat) {
        map.setEpicenter(lon, lat);
    }

    public void setEpicenter(Point2D.Double e) {
        map.setEpicenter(e.x, e.y);
    }

    public void setDefaultRegion(Rectangle2D.Double r) {
        this.defaultRegion = r;
    }

    public void setEpicenterAndZoomTo(double lon, double lat) {
        map.setEpicenter(lon, lat);
        map.zoomTo(lon - 10.0, lon + 10.0, lat - 10.0, lat + 10.0);
    }

    public void setEpicenterAndZoomTo(Point2D.Double e) {
        map.setEpicenter(e.x, e.y);
        map.zoomTo(e.x - 10.0, e.x + 10.0, e.y - 10.0, e.y + 10.0);
    }

    public void zoomIn() {
        map.zoomIn();
    }

    public void zoomOut() {
        map.zoomOut();
    }

    public void zoom(int z) {
        map.zoom(z);
    }

    public void zoomToFull() {
        map.zoomToFull();
    }

    public void zoomTo(double minLon, double maxLon, double minLat, double maxLat) {
        map.zoomTo(minLon, maxLon, minLat, maxLat);
    }

    public void zoomTo(Rectangle2D.Double r) {
        map.zoomTo(r.x, r.x + r.width, r.y, r.y + r.height);
    }

    public void zoomTo(Range2D range) {
        map.zoomTo(range.x, range.x + range.w, range.y, range.y + range.h);
    }

    public void zoomTo(double lon, double lat) {
        map.zoomTo(lon, lat);
    }

    public void zoomTo(Point2D.Double Pt) {
        map.zoomTo(Pt.x, Pt.y);
    }

    public void setMaxZoomLevel(int zl) {
        map.setMaxZoomLevel(zl);
    }

    public int getMaxZoomLevel() {
        return map.getMaxZoomLevel();
    }

    public void setMinZoomLevel(int zl) {
        map.setMinZoomLevel(zl);
    }

    public int getMinZoomLevel() {
        return map.getMinZoomLevel();
    }

    public void setMagnitude(double mag) {
        this.totalMagnitude = mag;
        this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
    }

    public double getMagnitude() {
        return this.totalMagnitude;
    }

    public static SourceCombo getRecommendedSourceCombo(double magnitude, double longitude, double latitude) {
        propdb.setUnitSources(map.getSources());
        return propdb.getSeismicInversion(magnitude, longitude, latitude);
    }

    public static SourceCombo getRecommendedSourceCombo(SeismicEvent se) {
        return EventEditor2.getRecommendedSourceCombo(se.getMagnitude(), se.getLongitude(), se.getLatitude());
    }

    public SourceCombo getSourceComboFromString(String linearComb) {
        return propdb.getSourceCombo(linearComb);
    }

    public void showEventDialog() {
        NewEventDialog ned = new NewEventDialog(new Frame(), true, null);
        ned.setLocationRelativeTo(this);
        SeismicEvent se = ned.showDialog();
        if (se != null) {
            this.setActive(EventEditor2.getRecommendedSourceCombo(se.getMagnitude(), se.getLongitude(), se.getLatitude()));
            map.setEpicenter(se.getLongitude(), se.getLatitude());
            map.plotMarkOn();
            this.jumpTo("to Selected");
        }
    }

    public SourceCombo setEvent(SeismicEvent se) {
        SourceCombo sc;
        double lat = se.getLatitude();
        double lon = se.getLongitude();
        ArrayList<SourceScenario> scenarios = se.getScenarioList();
        if (!scenarios.isEmpty()) {
            this.setActive(scenarios.get(0).getSourceNamesAndSlips());
            sc = this.getActiveSourceCombo();
            this.totalMagnitude = sc.getMomentMagnitude();
        } else {
            sc = EventEditor2.getRecommendedSourceCombo(se.getMagnitude(), lon, lat);
            this.setActive(sc);
            this.totalMagnitude = se.getMagnitude();
        }
        this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        map.setEpicenter(lon, lat);
        this.plotMark(true);
        double x = lon - 15.0;
        double width = 30.0;
        double y = lat - 15.0;
        double height = 30.0;
        Rectangle2D.Double re = new Rectangle2D.Double(x, y, width, height);
        this.setDefaultRegion(re);
        return sc;
    }

    public void plotMark(boolean b) {
        if (b) {
            map.plotMarkOn();
        } else {
            map.plotMarkOff();
        }
        this.repaintMap();
    }

    public void setMark(int m) {
        map.setMark(m);
        this.repaintMap();
    }

    public void setMarkSize(double s) {
        map.setMarkSize(s);
        this.repaintMap();
    }

    public void setMarkColor(Color c) {
        map.setMarkColor(c);
        this.repaintMap();
    }

    public void setBoxColor(Color c) {
        map.setBoxesColor(c);
        this.repaintMap();
    }

    public void setGridA(Point2D.Double[] Pts, String sn) {
        map.setGridA(Pts, sn);
    }

    public void setGridB(Point2D.Double[] Pts, String sn) {
        map.setGridB(Pts, sn);
    }

    public void setGridC(Point2D.Double[] Pts, String sn) {
        map.setGridC(Pts, sn);
    }

    public void setBackgroundBrightness(float scale, float offset) {
        map.setBackgroundBrightness(scale, offset);
        this.repaintMap();
    }

    public void setModeSingle() {
        if (this.selectMode == 0) {
            return;
        }
        this.selectMode = 0;
        if (this.sourceComboSingle != null && this.sourceComboMulti != null) {
            this.tableModel.setSourceCombo(this.sourceComboSingle);
            map.setActive(this.sourceComboSingle);
            this.totalMagnitude = this.tableModel.getMomentMagnitude();
            this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        }
        this.addDelButton.setEnabled(false);
        map.setMode(0);
        this.repaintMap();
    }

    public void setModeMulti() {
        if (this.selectMode == 1) {
            return;
        }
        if (this.sourceComboMulti != null && this.sourceComboSingle != null) {
            this.selectMode = 1;
            this.tableModel.setSourceCombo(this.sourceComboMulti);
            map.setActive(this.sourceComboMulti);
            this.totalMagnitude = this.tableModel.getMomentMagnitude();
            this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        }
        this.addDelButton.setEnabled(true);
        map.setMode(1);
        this.repaintMap();
    }

    public void setModeNone() {
        this.selectMode = 3;
        this.addDelButton.setEnabled(false);
        map.setMode(3);
        this.repaintMap();
    }

    public void drawSources(boolean b) {
        map.drawSources(b);
    }

    public void addLandMass(File f, int zoomLimit) throws IOException {
        map.addLandMass(f, zoomLimit);
    }

    public void plotLandMass(boolean b) {
        map.plotLandMass(b);
    }

    public void setLandMass(URL url) {
        map.setLandMass(url);
    }

    public void removeLandMass() {
        map.removeLandMass();
    }

    public void plotGraticules(boolean b) {
        map.showGraticules(b);
    }

    public void fillContinents(boolean b) {
        map.fillContinents(b);
    }

    public void setBorders(URL url) {
        map.setBorders(url);
        map.plotBorders(true);
    }

    public void plotBorders(boolean b) {
        map.plotBorders(b);
    }

    public void removeBorders() {
        map.removeBorders();
    }

    public static double distanceBetween(double lat1, double lon1, double lat2, double lon2) {
        double dist = 0.0;
        double D2R = Math.PI / 180;
        double Re = 6371.22;
        double theta = Math.sin(lat1 * D2R) * Math.sin(lat2 * D2R) + Math.cos(lat1 * D2R) * Math.cos(lat2 * D2R) * Math.cos((lon1 - lon2) * D2R);
        dist = Re * (theta = Math.acos(theta));
        if (dist < 0.1) {
            double deltaLon = lon2 - lon1;
            theta = Math.atan2(Math.sqrt(Math.pow(Math.cos(lat2 * D2R) * Math.sin(deltaLon * D2R), 2.0) + Math.cos(lat1 * D2R) * Math.cos(lat2 * D2R) * Math.pow(Math.sin(deltaLon * D2R / 2.0), 2.0)), Math.sin(lat1 * D2R) * Math.sin(lat2 * D2R) + Math.cos(lat1 * D2R) * Math.cos(lat2 * D2R) * Math.cos(deltaLon * D2R));
            dist = Re * theta;
        }
        return dist;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateAT(e.getActionCommand());
    }

    public void updateAT(String sn) {
        UnitSource clickedSource = propdb.getUnitSource(sn);
        if (this.editMode == 0) {
            clickedSource.setMagnitude(this.totalMagnitude);
        }
        if (clickedSource.isActive()) {
            int ret;
            Point2D.Double centroid = this.tableModel.getSourceCombo().getCentroid();
            if (centroid.x != 0.0 && EventEditor2.distanceBetween(centroid.y, centroid.x, clickedSource.getLatitude(), clickedSource.getLongitude()) > 1500.0 && (ret = JOptionPane.showConfirmDialog(this, "Selected fault: " + clickedSource.getName() + "\nis more than 1500 km away from others, use anyway?", "Adding distant fault", 0, 2)) != 0) {
                clickedSource.setActive(false);
                map.repaint();
                return;
            }
            if (this.selectMode == 0) {
                this.tableModel.clear();
            }
            this.tableModel.addSource(clickedSource);
            int idx = this.tableModel.getRow(sn);
            this.jTable1.setRowSelectionInterval(idx, idx);
        } else {
            this.jTable1.clearSelection();
            this.tableModel.deleteSource(sn);
        }
        if (this.editMode == 0) {
            this.tableModel.getSourceCombo().setMomentMagnitude(this.totalMagnitude);
        } else {
            this.totalMagnitude = this.tableModel.getMomentMagnitude();
            this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    private void fireActionPerformed() {
        log.info("firing action performed, sources changed");
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = "sources changed";
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        if (this.totalMagnitude == this.tableModel.getMomentMagnitude()) {
            this.fireActionPerformed();
        } else {
            this.totalMagnitude = this.tableModel.getMomentMagnitude();
            this.magFormattedTextField.setValue(new Double(this.totalMagnitude));
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
    }

    public void destroy() {
        map.destroy();
        map = null;
    }

    public void repaintMap() {
        map.repaint();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        log.info("setting table sourceCombo total magnitude");
        try {
            this.magFormattedTextField.commitEdit();
            this.tableModel.getSourceCombo().setMomentMagnitude(this.totalMagnitude);
            this.tableModel.fireTableDataChanged();
        }
        catch (ParseException ex) {
            log.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int[] rows = this.jTable1.getSelectedRows();
        this.clearHighlightedSources();
        for (int i = 0; i < rows.length; ++i) {
            String sn = (String)this.tableModel.getValueAt(rows[i], 0);
            UnitSource us = this.getSourceFromName(sn);
            if (us == null) continue;
            us.setHighlight(true);
        }
        map.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("EventEditor");
                f.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                DEBUG = true;
                EventEditor2 myee = new EventEditor2();
                myee.setLoggerConfigurationLocal();
                try {
                    File testFile = new File("/Volumes/big/Users/cmoore/Library/TsuCAT/etc/gshhs_h.nc");
                    testFile = new File("/Volumes/big/Users/cmoore/Library/TsuCAT/etc/gshhs_c.nc");
                    myee.addLandMass(testFile, 1);
                    myee.plotLandMass(true);
                    testFile = new File("/Volumes/big/Users/cmoore/Library/TsuCAT/etc/wdb_borders_i.b");
                    myee.setBorders(testFile.toURI().toURL());
                    testFile = new File("/Volumes/big/Users/cmoore/Library/TsuCAT/etc/countryReducedAKandHI.kml");
                    CountryBoundaries.loadCountries(testFile);
                }
                catch (IOException ioe) {
                    log.log(Level.WARNING, "Can't load land mass files", ioe);
                }
                if (myee.addShape(CountryBoundaries.getCountryOutline("Canada"), Color.PINK)) {
                    myee.plotShapes(true);
                }
                myee.plotGraticules(true);
                myee.drawSources(true);
                ArrayList<String> dblocs = new ArrayList<String>();
                dblocs.add("/Volumes/big/Users/cmoore/Library/TsuCAT/etc");
                try {
                    myee.setDatabaseLocations(dblocs, true);
                }
                catch (IOException ex) {
                    Logger.getLogger(EventEditor2.class.getName()).log(Level.SEVERE, "can't load Unit Sources", ex);
                }
                SeismicEvent se = new SeismicEvent(9.0, 234.88, 45.73);
                f.getContentPane().add("Center", myee);
                f.setBounds(200, 200, 1000, 800);
                f.setVisible(true);
                myee.setActive("8.9*ac57a+8.9*ac57b+8.9*ac58a+8.9*ac58b+8.9*ac59a+8.9*ac59b+8.9*ac60a+8.9*ac60b+8.9*ac61a+8.9*ac61b+8.9*ac62a+8.9*ac62b+8.9*ac63a+8.9*ac63b+8.9*ac64a+8.9*ac64b+8.9*ac65a+8.9*ac65b");
                myee.setEpicenter(se.getLongitude(), se.getLatitude());
                myee.plotMark(true);
                double x = se.getLongitude() - 30.0;
                double width = 60.0;
                double y = se.getLatitude() - 15.0;
                double height = 30.0;
                Rectangle2D.Double re = new Rectangle2D.Double(x, y, width, height);
                myee.setDefaultRegion(re);
                myee.zoomTo(x, x + width, y, y + height);
                myee.setModeMulti();
                myee.setEditMode(1);
                myee.plotPlaces(true);
            }
        });
    }

    static {
        propdb = PropagationDatabase.getInstance();
        NumberFormat magFor = NumberFormat.getNumberInstance();
        magFor.setMaximumFractionDigits(1);
        magFor.setMinimumFractionDigits(1);
        magFor.setMinimumIntegerDigits(0);
        NumberFormat magForEdit = NumberFormat.getNumberInstance();
        magForEdit.setMaximumFractionDigits(4);
        magForEdit.setMinimumFractionDigits(4);
        magForEdit.setMinimumIntegerDigits(0);
        magFormat = new NumberFormatter(magFor);
        magFormat.setCommitsOnValidEdit(true);
        magFormat.setAllowsInvalid(false);
        magFormatEdit = new NumberFormatter(magForEdit);
        magFormatEdit.setCommitsOnValidEdit(false);
        magFormatEdit.setAllowsInvalid(false);
    }

    static class Number2DRenderer
    extends DefaultTableCellRenderer {
        DecimalFormat df = new DecimalFormat("0.000");

        public Number2DRenderer() {
            this.setHorizontalAlignment(10);
        }

        @Override
        public void setValue(Object value) {
            this.setText(value == null ? "" : this.df.format(value));
        }
    }
}

