/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Fault
implements Shape {
    private String name = "";
    private String nameZone = "";
    private String nameLetter = "";
    private int nameNumber = 0;
    private String filename = "";
    private double longitude = 0.0;
    private double latitude = 0.0;
    private double distanceFromSource = 0.0;
    private double strike = 0.0;
    private double dip = 0.0;
    private double rake = 0.0;
    private double depth = 0.0;
    private double slip = 0.0;
    private double length = 0.0;
    private double width = 0.0;
    private double[] X = new double[4];
    private double[] Y = new double[4];
    private double[] Z = new double[4];
    private Rectangle bounds;
    public float[] points = new float[8];
    double D2R = Math.PI / 180;
    double KM2D = 111.195;

    public Fault() {
    }

    public Fault(String sn, String fn, double lon, double lat, double sl, double st, double di, double de, double le, double wi, double ra) {
        this.parseName(sn);
        this.filename = fn;
        this.longitude = lon;
        this.latitude = lat;
        this.slip = sl;
        this.strike = st;
        this.dip = di;
        this.depth = de;
        this.length = le;
        this.width = wi;
        this.rake = ra;
        this.createBoxOutline();
    }

    public Fault clone() {
        Fault f = new Fault(this.name, this.filename, this.longitude, this.latitude, this.slip, this.strike, this.dip, this.depth, this.length, this.width, this.rake);
        return f;
    }

    private void parseName(String sn) {
        this.name = sn.contains("sz") ? sn.substring(0, 2) + sn.substring(5, sn.length()) + sn.charAt(4) : sn;
        if (this.name.length() < 4) {
            return;
        }
        this.nameZone = this.name.substring(0, 2);
        this.nameLetter = this.name.substring(this.name.length() - 1);
        try {
            this.nameNumber = Integer.parseInt(this.name.replaceAll(this.nameZone, "").replaceAll(this.nameLetter, ""));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setDistanceFromSource(double d) {
        this.distanceFromSource = d;
    }

    public double getDistanceFromSource() {
        return this.distanceFromSource;
    }

    private boolean pointInPoly(double[] vx, double[] vy, double ptx, double pty) {
        int npts = vx.length;
        boolean inside = false;
        int i = 0;
        int j = npts - 1;
        while (i < npts) {
            if (vy[i] > pty != vy[j] > pty && ptx < (vx[j] - vx[i]) * (pty - vy[i]) / (vy[j] - vy[i]) + vx[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public boolean isInside(double lon, double lat) {
        return this.pointInPoly(this.X, this.Y, lon, lat);
    }

    private void createBoxOutline() {
        double tempDip = this.dip;
        double projWidth = this.getWidth() * Math.cos(tempDip * this.D2R);
        double dipDepth = this.getDepth() + this.getWidth() * Math.sin(this.dip * this.D2R);
        double halfLength = this.getLength() / 2.0;
        double angle = (270.0 - this.strike) * this.D2R;
        double[] Pt = this.rotatePoint(halfLength, 0.0, angle);
        Pt = this.kmToDegrees(Pt);
        this.X[0] = Pt[0];
        this.Y[0] = Pt[1];
        this.Z[0] = dipDepth;
        Pt = this.rotatePoint(halfLength, -projWidth, angle);
        Pt = this.kmToDegrees(Pt);
        this.X[3] = Pt[0];
        this.Y[3] = Pt[1];
        this.Z[3] = this.getDepth();
        Pt = this.rotatePoint(-halfLength, -projWidth, angle);
        Pt = this.kmToDegrees(Pt);
        this.X[2] = Pt[0];
        this.Y[2] = Pt[1];
        this.Z[2] = this.getDepth();
        Pt = this.rotatePoint(-halfLength, 0.0, angle);
        Pt = this.kmToDegrees(Pt);
        this.X[1] = Pt[0];
        this.Y[1] = Pt[1];
        this.Z[1] = dipDepth;
        for (int i = 0; i < 4; ++i) {
            this.points[i * 2] = (float)this.X[i];
            this.points[i * 2 + 1] = (float)this.Y[i];
        }
    }

    private double[] rotatePoint(double x, double y, double angle) {
        double[] Pt = new double[]{x * Math.cos(angle) - y * Math.sin(angle), x * Math.sin(angle) + y * Math.cos(angle)};
        return Pt;
    }

    private double[] kmToDegrees(double[] pt) {
        double[] pt2 = new double[]{this.longitude + pt[0] / (Math.cos(this.latitude * this.D2R) * this.KM2D), this.latitude + pt[1] / this.KM2D};
        return pt2;
    }

    public String toString() {
        return "name: " + this.getName() + " lon: " + this.getLongitude() + " lat: " + this.getLatitude() + " depth: " + this.getDepth() + " lenth: " + this.getLength() + " width: " + this.getWidth() + " slip:" + this.getSlip() + " strike:" + this.getStrike() + " dip: " + this.getDip() + " rake:" + this.getRake();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getNameZone() {
        return this.nameZone;
    }

    public String getNameLetter() {
        return this.nameLetter;
    }

    public int getNameNumber() {
        return this.nameNumber;
    }

    public boolean isOuterRise() {
        return this.nameLetter.equals("c") || this.nameLetter.equals("d");
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String f) {
        this.filename = f;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double l) {
        this.longitude = l;
        this.createBoxOutline();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double l) {
        this.latitude = l;
        this.createBoxOutline();
    }

    public double getCenterLongitude() {
        return (this.X[0] + this.X[1] + this.X[2] + this.X[3]) / 4.0;
    }

    public double getCenterLatitude() {
        return (this.Y[0] + this.Y[1] + this.Y[2] + this.Y[3]) / 4.0;
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double d) {
        this.depth = d;
        this.createBoxOutline();
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double l) {
        this.length = l;
        this.createBoxOutline();
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double w) {
        this.width = w;
        this.createBoxOutline();
    }

    public double getSlip() {
        return this.slip;
    }

    public void setSlip(double s) {
        this.slip = s;
        this.createBoxOutline();
    }

    public double getStrike() {
        return this.strike;
    }

    public void setStrike(double s) {
        this.strike = s;
        this.createBoxOutline();
    }

    public double getDip() {
        return this.dip;
    }

    public void setDip(double d) {
        this.dip = d;
        this.createBoxOutline();
    }

    public double getRake() {
        return this.rake;
    }

    public void setRake(double r) {
        this.rake = r;
        this.createBoxOutline();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public boolean crossPositive(float x_a, float y_a, float x_b, float y_b, double x_d, double y_d) {
        return (x_d - (double)x_a) * (double)(y_b - y_a) - (y_d - (double)y_a) * (double)(x_b - x_a) > 0.0;
    }

    public boolean contains2(double x, double y) {
        if (this.crossPositive(this.points[0], this.points[1], this.points[2], this.points[3], x, y)) {
            return false;
        }
        if (this.crossPositive(this.points[2], this.points[3], this.points[4], this.points[5], x, y)) {
            return false;
        }
        if (this.crossPositive(this.points[4], this.points[5], this.points[6], this.points[7], x, y)) {
            return false;
        }
        return !this.crossPositive(this.points[6], this.points[7], this.points[0], this.points[1], x, y);
    }

    @Override
    public boolean contains(double ptx, double pty) {
        int npts = 4;
        boolean inside = false;
        int i = 0;
        int j = npts - 1;
        while (i < npts) {
            if ((double)this.points[i * 2 + 1] > pty != (double)this.points[j * 2 + 1] > pty && ptx < (double)(this.points[j * 2] - this.points[i * 2]) * (pty - (double)this.points[i * 2 + 1]) / (double)(this.points[j * 2 + 1] - this.points[i * 2 + 1]) + (double)this.points[i * 2]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new FaultPathIterator(this, at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    class FaultPathIterator
    implements PathIterator {
        Fault aSource;
        AffineTransform transform;
        int index;

        public FaultPathIterator(Fault s, AffineTransform at) {
            this.aSource = s;
            this.transform = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > 4;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= 4) {
                return 4;
            }
            coords[0] = this.aSource.points[this.index * 2];
            coords[1] = this.aSource.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= 4) {
                return 4;
            }
            coords[0] = this.aSource.points[this.index * 2];
            coords[1] = this.aSource.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

