/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.LandMass;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class GSHHSReader {
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    static int count_polygons = 0;
    static int count_points = 0;
    static int nbytes;
    static int npoints;
    static int id;
    static int flag;
    static int level;
    static int greenwich;
    static int mag_p;
    static int west;
    static int east;
    static int north;
    static int south;
    static int container;
    static int ancestor;
    static double lon;
    static double lat;
    static double area;
    static double area_full;
    static double min_area;
    static byte[] header;
    static byte[] points;
    static InputStream fis;
    static ArrayList<LandMass> masses;
    static LandMass lm;
    static ArrayList<Double> extraLons;
    static ArrayList<Double> extraLats;
    static DecimalFormat df;
    static ByteBuffer wrapped;
    private static Shape extents;
    private static boolean useExtents;
    private static int maxLevel;

    public ArrayList<Point2D> readItMatlab(File f) {
        ArrayList<Point2D> ret = new ArrayList<Point2D>();
        float[] coords = new float[2];
        int type = 0;
        try {
            ArrayList<Area> arr = GSHHSReader.getAreas(f);
            for (Area p : arr) {
                PathIterator it = p.getPathIterator(null);
                while (!it.isDone()) {
                    type = it.currentSegment(coords);
                    if (type == 0) {
                        ret.add(new Point2D.Float(Float.NaN, Float.NaN));
                    }
                    ret.add(new Point2D.Float(coords[0], coords[1]));
                    it.next();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }

    public ArrayList<Point2D> readItMatlabBordersRivers(File f) {
        ArrayList<Point2D> ret = new ArrayList<Point2D>();
        float[] coords = new float[2];
        int type = 0;
        try {
            ArrayList<Path2D> arr = GSHHSReader.readIt(f);
            for (Path2D p : arr) {
                PathIterator it = p.getPathIterator(null);
                while (!it.isDone()) {
                    type = it.currentSegment(coords);
                    if (type == 0) {
                        ret.add(new Point2D.Float(Float.NaN, Float.NaN));
                    }
                    ret.add(new Point2D.Float(coords[0], coords[1]));
                    it.next();
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return ret;
    }

    public static void setExtents(double minLon, double maxLon, double minLat, double maxLat) {
        extents = new Rectangle2D.Double(minLon, minLat, maxLon - minLon, maxLat - minLat);
    }

    public static void useExtents(boolean b) {
        useExtents = b;
    }

    public static ArrayList<Path2D> readIt(File f, Shape s) throws IOException {
        extents = s;
        return GSHHSReader.readIt(f);
    }

    public static void setMaxLevel(int lev) {
        maxLevel = lev;
    }

    public static void setMinArea(double a) {
        min_area = a;
    }

    public static ArrayList<Path2D> readIt(File f) throws IOException {
        ArrayList<Path2D> paths = new ArrayList<Path2D>();
        try (FileInputStream fis = new FileInputStream(f);){
            while (44 == fis.read(header)) {
                wrapped = ByteBuffer.wrap(header);
                id = wrapped.getInt();
                npoints = wrapped.getInt();
                flag = wrapped.getInt();
                mag_p = flag >> 26;
                west = wrapped.getInt();
                east = wrapped.getInt();
                south = wrapped.getInt();
                north = wrapped.getInt();
                area = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                area_full = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                level = flag & 0xFF;
                greenwich = flag >> 16 & 1;
                nbytes = 8 * npoints;
                points = new byte[nbytes];
                if (nbytes != fis.read(points)) {
                    throw new IOException("Could not read the required bytes.");
                }
                if (level > maxLevel || npoints < 2 || area_full > 0.0 && area_full < min_area) continue;
                Path2D.Float path = new Path2D.Float();
                extraLons = new ArrayList();
                extraLats = new ArrayList();
                boolean firstpt = true;
                for (int pt = 0; pt < npoints; ++pt) {
                    lon = (double)GSHHSReader.fromByteArray(points, 8 * pt) / 1000000.0;
                    lat = (double)GSHHSReader.fromByteArray(points, 4 + 8 * pt) / 1000000.0;
                    double d = lon = lon < 0.0 ? lon + 360.0 : lon;
                    if (useExtents && !extents.contains(lon, lat)) {
                        firstpt = true;
                        continue;
                    }
                    if (greenwich == 1 && lon > 200.0) {
                        extraLons.add(lon);
                        extraLats.add(lat);
                        lon -= 360.0;
                    }
                    if (firstpt) {
                        path.moveTo(lon, lat);
                        firstpt = false;
                        continue;
                    }
                    path.lineTo(lon, lat);
                }
                float[] coords = new float[2];
                if (path.contains(180.0, 71.2)) {
                    firstpt = true;
                    Path2D.Float npath = new Path2D.Float();
                    PathIterator it = path.getPathIterator(null);
                    while (!it.isDone()) {
                        it.currentSegment(coords);
                        if ((double)coords[1] > 68.0) {
                            if (firstpt) {
                                npath.moveTo(coords[0], coords[1]);
                                firstpt = false;
                            } else {
                                npath.lineTo(coords[0], coords[1]);
                            }
                        }
                        it.next();
                    }
                    npath.closePath();
                    path = npath;
                }
                paths.add(path);
                if (extraLons.size() <= 3) continue;
                path = new Path2D.Float();
                path.moveTo(extraLons.get(0), extraLats.get(0));
                for (int i = 1; i < extraLons.size(); ++i) {
                    path.lineTo(extraLons.get(i), extraLats.get(i));
                }
                paths.add(path);
            }
            fis.close();
        }
        return paths;
    }

    public static ArrayList<Area> getAreas(File f, double minLon, double maxLon, double minLat, double maxLat) throws IOException {
        double tmp;
        if (minLon > maxLon) {
            tmp = maxLon;
            maxLon = minLon;
            minLon = tmp;
        }
        if (minLat > maxLat) {
            tmp = maxLat;
            maxLat = minLat;
            minLat = tmp;
        }
        extents = new Rectangle2D.Double(minLon, minLat, maxLon - minLon, maxLat - minLat);
        return GSHHSReader.getAreas(f);
    }

    public static ArrayList<Area> getAreas(File f, Rectangle2D rec) throws IOException {
        extents = rec;
        return GSHHSReader.getAreas(f);
    }

    public static ArrayList<Area> getAreas(File f) throws IOException {
        ArrayList<Area> areas = new ArrayList<Area>();
        Area extentsArea = new Area(extents);
        try (FileInputStream fis = new FileInputStream(f);){
            while (44 == fis.read(header)) {
                wrapped = ByteBuffer.wrap(header);
                id = wrapped.getInt();
                npoints = wrapped.getInt();
                flag = wrapped.getInt();
                mag_p = flag >> 26;
                west = wrapped.getInt();
                east = wrapped.getInt();
                south = wrapped.getInt();
                north = wrapped.getInt();
                area = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                area_full = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                level = flag & 0xFF;
                greenwich = flag >> 16 & 1;
                nbytes = 8 * npoints;
                points = new byte[nbytes];
                if (nbytes != fis.read(points)) {
                    throw new IOException("Could not read the required bytes.");
                }
                if (level > maxLevel || npoints < 2 || area_full > 0.0 && area_full < min_area) continue;
                Area area = new Area();
                Path2D.Float path = new Path2D.Float();
                extraLons = new ArrayList();
                extraLats = new ArrayList();
                boolean firstpt = true;
                for (int pt = 0; pt < npoints; ++pt) {
                    lon = (double)GSHHSReader.fromByteArray(points, 8 * pt) / 1000000.0;
                    lat = (double)GSHHSReader.fromByteArray(points, 4 + 8 * pt) / 1000000.0;
                    double d = lon = lon < 0.0 ? lon + 360.0 : lon;
                    if (greenwich == 1 && lon > 200.0) {
                        extraLons.add(lon);
                        extraLats.add(lat);
                        lon -= 360.0;
                    }
                    if (firstpt) {
                        path.moveTo(lon, lat);
                        firstpt = false;
                        continue;
                    }
                    path.lineTo(lon, lat);
                }
                if (area_full != 0.0) {
                    path.closePath();
                }
                float[] coords = new float[2];
                if (path.contains(180.0, 71.2)) {
                    firstpt = true;
                    Path2D.Float npath = new Path2D.Float();
                    PathIterator it = path.getPathIterator(null);
                    while (!it.isDone()) {
                        it.currentSegment(coords);
                        if ((double)coords[1] > 68.0) {
                            if (firstpt) {
                                npath.moveTo(coords[0], coords[1]);
                                firstpt = false;
                            } else {
                                npath.lineTo(coords[0], coords[1]);
                            }
                        }
                        it.next();
                    }
                    npath.closePath();
                    path = npath;
                }
                area = new Area(path);
                if (useExtents) {
                    area.intersect(extentsArea);
                }
                areas.add(area);
                if (extraLons.size() <= 3) continue;
                path = new Path2D.Float();
                path.moveTo(extraLons.get(0), extraLats.get(0));
                for (int i = 1; i < extraLons.size(); ++i) {
                    path.lineTo(extraLons.get(i), extraLats.get(i));
                }
                area = new Area(path);
                area.intersect(extentsArea);
                areas.add(area);
            }
            fis.close();
        }
        return areas;
    }

    public static ArrayList<Area> tileAreas(ArrayList<Area> areas) {
        ArrayList<Area> tiledAreas = new ArrayList<Area>();
        for (float x = 0.0f; x < 375.0f; x += 15.0f) {
            for (float y = -90.0f; y <= 85.0f; y += 15.0f) {
                Rectangle2D.Float rec = new Rectangle2D.Float(x, y, 15.0f, 15.0f);
                Area recArea = null;
                for (Area a : areas) {
                    if (!a.intersects(rec)) continue;
                    if (recArea == null) {
                        recArea = new Area(rec);
                        recArea.intersect(a);
                        continue;
                    }
                    Area ra = new Area(rec);
                    ra.intersect(a);
                    recArea.add(ra);
                }
                if (recArea == null) continue;
                tiledAreas.add(recArea);
            }
        }
        return tiledAreas;
    }

    public static ArrayList<Area> getTileAreas(URI uri) throws IOException {
        NetcdfFile nc = NetcdfFile.openInMemory(uri);
        return GSHHSReader.getTileAreas(nc);
    }

    public static ArrayList<Area> getTileAreas(File f) throws IOException {
        NetcdfFile nc = NetcdfFile.open(f.getPath());
        return GSHHSReader.getTileAreas(nc);
    }

    public static ArrayList<Area> getTileAreas(NetcdfFile nc) throws IOException {
        ArrayList<Area> areas = new ArrayList<Area>();
        Variable segVar = nc.findVariable("nsegs");
        Variable latVar = nc.findVariable("lat");
        Variable lonVar = nc.findVariable("lon");
        int[] nsegs = (int[])segVar.read().copyTo1DJavaArray();
        float[] lats = (float[])latVar.read().copyTo1DJavaArray();
        float[] lons = (float[])lonVar.read().copyTo1DJavaArray();
        int cnt = 0;
        for (int i = 0; i < nsegs.length; ++i) {
            Path2D.Float p = new Path2D.Float();
            p.moveTo(lons[cnt], lats[cnt]);
            ++cnt;
            for (int j = 1; j < nsegs[i]; ++j) {
                p.lineTo(lons[cnt], lats[cnt]);
                ++cnt;
            }
            areas.add(new Area(p));
        }
        return areas;
    }

    public static ArrayList<LandMass> getBorders(String fn) {
        ArrayList<LandMass> bmasses = new ArrayList<LandMass>();
        try (NetcdfFile nc = NetcdfFile.open(fn);){
            Variable segVar = nc.findVariable("nsegs");
            Variable latVar = nc.findVariable("lat");
            Variable lonVar = nc.findVariable("lon");
            int[] nsegs = (int[])segVar.read().copyTo1DJavaArray();
            float[] lats = (float[])latVar.read().copyTo1DJavaArray();
            float[] lons = (float[])lonVar.read().copyTo1DJavaArray();
            int cnt = 0;
            for (int i = 0; i < nsegs.length; ++i) {
                LandMass mass = new LandMass();
                mass.setBorders();
                mass.add_lonlat(lons[cnt], lats[cnt]);
                ++cnt;
                for (int j = 1; j < nsegs[i]; ++j) {
                    mass.add_lonlat(lons[cnt], lats[cnt]);
                    ++cnt;
                }
                bmasses.add(mass);
            }
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Can't read borders netcdf file", ioe);
        }
        return bmasses;
    }

    public static ArrayList<LandMass> getBorders(URL url) {
        ArrayList<LandMass> bmasses = new ArrayList<LandMass>();
        try (NetcdfFile nc = NetcdfFile.openInMemory(url.toURI());){
            Variable segVar = nc.findVariable("nsegs");
            Variable latVar = nc.findVariable("lat");
            Variable lonVar = nc.findVariable("lon");
            int[] nsegs = (int[])segVar.read().copyTo1DJavaArray();
            float[] lats = (float[])latVar.read().copyTo1DJavaArray();
            float[] lons = (float[])lonVar.read().copyTo1DJavaArray();
            int cnt = 0;
            for (int i = 0; i < nsegs.length; ++i) {
                LandMass mass = new LandMass();
                mass.setBorders();
                mass.add_lonlat(lons[cnt], lats[cnt]);
                ++cnt;
                for (int j = 1; j < nsegs[i]; ++j) {
                    mass.add_lonlat(lons[cnt], lats[cnt]);
                    ++cnt;
                }
                bmasses.add(mass);
            }
        }
        catch (IOException | URISyntaxException ioe) {
            log.log(Level.WARNING, "Can't read borders netcdf file", ioe);
        }
        return bmasses;
    }

    public static ArrayList<LandMass> readIt(URL url, boolean borders) {
        masses = new ArrayList();
        count_polygons = 0;
        count_points = 0;
        try {
            fis = url.openStream();
            while (44 == fis.read(header)) {
                wrapped = ByteBuffer.wrap(header);
                id = wrapped.getInt();
                npoints = wrapped.getInt();
                flag = wrapped.getInt();
                mag_p = flag >> 26;
                west = wrapped.getInt();
                east = wrapped.getInt();
                south = wrapped.getInt();
                north = wrapped.getInt();
                area = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                area_full = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                level = flag & 0xFF;
                greenwich = flag >> 16 & 1;
                nbytes = 8 * npoints;
                points = new byte[nbytes];
                if (nbytes != fis.read(points)) {
                    throw new IOException("Could not read the required bytes.");
                }
                if (borders ? level > 1 : level > 1 || area_full < 2.4) continue;
                ++count_polygons;
                count_points += npoints;
                lm = new LandMass(npoints);
                if (borders) {
                    lm.setBorders();
                }
                extraLons = new ArrayList();
                extraLats = new ArrayList();
                for (int pt = 0; pt < npoints; ++pt) {
                    lon = (double)GSHHSReader.fromByteArray(points, 8 * pt) / 1000000.0;
                    lat = (double)GSHHSReader.fromByteArray(points, 4 + 8 * pt) / 1000000.0;
                    double d = lon = lon < 0.0 ? lon + 360.0 : lon;
                    if (lat < -60.0) continue;
                    if (greenwich == 1 && lon > 200.0) {
                        extraLons.add(lon);
                        extraLats.add(lat);
                        lon -= 360.0;
                    }
                    lm.add_lonlat(lon, lat);
                }
                if (lm.getNumPoints() > 2) {
                    masses.add(lm);
                }
                if (extraLons.size() <= 0) continue;
                lm = new LandMass(extraLons.size());
                if (borders) {
                    lm.setBorders();
                }
                masses.add(lm);
                for (int i = 0; i < extraLons.size(); ++i) {
                    lm.add_lonlat(extraLons.get(i), extraLats.get(i));
                }
            }
            fis.close();
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Can't parse borders file", ex);
        }
        log.fine("Number of points in " + (borders ? "borders" : "coastline") + ": " + count_points + ";  Number of polys: " + count_polygons + " url: " + url.toString());
        return masses;
    }

    public static int fromByteArray(byte[] bytes, int offset) {
        return bytes[0 + offset] << 24 | (bytes[1 + offset] & 0xFF) << 16 | (bytes[2 + offset] & 0xFF) << 8 | bytes[3 + offset] & 0xFF;
    }

    static {
        min_area = 2.4;
        header = new byte[44];
        masses = new ArrayList();
        df = new DecimalFormat("###,###,###");
        extents = new Rectangle2D.Double(-180.0, -60.0, 540.0, 150.0);
        useExtents = true;
        maxLevel = 1;
    }
}

