/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.image.BufferedImage;

public class HillShade {
    private static double xPixelSizeS = 90.0;
    private static double yPixelSizeS = 90.0;
    private static double elevationS = 45.0;
    private static double azimuthS = 315.0;
    private static double nonlinContrastS = 0.0;
    private static boolean halfBrightFlatS = true;

    public static BufferedImage makeHillshade(double[][] bath, int xPixelSize, int yPixelSize) {
        return HillShade.makeHillshade(bath, xPixelSize, yPixelSize, elevationS, azimuthS, nonlinContrastS, halfBrightFlatS);
    }

    public static BufferedImage makeHillshade(double[][] bath, int xPixelSize, int yPixelSize, double elevation, double azimuth, double nonlinContrast, boolean halfBrightFlat) {
        int x;
        int y;
        int width = bath[0].length;
        int height = bath.length;
        BufferedImage bi = new BufferedImage(width, height, 2);
        double xSun = Math.sin(azimuth *= Math.PI / 180) * Math.cos(elevation *= Math.PI / 180);
        double ySun = -Math.cos(azimuth) * Math.cos(elevation);
        double zSun = Math.sin(elevation);
        for (int y2 = 1; y2 < height - 1; ++y2) {
            if (y2 % 50 == 0 && Thread.currentThread().isInterrupted()) {
                return null;
            }
            double b = bath[y2 - 1][0];
            double c = bath[y2 - 1][1];
            double e = bath[y2][0];
            double f = bath[y2][1];
            double h = bath[y2 + 1][0];
            double i = bath[y2 + 1][1];
            for (int x2 = 1; x2 < width - 1; ++x2) {
                double a = b;
                b = c;
                double d = e;
                e = f;
                double g = h;
                h = i;
                c = bath[y2 - 1][x2 + 1];
                f = bath[y2][x2 + 1];
                i = bath[y2 + 1][x2 + 1];
                double xSlope = (a + 2.0 * d + g - (c + 2.0 * f + i)) / (double)(8 * xPixelSize);
                double ySlope = (a + 2.0 * b + c - (g + 2.0 * h + i)) / (double)(8 * yPixelSize);
                int hillshade = HillShade.getShade(xSlope, ySlope, xSun, ySun, zSun, 1.0 / nonlinContrast, halfBrightFlat);
                bi.setRGB(x2, y2, HillShade.argb2int(255, hillshade, hillshade, hillshade));
            }
        }
        double[] slopes = new double[2];
        for (y = 0; y < height; y += height - 1) {
            for (x = 1; x < width - 1; ++x) {
                HillShade.getEdgeSlopeX(bath, x, y, xPixelSize, yPixelSize, slopes);
                int hillshade = HillShade.getShade(slopes[0], slopes[1], xSun, ySun, zSun, 1.0 / nonlinContrast, halfBrightFlat);
                bi.setRGB(x, y, HillShade.argb2int(255, hillshade, hillshade, hillshade));
            }
        }
        for (int x3 = 0; x3 < width; x3 += width - 1) {
            for (int y3 = 1; y3 < height - 1; ++y3) {
                HillShade.getEdgeSlopeY(bath, x3, y3, xPixelSize, yPixelSize, slopes);
                int hillshade = HillShade.getShade(slopes[0], slopes[1], xSun, ySun, zSun, 1.0 / nonlinContrast, halfBrightFlat);
                bi.setRGB(x3, y3, HillShade.argb2int(255, hillshade, hillshade, hillshade));
            }
        }
        for (y = 0; y < height; y += height - 1) {
            for (x = 0; x < width; x += width - 1) {
                HillShade.getCornerSlope(bath, x, y, xPixelSize, yPixelSize, slopes);
                int hillshade = HillShade.getShade(slopes[0], slopes[1], xSun, ySun, zSun, 1.0 / nonlinContrast, halfBrightFlat);
                bi.setRGB(x, y, HillShade.argb2int(255, hillshade, hillshade, hillshade));
            }
        }
        return bi;
    }

    private static int argb2int(int A, int R, int G, int B) {
        int val = (A & 0xFF) << 24 | (R & 0xFF) << 16 | (G & 0xFF) << 8 | B & 0xFF;
        return val;
    }

    private static void getEdgeSlopeX(double[][] bath, int x, int y, double xPixelSize, double yPixelSize, double[] slopes) {
        int y1 = y == 0 ? 1 : y - 1;
        int y2 = y == 0 ? 2 : y - 2;
        double a = bath[y][x - 1];
        double b = bath[y][x];
        double c = bath[y][x + 1];
        double d = bath[y1][x - 1];
        double e = bath[y1][x];
        double f = bath[y1][x + 1];
        double g = bath[y2][x - 1];
        double h = bath[y2][x];
        double i = bath[y2][x + 1];
        slopes[0] = (a - c) / (2.0 * xPixelSize);
        slopes[1] = (4.0 * (d + 2.0 * e + f) - 3.0 * (a + 2.0 * b + c) - (g + 2.0 * h + i)) / (8.0 * yPixelSize);
        if (y == 0) {
            slopes[1] = -slopes[1];
        }
    }

    private static void getEdgeSlopeY(double[][] bath, int x, int y, double xPixelSize, double yPixelSize, double[] slopes) {
        int x1 = x == 0 ? 1 : x - 1;
        int x2 = x == 0 ? 2 : x - 2;
        double a = bath[y - 1][x];
        double b = bath[y][x];
        double c = bath[y + 1][x];
        double d = bath[y - 1][x1];
        double e = bath[y][x1];
        double f = bath[y + 1][x1];
        double g = bath[y - 1][x2];
        double h = bath[y][x2];
        double i = bath[y + 1][x2];
        slopes[1] = (a - c) / (2.0 * yPixelSize);
        slopes[0] = (4.0 * (d + 2.0 * e + f) - 3.0 * (a + 2.0 * b + c) - (g + 2.0 * h + i)) / (8.0 * xPixelSize);
        if (x == 0) {
            slopes[0] = -slopes[0];
        }
    }

    private static void getCornerSlope(double[][] bath, int x, int y, double xPixelSize, double yPixelSize, double[] slopes) {
        int x1 = x == 0 ? 1 : x - 1;
        int x2 = x == 0 ? 2 : x - 2;
        int y1 = y == 0 ? 1 : y - 1;
        int y2 = y == 0 ? 2 : y - 2;
        double a = bath[y][x];
        double bx = bath[y][x1];
        double cx = bath[y][x2];
        double by = bath[y1][x];
        double cy = bath[y2][x];
        slopes[0] = (4.0 * bx - 3.0 * a - cx) / (2.0 * xPixelSize);
        if (x == 0) {
            slopes[0] = -slopes[0];
        }
        slopes[1] = (4.0 * by - 3.0 * a - cy) / (2.0 * yPixelSize);
        if (y == 0) {
            slopes[1] = -slopes[1];
        }
    }

    private static int getShade(double xSlope, double ySlope, double xSun, double ySun, double zSun, double invNonlinContrast, boolean halfBrightFlat) {
        boolean doNonlinContrast;
        double slopeSqr = xSlope * xSlope + ySlope * ySlope;
        double slopeFact = 1.0 / Math.sqrt(1.0 + slopeSqr);
        double xNorm = xSlope * slopeFact;
        double yNorm = ySlope * slopeFact;
        double zNorm = slopeFact;
        double hillshade = xNorm * xSun + yNorm * ySun + zNorm * zSun;
        boolean bl = doNonlinContrast = invNonlinContrast < 100000.0;
        if ((halfBrightFlat || doNonlinContrast) && hillshade > 0.0 && zSun > 1.0E-4 && zSun < 0.99999) {
            hillshade = Math.pow(hillshade, Math.log(0.5) / Math.log(zSun));
        }
        if (doNonlinContrast) {
            double sign = hillshade > 0.5 ? 2.0 : -2.0;
            double tmp = sign * (hillshade - 0.5);
            tmp = Math.log(invNonlinContrast + tmp);
            double min = Math.log(invNonlinContrast);
            double max = Math.log(invNonlinContrast + 1.0);
            tmp = (tmp - min) / (max - min);
            hillshade = 0.5 + 0.25 * tmp * sign;
            if (doNonlinContrast && !halfBrightFlat) {
                hillshade = Math.pow(hillshade, Math.log(zSun) / Math.log(0.5));
            }
        }
        return (int)(hillshade * 256.0);
    }
}

