/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import javax.swing.JFrame;
import javax.swing.JPanel;

class JRotation
extends JPanel
implements MouseMotionListener {
    private double rotation = 1.0;

    public double getRotation() {
        return this.rotation;
    }

    public JRotation() {
        this.setPreferredSize(new Dimension(100, 100));
        this.addMouseMotionListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setPaint(Color.black);
        AffineTransform t = g2.getTransform();
        g2.translate(this.getWidth() / 2, this.getHeight() / 2);
        g2.rotate(-this.rotation);
        g2.drawLine(0, 0, Math.max(this.getWidth(), this.getHeight()), 0);
        g2.setTransform(t);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int midX = this.getWidth() / 2;
        int midY = this.getHeight() / 2;
        this.rotation = x > midX ? (y > midY ? Math.PI * 2 - Math.atan((double)(y - midY) / (double)(x - midX)) : Math.atan((double)(midY - y) / (double)(x - midX))) : (y > midY ? Math.PI + Math.atan((double)(y - midY) / (double)(midX - x)) : Math.PI - Math.atan((double)(midY - y) / (double)(midX - x)));
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Test");
        final JRotation rot = new JRotation();
        f.getContentPane().add(rot);
        f.setDefaultCloseOperation(3);
        f.pack();
        f.setVisible(true);
        rot.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                System.out.println(rot.getRotation());
            }
        });
    }
}

