/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public class LandMass
implements Shape {
    public static final int EXPAND_COORDS = 500;
    public float[] points;
    public static int npoints = 100;
    private int pcount = 0;
    private boolean pointsTransformed = false;
    private Rectangle bounds;
    private boolean borders = false;

    public LandMass() {
        this.points = new float[npoints * 2];
    }

    public LandMass(int npoints) {
        LandMass.npoints = npoints;
        this.points = new float[npoints * 2];
    }

    public void add_lonlat(double lon, double lat) {
        if (this.pcount >= npoints) {
            this.points = LandMass.expandCoords(this.points);
            System.gc();
        }
        this.points[this.pcount * 2] = (float)lon;
        this.points[this.pcount * 2 + 1] = (float)lat;
        ++this.pcount;
    }

    public void setBorders() {
        this.borders = true;
    }

    private static float[] expandCoords(float[] oldCoords) {
        npoints = oldCoords.length + 500;
        return Arrays.copyOf(oldCoords, npoints * 2);
    }

    public int getNumPoints() {
        return this.pcount;
    }

    public void transformPoints(AffineTransform at) {
        if (this.pointsTransformed) {
            return;
        }
        at.transform(this.points, 0, this.points, 0, this.pcount);
        this.updateBounds();
        this.pointsTransformed = true;
    }

    private void updateBounds() {
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        for (int i = 0; i < this.pcount; ++i) {
            xMin = Math.min(xMin, this.points[i * 2]);
            xMax = Math.max(xMax, this.points[i * 2]);
            yMin = Math.min(yMin, this.points[i * 2 + 1]);
            yMax = Math.max(yMax, this.points[i * 2 + 1]);
        }
        this.bounds = new Rectangle((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin));
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    @Override
    public Rectangle2D getBounds2D() {
        if (this.bounds == null) {
            this.updateBounds();
        }
        return this.bounds;
    }

    @Override
    public boolean contains(double d, double d1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Point2D pd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean intersects(double d, double d1, double d2, double d3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean intersects(Rectangle2D rd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(double d, double d1, double d2, double d3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean contains(Rectangle2D rd) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new LandMassPathIterator(this, at, this.borders);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double d) {
        return this.getPathIterator(at);
    }

    class LandMassPathIterator
    implements PathIterator {
        LandMass aMass;
        AffineTransform transform;
        int index = 0;
        boolean borders;

        public LandMassPathIterator(LandMass s, AffineTransform at, boolean b) {
            this.aMass = s;
            this.transform = at;
            this.borders = b;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > LandMass.this.pcount;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= LandMass.this.pcount) {
                return this.borders ? 0 : 4;
            }
            coords[0] = this.aMass.points[this.index * 2];
            coords[1] = this.aMass.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= LandMass.this.pcount) {
                return this.borders ? 0 : 4;
            }
            coords[0] = this.aMass.points[this.index * 2];
            coords[1] = this.aMass.points[this.index * 2 + 1];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

