/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.EventEditor2;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class LatLonChooser
extends JComponent {
    private Image image;
    boolean imageFileExists = false;
    private int displayWidth = 400;
    private int displayHeight = 400;
    private int imageWidth;
    private int imageHeight;
    private AffineTransform imageToDisplay;
    private AffineTransform worldToImage;
    private AffineTransform starTransform;
    private Rectangle2D imageCoordinates = new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0);
    private Point2D.Double latLon = new Point2D.Double();
    private MediaTracker tracker;
    private Color starColor;
    private GeneralPath star;

    public LatLonChooser() {
        this.createStar();
        this.tracker = new MediaTracker(this);
        this.setSize(new Dimension(this.displayWidth, this.displayHeight));
        this.setupTransforms();
        this.addMouseListener(new MapMouseListener());
    }

    @Override
    public void setSize(Dimension d) {
        this.displayWidth = d.width;
        this.displayHeight = d.height;
        this.setupTransforms();
    }

    @Override
    public void setSize(int w, int h) {
        this.setSize(new Dimension(w, h));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g2.drawImage(this.image, this.imageToDisplay, this);
        g2.setColor(Color.BLACK);
        g2.draw(this.starTransform.createTransformedShape(this.star));
        g2.setColor(this.starColor);
        g2.fill(this.starTransform.createTransformedShape(this.star));
    }

    public void setStarColor(Color c) {
        this.starColor = c;
    }

    public void setImage(Image i) {
        this.image = i;
        this.imageHeight = this.image.getHeight(this);
        this.imageWidth = this.image.getWidth(this);
    }

    public void setImage(String imageFileName) {
        File f = new File(imageFileName);
        try {
            if (!f.exists()) {
                throw new Exception();
            }
            this.image = ImageIO.read(new URL("file://" + imageFileName));
            this.imageHeight = this.image.getHeight(this);
            this.imageWidth = this.image.getWidth(this);
            this.imageFileExists = true;
        }
        catch (Exception e) {
            this.imageFileExists = false;
        }
    }

    public void setImage() {
        try {
            this.image = ImageIO.read(this.getClass().getResourceAsStream("images/map5.jpg"));
            this.tracker.addImage(this.image, 0);
            this.tracker.waitForID(0);
            this.imageHeight = this.image.getHeight(this);
            this.imageWidth = this.image.getWidth(this);
            this.imageFileExists = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.imageFileExists = false;
        }
        if (EventEditor2.DEBUG) {
            System.out.println("imageFileExists: " + this.imageFileExists);
        }
    }

    public void setImageCoords(Rectangle2D.Double r) {
        this.imageCoordinates = r;
        this.setupTransforms();
    }

    public void setupTransforms() {
        double sx = (double)this.imageWidth / this.imageCoordinates.getWidth();
        double sy = (double)(-this.imageHeight) / this.imageCoordinates.getHeight();
        this.worldToImage = new AffineTransform(sx, 0.0, 0.0, sy, -this.imageCoordinates.getX() * sx, -(this.imageCoordinates.getY() + this.imageCoordinates.getHeight()) * sy);
        this.imageToDisplay = AffineTransform.getScaleInstance((double)this.displayWidth / (double)this.imageWidth, (double)this.displayHeight / (double)this.imageHeight);
        this.starTransform = new AffineTransform();
    }

    public void createStar() {
        double[] xPoints = new double[]{5.5, 6.7, 10.9, 7.3, 8.3, 5.5, 2.7, 3.7, 0.1, 4.3};
        double[] yPoints = new double[]{0.0, 3.6, 3.6, 5.4, 9.6, 7.2, 9.6, 5.4, 3.6, 3.6};
        this.star = new GeneralPath();
        this.star.moveTo((float)xPoints[0] - 5.4f, (float)yPoints[0] - 4.8f);
        for (int k = 1; k < xPoints.length; ++k) {
            this.star.lineTo((float)xPoints[k] - 5.4f, (float)yPoints[k] - 4.8f);
        }
        this.star.closePath();
    }

    public void setTSLocation(Point2D.Double p) {
        try {
            this.starTransform.setToTranslation(p.getX(), p.getY());
            this.imageToDisplay.inverseTransform(p, p);
            this.worldToImage.inverseTransform(p, p);
            this.latLon.x = p.x;
            this.latLon.y = p.y;
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        this.fireActionPerformed();
        this.repaint();
    }

    public Point2D.Double getLatLon() {
        return this.latLon;
    }

    public int[] getTSLocation(Point2D.Double p) {
        int[] result = new int[2];
        this.worldToImage.transform(p, p);
        this.imageToDisplay.transform(p, p);
        this.starTransform.setToTranslation(p.getX(), p.getY());
        this.repaint();
        return result;
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed() {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = "Lat/Lon selected";
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    class MapMouseListener
    extends MouseAdapter {
        MapMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point2D.Double Pt = new Point2D.Double(e.getX(), e.getY());
            LatLonChooser.this.setTSLocation(Pt);
        }
    }
}

