/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.Fault;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MOSTGrid {
    public static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private Model model = Model.MOST;
    private String fileName;
    private boolean dataValid = false;
    private boolean regrid = true;
    private int nLons;
    private int nLats;
    private double[] lons;
    private double[] lats;
    private double[][] maxAmp;
    private double[][] travelTime;
    private int numFaults = 1;
    private double[] faultLen = new double[]{100.0};
    private double[] faultWid = new double[]{50.0};
    private double[] faultSlip = new double[]{1.0};
    private double[] faultStrike;
    private double[] faultDip;
    private double[] faultDepth;
    private double[] faultRake;
    private double[] faultLon;
    private double[] faultLat;
    private ArrayList<String> faultName = new ArrayList();
    private double delx = 0.0;
    private double dely = 0.0;
    public static final double roundTo = 1.0E10;
    public static final double epsilon = 1.0E-4;
    private String solution = "none";
    private String bathyFilename = "";
    private Point2D.Float epicenter = new Point2D.Float();
    private double scaleFactor = 1.0;
    private double Mw;
    private static double u = 4.0E11;
    private boolean realEvent = false;
    private boolean hasTravelTime = false;
    private String eventID = "";
    private String eventDate = "";
    private String expertSourceName = "";
    private HashMap<Integer, Rectangle2D> rects = null;
    private double maxAmpMin = Double.MAX_VALUE;
    private double maxAmpMax = Double.MIN_VALUE;

    public MOSTGrid(String fileName) {
        this(fileName, true);
    }

    public MOSTGrid(String fileName, boolean regrid) {
        this.fileName = fileName;
        this.regrid = regrid;
        try {
            this.dataValid = this.readHeader();
            log.fine(this.toString());
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error reading source metadata.", ioe);
        }
    }

    public void setLogger(Logger l) {
        log = l;
    }

    private boolean readHeader() throws IOException {
        this.scaleFactor = 1.0;
        log.info("Reading metadata from netcdf file: " + this.fileName);
        try (NetcdfFile nc = NetcdfFile.open(this.fileName);){
            Attribute att;
            this.lons = (double[])nc.findVariable("lon").read().copyTo1DJavaArray();
            this.lats = (double[])nc.findVariable("lat").read().copyTo1DJavaArray();
            this.nLons = this.lons.length;
            this.nLats = this.lats.length;
            this.fixLons();
            this.bathyFilename = this.getAttribute(nc, "Grid_Filename").getStringValue();
            if (this.getAttribute(nc, "title").getStringValue().contains("RIFT")) {
                this.model = Model.RIFT;
            }
            this.numFaults = (att = this.getAttribute(nc, "Number_Of_Fault_Planes")) == null ? 1 : att.getNumericValue().intValue();
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            atts.add(this.getAttribute(nc, "Source_Length"));
            int numFaultsWithMetadata = ((Attribute)atts.get(0)).getLength();
            if (this.numFaults != numFaultsWithMetadata) {
                log.warning("Fault plane info missing for multi-fault run, consider using 'inversion' metadata and get geometry from PropDB");
                this.numFaults = 1;
            }
            atts.add(this.getAttribute(nc, "Source_Width"));
            atts.add(this.getAttribute(nc, "Slip"));
            att = this.getAttribute(nc, "Source_Longitude");
            if (att == null) {
                att = this.getAttribute(nc, "Source_Longitude_Combined");
            }
            atts.add(att);
            att = this.getAttribute(nc, "Source_Latitude");
            if (att == null) {
                att = this.getAttribute(nc, "Source_Latitude_Combined");
            }
            atts.add(att);
            atts.add(this.getAttribute(nc, "Strike"));
            atts.add(this.getAttribute(nc, "Dip"));
            atts.add(this.getAttribute(nc, "Depth"));
            atts.add(this.getAttribute(nc, "Rake"));
            att = this.getAttribute(nc, "Source_Code_Name");
            String[] str = null;
            if (att != null) {
                atts.add(att);
                str = ((Attribute)atts.get(9)).getStringValue().split("\\s+");
            } else {
                str = new String[]{"ev000q"};
            }
            this.faultLen = new double[this.numFaults];
            this.faultWid = new double[this.numFaults];
            this.faultSlip = new double[this.numFaults];
            this.faultLon = new double[this.numFaults];
            this.faultLat = new double[this.numFaults];
            this.faultStrike = new double[this.numFaults];
            this.faultDip = new double[this.numFaults];
            this.faultDepth = new double[this.numFaults];
            this.faultRake = new double[this.numFaults];
            for (int i = 0; i < numFaultsWithMetadata; ++i) {
                this.faultLen[i] = ((Attribute)atts.get(0)).getNumericValue(i).doubleValue();
                this.faultWid[i] = ((Attribute)atts.get(1)).getNumericValue(i).doubleValue();
                this.faultSlip[i] = ((Attribute)atts.get(2)).getNumericValue(i).doubleValue();
                this.faultLon[i] = ((Attribute)atts.get(3)).getNumericValue(i).doubleValue();
                this.faultLat[i] = ((Attribute)atts.get(4)).getNumericValue(i).doubleValue();
                this.faultStrike[i] = ((Attribute)atts.get(5)).getNumericValue(i).doubleValue();
                this.faultDip[i] = ((Attribute)atts.get(6)).getNumericValue(i).doubleValue();
                this.faultDepth[i] = ((Attribute)atts.get(7)).getNumericValue(i).doubleValue();
                this.faultRake[i] = ((Attribute)atts.get(8)).getNumericValue(i).doubleValue();
                this.faultName.add(str[i]);
            }
            float eplon = 0.0f;
            float eplat = 0.0f;
            att = nc.findGlobalAttribute("Source_Longitude_Combined");
            if (att != null) {
                eplon = Float.valueOf(this.getAttribute(nc, "Source_Longitude_Combined").getNumericValue().floatValue()).floatValue();
                eplat = Float.valueOf(this.getAttribute(nc, "Source_Latitude_Combined").getNumericValue().floatValue()).floatValue();
            } else {
                att = nc.findGlobalAttribute("EventLongitude");
                if (att != null) {
                    eplon = Float.valueOf(att.getNumericValue().floatValue()).floatValue();
                    eplat = Float.valueOf(this.getAttribute(nc, "EventLatitude").getNumericValue().floatValue()).floatValue();
                }
            }
            eplon = (double)eplon < 0.0 ? eplon + 360.0f : eplon;
            this.epicenter = new Point2D.Float(eplon, eplat);
            att = nc.findGlobalAttribute("magnitude");
            this.Mw = att != null ? Double.parseDouble(att.getStringValue()) : ((att = this.getAttribute(nc, "EventMagnitude")) != null ? att.getNumericValue().doubleValue() : MOSTGrid.getMagnitudeAR(this.faultSlip, this.faultLen, this.faultWid));
            att = nc.findGlobalAttribute("inversion");
            if (att != null) {
                this.solution = this.getAttribute(nc, "inversion").getStringValue();
            }
            if ((att = nc.findGlobalAttribute("Event_Date")) != null) {
                this.realEvent = true;
                this.eventDate = att.getStringValue();
            } else {
                this.realEvent = false;
            }
            att = nc.findGlobalAttribute("EventID");
            if (att != null) {
                this.eventID = att.getStringValue();
            }
            if ((att = nc.findGlobalAttribute("Expert_Source_Name")) != null) {
                this.expertSourceName = att.getStringValue();
                this.realEvent = true;
            }
            this.maxAmp = new double[this.nLats][this.nLons];
            this.travelTime = new double[this.nLats][this.nLons];
        }
        catch (RuntimeException ex) {
            log.log(Level.WARNING, "Error reading metadata.", ex);
            this.dataValid = false;
        }
        return true;
    }

    public void setRealEvent(boolean b) {
        this.realEvent = b;
    }

    public boolean hasData() {
        return this.dataValid;
    }

    private Attribute getAttribute(NetcdfFile nc, String attName) {
        Attribute a = nc.findGlobalAttribute(attName);
        if (a == null) {
            log.warning("Can't find attribute: " + attName + " in file: " + nc.getLocation());
        }
        return a;
    }

    public String getExpertSourceName() {
        return this.expertSourceName;
    }

    private void fixLons() {
        int i;
        boolean lonneg = false;
        for (i = 0; i < this.nLons; ++i) {
            if (!(this.lons[i] < 0.0)) continue;
            lonneg = true;
            break;
        }
        if (lonneg) {
            i = 0;
            while (i < this.nLons) {
                int n = i++;
                this.lons[n] = this.lons[n] + 360.0;
            }
        }
    }

    public boolean hasTravelTime() {
        return this.hasTravelTime;
    }

    public String getEventID() {
        return this.eventID;
    }

    public String getEventDate() {
        return this.eventDate;
    }

    public double getMag() {
        return this.Mw;
    }

    private boolean readData() throws IOException {
        block18: {
            log.info("Reading data from netcdf file: " + this.fileName);
            try (NetcdfFile nc = NetcdfFile.open(this.fileName);){
                int i;
                int j;
                Variable var = nc.findVariable("max_height");
                if (var == null) {
                    throw new IOException("Can't find variable 'max_height' in source file: " + this.fileName);
                }
                this.maxAmp = var.getDataType().equals((Object)DataType.SHORT) ? this.readShort2D(var, this.scaleFactor, false) : this.readFloat2D(var, this.scaleFactor, false);
                for (j = 0; j < this.nLats; ++j) {
                    for (i = 0; i < this.nLons; ++i) {
                        this.maxAmpMin = this.maxAmp[j][i] < this.maxAmpMin ? this.maxAmp[j][i] : this.maxAmpMin;
                        this.maxAmpMax = this.maxAmp[j][i] > this.maxAmpMax ? this.maxAmp[j][i] : this.maxAmpMax;
                    }
                }
                log.fine("Stats for maxAmp, min: " + this.maxAmpMin + " max: " + this.maxAmpMax);
                var = nc.findVariable("travel_time");
                if (var == null) {
                    log.warning("Can't find travel_time variable in file: " + nc.getLocation());
                    break block18;
                }
                this.travelTime = var.getDataType().equals((Object)DataType.SHORT) ? this.readShort2D(var, 1.0, true) : this.readFloat2D(var, 1.0, true);
                for (j = 0; j < this.nLats; ++j) {
                    for (i = 0; i < this.nLons; ++i) {
                        if (Double.isNaN(this.travelTime[j][i])) continue;
                        this.hasTravelTime = true;
                        break block18;
                    }
                }
            }
        }
        return true;
    }

    public double[][] readShort2D(Variable var, double magScale, boolean useNaN) throws IOException {
        int[] shape = var.getShape();
        if (shape[0] != this.nLats || shape[1] != this.nLons) {
            throw new IOException("variable shape doesn't match axes");
        }
        double scale = 1.0;
        double offset = 0.0;
        double[][] result = new double[this.nLats][this.nLons];
        short miss = -9999;
        short holder = 0;
        double missD = useNaN ? Double.NaN : 0.0;
        ArrayShort.D2 arr = (ArrayShort.D2)var.read();
        Attribute att = var.findAttribute("scale_factor");
        if (att != null) {
            scale = (float)att.getNumericValue().doubleValue();
        }
        if ((att = var.findAttribute("add_offset")) != null) {
            offset = (float)var.findAttribute("add_offset").getNumericValue().doubleValue();
        }
        if ((att = var.findAttribute("missing_value")) != null) {
            miss = att.getNumericValue().shortValue();
        }
        for (int j = 0; j < this.nLats; ++j) {
            for (int i = 0; i < this.nLons; ++i) {
                holder = arr.get(j, i);
                result[j][i] = holder == miss ? missD : magScale * (scale * (double)holder + offset);
            }
        }
        return result;
    }

    public double[][] readFloat2D(Variable var, double magScale, boolean useNaN) throws IOException {
        int[] shape = var.getShape();
        if (shape[0] != this.nLats || shape[1] != this.nLons) {
            throw new IOException("variable shape doesn't match axes");
        }
        double scale = 1.0;
        double offset = 0.0;
        double[][] result = new double[this.nLats][this.nLons];
        float miss = -9999.0f;
        float holder = 0.0f;
        double missD = useNaN ? Double.NaN : 0.0;
        ArrayFloat.D2 arr = (ArrayFloat.D2)var.read();
        Attribute att = var.findAttribute("scale_factor");
        if (att != null) {
            scale = (float)att.getNumericValue().doubleValue();
        }
        if ((att = var.findAttribute("add_offset")) != null) {
            offset = (float)var.findAttribute("add_offset").getNumericValue().doubleValue();
        }
        if ((att = var.findAttribute("missing_value")) != null) {
            miss = att.getNumericValue().floatValue();
        }
        if ((att = var.findAttribute("positive")) != null && "down".equals(att.getStringValue())) {
            scale *= -1.0;
        }
        for (int j = 0; j < this.nLats; ++j) {
            for (int i = 0; i < this.nLons; ++i) {
                holder = arr.get(j, i);
                result[j][i] = holder == miss ? missD : magScale * (scale * (double)holder + offset);
            }
        }
        return result;
    }

    public String getSolution() {
        return this.solution;
    }

    public Point2D.Float getEpicenter() {
        return this.epicenter;
    }

    public double getMagnitude() {
        return this.Mw;
    }

    public Model getModel() {
        return this.model;
    }

    public String getBathyFilename() {
        return this.bathyFilename;
    }

    public String getFilename() {
        return this.fileName;
    }

    public static double getMagnitudeAR(double[] slip, double[] len, double[] wid) {
        double u = 40.0;
        double mu = u * 1.0E9;
        double Mo = 0.0;
        double area = 0.0;
        for (int i = 0; i < slip.length; ++i) {
            area = len[i] * wid[i] * 1000000.0;
            Mo += mu * Math.abs(slip[i] * area) * 1.0E7;
        }
        double Mw = 0.0 * Math.log10(Mo) - 10.7333;
        return Mw;
    }

    public double setMagnitude(double magnitude) {
        double Mo = 0.0;
        Mo = this.getModel().equals((Object)Model.MOST) ? Math.pow(10.0, 1.5 * (magnitude + 10.7)) : Math.pow(10.0, 1.5 * (magnitude + 10.7333));
        double area = 0.0;
        if (this.realEvent) {
            this.scaleFactor = 1.0;
        } else {
            this.scaleFactor = 0.0;
            for (int i = 0; i < this.numFaults; ++i) {
                area = this.faultLen[i] * this.faultWid[i] * 1.0E10;
                this.scaleFactor += Mo / (u * area) * 0.01 / this.faultSlip[i];
            }
        }
        log.fine("file Mw: " + this.Mw + " requested Mw: " + magnitude + " numFaults: " + this.faultSlip.length + " scale: " + this.scaleFactor + " realEvent: " + this.realEvent);
        try {
            this.dataValid = this.readData();
            if (this.dataValid) {
                if (this.regrid) {
                    long tic = System.currentTimeMillis();
                    this.regrid();
                    log.fine("time for regrid: " + (double)(System.currentTimeMillis() - tic) / 1000.0);
                } else {
                    this.createRects();
                }
            }
        }
        catch (IOException ioe) {
            log.log(Level.WARNING, "Error reading source file data.", ioe);
            this.dataValid = false;
        }
        return this.scaleFactor;
    }

    public Point2D.Double getMinMaxAmp(Rectangle2D.Double rec) {
        double minLon = rec.x;
        double maxLon = rec.x + rec.width;
        double minLat = rec.y;
        double maxLat = rec.y + rec.height;
        double val = 0.0;
        Point2D.Double minmax = new Point2D.Double();
        minmax.x = Double.MAX_VALUE;
        minmax.y = Double.MIN_VALUE;
        for (int j = 0; j < this.nLats; ++j) {
            for (int i = 0; i < this.nLons; ++i) {
                if (!(minLon < this.lons[i]) || !(this.lons[i] < maxLon) || !(minLat < this.lats[j]) || !(this.lats[j] < maxLat) || !((val = this.maxAmp[j][i]) > 0.09)) continue;
                minmax.x = this.maxAmp[j][i] < minmax.x ? this.maxAmp[j][i] : minmax.x;
                minmax.y = this.maxAmp[j][i] > minmax.y ? this.maxAmp[j][i] : minmax.y;
            }
        }
        return minmax;
    }

    public ArrayList<Fault> getFaults() {
        ArrayList<Fault> faults = new ArrayList<Fault>();
        for (int i = 0; i < this.faultSlip.length; ++i) {
            faults.add(new Fault(this.faultName.get(i), "", this.faultLon[i], this.faultLat[i], this.faultSlip[i], this.faultStrike[i], this.faultDip[i], this.faultDepth[i], this.faultLen[i], this.faultWid[i], this.faultRake[i]));
        }
        return faults;
    }

    public Point2D.Double getMinMaxTravelTime(Rectangle2D.Double rec) {
        double minLon = rec.x;
        double maxLon = rec.x + rec.width;
        double minLat = rec.y;
        double maxLat = rec.y + rec.height;
        double val = 0.0;
        Point2D.Double minmax = new Point2D.Double();
        minmax.x = Double.MAX_VALUE;
        minmax.y = Double.MIN_VALUE;
        for (int j = 0; j < this.nLats; ++j) {
            for (int i = 0; i < this.nLons; ++i) {
                if (!(minLon < this.lons[i]) || !(this.lons[i] < maxLon) || !(minLat < this.lats[j]) || !(this.lats[j] < maxLat) || !((val = this.travelTime[j][i]) > 0.0)) continue;
                minmax.x = this.travelTime[j][i] < minmax.x ? this.travelTime[j][i] : minmax.x;
                minmax.y = this.travelTime[j][i] > minmax.y ? this.travelTime[j][i] : minmax.y;
            }
        }
        return minmax;
    }

    public static double getMinDX(double[] lonslats) {
        double dx = 0.0;
        double mindx = 100000.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            mindx = dx < mindx ? dx : mindx;
        }
        return Math.floor(mindx * 1.0E10) / 1.0E10;
    }

    public static double getMaxDX(double[] lonslats) {
        double dx = 0.0;
        double maxdx = 0.0;
        for (int i = 1; i < lonslats.length; ++i) {
            dx = Math.abs(lonslats[i] - lonslats[i - 1]);
            maxdx = dx > maxdx ? dx : maxdx;
        }
        return Math.floor(maxdx * 1.0E10) / 1.0E10;
    }

    public static ArrayList<Double> equiSpace(double start, double end, int size) {
        ArrayList<Double> al = new ArrayList<Double>();
        double dx = (end - start) / (double)(size - 1);
        for (int i = 0; i < size; ++i) {
            al.add(start + (double)i * dx);
        }
        return al;
    }

    public static double[] constantDX(double start, double end, double dx) {
        ArrayList<Double> al = new ArrayList<Double>();
        double x = start;
        al.add(x);
        while (x < end) {
            al.add(x += dx);
        }
        double[] result = new double[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            result[i] = (Double)al.get(i);
        }
        return result;
    }

    private void regrid() {
        double maxdx = MOSTGrid.getMaxDX(this.lons);
        double mindx = MOSTGrid.getMinDX(this.lons);
        double maxdy = MOSTGrid.getMaxDX(this.lats);
        double mindy = MOSTGrid.getMinDX(this.lats);
        if (maxdx - mindx < 1.0E-4 && maxdy - mindy < 1.0E-4 && maxdx - maxdy < 1.0E-4) {
            log.info(String.format("not regridding: dx = dy = %2.2f [arcmin]", maxdx * 60.0));
            return;
        }
        double dx = Math.max(maxdx, maxdy);
        double[] x = MOSTGrid.constantDX(this.lons[0], this.lons[this.nLons - 1], dx);
        double[] y = MOSTGrid.constantDX(this.lats[0], this.lats[this.nLats - 1], dx);
        double[][] z = new double[y.length][x.length];
        double[][] z2 = new double[y.length][x.length];
        log.info(String.format("regridding to dx of %2.2f [arcmin], nLons: %d nLats: %d", dx * 60.0, x.length, y.length));
        MOSTGrid.bilinearRegrid(this.lons, this.lats, this.maxAmp, x, y, z);
        MOSTGrid.bilinearRegrid(this.lons, this.lats, this.travelTime, x, y, z2);
        this.maxAmp = z;
        this.travelTime = z2;
        this.lons = x;
        this.lats = y;
        this.nLons = this.lons.length;
        this.nLats = this.lats.length;
    }

    private void regrid2() {
        double[] dx = new double[this.nLons];
        double[] dy = new double[this.nLats];
        double[][] dz = new double[this.nLats][this.nLons];
        double[][] dz2 = new double[this.nLats][this.nLons];
        this.delx = (this.lons[this.nLons - 1] - this.lons[0]) / (double)this.nLons;
        dx[0] = this.lons[0];
        for (int i = 1; i < this.nLons; ++i) {
            dx[i] = dx[i - 1] + this.delx;
        }
        this.dely = (this.lats[this.nLats - 1] - this.lats[0]) / (double)this.nLats;
        dy[0] = this.lats[0];
        for (int j = 1; j < this.nLats; ++j) {
            dy[j] = dy[j - 1] + this.dely;
        }
        log.fine("lons[0]:" + this.lons[0] + "/" + dx[0] + ", " + this.lons[this.nLons - 1] + "/" + dx[this.nLons - 1] + "\nlats[0]:" + this.lats[0] + "/" + dy[0] + ", " + this.lats[this.nLats - 1] + "/" + dy[this.nLats - 1]);
        MOSTGrid.bilinearRegrid(this.lons, this.lats, this.maxAmp, dx, dy, dz);
        this.maxAmp = dz;
        MOSTGrid.bilinearRegrid(this.lons, this.lats, this.travelTime, dx, dy, dz2);
        this.travelTime = dz2;
        this.lons = dx;
        this.lats = dy;
    }

    private static int findIndex(double[] x, double sx) {
        int i;
        if (sx < x[0] || sx > x[x.length - 1]) {
            return Integer.MIN_VALUE;
        }
        for (i = 1; i < x.length && x[i] < sx; ++i) {
        }
        return i;
    }

    public static void bilinearRegrid(double[] sx, double[] sy, double[][] sz, double[] dx, double[] dy, double[][] dz) {
        int sylen = sy.length;
        for (int dj = 0; dj < dy.length; ++dj) {
            int sj = MOSTGrid.findIndex(sy, dy[dj]);
            if (sj < 0 || sy[sj] == sy[sj - 1]) continue;
            double u = (dy[dj] - sy[sj - 1]) / (sy[sj] - sy[sj - 1]);
            for (int di = 0; di < dx.length; ++di) {
                int si = MOSTGrid.findIndex(sx, dx[di]);
                if (si < 0 || sx[si] == sx[si - 1]) continue;
                double t = (dx[di] - sx[si - 1]) / (sx[si] - sx[si - 1]);
                dz[dj][di] = t * u * sz[sj][si] + (1.0 - t) * u * sz[sj][si - 1] + (1.0 - t) * (1.0 - u) * sz[sj - 1][si - 1] + t * (1.0 - u) * sz[sj - 1][si];
            }
        }
    }

    public double[] getLons() {
        return this.lons;
    }

    public double[] getLats() {
        return this.lats;
    }

    public int getNumLons() {
        return this.lons.length;
    }

    public int getNumLats() {
        return this.lats.length;
    }

    private void createRects() {
        this.rects = new HashMap();
        for (int i = 0; i < this.nLons; ++i) {
            for (int j = 0; j < this.nLats; ++j) {
                double dx = 0.0;
                dx = i == this.lons.length - 1 ? this.lons[i] - this.lons[i - 1] : this.lons[i + 1] - this.lons[i];
                double dy = 0.0;
                dy = j == this.lats.length - 1 ? this.lats[j] - this.lats[j - 1] : this.lats[j + 1] - this.lats[j];
                dx = Math.abs(dx);
                dy = Math.abs(dy);
                this.rects.put(i + this.nLons * j, new Rectangle2D.Float((float)(this.lons[i] - dx / 2.0), (float)(this.lats[j] - dy / 2.0), (float)dx, (float)dy));
            }
        }
    }

    public Rectangle2D getRect(int i, int j) {
        return this.rects.get(i + this.nLons * j);
    }

    private int[] getRowCol(Point2D.Double pt) {
        return this.getRowCol(pt.getX(), pt.getY());
    }

    private int[] getRowCol(double lon, double lat) {
        int row;
        int col;
        for (col = 0; col < this.lons.length && !(lon < this.lons[col]); ++col) {
        }
        col = col == this.lons.length ? this.lons.length - 1 : col;
        double d = this.lons[col] - lon;
        if (col != 0 && this.lons[col - 1] - lon < d) {
            --col;
        }
        for (row = 0; row < this.lats.length && !(lat < this.lats[row]); ++row) {
        }
        row = row == this.lats.length ? this.lats.length - 1 : row;
        d = this.lats[row] - lat;
        if (row == 0 || this.lats[row - 1] - lat < d) {
            // empty if block
        }
        return new int[]{col, --row};
    }

    public Rectangle2D.Double getExtents() {
        return new Rectangle2D.Double(this.lons[0] - this.delx / 2.0, this.lats[0] - this.dely / 2.0, this.lons[this.lons.length - 1] - this.lons[0] + this.delx, this.lats[this.lats.length - 1] - this.lats[0] + this.dely);
    }

    public double[][] getMaxAmp() {
        return this.maxAmp;
    }

    public double[][] getTravelTime() {
        return this.travelTime;
    }

    public double[][] getBathymetry() throws IOException {
        double[][] bath = new double[this.nLats][this.nLons];
        try (NetcdfFile nc = NetcdfFile.open(this.fileName);){
            Variable var = nc.findVariable("bathymetry");
            bath = this.readFloat2D(var, 1.0, false);
            nc.close();
        }
        return bath;
    }

    public void setTravelTime(double[][] tt2) {
        this.travelTime = tt2;
    }

    private double getTravelTime(int r, int c) {
        return this.travelTime[r][c];
    }

    public double getMaxAmp(int r, int c) {
        return this.maxAmp[r][c];
    }

    public double getMaxAmp(double lon, double lat) {
        int i = MOSTGrid.findIndex(this.lons, lon);
        int j = MOSTGrid.findIndex(this.lats, lat);
        if (i == Integer.MIN_VALUE || j == Integer.MIN_VALUE) {
            return Double.NaN;
        }
        return this.maxAmp[j][i];
    }

    public double getTravelTime(double lon, double lat) {
        int i = MOSTGrid.findIndex(this.lons, lon);
        int j = MOSTGrid.findIndex(this.lats, lat);
        if (i == Integer.MIN_VALUE || j == Integer.MIN_VALUE) {
            return Double.NaN;
        }
        return this.travelTime[j][i];
    }

    public String toString() {
        return "MOSTGrid, fn: " + this.fileName + " size: " + this.nLons + "x" + this.nLats + " soln: " + this.solution + " Mw: " + this.Mw + " model: " + (Object)((Object)this.model);
    }

    public static enum Model {
        MOST,
        RIFT;

    }
}

