/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class MOSTGridHA {
    public static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private String fileName;
    private boolean dataValid = false;
    private boolean regrid = true;
    int nLons;
    int nLats;
    int nLonsOrig;
    int nLatsOrig;
    private double[] lons;
    private double[] lats;
    private double[] time;
    private double[] lonsOrig;
    private double[] latsOrig;
    private boolean imageFormat = false;
    private double[][] ha;
    private double delx = 0.0;
    private double dely = 0.0;
    private float missing = -1.0E34f;
    private int[] origin;
    private int[] shape;
    private NetcdfFile nc = null;
    private HashMap<Integer, Rectangle2D> rects = null;

    public MOSTGridHA(String fileName) {
        this(fileName, true);
    }

    public MOSTGridHA(String fileName, boolean regrid) {
        this.fileName = fileName;
        this.regrid = regrid;
        try {
            this.dataValid = this.readAxes();
        }
        catch (IOException ioe) {
            this.dataValid = false;
        }
    }

    public void setLogger(Logger l) {
        log = l;
    }

    private boolean readAxes() throws IOException {
        this.close();
        log.info("Reading file: " + this.fileName);
        this.nc = NetcdfFile.open(this.fileName);
        Variable var = null;
        var = this.getVariable("lon");
        if (var == null) {
            log.warning("can't find variable 'lon'.");
            this.nc.close();
            return false;
        }
        this.lons = (double[])var.read().copyTo1DJavaArray();
        var = this.getVariable("lat");
        ArrayDouble.D1 a = (ArrayDouble.D1)var.read();
        boolean bl = this.imageFormat = a.get(1) < a.get(0);
        if (this.imageFormat) {
            log.info("detected image-format netCDF file");
            a = (ArrayDouble.D1)a.flip(0);
        }
        this.lats = (double[])a.copyTo1DJavaArray();
        this.nLons = this.lons.length;
        this.nLats = this.lats.length;
        this.nLonsOrig = this.nLons;
        this.nLatsOrig = this.nLats;
        this.lonsOrig = Arrays.copyOf(this.lons, this.nLons);
        this.latsOrig = Arrays.copyOf(this.lats, this.nLats);
        var = this.getVariable("time");
        this.time = (double[])var.read().copyTo1DJavaArray();
        var = this.getVariable("ha");
        this.missing = ((Float)var.findAttribute("missing_value").getNumericValue()).floatValue();
        this.shape = var.getShape();
        this.origin = new int[var.getRank()];
        log.info("nLons: " + this.nLons + " nLats: " + this.nLats);
        if (this.regrid) {
            this.regridAxes();
        }
        this.createRects();
        return true;
    }

    private void regridAxes() {
        int i;
        boolean constdel = true;
        double tmp = 0.0;
        for (int i2 = 1; i2 < this.lons.length; ++i2) {
            tmp += this.lons[i2] - this.lons[i2 - 1];
        }
        double roundTo = 1.0E10;
        double epsilon = 1.0E-8;
        this.delx = tmp / (double)(this.lons.length - 1);
        this.delx = Math.floor(this.delx * roundTo) / roundTo;
        for (i = 1; i < this.lons.length; ++i) {
            if (!(Math.abs(this.lons[i] - this.lons[i - 1] - this.delx) > epsilon)) continue;
            constdel = false;
        }
        tmp = 0.0;
        for (i = 1; i < this.lats.length; ++i) {
            tmp += this.lats[i] - this.lats[i - 1];
        }
        this.dely = tmp / (double)(this.lats.length - 1);
        this.dely = Math.floor(this.dely * roundTo) / roundTo;
        for (i = 1; i < this.lats.length; ++i) {
            if (!(Math.abs(this.lats[i] - this.lats[i - 1] - this.dely) > epsilon)) continue;
            constdel = false;
        }
        if (constdel) {
            log.info("grid: " + this.fileName + " is evenly-spaced.  Not regridding.");
            this.regrid = false;
            return;
        }
        int nLons2 = (int)(Math.abs(this.lons[0] - this.lons[this.lons.length - 1]) / this.delx) + 1;
        int nLats2 = (int)(Math.abs(this.lats[0] - this.lats[this.lats.length - 1]) / this.dely) + 1;
        double[] dx = new double[nLons2];
        double[] dy = new double[nLats2];
        dx[0] = this.lons[0];
        for (int i3 = 1; i3 < nLons2; ++i3) {
            dx[i3] = dx[i3 - 1] + this.delx;
        }
        dy[0] = this.lats[0];
        for (int j = 1; j < nLats2; ++j) {
            dy[j] = dy[j - 1] + this.dely;
        }
        this.lons = dx;
        this.lats = dy;
        this.nLons = nLons2;
        this.nLats = nLats2;
        log.info("nLons/nLonsOrig: " + this.nLons + "/" + this.nLonsOrig + "\nnLats/nLatsOrig: " + this.nLats + "/" + this.nLatsOrig);
        log.info("lons[0]: " + this.lons[0] + "/" + this.lonsOrig[0] + "lons[end]" + this.lons[this.lons.length - 1] + "/" + this.lonsOrig[this.lonsOrig.length - 1]);
        log.info("lats[0]: " + this.lats[0] + "/" + this.latsOrig[0] + "lats[end]" + this.lats[this.lats.length - 1] + "/" + this.latsOrig[this.latsOrig.length - 1]);
    }

    private void regridHA() {
        double[][] dz = new double[this.nLats][this.nLons];
        MOSTGridHA.bilinearRegrid(this.lonsOrig, this.latsOrig, this.ha, this.lons, this.lats, dz);
        this.ha = dz;
    }

    private static int findIndex(double[] x, double sx) {
        int i;
        if (sx < x[0] || sx > x[x.length - 1]) {
            return Integer.MIN_VALUE;
        }
        for (i = 1; i < x.length && x[i] < sx; ++i) {
        }
        return i;
    }

    public static void bilinearRegrid(double[] sx, double[] sy, double[][] sz, double[] dx, double[] dy, double[][] dz) {
        int sylen = sy.length;
        for (int dj = 0; dj < dy.length; ++dj) {
            int sj = MOSTGridHA.findIndex(sy, dy[dj]);
            if (sj < 0 || sy[sj] == sy[sj - 1]) continue;
            double u = (dy[dj] - sy[sj - 1]) / (sy[sj] - sy[sj - 1]);
            for (int di = 0; di < dx.length; ++di) {
                int si = MOSTGridHA.findIndex(sx, dx[di]);
                if (si < 0 || sx[si] == sx[si - 1]) continue;
                double t = (dx[di] - sx[si - 1]) / (sx[si] - sx[si - 1]);
                dz[dj][di] = t * u * sz[sj][si] + (1.0 - t) * u * sz[sj][si - 1] + (1.0 - t) * (1.0 - u) * sz[sj - 1][si - 1] + t * (1.0 - u) * sz[sj - 1][si];
            }
        }
    }

    public int getNumberOfTimeSteps() {
        return this.dataValid ? this.time.length : 0;
    }

    public Variable getVariable(String varName) {
        if (this.nc == null) {
            return null;
        }
        Variable var = this.nc.findVariable(varName);
        if (var == null) {
            var = this.nc.findVariable(varName.toUpperCase(Locale.ENGLISH));
        }
        if (var == null) {
            var = this.nc.findVariable(varName.toLowerCase(Locale.ENGLISH));
        }
        return var;
    }

    public boolean readStep(int step) {
        if (step < 0 || step >= this.time.length) {
            return false;
        }
        this.shape[0] = 1;
        this.origin[0] = step;
        Variable v = this.getVariable("ha");
        if (v == null) {
            log.warning("can't find variable 'ha'");
            return false;
        }
        try {
            this.ha = new double[this.nLatsOrig][this.nLonsOrig];
            ArrayFloat.D2 a = (ArrayFloat.D2)v.read(this.origin, this.shape).reduce();
            if (this.imageFormat) {
                a = (ArrayFloat.D2)a.flip(0);
            }
            for (int i = 0; i < this.nLonsOrig; ++i) {
                for (int j = 0; j < this.nLatsOrig; ++j) {
                    double holder = a.get(j, i);
                    this.ha[j][i] = holder > (double)this.missing ? holder : Double.NaN;
                }
            }
            if (this.regrid) {
                this.regridHA();
            }
        }
        catch (IOException | InvalidRangeException ex) {
            log.log(Level.WARNING, "Can't read 'ha'.", ex);
            return false;
        }
        return true;
    }

    public double[][] getHA() {
        return this.ha;
    }

    private void createRects() {
        this.rects = new HashMap();
        for (int i = 0; i < this.nLons; ++i) {
            for (int j = 0; j < this.nLats; ++j) {
                double dx = 0.0;
                dx = i == this.lons.length - 1 ? this.lons[i] - this.lons[i - 1] : this.lons[i + 1] - this.lons[i];
                double dy = 0.0;
                dy = j == this.lats.length - 1 ? this.lats[j] - this.lats[j - 1] : this.lats[j + 1] - this.lats[j];
                dx = Math.abs(dx);
                dy = Math.abs(dy);
                this.rects.put(i + this.nLons * j, new Rectangle2D.Float((float)(this.lons[i] - dx / 2.0), (float)(this.lats[j] - dy / 2.0), (float)dx, (float)dy));
            }
        }
    }

    public Rectangle2D getRect(int i, int j) {
        return this.rects.get(i + this.nLons * j);
    }

    public Rectangle2D.Double getExtents() {
        Rectangle2D.Double rec = new Rectangle2D.Double(this.lons[0] - this.delx / 2.0, this.lats[0] - this.dely / 2.0, this.lons[this.lons.length - 1] - this.lons[0] + this.delx, this.lats[this.lats.length - 1] - this.lats[0] + this.dely);
        return rec;
    }

    public void close() {
        try {
            if (this.nc != null) {
                this.nc.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.nc = null;
        }
    }
}

