/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.dart.Buoy;
import gov.noaa.tsunami.websift.ee.City;
import gov.noaa.tsunami.websift.ee.EventEditor2;
import gov.noaa.tsunami.websift.ee.EventEditorConstants;
import gov.noaa.tsunami.websift.ee.GSHHSReader;
import gov.noaa.tsunami.websift.ee.LandMass;
import gov.noaa.tsunami.websift.ee.PlotMark;
import gov.noaa.tsunami.websift.ee.SourceInfoFrame;
import gov.noaa.tsunami.websift.ee.StarShape;
import gov.noaa.tsunami.websift.propdb.PropGrid;
import gov.noaa.tsunami.websift.propdb.Range2D;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class MapCanvas
extends JComponent
implements EventEditorConstants {
    public static Logger log = Logger.getLogger(EventEditor2.class.getPackage().getName());
    private int selectMode;
    private int zoomLevel;
    private int maxZoomLevel = 31;
    private int minZoomLevel = 5;
    private int zoomMidPt;
    private static final Rectangle2D.Double panUpRect = new Rectangle2D.Double(10.0, 10.0, 18.0, 18.0);
    private static final Rectangle2D.Double panLeftRect = new Rectangle2D.Double(1.0, 30.0, 18.0, 18.0);
    private static final Rectangle2D.Double panRightRect = new Rectangle2D.Double(19.0, 30.0, 18.0, 18.0);
    private static final Rectangle2D.Double panDownRect = new Rectangle2D.Double(10.0, 50.0, 18.0, 18.0);
    private static final Rectangle2D.Double zoomInRect = new Rectangle2D.Double(10.0, 80.0, 18.0, 18.0);
    private static final Rectangle2D.Double zoomOutRect = new Rectangle2D.Double(10.0, 100.0, 18.0, 18.0);
    private static URL backgroundImage = null;
    private static BufferedImage mSourceImage = null;
    private static int imageWidth;
    private static int imageHeight;
    private static Rectangle2D mImageCoordinates;
    private static AffineTransform worldToUser;
    private final AffineTransform imageTransform = new AffineTransform();
    private static BufferedImage biZoomIn;
    private static BufferedImage biZoomOut;
    private static BufferedImage biPanRight;
    private static BufferedImage biPanLeft;
    private static BufferedImage biPanUp;
    private static BufferedImage biPanDown;
    private int lastX;
    private int lastY;
    private static final BasicStroke thickstroke;
    private static final BasicStroke stroke;
    private static final BasicStroke stroke_hl;
    private static final BasicStroke thinstroke;
    private static final float[] dash1;
    private static final BasicStroke dashed;
    private static final BasicStroke dashed_hl;
    private static final BasicStroke daskedStroke;
    private Font font = new Font("Dialog", 0, 10);
    private Font cityFont = this.font.deriveFont(12.0f);
    private Font countryFont = new Font("Dialog", 1, 15);
    private final ArrayList<UnitSource> boxes = new ArrayList();
    private LinkedHashMap<Shape, Color> shapes = new LinkedHashMap();
    private boolean plotShapes = false;
    private StarShape epicenter = new StarShape(20.0, 20.0, 5.0, 5.0, 13);
    private static final BasicStroke thinStroke;
    private ArrayList<Area> landMasses = new ArrayList();
    private TreeMap<Integer, ArrayList<Area>> landMassesLOD = new TreeMap();
    private Color landColor = new Color(85, 85, 85);
    private Color borderColor = new Color(155, 155, 155);
    private static final BasicStroke borderStroke;
    private boolean plotLand = false;
    private boolean plotBorders = false;
    private ArrayList<LandMass> massesCoast = new ArrayList();
    private ArrayList<LandMass> massesBorder = new ArrayList();
    private boolean drawSites;
    private Rectangle2D aGridPoly;
    private Rectangle2D bGridPoly;
    private Rectangle2D cGridPoly;
    private Shape propGridPoly;
    private final EventListenerList actionListenerList = new EventListenerList();
    private boolean plotMark;
    private PlotMark mark = new PlotMark(44);
    private Point2D.Double epiLocDisplay;
    private Point2D.Double epiLocImage;
    private String siteName;
    private Shape aGridPolyTrans;
    private Rectangle2D.Double rectDouble;
    private Rectangle2D.Float rectFloat;
    private UnitSource mostRecentlyClicked;
    private UnitSource activeSource;
    private List<Buoy> buoys;
    private boolean plotBuoys = false;
    private boolean dragTriggered = false;
    private Color markColor = new Color(246, 255, 133);
    private static final Color aGridColor;
    private static final Color bGridColor;
    private static final Color cGridColor;
    private static final Color propGridColor;
    private static final Color lightGreen;
    private static final Color darkGreen;
    private static final Color ColorTan;
    private static final Composite alphaComposite;
    private boolean drawGrids = false;
    private final LinkedHashSet<PropGrid> propGridSet = new LinkedHashSet();
    private final Timer panTimer;
    public static final int PAN_RIGHT = 1;
    public static final int PAN_LEFT = 2;
    public static final int PAN_UP = 3;
    public static final int PAN_DOWN = 4;
    private int lastPan = 1;
    private boolean rubberBanding = false;
    private Rectangle2D.Double rubberRect = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    private Rectangle2D.Double rubberRectDraw = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
    private static final Color rubberColor;
    private Point2D.Double pointerLocation = null;
    private List<Shape> gridOverlays = null;
    private boolean fillContinents = false;
    private boolean drawSources = true;
    private ArrayList<City> cities = null;
    private boolean useCities = false;
    private Color cityColor = Color.yellow;
    private int mapWidth;
    private int mapHeight;
    private boolean useCountries = false;
    private Color countryColor = Color.BLACK;
    private HashMap<String, PolyPoints> countryMap = null;
    private HashMap<String, GeneralPath> countryPath = null;
    private HashMap<String, Point2D> countryNameMap = null;
    private boolean plotTravelTimes = false;
    private GeneralPath[] travelTimePaths = null;
    private boolean plotGraticules = false;
    private GeneralPath grats = null;
    Rectangle2D.Double windowExtents = new Rectangle2D.Double();

    public MapCanvas(int dw, int dh) {
        this.mapWidth = dw;
        this.mapHeight = dh;
        this.setSize(new Dimension(dw, dh));
        MapMouseListener mml = new MapMouseListener();
        this.addMouseListener(mml);
        this.addMouseWheelListener(mml);
        this.addMouseMotionListener(new MapMouseMotionListener());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = e.getComponent().getSize();
                MapCanvas.this.mapWidth = d.width;
                MapCanvas.this.mapHeight = d.height;
            }
        });
        this.zoomMidPt = (int)Math.ceil((double)this.maxZoomLevel / 2.0);
        this.zoomLevel = this.scaleToZoomLevel(1.0);
        this.selectMode = 0;
        this.epiLocDisplay = new Point2D.Double();
        this.epiLocImage = new Point2D.Double();
        this.mark.setMarkHeightP(30.0);
        this.plotMark = true;
        if (backgroundImage == null) {
            this.setBackgroundImage(this.getClass().getResource("images/map5.jpg"), new Rectangle2D.Double(0.0, -90.0, 360.0, 180.0));
        }
        if (mSourceImage == null && backgroundImage != null) {
            try {
                mSourceImage = this.loadBackgroundImage();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                backgroundImage = null;
            }
        }
        if (biZoomIn == null) {
            try {
                biZoomIn = ImageIO.read(this.getClass().getResourceAsStream("images/zoomin.png"));
                biZoomOut = ImageIO.read(this.getClass().getResourceAsStream("images/zoomout.png"));
                biPanRight = ImageIO.read(this.getClass().getResourceAsStream("images/panright.png"));
                biPanLeft = ImageIO.read(this.getClass().getResourceAsStream("images/panleft.png"));
                biPanUp = ImageIO.read(this.getClass().getResourceAsStream("images/panup.png"));
                biPanDown = ImageIO.read(this.getClass().getResourceAsStream("images/pandown.png"));
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
            }
        }
        this.panTimer = new Timer(50, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MapCanvas.this.repeatPan();
            }
        });
        this.panTimer.setInitialDelay(500);
        this.drawSites = false;
        this.aGridPoly = new Rectangle2D.Double();
        this.bGridPoly = new Rectangle2D.Double();
        this.cGridPoly = new Rectangle2D.Double();
        this.propGridPoly = new Path2D.Double();
    }

    public void fillContinents(boolean b) {
        this.fillContinents = b;
    }

    public void setGridOverlays(List<Rectangle2D.Double> overlays) {
        this.gridOverlays = new ArrayList<Shape>(overlays.size());
        for (Rectangle2D.Double r : overlays) {
            this.gridOverlays.add(worldToUser.createTransformedShape(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        this.windowExtents = this.getWindowExtents();
        if (mSourceImage != null) {
            g2.drawImage(mSourceImage, this.imageTransform, this);
        }
        g2.setStroke(stroke);
        if (this.plotLand) {
            g2.setColor(this.landColor);
            for (Area area : this.landMasses) {
                if (!area.intersects(this.windowExtents)) continue;
                g2.fill(this.imageTransform.createTransformedShape(worldToUser.createTransformedShape(area)));
            }
        }
        if (this.plotBorders) {
            g2.setStroke(borderStroke);
            g2.setColor(this.borderColor);
            for (LandMass landMass : this.massesBorder) {
                g2.draw(this.imageTransform.createTransformedShape(landMass));
            }
        }
        if (this.plotShapes) {
            for (Shape shape : this.shapes.keySet()) {
                g2.setColor(this.shapes.get(shape));
                if (!shape.intersects(this.windowExtents)) continue;
                g2.fill(this.imageTransform.createTransformedShape(worldToUser.createTransformedShape(shape)));
            }
        }
        g2.setFont(this.font);
        if (this.drawSources) {
            ArrayList<UnitSource> arrayList = this.boxes;
            synchronized (arrayList) {
                if (!this.boxes.isEmpty()) {
                    int n = this.boxes.get(0).getRGB();
                    Color boxColor = new Color(n);
                    Composite composite = g2.getComposite();
                    for (UnitSource us : this.boxes) {
                        int n2;
                        if (us.getNameLetter().equals("c") || us.getNameLetter().equals("d")) {
                            g2.setStroke(us.getHighlight() ? dashed_hl : dashed);
                        } else {
                            g2.setStroke(us.getHighlight() ? stroke_hl : stroke);
                        }
                        if (us.isActive()) {
                            g2.setColor(us.isCropped() ? Color.GREEN : Color.RED);
                            g2.setComposite(alphaComposite);
                            g2.fill(this.imageTransform.createTransformedShape(us));
                            g2.setComposite(composite);
                        }
                        if (n2 != us.getRGB()) {
                            n2 = us.getRGB();
                            boxColor = new Color(n2);
                        }
                        if (us.getHighlight()) {
                            g2.setColor(Color.BLACK);
                        } else {
                            g2.setColor(boxColor);
                        }
                        g2.draw(this.imageTransform.createTransformedShape(us));
                    }
                }
            }
        }
        if (this.gridOverlays != null) {
            Composite composite = g2.getComposite();
            g2.setColor(Color.BLACK);
            g2.setComposite(AlphaComposite.getInstance(3, 0.75f));
            for (Shape sh : this.gridOverlays) {
                g2.draw(this.imageTransform.createTransformedShape(sh));
            }
            g2.setComposite(composite);
        }
        if (this.drawSites) {
            g2.setColor(aGridColor);
            this.aGridPolyTrans = this.imageTransform.createTransformedShape(this.aGridPoly);
            g2.draw(this.aGridPolyTrans);
            try {
                this.rectDouble = (Rectangle2D.Double)this.aGridPolyTrans.getBounds2D();
                g2.drawString(this.siteName + " A-Grid", (float)this.rectDouble.x + 0.05f * (float)this.rectDouble.width, (float)this.rectDouble.y + 0.95f * (float)this.rectDouble.height);
            }
            catch (ClassCastException e) {
                this.rectFloat = (Rectangle2D.Float)this.aGridPolyTrans.getBounds2D();
                g2.drawString(this.siteName + " A-Grid", this.rectFloat.x + 0.05f * this.rectFloat.width, this.rectFloat.y + 0.95f * this.rectFloat.height);
            }
            g2.setColor(bGridColor);
            g2.draw(this.imageTransform.createTransformedShape(this.bGridPoly));
            g2.setColor(cGridColor);
            g2.draw(this.imageTransform.createTransformedShape(this.cGridPoly));
            g2.setColor(propGridColor);
            g2.draw(this.imageTransform.createTransformedShape(this.propGridPoly));
        }
        if (this.drawGrids) {
            LinkedHashSet<PropGrid> e = this.propGridSet;
            synchronized (e) {
                for (PropGrid pg : this.propGridSet) {
                    g2.setColor(new Color(pg.getRGB()));
                    g2.draw(this.imageTransform.createTransformedShape(pg));
                }
            }
        }
        if (this.plotBuoys) {
            Point2D.Double Pt = new Point2D.Double();
            for (Buoy b : this.buoys) {
                if (b.hasData()) {
                    g2.setColor(darkGreen);
                    g2.fill(this.imageTransform.createTransformedShape(b.getUserCircle()));
                }
                if (b.isSelected()) {
                    g2.setColor(lightGreen);
                    g2.fill(this.imageTransform.createTransformedShape(b.getUserCircle()));
                }
                g2.setColor(Color.WHITE);
                g2.draw(this.imageTransform.createTransformedShape(b.getUserCircle()));
                this.imageTransform.transform(b.getUserPt(), Pt);
                g2.drawString(b.getStationID(), (float)Pt.x, (float)Pt.y);
            }
        }
        if (this.rubberBanding && this.rubberRectDraw != null) {
            g2.setColor(rubberColor);
            g2.draw(this.rubberRectDraw);
        }
        if (this.plotMark) {
            g2.setColor(this.markColor);
            this.mark.paintMark(g2, (int)this.epiLocDisplay.x, (int)this.epiLocDisplay.y);
            double radius = 14.0 / this.zoomLevelToScale(this.zoomLevel);
            this.epicenter.setRaDius(radius);
            g2.setColor(Color.YELLOW);
            g2.fill(this.imageTransform.createTransformedShape(this.epicenter));
            g2.setColor(Color.BLACK);
            g2.setStroke(thinStroke);
            g2.draw(this.imageTransform.createTransformedShape(this.epicenter));
        }
        if (this.useCities) {
            double radius = 8.0 / this.zoomLevelToScale(this.zoomLevel);
            Point2D.Double Pt = new Point2D.Double();
            g2.setColor(this.cityColor);
            g2.setFont(this.cityFont);
            int count = 0;
            for (City city : this.cities) {
                city.setRadius(radius);
                Pt.x = city.getLon();
                Pt.y = city.getLat();
                if (!this.windowExtents.contains(Pt)) continue;
                this.imageTransform.transform(city.getUserPt(), Pt);
                g2.fill(this.imageTransform.createTransformedShape(city.getUserCircle()));
                g2.drawString(city.getName(), (float)Pt.x, (float)Pt.y);
                if (++count <= 15) continue;
                break;
            }
        }
        if (this.useCountries && this.zoomLevel > 11) {
            g2.setColor(this.countryColor);
            g2.setFont(this.countryFont);
            FontMetrics metrics = g2.getFontMetrics(this.countryFont);
            Point2D.Float float_ = new Point2D.Float();
            for (Map.Entry<String, Point2D> e : this.countryNameMap.entrySet()) {
                this.imageTransform.transform(e.getValue(), float_);
                g2.drawString(e.getKey(), float_.x - (float)(metrics.stringWidth(e.getKey()) / 2), float_.y);
            }
        }
        if (this.plotTravelTimes) {
            g2.setColor(Color.BLACK);
            g2.setStroke(stroke);
            for (GeneralPath p : this.travelTimePaths) {
                g2.draw(this.imageTransform.createTransformedShape(p));
            }
        }
        if (this.plotGraticules) {
            g2.setColor(Color.RED);
            g2.draw(this.imageTransform.createTransformedShape(this.grats));
        }
        g2.setColor(Color.BLACK);
        g2.setStroke(thinstroke);
        g2.draw(zoomInRect);
        g2.draw(zoomOutRect);
        g2.draw(panUpRect);
        g2.draw(panLeftRect);
        g2.draw(panRightRect);
        g2.draw(panDownRect);
        g2.drawImage(biPanUp, null, 10, 10);
        g2.drawImage(biPanLeft, null, 1, 30);
        g2.drawImage(biPanRight, null, 19, 30);
        g2.drawImage(biPanDown, null, 10, 50);
        g2.drawImage(biZoomIn, null, 10, 80);
        g2.drawImage(biZoomOut, null, 10, 100);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void drawSources(boolean b) {
        this.drawSources = b;
    }

    public void clearBackgroundImage() {
        mSourceImage = null;
    }

    public void setBackgroundImage(URL imageUrl, Rectangle2D.Double rec) {
        if (imageUrl == null || !imageUrl.equals(backgroundImage)) {
            log.log(Level.INFO, "Setting background image");
            backgroundImage = imageUrl;
            mImageCoordinates = rec;
            mSourceImage = null;
            try {
                mSourceImage = this.loadBackgroundImage();
            }
            catch (IOException ex) {
                log.log(Level.SEVERE, null, ex);
                backgroundImage = null;
            }
        }
    }

    public void setBackgroundImage(Image im, Rectangle2D.Double rec) {
        mSourceImage = this.writeImageToBuffer(im);
        mImageCoordinates = rec;
    }

    private BufferedImage loadBackgroundImage() throws IOException {
        MediaTracker tracker = new MediaTracker(this);
        log.log(Level.INFO, "loading image: " + backgroundImage.toString());
        BufferedImage mFileImage = ImageIO.read(backgroundImage.openStream());
        tracker.addImage(mFileImage, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex.toString());
        }
        return this.writeImageToBuffer(mFileImage);
    }

    private BufferedImage writeImageToBuffer(Image fileImage) {
        BufferedImage img = null;
        imageWidth = fileImage.getWidth(this);
        imageHeight = fileImage.getHeight(this);
        log.info("w:" + imageWidth + " h:" + imageHeight);
        img = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D big = img.createGraphics();
        big.drawImage(fileImage, 0, 0, this);
        double sx = (double)imageWidth / mImageCoordinates.getWidth();
        double sy = (double)(-imageHeight) / mImageCoordinates.getHeight();
        worldToUser = new AffineTransform(sx, 0.0, 0.0, sy, -mImageCoordinates.getX() * sx, -(mImageCoordinates.getY() + mImageCoordinates.getHeight()) * sy);
        return img;
    }

    public void setLogger(Logger l) {
        log = l;
    }

    public Image getImage() {
        return mSourceImage;
    }

    public void plotMarkOn() {
        this.plotMark = true;
    }

    public void plotMarkOff() {
        this.plotMark = false;
    }

    public void setMark(int m) {
        this.mark.setMark(m);
    }

    public void setMarkSize(double s) {
        this.mark.setMarkHeightP(s);
    }

    public void setMarkColor(Color c) {
        this.markColor = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoxesColor(Color c) {
        ArrayList<UnitSource> arrayList = this.boxes;
        synchronized (arrayList) {
            for (UnitSource us : this.boxes) {
                us.setRGB(c.getRGB());
            }
        }
    }

    public void setBorders(URL url) {
        this.massesBorder = GSHHSReader.readIt(url, true);
        for (LandMass lm : this.massesBorder) {
            lm.transformPoints(worldToUser);
        }
        this.repaint();
    }

    public void plotBorders(boolean b) {
        this.plotBorders = b;
        this.repaint();
    }

    public void removeBorders() {
        this.massesBorder = new ArrayList();
        this.repaint();
    }

    public void addLandMass(File f, int zoomLimit) throws IOException {
        log.info("Loading tiled GSHHS land masses in netcdf format from file: " + f.getPath());
        ArrayList<Area> lma = GSHHSReader.getTileAreas(f);
        log.fine("Number of land masses in file: " + lma.size());
        this.landMassesLOD.put(zoomLimit, lma);
        this.setLandMassLOD();
        this.plotLand = true;
        this.repaint();
    }

    public void setLandMasses(TreeMap<Integer, ArrayList<Area>> lm) {
        this.landMassesLOD = lm;
        this.plotLand = true;
    }

    public TreeMap<Integer, ArrayList<Area>> getLandMasses() {
        return this.landMassesLOD;
    }

    public void plotLandMass(boolean b) {
        this.plotLand = b;
        this.setLandMassLOD();
        this.repaint();
    }

    public void setLandMassLOD() {
        if (this.landMassesLOD.size() > 0) {
            int lodUse = this.landMassesLOD.keySet().iterator().next();
            for (Integer zl : this.landMassesLOD.keySet()) {
                if (this.zoomLevel < zl) continue;
                lodUse = zl;
            }
            log.info("using LOD: " + lodUse);
            this.landMasses = this.landMassesLOD.get(lodUse);
        }
    }

    public void setLandMass(URL url) {
        this.massesCoast = GSHHSReader.readIt(url, false);
        for (LandMass lm : this.massesCoast) {
            lm.transformPoints(worldToUser);
        }
        this.repaint();
    }

    public void removeLandMass() {
        this.massesCoast = new ArrayList();
        this.repaint();
    }

    public void addShape(Shape s, Color c) {
        this.shapes.put(s, c);
    }

    public void clearShapes() {
        this.shapes.clear();
    }

    public void plotShapes(boolean b) {
        this.plotShapes = b;
    }

    private void loadCountries() throws IOException {
        block18: {
            this.countryNameMap = new HashMap();
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("images/CountryLabels.csv")));
                Throwable throwable = null;
                block13: while (true) {
                    try {
                        String line;
                        while ((line = br.readLine()) != null) {
                            String[] sa = line.split(",");
                            try {
                                float lon = Float.parseFloat(sa[1]);
                                float lat = Float.parseFloat(sa[2]);
                                Point2D.Float Pt = new Point2D.Float(lon, lat);
                                worldToUser.transform(Pt, Pt);
                                this.countryNameMap.put(sa[0], Pt);
                                continue block13;
                            }
                            catch (NumberFormatException numberFormatException) {
                            }
                        }
                        break block18;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (br != null) {
                        if (throwable != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            br.close();
                        }
                    }
                }
            }
            catch (IOException ioe) {
                log.log(Level.WARNING, "Can't load Country Names from CountryNames.csv", ioe);
            }
        }
    }

    public void useCountries(boolean useCountries) {
        try {
            this.useCountries = useCountries;
            if (this.countryNameMap == null) {
                this.loadCountries();
            }
            this.repaint();
        }
        catch (IOException ioe) {
            log.warning("Error loading country file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCities() throws IOException {
        this.cities = new ArrayList();
        String citiesFilename = "cities5000strip.txt.gz";
        try (InputStream is = null;){
            String line;
            is = this.getClass().getResourceAsStream("images/" + citiesFilename);
            if (is == null) {
                throw new IOException("cities file: " + citiesFilename + "  not found");
            }
            is = new GZIPInputStream(is);
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            this.cities.clear();
            while ((line = br.readLine()) != null) {
                String[] lineArr = line.split(",");
                try {
                    double pop = Double.parseDouble(lineArr[5]);
                    City city = new City(lineArr[0], Double.parseDouble(lineArr[1]), Double.parseDouble(lineArr[2]), lineArr[3], lineArr[4], pop);
                    Point2D.Double Pt = new Point2D.Double(city.getLon(), city.getLat());
                    worldToUser.transform(Pt, Pt);
                    city.setUserPt(Pt);
                    this.cities.add(city);
                }
                catch (NumberFormatException nfe) {
                    log.warning("error parsing city: " + line);
                }
            }
            Collections.sort(this.cities);
            log.info("number of cities: " + this.cities.size());
        }
    }

    public void useCities(boolean useCities) {
        try {
            this.useCities = useCities;
            if (this.cities == null) {
                this.loadCities();
            }
            this.repaint();
        }
        catch (IOException ioe) {
            log.warning("Error loading cities file.");
        }
    }

    private double getPopLim() {
        if (this.zoomLevel > 13) {
            return 0.0;
        }
        if (this.zoomLevel > 12) {
            return 200000.0;
        }
        if (this.zoomLevel > 11) {
            return 750000.0;
        }
        if (this.zoomLevel > 10) {
            return 2000000.0;
        }
        return 5000000.0;
    }

    public void addTravelTime(GeneralPath[] tt2) {
        for (GeneralPath aPath : this.travelTimePaths = tt2) {
            aPath.transform(worldToUser);
        }
    }

    public void showTravelTime(boolean b) {
        this.plotTravelTimes = b;
    }

    public void showGraticules(boolean b) {
        this.plotGraticules = b;
        if (this.plotGraticules && this.grats == null) {
            this.grats = new GeneralPath(0);
            this.grats.moveTo(180.0, -90.0);
            this.grats.lineTo(180.0, 90.0);
            this.grats.moveTo(0.0, 0.0);
            this.grats.lineTo(360.0, 0.0);
            this.grats.transform(worldToUser);
        }
    }

    public int addPropGrid(PropGrid propGrid) {
        if (this.propGridSet.contains(propGrid)) {
            for (PropGrid pg : this.propGridSet) {
                if (!pg.equals(propGrid)) continue;
                return pg.getRGB();
            }
        } else {
            propGrid.setTransform(worldToUser);
            this.propGridSet.add(propGrid);
        }
        return propGrid.getRGB();
    }

    public void clearPropGrids() {
        this.propGridSet.clear();
    }

    public void drawGrids(boolean dg) {
        this.drawGrids = dg;
        this.repaint();
    }

    public void setBackgroundBrightness(float scaleFactor, float offset) {
        RescaleOp brightnessOp = new RescaleOp(scaleFactor, offset, null);
        brightnessOp.filter(mSourceImage, mSourceImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActiveSingle(String sn) {
        ArrayList<UnitSource> arrayList = this.boxes;
        synchronized (arrayList) {
            for (UnitSource aSource : this.boxes) {
                aSource.setActive(false);
                if (!aSource.getName().equals(sn)) continue;
                aSource.setActive(true);
                this.activeSource = aSource;
            }
            this.repaint();
        }
    }

    public void setActive(String sn) {
        for (UnitSource aSource : this.boxes) {
            if (!aSource.getName().equals(sn)) continue;
            aSource.setActive(!aSource.isActive());
        }
        this.repaint();
        this.fireActionPerformed(sn);
    }

    public UnitSource getActiveSingle() {
        for (UnitSource aSource : this.boxes) {
            if (!aSource.isActive()) continue;
            return aSource;
        }
        return null;
    }

    public void setActive(Collection<UnitSource> sv) {
        try {
            for (UnitSource aSource : this.boxes) {
                aSource.setActive(false);
                for (UnitSource inputSource : sv) {
                    if (!inputSource.getName().equals(aSource.getName())) continue;
                    aSource.setActive(true);
                    aSource.setAlpha(inputSource.getAlpha());
                    this.activeSource = aSource;
                }
            }
        }
        catch (ConcurrentModificationException cme) {
            this.waitSetActive(sv, 500L);
        }
        this.repaint();
    }

    private void waitSetActive(Collection<UnitSource> sv, long wait) {
        try {
            Thread.sleep(wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setActive(sv);
    }

    public void setActive(SourceCombo sc) {
        this.setActive(sc.getSources());
    }

    public List<UnitSource> getActive() {
        ArrayList<UnitSource> sv = new ArrayList<UnitSource>();
        for (UnitSource aSource : this.boxes) {
            if (!aSource.isActive()) continue;
            sv.add(aSource);
        }
        return sv;
    }

    public ArrayList<UnitSource> getSources() {
        return this.boxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSources(Collection<UnitSource> sources) {
        ArrayList<UnitSource> arrayList = this.boxes;
        synchronized (arrayList) {
            this.boxes.clear();
            this.boxes.addAll(sources);
            for (UnitSource aSource : this.boxes) {
                aSource.transformPoints(worldToUser);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSource(UnitSource updatedSource) {
        ArrayList<UnitSource> arrayList = this.boxes;
        synchronized (arrayList) {
            for (int i = 0; i < this.boxes.size(); ++i) {
                if (!this.boxes.get(i).getName().equals(updatedSource.getName())) continue;
                this.boxes.set(i, updatedSource);
            }
        }
        this.repaint();
    }

    public SourceCombo getActiveSourceCombo() {
        return new SourceCombo(this.getActive());
    }

    public void setEpicenter(double lon, double lat) {
        this.epiLocImage.x = lon;
        this.epiLocImage.y = lat;
        worldToUser.transform(this.epiLocImage, this.epiLocImage);
        this.imageTransform.transform(this.epiLocImage, this.epiLocDisplay);
        Point2D.Double pt = new Point2D.Double(lon, lat);
        worldToUser.transform(pt, pt);
        this.epicenter = new StarShape(pt.x, pt.y, 0.5, 0.25, 5, 0.3141592653589793);
        this.repaint();
    }

    public void setMode(int m) {
        this.selectMode = m;
    }

    public UnitSource getMostRecentlyClicked() {
        return this.mostRecentlyClicked;
    }

    public void setMostRecentlyClicked(UnitSource us) {
        this.mostRecentlyClicked = us;
    }

    public void clearUnitSources() {
        this.boxes.clear();
        log.info("cleared all unit sources");
        this.repaint();
    }

    public void sortSourcesByName() {
        Collections.sort(this.boxes);
    }

    public Range2D getRegion() {
        return this.getRegion(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public Range2D getRegion(double x0, double y0, double x1, double y1) {
        double[] ul = new double[]{x0, y0, x1, y1};
        try {
            this.imageTransform.inverseTransform(ul, 0, ul, 0, 2);
            worldToUser.inverseTransform(ul, 0, ul, 0, 2);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        return new Range2D(ul[0], ul[3], ul[2] - ul[0], ul[1] - ul[3]);
    }

    public Rectangle2D.Double getWindowExtents() {
        Point2D ul = new Point2D.Double(0.0, 0.0);
        Point2D lr = new Point2D.Double(this.getWidth(), this.getHeight());
        try {
            ul = this.imageTransform.inverseTransform(ul, null);
            ul = worldToUser.inverseTransform(ul, null);
            lr = this.imageTransform.inverseTransform(lr, null);
            lr = worldToUser.inverseTransform(lr, null);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        return new Rectangle2D.Double(ul.getX(), lr.getY(), lr.getX() - ul.getX(), ul.getY() - lr.getY());
    }

    public void zoomTo(double minLon, double maxLon, double minLat, double maxLat) {
        Point2D.Double minPt = new Point2D.Double(minLon, minLat);
        Point2D.Double maxPt = new Point2D.Double(maxLon, maxLat);
        worldToUser.transform(minPt, minPt);
        worldToUser.transform(maxPt, maxPt);
        double deltaLon = maxPt.x - minPt.x;
        double deltaLat = minPt.y - maxPt.y;
        double scaleX = (double)this.getWidth() / deltaLon;
        double scaleY = (double)this.getHeight() / deltaLat;
        double scale = 1.0;
        scale = scaleX >= scaleY ? scaleY : scaleX;
        this.imageTransform.setToScale(scale, scale);
        if (scaleX == scaleY) {
            this.imageTransform.translate(-minPt.x, -maxPt.y);
        } else if (scaleX > scaleY) {
            this.imageTransform.translate(-(minPt.x - ((double)this.getWidth() / scaleY - deltaLon) / 2.0), -maxPt.y);
        } else {
            this.imageTransform.translate(-minPt.x, -(maxPt.y - ((double)this.getHeight() / scaleX - deltaLat) / 2.0));
        }
        this.zoomLevel = this.scaleToZoomLevel(scale);
        this.setLandMassLOD();
        this.imageTransform.transform(this.epiLocImage, this.epiLocDisplay);
        this.firePropertyChange("region", null, null);
        this.repaint();
    }

    public void zoomTo(double lon, double lat) {
        Point2D.Double Pt = new Point2D.Double(lon, lat);
        worldToUser.transform(Pt, Pt);
        double scale = this.zoomLevelToScale(this.zoomLevel);
        Pt.x -= 1.0 / scale * (double)this.getWidth() / 2.0;
        Pt.y -= 1.0 / scale * (double)this.getHeight() / 2.0;
        this.imageTransform.setToScale(scale, scale);
        this.imageTransform.translate(-Pt.x, -Pt.y);
        this.imageTransform.transform(this.epiLocImage, this.epiLocDisplay);
        this.setLandMassLOD();
        this.firePropertyChange("region", null, null);
        this.repaint();
    }

    public void zoomToFull() {
        this.zoomTo(mImageCoordinates.getMinX(), mImageCoordinates.getMaxX(), mImageCoordinates.getMinY(), mImageCoordinates.getMaxY());
        this.repaint();
    }

    private void zoom(double scale) {
        double dw = (double)this.getWidth() / 2.0;
        double dh = (double)this.getHeight() / 2.0;
        double sx = this.imageTransform.getScaleX();
        double sy = this.imageTransform.getScaleY();
        this.imageTransform.preConcatenate(AffineTransform.getTranslateInstance(-dw, -dh));
        this.imageTransform.preConcatenate(AffineTransform.getScaleInstance(1.0 / sx, 1.0 / sy));
        this.imageTransform.preConcatenate(AffineTransform.getScaleInstance(scale, scale));
        this.imageTransform.preConcatenate(AffineTransform.getTranslateInstance(dw, dh));
        this.imageTransform.transform(this.epiLocImage, this.epiLocDisplay);
        this.zoomLevel = this.scaleToZoomLevel(scale);
        log.info("zoom level: " + this.zoomLevel + " of " + this.maxZoomLevel);
        this.setLandMassLOD();
        this.firePropertyChange("region", null, null);
        this.repaint();
    }

    public void zoom(int lvl) {
        if (lvl < 1) {
            lvl = 1;
        }
        if (lvl > this.maxZoomLevel) {
            lvl = this.maxZoomLevel;
        }
        this.zoomLevel = lvl;
        this.zoom(this.zoomLevelToScale(this.zoomLevel));
    }

    public void zoomIn() {
        ++this.zoomLevel;
        if (this.zoomLevel > this.maxZoomLevel) {
            this.zoomLevel = this.maxZoomLevel;
            return;
        }
        this.zoom(this.zoomLevel);
    }

    public void zoomOut() {
        --this.zoomLevel;
        if (this.zoomLevel < this.minZoomLevel) {
            this.zoomLevel = this.minZoomLevel;
            return;
        }
        this.zoom(this.zoomLevel);
    }

    public void setMaxZoomLevel(int zl) {
        this.maxZoomLevel = zl;
        this.zoomMidPt = (int)Math.ceil((double)(this.maxZoomLevel - this.minZoomLevel) / 2.0);
    }

    public int getMaxZoomLevel() {
        return this.maxZoomLevel;
    }

    public void setMinZoomLevel(int zl) {
        this.minZoomLevel = zl;
        this.zoomMidPt = (int)Math.ceil((double)(this.maxZoomLevel - this.minZoomLevel) / 2.0);
    }

    public int getMinZoomLevel() {
        return this.minZoomLevel;
    }

    private int scaleToZoomLevel(double s) {
        int result = (int)Math.rint(Math.log(s) / Math.log(1.5)) + this.zoomMidPt;
        if (result > this.maxZoomLevel) {
            result = this.maxZoomLevel;
        }
        if (result < this.minZoomLevel) {
            result = this.minZoomLevel;
        }
        this.font = new Font("Arial", 0, result * 2);
        return result;
    }

    private double zoomLevelToScale(int zl) {
        this.font = new Font("Arial", 0, zl * 2);
        double scale = zl - this.zoomMidPt;
        return Math.pow(1.5, scale);
    }

    private void pan(int x, int y) {
        Point2D xy = null;
        Point2D lxy = null;
        try {
            xy = this.imageTransform.inverseTransform(new Point(x, y), xy);
            lxy = this.imageTransform.inverseTransform(new Point(this.lastX, this.lastY), lxy);
            this.imageTransform.translate(xy.getX() - lxy.getX(), xy.getY() - lxy.getY());
            this.imageTransform.transform(this.epiLocImage, this.epiLocDisplay);
            if (this.rubberRectDraw != null) {
                this.rubberRectDraw.x += (double)(x - this.lastX);
                this.rubberRectDraw.y += (double)(y - this.lastY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    private void panRight() {
        int x = this.lastX - 15;
        int y = this.lastY;
        this.lastPan = 1;
        this.pan(x, y);
    }

    private void panLeft() {
        int x = this.lastX + 15;
        int y = this.lastY;
        this.lastPan = 2;
        this.pan(x, y);
    }

    private void panUp() {
        int x = this.lastX;
        int y = this.lastY + 15;
        this.lastPan = 3;
        this.pan(x, y);
    }

    private void panDown() {
        int x = this.lastX;
        int y = this.lastY - 15;
        this.lastPan = 4;
        this.pan(x, y);
    }

    private void repeatPan() {
        switch (this.lastPan) {
            case 1: {
                this.panRight();
                break;
            }
            case 2: {
                this.panLeft();
                break;
            }
            case 3: {
                this.panUp();
                break;
            }
            case 4: {
                this.panDown();
                break;
            }
            default: {
                log.warning(Integer.toString(this.lastPan));
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String sn) {
        Object[] listeners = this.actionListenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = sn;
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public void drawSitesOn() {
        this.drawSites = true;
    }

    public void drawSitesOff() {
        this.drawSites = false;
    }

    private Rectangle2D.Double setGrid(Point2D.Double[] Pts) {
        Rectangle2D.Double gridPoly = new Rectangle2D.Double();
        Point2D.Double Pt = new Point2D.Double();
        for (int i = 0; i < Pts.length; ++i) {
            Pt.x = Pts[i].x;
            Pt.y = Pts[i].y;
            worldToUser.transform(Pt, Pt);
            Pts[i].x = Pt.x;
            Pts[i].y = Pt.y;
        }
        gridPoly.x = Pts[3].x;
        gridPoly.y = Pts[3].y;
        gridPoly.width = Pts[1].x - Pts[0].x;
        gridPoly.height = Pts[1].y - Pts[2].y;
        return gridPoly;
    }

    public void setGridA(Point2D.Double[] Pts, String sn) {
        this.siteName = sn;
        this.aGridPoly = this.setGrid(Pts);
        this.repaint();
    }

    public void setGridB(Point2D.Double[] Pts, String sn) {
        this.siteName = sn;
        this.bGridPoly = this.setGrid(Pts);
        this.repaint();
    }

    public void setGridC(Point2D.Double[] Pts, String sn) {
        this.siteName = sn;
        this.cGridPoly = this.setGrid(Pts);
        this.repaint();
    }

    public void setGrid0(Rectangle2D r) {
        this.propGridPoly = worldToUser.createTransformedShape(r);
        this.repaint();
    }

    void setBuoyLocs(List<Buoy> v) {
        this.buoys = v;
        for (Buoy b : this.buoys) {
            Point2D.Double Pt = new Point2D.Double(b.getLongitude(), b.getLatitude());
            worldToUser.transform(Pt, Pt);
            b.setUserPt(Pt);
        }
        this.repaint();
    }

    void plotBuoyLocsOn() {
        if (this.buoys == null) {
            log.warning("EventEditor: call setBuoyLocs(Vector) before calling plotBuoyLocsOn()");
            this.plotBuoys = false;
            return;
        }
        this.plotBuoys = true;
        this.repaint();
    }

    public Point2D getPointerLocation() {
        return this.pointerLocation;
    }

    private void updatePointerLocation(int x, int y) {
        if (x == Integer.MIN_VALUE) {
            this.pointerLocation = null;
        } else {
            if (this.pointerLocation == null) {
                this.pointerLocation = new Point2D.Double(x, y);
            } else {
                this.pointerLocation.x = x;
                this.pointerLocation.y = y;
            }
            try {
                this.imageTransform.inverseTransform(this.pointerLocation, this.pointerLocation);
                worldToUser.inverseTransform(this.pointerLocation, this.pointerLocation);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        this.firePropertyChange("pointerLocation", null, this.pointerLocation);
    }

    public boolean isRubberbanding() {
        return this.rubberBanding;
    }

    public void setRubberbanding(boolean b) {
        this.rubberBanding = b;
    }

    public Range2D getRubberbandRegion() {
        return this.rubberRectDraw != null ? this.getRegion(this.rubberRectDraw.x, this.rubberRectDraw.y, this.rubberRectDraw.width + this.rubberRectDraw.x, this.rubberRectDraw.height + this.rubberRectDraw.y) : null;
    }

    public void setRubberbandRegion(double minlon, double maxlon, double minlat, double maxlat) {
        Point2D.Double ll = new Point2D.Double(minlon, minlat);
        Point2D.Double ur = new Point2D.Double(maxlon, maxlat);
        worldToUser.transform(ur, ur);
        worldToUser.transform(ll, ll);
        this.imageTransform.transform(ur, ur);
        this.imageTransform.transform(ll, ll);
        this.rubberRectDraw = new Rectangle2D.Double(ll.x, ll.y, ur.x - ll.x, ur.y - ll.y);
        this.flipRect(this.rubberRectDraw);
        this.rubberBanding = true;
        this.repaint();
    }

    public void flipRect(Rectangle2D.Double re) {
        if (re.width < 0.0) {
            re.x += re.width;
            re.width *= -1.0;
        }
        if (re.height < 0.0) {
            re.y += re.height;
            re.height *= -1.0;
        }
    }

    void plotBuoyLocsOff() {
        this.plotBuoys = false;
        this.repaint();
    }

    private void fireBuoyChange(Buoy oldbuoy, Buoy newbuoy) {
        this.firePropertyChange("buoy", oldbuoy, newbuoy);
    }

    public void destroy() {
        mSourceImage = null;
    }

    static {
        thickstroke = new BasicStroke(2.0f, 2, 1);
        stroke = new BasicStroke(1.8f, 2, 1);
        stroke_hl = new BasicStroke(4.0f, 2, 1);
        thinstroke = new BasicStroke(0.5f);
        dash1 = new float[]{2.0f};
        dashed = new BasicStroke(1.8f, 0, 0, 2.0f, dash1, 0.0f);
        dashed_hl = new BasicStroke(4.0f, 0, 0, 2.0f, dash1, 0.0f);
        daskedStroke = new BasicStroke(0.5f, 2, 1, 10.0f, new float[]{3.0f}, 10.0f);
        thinStroke = new BasicStroke(0.5f);
        borderStroke = new BasicStroke(1.5f, 2, 1);
        aGridColor = new Color(109, 254, 65);
        bGridColor = new Color(239, 254, 70);
        cGridColor = new Color(254, 62, 51);
        propGridColor = new Color(245, 202, 81);
        lightGreen = new Color(51, 255, 0);
        darkGreen = new Color(102, 153, 0);
        ColorTan = new Color(245, 202, 81);
        alphaComposite = AlphaComposite.getInstance(3, 0.55f);
        rubberColor = new Color(200, 200, 200);
    }

    private class MapMouseMotionListener
    extends MouseMotionAdapter {
        private MapMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (MapCanvas.this.rubberBanding) {
                ((MapCanvas)MapCanvas.this).rubberRectDraw.width = (double)x - ((MapCanvas)MapCanvas.this).rubberRectDraw.x;
                ((MapCanvas)MapCanvas.this).rubberRectDraw.height = (double)y - ((MapCanvas)MapCanvas.this).rubberRectDraw.y;
                MapCanvas.this.flipRect(MapCanvas.this.rubberRectDraw);
                MapCanvas.this.repaint();
            } else {
                MapCanvas.this.pan(x, y);
                MapCanvas.this.dragTriggered = true;
            }
            MapCanvas.this.lastX = x;
            MapCanvas.this.lastY = y;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MapCanvas.this.updatePointerLocation(e.getX(), e.getY());
            if (MapCanvas.this.rubberBanding || MapCanvas.this.dragTriggered) {
                return;
            }
            if (MapCanvas.this.drawSources) {
                Point2D.Double Pt = new Point2D.Double(e.getX(), e.getY());
                try {
                    MapCanvas.this.imageTransform.inverseTransform(Pt, Pt);
                }
                catch (NoninvertibleTransformException ex) {
                    ex.printStackTrace();
                }
                for (UnitSource aSource : MapCanvas.this.boxes) {
                    aSource.setHighlight(false);
                    if (!aSource.contains(Pt)) continue;
                    aSource.setHighlight(true);
                    MapCanvas.this.fireActionPerformed(aSource.getName());
                }
                MapCanvas.this.repaint();
            }
        }
    }

    private class MapMouseListener
    extends MouseAdapter
    implements MouseWheelListener {
        public SourceInfoFrame sourceInfoWindow = null;

        private MapMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MapCanvas.this.requestFocusInWindow();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MapCanvas.this.updatePointerLocation(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MapCanvas.this.dragTriggered) {
                MapCanvas.this.firePropertyChange("region", null, null);
                MapCanvas.this.dragTriggered = false;
                return;
            }
            if (MapCanvas.this.panTimer.isRunning()) {
                MapCanvas.this.panTimer.stop();
                MapCanvas.this.firePropertyChange("region", null, null);
                return;
            }
            if (MapCanvas.this.rubberBanding) {
                MapCanvas.this.rubberBanding = false;
                MapCanvas.this.firePropertyChange("rubberbandRegion", null, MapCanvas.this.getRubberbandRegion());
                MapCanvas.this.repaint();
                return;
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MapCanvas.this.lastX = e.getX();
            MapCanvas.this.lastY = e.getY();
            MapCanvas.this.dragTriggered = false;
            MapCanvas.this.rubberBanding = false;
            if (this.sourceInfoWindow != null) {
                this.sourceInfoWindow.setVisible(false);
                this.sourceInfoWindow.dispose();
                this.sourceInfoWindow = null;
                MapCanvas.this.repaint();
            }
            if ((e.getModifiersEx() & 0x40) == 64) {
                ((MapCanvas)MapCanvas.this).rubberRectDraw.x = e.getX();
                ((MapCanvas)MapCanvas.this).rubberRectDraw.y = e.getY();
                ((MapCanvas)MapCanvas.this).rubberRectDraw.width = 0.01;
                ((MapCanvas)MapCanvas.this).rubberRectDraw.height = 0.01;
                MapCanvas.this.rubberBanding = true;
                return;
            }
            Point2D.Double Pt = new Point2D.Double(e.getX(), e.getY());
            if (zoomInRect.contains(Pt)) {
                MapCanvas.this.zoomIn();
                return;
            }
            if (zoomOutRect.contains(Pt)) {
                MapCanvas.this.zoomOut();
                return;
            }
            if (panUpRect.contains(Pt)) {
                MapCanvas.this.panUp();
                MapCanvas.this.panTimer.start();
                return;
            }
            if (panDownRect.contains(Pt)) {
                MapCanvas.this.panDown();
                MapCanvas.this.panTimer.start();
                return;
            }
            if (panLeftRect.contains(Pt)) {
                MapCanvas.this.panLeft();
                MapCanvas.this.panTimer.start();
                return;
            }
            if (panRightRect.contains(Pt)) {
                MapCanvas.this.panRight();
                MapCanvas.this.panTimer.start();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point2D.Double Pt = new Point2D.Double(e.getX(), e.getY());
            if (e.isControlDown() || e.isPopupTrigger()) {
                try {
                    MapCanvas.this.imageTransform.inverseTransform(Pt, Pt);
                }
                catch (NoninvertibleTransformException ex) {
                    log.log(Level.WARNING, "Error getting transform", ex);
                    return;
                }
                for (UnitSource aSource : MapCanvas.this.boxes) {
                    if (!aSource.contains(Pt)) continue;
                    this.showSourceInfo(e, aSource);
                    break;
                }
                return;
            }
            if (e.getClickCount() == 2) {
                try {
                    MapCanvas.this.imageTransform.inverseTransform(Pt, Pt);
                }
                catch (NoninvertibleTransformException ex) {
                    log.log(Level.WARNING, "Error getting transform", ex);
                    return;
                }
                if (MapCanvas.this.plotBuoys) {
                    for (Buoy b : MapCanvas.this.buoys) {
                        if (!b.getUserCircle().contains(Pt)) continue;
                        Buoy oldbuoy = new Buoy();
                        b.setSelected(!b.isSelected());
                        MapCanvas.this.fireBuoyChange(oldbuoy, b);
                        MapCanvas.this.repaint();
                        return;
                    }
                }
                if (MapCanvas.this.drawSources) {
                    String name = null;
                    for (UnitSource aSource : MapCanvas.this.boxes) {
                        if (!aSource.contains(Pt)) continue;
                        MapCanvas.this.mostRecentlyClicked = aSource;
                        aSource.setActive(!aSource.isActive());
                        if (MapCanvas.this.selectMode == 0) {
                            if (MapCanvas.this.activeSource != null) {
                                MapCanvas.this.activeSource.setActive(false);
                            }
                            MapCanvas.this.activeSource = aSource.isActive() ? aSource : null;
                        }
                        MapCanvas.this.repaint();
                        name = aSource.getName();
                        break;
                    }
                    if (name != null) {
                        MapCanvas.this.fireActionPerformed(name);
                    }
                }
            }
        }

        private void showSourceInfo(MouseEvent e, UnitSource aSource) {
            if (this.sourceInfoWindow == null) {
                this.sourceInfoWindow = new SourceInfoFrame();
            }
            this.sourceInfoWindow.setSource(aSource);
            Point p = ((JComponent)e.getSource()).getLocationOnScreen();
            this.sourceInfoWindow.setLocation(p.x + e.getX(), p.y + e.getY());
            this.sourceInfoWindow.setVisible(true);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (this.sourceInfoWindow != null) {
                return;
            }
            int ticks = e.getWheelRotation();
            for (int i = 0; i < Math.abs(ticks); i += 2) {
                if (ticks < 0) {
                    MapCanvas.this.zoomIn();
                    continue;
                }
                if (ticks <= 0) continue;
                MapCanvas.this.zoomOut();
            }
        }
    }

    public class PolyPoints {
        double[] lons;
        double[] lats;

        public void setLons(double[] lons) {
            this.lons = lons;
        }

        public void addLons(double[] somelons) {
            if (this.lons == null) {
                this.setLons(somelons);
                return;
            }
            int aLen = this.lons.length;
            int bLen = somelons.length;
            double[] c = new double[aLen + bLen];
            System.arraycopy(this.lons, 0, c, 0, aLen);
            System.arraycopy(somelons, 0, c, aLen, bLen);
            this.lons = c;
        }

        public double[] getLons() {
            return this.lons;
        }

        public void setLats(double[] lats) {
            this.lats = lats;
        }

        public void addLats(double[] somelats) {
            if (this.lats == null) {
                this.setLats(somelats);
                return;
            }
            int aLen = this.lats.length;
            int bLen = somelats.length;
            double[] c = new double[aLen + bLen];
            System.arraycopy(this.lats, 0, c, 0, aLen);
            System.arraycopy(somelats, 0, c, aLen, bLen);
            this.lats = c;
        }

        public double[] getLats() {
            return this.lats;
        }
    }
}

