/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.geom.Point2D;
import java.util.ArrayList;

public final class MarchingSq {
    private static Direction direction;
    private static double threshold;

    private MarchingSq() {
    }

    public static boolean calculateContour(ArrayList<Point2D> contour, double[][] potentialArea, int step, double t) {
        boolean marched = false;
        direction = Direction.S;
        threshold = t;
        for (int x = 0; x < potentialArea.length && !marched; ++x) {
            double[] potLine = potentialArea[x];
            for (int y = 0; y < potLine.length && !marched; ++y) {
                if (!MarchingSq.test(potLine[y]) || MarchingSq.getState(potentialArea, x, y) == 15) continue;
                marched = MarchingSq.march(contour, potentialArea, x, y, step);
            }
        }
        return marched;
    }

    private static boolean march(ArrayList<Point2D> contour, double[][] potentialArea, int xpos, int ypos, int step) {
        int state;
        int x = xpos;
        int y = ypos;
        block15: while (true) {
            Point2D.Float p;
            if (contour.contains(p = new Point2D.Float((float)x * (float)step, (float)y * (float)step))) {
                if (contour.get(0).equals(p)) {
                    return true;
                }
            } else {
                contour.add(p);
            }
            state = MarchingSq.getState(potentialArea, x, y);
            switch (state) {
                case -1: {
                    throw new IllegalStateException("Marched out of bounds");
                }
                case 0: 
                case 2: 
                case 3: 
                case 7: {
                    direction = Direction.E;
                    break;
                }
                case 4: 
                case 12: 
                case 14: {
                    direction = Direction.W;
                    break;
                }
                case 6: {
                    direction = direction == Direction.N ? Direction.W : Direction.E;
                    break;
                }
                case 1: 
                case 5: 
                case 13: {
                    direction = Direction.N;
                    break;
                }
                case 9: {
                    direction = direction == Direction.E ? Direction.N : Direction.S;
                    break;
                }
                case 8: 
                case 10: 
                case 11: {
                    direction = Direction.S;
                    break;
                }
                default: {
                    throw new IllegalStateException("Marching squares invalid state: " + state);
                }
            }
            switch (direction) {
                case N: {
                    --y;
                    continue block15;
                }
                case S: {
                    ++y;
                    continue block15;
                }
                case W: {
                    --x;
                    continue block15;
                }
                case E: {
                    ++x;
                    continue block15;
                }
            }
            break;
        }
        throw new IllegalStateException("Marching squares invalid state: " + state);
    }

    private static boolean test(double test) {
        return test > threshold;
    }

    private static int getState(double[][] potentialArea, int x, int y) {
        int n;
        int dir = 0;
        try {
            dir += MarchingSq.test(potentialArea[x][y]) ? 1 : 0;
            dir += MarchingSq.test(potentialArea[x + 1][y]) ? 2 : 0;
            dir += MarchingSq.test(potentialArea[x][y + 1]) ? 4 : 0;
            n = MarchingSq.test(potentialArea[x + 1][y + 1]) ? 8 : 0;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.err.println("Marched out of bounds: " + x + " " + y + " bounds: " + potentialArea.length + " " + potentialArea[0].length);
            return -1;
        }
        return dir += n;
    }

    private static enum Direction {
        N,
        S,
        E,
        W;

    }
}

