/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.TopoShape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MarchingSquares {
    private final double epsilon = 1.0E-21;
    private double[] lons;
    private double[] lats;
    private double xPrev = 0.0;
    private double yPrev = 0.0;
    private int skipX = 1;
    private int skipY = 1;
    private int maxDimension = 400;
    private double level = 0.0;
    private HashMap<Double, ArrayList<TopoShape>> labels = new HashMap();
    public static Logger log = Logger.getLogger("gov.noaa.tsunami");

    public GeneralPath[] mkIsos(double[][] data, ArrayList<Double> levels) {
        this.labels.clear();
        double[][] dataP = this.padData(data);
        GeneralPath[] isos = new GeneralPath[levels.size()];
        try {
            for (int i = 0; i < levels.size(); ++i) {
                this.level = levels.get(i);
                this.labels.put(this.level, new ArrayList());
                IsoCell[][] contour = this.mkContour(dataP, levels.get(i));
                isos[i] = this.mkIso(contour, dataP, levels.get(i));
            }
        }
        catch (RuntimeException re) {
            log.log(Level.SEVERE, "Error calculating countours!", re);
        }
        return isos;
    }

    public void setAxes(double[] x, double[] y) {
        int i;
        int nLon = x.length;
        int nLat = y.length;
        this.skipX = 1;
        this.skipY = 1;
        while (nLon / this.skipX > this.maxDimension) {
            ++this.skipX;
        }
        while (nLat / this.skipY > this.maxDimension) {
            ++this.skipY;
        }
        log.fine("skipX: " + this.skipX + " skipY: " + this.skipY);
        this.lons = new double[(nLon - 1) / this.skipX + 1];
        this.lats = new double[(nLat - 1) / this.skipY + 1];
        for (i = 0; i < this.lons.length; ++i) {
            this.lons[i] = x[i * this.skipX];
        }
        for (i = 0; i < this.lats.length; ++i) {
            this.lats[i] = y[i * this.skipY];
        }
    }

    public String asciiPrintContours(double[][] data, double[] levels) {
        String s = "";
        double[][] dataP = this.padData(data);
        for (int i = 0; i < levels.length; ++i) {
            s = s + this.asciiContourPrint(this.mkContour(dataP, levels[i]));
            s = s + "\n";
        }
        return s;
    }

    private IsoCell[][] mkContour(double[][] data, double level) {
        int numRows = data.length;
        int numCols = data[0].length;
        IsoCell[][] contours = new IsoCell[numRows - 1][numCols - 1];
        for (int r = 0; r < numRows - 1; ++r) {
            for (int c = 0; c < numCols - 1; ++c) {
                int ll = data[r][c] > level ? 0 : 1;
                int lr = data[r][c + 1] > level ? 0 : 2;
                int ur = data[r + 1][c + 1] > level ? 0 : 4;
                int ul = data[r + 1][c] > level ? 0 : 8;
                int nInfo = ll | lr | ur | ul;
                boolean isFlipped = false;
                if (nInfo == 5 || nInfo == 10) {
                    double center = (data[r][c] + data[r][c + 1] + data[r + 1][c + 1] + data[r + 1][c]) / 4.0;
                    if (nInfo == 5 && center < level) {
                        isFlipped = true;
                    } else if (nInfo == 10 && center < level) {
                        isFlipped = true;
                    }
                }
                if (Double.isNaN(data[r][c]) || Double.isNaN(data[r][c + 1]) || Double.isNaN(data[r + 1][c + 1]) || Double.isNaN(data[r + 1][c])) {
                    nInfo = 15;
                }
                contours[r][c] = new IsoCell();
                contours[r][c].setFlipped(isFlipped);
                contours[r][c].setNeighborInfo(nInfo);
            }
        }
        return contours;
    }

    private GeneralPath mkIso(IsoCell[][] isoData, double[][] data, double threshold) {
        int c;
        int r;
        int numRows = isoData.length;
        int numCols = isoData[0].length;
        for (r = 0; r < numRows; ++r) {
            for (c = 0; c < numCols; ++c) {
                this.interpolateCrossing(isoData, data, r, c, threshold);
            }
        }
        GeneralPath isoPath = new GeneralPath(0);
        for (r = 0; r < numRows; ++r) {
            for (c = 0; c < numCols; ++c) {
                if (isoData[r][c].getNeighborInfo() == 0 || isoData[r][c].getNeighborInfo() == 5 || isoData[r][c].getNeighborInfo() == 10 || isoData[r][c].getNeighborInfo() == 15) continue;
                this.isoSubpath(isoData, r, c, isoPath);
            }
        }
        return isoPath;
    }

    private double getLon(int i, double offset) {
        if (i == 0 || i == 1) {
            return this.lons[0];
        }
        if (i == this.lons.length || i == this.lons.length - 1) {
            return this.lons[this.lons.length - 1];
        }
        return this.lons[i - 1] + (this.lons[i + 1] - this.lons[i]) * offset;
    }

    private double getLat(int i, double offset) {
        if (i == 0 || i == 1) {
            return this.lats[0];
        }
        if (i == this.lats.length || i == this.lats.length - 1) {
            return this.lats[this.lats.length - 1];
        }
        return this.lats[i - 1] + (this.lats[i + 1] - this.lats[i]) * offset;
    }

    private void isoSubpath(IsoCell[][] isoData, int r, int c, GeneralPath iso) {
        boolean numPts = false;
        int labelInterval = 30;
        side prevSide = side.NONE;
        IsoCell start = isoData[r][c];
        Point2D pt = start.normalizedPointCCW(start.firstSideCCW(prevSide));
        double x = this.getLon(c, pt.getX());
        double y = this.getLat(r, pt.getY());
        iso.moveTo(x, y);
        pt = start.normalizedPointCCW(start.secondSideCCW(prevSide));
        x = this.getLon(c, pt.getX());
        y = this.getLat(r, pt.getY());
        iso.lineTo(x, y);
        this.xPrev = x;
        this.yPrev = y;
        prevSide = start.nextCellCCW(prevSide);
        switch (prevSide) {
            case BOTTOM: {
                --r;
                break;
            }
            case LEFT: {
                --c;
                break;
            }
            case RIGHT: {
                ++c;
                break;
            }
            case TOP: {
                ++r;
            }
        }
        start.clearIso(prevSide);
        IsoCell curCell = isoData[r][c];
        while (curCell.neighborInfo != 0 && curCell.neighborInfo != 15) {
            pt = curCell.normalizedPointCCW(curCell.firstSideCCW(prevSide));
            x = this.getLon(c, pt.getX());
            y = this.getLat(r, pt.getY());
            iso.lineTo(x, y);
            this.xPrev = x;
            this.yPrev = y;
            pt = curCell.normalizedPointCCW(curCell.secondSideCCW(prevSide));
            x = this.getLon(c, pt.getX());
            y = this.getLat(r, pt.getY());
            iso.lineTo(x, y);
            this.xPrev = x;
            this.yPrev = y;
            prevSide = curCell.nextCellCCW(prevSide);
            switch (prevSide) {
                case BOTTOM: {
                    --r;
                    break;
                }
                case LEFT: {
                    --c;
                    break;
                }
                case RIGHT: {
                    ++c;
                    break;
                }
                case TOP: {
                    ++r;
                }
            }
            curCell.clearIso(prevSide);
            curCell = isoData[r][c];
        }
    }

    public HashMap<Double, ArrayList<TopoShape>> getLabels() {
        return this.labels;
    }

    private double[][] padData(double[][] data) {
        int i;
        int rows = data.length / this.skipY;
        int cols = data[0].length / this.skipX;
        double superMin = Double.NaN;
        double[][] padded = new double[rows + 2][cols + 2];
        for (i = 0; i < cols + 2; ++i) {
            padded[0][i] = superMin;
            padded[rows + 1][i] = superMin;
        }
        for (i = 0; i < rows + 2; ++i) {
            padded[i][0] = superMin;
            padded[i][cols + 1] = superMin;
        }
        for (i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                padded[i + 1][j + 1] = data[i * this.skipY][j * this.skipX];
            }
        }
        return padded;
    }

    public double ovalOfCassini(double x, double y) {
        return this.ovalOfCassini(x, y, 0.48, 0.5);
    }

    public double ovalOfCassini(double x, double y, double a, double b) {
        return (x * x + y * y + a * a) * (x * x + y * y + a * a) - 4.0 * a * a * x * x - b * b * b * b;
    }

    private void interpolateCrossing(IsoCell[][] isoData, double[][] data, int r, int c, double threshold) {
        double b;
        double a;
        IsoCell cell = isoData[r][c];
        double ll = data[r][c];
        double lr = data[r][c + 1];
        double ul = data[r + 1][c];
        double ur = data[r + 1][c + 1];
        switch (cell.getNeighborInfo()) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                a = ll;
                b = ul;
                cell.setLeft((threshold - a) / (b - a));
                break;
            }
        }
        switch (cell.getNeighborInfo()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: {
                a = ll;
                b = lr;
                cell.setBottom((threshold - a) / (b - a));
                break;
            }
        }
        switch (cell.getNeighborInfo()) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                a = ul;
                b = ur;
                cell.setTop((threshold - a) / (b - a));
                break;
            }
        }
        switch (cell.getNeighborInfo()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                a = lr;
                b = ur;
                cell.setRight((threshold - a) / (b - a));
                break;
            }
        }
    }

    private String asciiContourPrint(IsoCell[][] a) {
        int j;
        String s = "";
        int rows = a.length;
        int cols = a[0].length;
        for (j = 0; j < cols; ++j) {
            s = s + "===";
        }
        s = s + "\n";
        for (int i = rows - 1; i >= 0; --i) {
            int j2;
            block42: for (j2 = 0; j2 < cols; ++j2) {
                switch (a[i][j2].getNeighborInfo()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        s = s + "xxx";
                        continue block42;
                    }
                    case 4: {
                        s = s + "x\\ ";
                        continue block42;
                    }
                    case 5: {
                        if (a[i][j2].isFlipped()) {
                            s = s + "x\\ ";
                            continue block42;
                        }
                    }
                    case 7: {
                        s = s + "x/ ";
                        continue block42;
                    }
                    case 6: {
                        s = s + "x| ";
                        continue block42;
                    }
                    case 8: {
                        s = s + " /x";
                        continue block42;
                    }
                    case 9: {
                        s = s + " |x";
                        continue block42;
                    }
                    case 10: {
                        if (a[i][j2].isFlipped()) {
                            s = s + " /x";
                            continue block42;
                        }
                    }
                    case 11: {
                        s = s + " \\x";
                        continue block42;
                    }
                    default: {
                        s = s + "   ";
                    }
                }
            }
            s = s + "\n";
            block43: for (j2 = 0; j2 < cols; ++j2) {
                switch (a[i][j2].getNeighborInfo()) {
                    case 0: {
                        s = s + "xxx";
                        continue block43;
                    }
                    case 1: {
                        s = s + "\\xx";
                        continue block43;
                    }
                    case 2: {
                        s = s + "xx/";
                        continue block43;
                    }
                    case 3: 
                    case 12: {
                        s = s + "---";
                        continue block43;
                    }
                    case 4: {
                        s = s + "xx\\";
                        continue block43;
                    }
                    case 5: {
                        if (a[i][j2].isFlipped()) {
                            s = s + "\\x\\";
                            continue block43;
                        }
                        s = s + "/ /";
                        continue block43;
                    }
                    case 6: {
                        s = s + "x| ";
                        continue block43;
                    }
                    case 7: {
                        s = s + "/  ";
                        continue block43;
                    }
                    case 8: {
                        s = s + "/xx";
                        continue block43;
                    }
                    case 9: {
                        s = s + " |x";
                        continue block43;
                    }
                    case 10: {
                        if (a[i][j2].isFlipped()) {
                            s = s + "/x/";
                            continue block43;
                        }
                        s = s + "\\ \\";
                        continue block43;
                    }
                    case 11: {
                        s = s + "  \\";
                        continue block43;
                    }
                    case 13: {
                        s = s + "  /";
                        continue block43;
                    }
                    case 14: {
                        s = s + "\\  ";
                        continue block43;
                    }
                    case 15: {
                        s = s + "   ";
                    }
                }
            }
            s = s + "\n";
            block44: for (j2 = 0; j2 < cols; ++j2) {
                switch (a[i][j2].getNeighborInfo()) {
                    case 0: 
                    case 4: 
                    case 8: 
                    case 12: {
                        s = s + "xxx";
                        continue block44;
                    }
                    case 1: {
                        s = s + " \\x";
                        continue block44;
                    }
                    case 2: {
                        s = s + "x/ ";
                        continue block44;
                    }
                    case 3: 
                    case 7: 
                    case 11: 
                    case 15: {
                        s = s + "   ";
                        continue block44;
                    }
                    case 5: {
                        if (a[i][j2].isFlipped()) {
                            s = s + " \\x";
                            continue block44;
                        }
                        s = s + " /x";
                        continue block44;
                    }
                    case 6: {
                        s = s + "x| ";
                        continue block44;
                    }
                    case 9: {
                        s = s + " |x";
                        continue block44;
                    }
                    case 10: {
                        if (a[i][j2].isFlipped()) {
                            s = s + "x/ ";
                            continue block44;
                        }
                    }
                    case 14: {
                        s = s + "x\\ ";
                        continue block44;
                    }
                    case 13: {
                        s = s + " /x";
                    }
                }
            }
            s = s + "\n";
        }
        for (j = 0; j < cols; ++j) {
            s = s + "===";
        }
        s = s + "\n";
        return s;
    }

    public class IsoCell {
        boolean flipped = false;
        int neighborInfo;
        double left;
        double right;
        double top;
        double bottom;

        public boolean isFlipped() {
            return this.flipped;
        }

        public void setFlipped(boolean flipped) {
            this.flipped = flipped;
        }

        public int getNeighborInfo() {
            return this.neighborInfo;
        }

        public void setNeighborInfo(int neighborInfo) {
            this.neighborInfo = neighborInfo;
        }

        public Point2D normalizedPointCCW(side cellSide) {
            switch (cellSide) {
                case BOTTOM: {
                    return new Point2D.Double(this.bottom, 0.0);
                }
                case LEFT: {
                    return new Point2D.Double(0.0, this.left);
                }
                case RIGHT: {
                    return new Point2D.Double(1.0, this.right);
                }
                case TOP: {
                    return new Point2D.Double(this.top, 1.0);
                }
            }
            return null;
        }

        public side firstSideCCW(side prev) {
            switch (this.neighborInfo) {
                case 1: 
                case 3: 
                case 7: {
                    return side.LEFT;
                }
                case 2: 
                case 6: 
                case 14: {
                    return side.BOTTOM;
                }
                case 4: 
                case 11: 
                case 12: 
                case 13: {
                    return side.RIGHT;
                }
                case 8: 
                case 9: {
                    return side.TOP;
                }
                case 5: {
                    switch (prev) {
                        case LEFT: {
                            return side.RIGHT;
                        }
                        case RIGHT: {
                            return side.LEFT;
                        }
                    }
                    System.out.println(this.getClass() + ".firstSideCCW: case 5!");
                    System.exit(1);
                }
                case 10: {
                    switch (prev) {
                        case BOTTOM: {
                            return side.TOP;
                        }
                        case TOP: {
                            return side.BOTTOM;
                        }
                    }
                    System.out.println(this.getClass() + ".firstSideCCW: case 10!");
                    System.exit(1);
                }
            }
            System.out.println(this.getClass() + ".firstSideCCW: default!");
            System.exit(1);
            return null;
        }

        public side secondSideCCW(side prev) {
            switch (this.neighborInfo) {
                case 8: 
                case 12: 
                case 14: {
                    return side.LEFT;
                }
                case 1: 
                case 9: 
                case 13: {
                    return side.BOTTOM;
                }
                case 2: 
                case 3: 
                case 11: {
                    return side.RIGHT;
                }
                case 4: 
                case 6: 
                case 7: {
                    return side.TOP;
                }
                case 5: {
                    switch (prev) {
                        case LEFT: {
                            return this.flipped ? side.BOTTOM : side.TOP;
                        }
                        case RIGHT: {
                            return this.flipped ? side.TOP : side.BOTTOM;
                        }
                    }
                    System.out.println(this.getClass() + ".secondSideCCW: case 5!");
                    System.exit(1);
                }
                case 10: {
                    switch (prev) {
                        case BOTTOM: {
                            return this.flipped ? side.RIGHT : side.LEFT;
                        }
                        case TOP: {
                            return this.flipped ? side.LEFT : side.RIGHT;
                        }
                    }
                    System.out.println(this.getClass() + ".secondSideCCW: case 10!");
                    System.exit(1);
                }
            }
            System.out.println(this.getClass() + ".secondSideCCW: shouldn't be here!  Neighborinfo = " + this.neighborInfo);
            System.exit(1);
            return side.NONE;
        }

        public side nextCellCCW(side prev) {
            return this.secondSideCCW(prev);
        }

        public void clearIso(side prev) {
            switch (this.neighborInfo) {
                case 0: 
                case 5: 
                case 10: 
                case 15: {
                    break;
                }
                default: {
                    this.neighborInfo = 15;
                }
            }
        }

        public double getLeft() {
            return this.left;
        }

        public void setLeft(double left) {
            this.left = left;
        }

        public double getRight() {
            return this.right;
        }

        public void setRight(double right) {
            this.right = right;
        }

        public double getTop() {
            return this.top;
        }

        public void setTop(double top) {
            this.top = top;
        }

        public double getBottom() {
            return this.bottom;
        }

        public void setBottom(double bottom) {
            this.bottom = bottom;
        }
    }

    public static enum side {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        NONE;

    }
}

