/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.EventEditor2;
import gov.noaa.tsunami.websift.ee.LatLonChooser;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;

public class NewEventDialog
extends JDialog
implements PropertyChangeListener,
ChangeListener,
ActionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private LatLonChooser latLonChooser;
    private NumberFormat dfxxxx;
    private SeismicEvent returnValue;
    private JButton cancelButton;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JSpinner jSpinner1;
    private JPanel mapPanel;
    private JButton okButton;
    private int returnStatus = 0;

    public NewEventDialog(Frame parent, boolean modal, Image im) {
        super(parent, modal);
        this.initComponents();
        this.latLonChooser = new LatLonChooser();
        if (im == null) {
            this.latLonChooser.setImage();
        } else {
            this.latLonChooser.setImage(im);
        }
        this.latLonChooser.setSize(800, 400);
        this.latLonChooser.setStarColor(Color.YELLOW);
        this.latLonChooser.setImageCoords(new Rectangle2D.Double(0.0, -75.0, 360.0, 150.0));
        this.latLonChooser.addActionListener(this);
        this.mapPanel.add((Component)this.latLonChooser, "Center");
        this.mapPanel.setSize(this.latLonChooser.getSize());
        this.dfxxxx = NumberFormat.getNumberInstance();
        this.dfxxxx.setMinimumFractionDigits(4);
        this.jFormattedTextField1.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.dfxxxx)));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField1.addPropertyChangeListener("value", this);
        this.jFormattedTextField2.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(this.dfxxxx)));
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jFormattedTextField2.addPropertyChangeListener("value", this);
        this.pack();
        if (EventEditor2.DEBUG) {
            System.out.println("llc size: " + this.latLonChooser.getSize());
        }
        this.setLatitude(0.0);
        this.setLongitude(180.0);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner(new SpinnerNumberModel(8.5, 1.0, 15.0, 0.1));
        this.jSpinner1.setEditor(new JSpinner.NumberEditor(this.jSpinner1, "0.0"));
        this.jSpinner1.addChangeListener(this);
        this.mapPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jFormattedTextField1 = new JFormattedTextField();
        this.jLabel3 = new JLabel();
        this.jFormattedTextField2 = new JFormattedTextField();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewEventDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewEventDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewEventDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        this.jLabel1.setText("Set Magnitude:");
        this.mapPanel.setLayout(new BorderLayout());
        this.mapPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mapPanel.setPreferredSize(new Dimension(800, 400));
        this.jLabel2.setFont(new Font("Dialog", 0, 14));
        this.jLabel2.setText("Latitude:");
        this.jFormattedTextField1.setText("0.0");
        this.jLabel3.setFont(new Font("Dialog", 0, 14));
        this.jLabel3.setText("Longitude:");
        this.jFormattedTextField2.setText("0.0");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.mapPanel, -2, -1, -2).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.jSpinner1, -2, 56, -2).add(117, 117, 117)).add(layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0))).add(this.jFormattedTextField1, -2, 98, -2)).add(this.okButton, -2, 67, -2)).addPreferredGap(0).add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(0).add(this.jFormattedTextField2, -2, 103, -2)).add(this.cancelButton)))).add(13, 13, 13)));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(3).add(this.jLabel1).add(this.jSpinner1, -2, -1, -2)).addPreferredGap(0).add(this.mapPanel, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.jLabel3).add(this.jFormattedTextField2, -2, -1, -2).add(this.jFormattedTextField1, -2, -1, -2).add(this.jLabel2)).addPreferredGap(0, -1, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.okButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    public SeismicEvent showDialog() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NewEventDialog.this.returnValue = null;
            }
        });
        this.setVisible(true);
        this.dispose();
        return this.returnValue;
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
        this.returnValue = retStatus == 1 ? new SeismicEvent((Double)((SpinnerNumberModel)this.jSpinner1.getModel()).getValue(), Double.parseDouble(this.jFormattedTextField2.getText()), Double.parseDouble(this.jFormattedTextField1.getText())) : null;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new NewEventDialog((Frame)new JFrame(), true, null).setVisible(true);
            }
        });
    }

    public void setLatitude(double lat) {
        this.jFormattedTextField1.setValue(lat);
    }

    public void setLongitude(double lon) {
        this.jFormattedTextField2.setValue(lon);
    }

    public void setMagnitude(double mag) {
        this.jSpinner1.setValue(new Double(mag));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Point2D.Double pt = this.latLonChooser.getLatLon();
        this.setLongitude(pt.x);
        this.setLatitude(pt.y);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JFormattedTextField tf = (JFormattedTextField)evt.getSource();
        if (tf == this.jFormattedTextField1) {
            this.latLonChooser.getTSLocation(new Point2D.Double(((Number)this.jFormattedTextField2.getValue()).doubleValue(), ((Number)this.jFormattedTextField1.getValue()).doubleValue()));
        }
        if (tf == this.jFormattedTextField2) {
            this.latLonChooser.getTSLocation(new Point2D.Double(((Number)this.jFormattedTextField2.getValue()).doubleValue(), ((Number)this.jFormattedTextField1.getValue()).doubleValue()));
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

