/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PanZoomProblem
extends JPanel {
    private static Image image;
    private double currentX;
    private double currentY;
    private double previousX;
    private double previousY;
    private double zoom = 1.0;

    public static void main(String[] args) throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.add(new PanZoomProblem());
                frame.setSize(640, 480);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public PanZoomProblem() {
        try {
            image = ImageIO.read(this.getClass().getResource("images/world_all_4096x2048comp.jpg"));
        }
        catch (IOException ioe) {
            System.out.println("ack!");
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PanZoomProblem.this.previousX = e.getX();
                PanZoomProblem.this.previousY = e.getY();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point2D adjPreviousPoint = PanZoomProblem.this.getTranslatedPoint(PanZoomProblem.this.previousX, PanZoomProblem.this.previousY);
                Point2D adjNewPoint = PanZoomProblem.this.getTranslatedPoint(e.getX(), e.getY());
                double newX = adjNewPoint.getX() - adjPreviousPoint.getX();
                double newY = adjNewPoint.getY() - adjPreviousPoint.getY();
                PanZoomProblem.this.previousX = e.getX();
                PanZoomProblem.this.previousY = e.getY();
                PanZoomProblem.this.currentX = PanZoomProblem.this.currentX + newX;
                PanZoomProblem.this.currentY = PanZoomProblem.this.currentY + newY;
                PanZoomProblem.this.repaint();
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getScrollType() == 0) {
                    PanZoomProblem.this.incrementZoom(-0.1 * (double)e.getWheelRotation());
                }
            }
        });
        this.setOpaque(false);
    }

    private void incrementZoom(double amount) {
        this.zoom += amount;
        this.zoom = Math.max(1.0E-5, this.zoom);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        AffineTransform tx = this.getCurrentTransform();
        g2d.drawImage(image, tx, this);
        g2d.dispose();
    }

    private AffineTransform getCurrentTransform() {
        AffineTransform tx = new AffineTransform();
        double centerX = (double)this.getWidth() / 2.0;
        double centerY = (double)this.getHeight() / 2.0;
        tx.translate(centerX, centerY);
        tx.scale(this.zoom, this.zoom);
        tx.translate(this.currentX, this.currentY);
        return tx;
    }

    private Point2D getTranslatedPoint(double panelX, double panelY) {
        AffineTransform tx = this.getCurrentTransform();
        Point2D.Double point2d = new Point2D.Double(panelX, panelY);
        try {
            return tx.inverseTransform(point2d, null);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

