/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.TopoShape;
import java.awt.Color;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlateBoundaries {
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");
    private static ArrayList<TopoShape> shapeList = new ArrayList();
    private static boolean dataValid = false;

    public static boolean loadPlates(File f) {
        try {
            PlateBoundaries.parsePlates(f);
            dataValid = true;
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Can't parse kml file: " + f, ioe);
        }
        return dataValid;
    }

    public static ArrayList<TopoShape> getPlates() {
        return shapeList;
    }

    private static void parsePlates(File f) throws IOException {
        Path2D.Float greenLines = new Path2D.Float();
        Path2D.Float blueLines = new Path2D.Float();
        Path2D.Float redLines = new Path2D.Float();
        Path2D.Float whiteLines = new Path2D.Float();
        Path2D.Float pp = greenLines;
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            ArrayList<Point2D.Double> pts = new ArrayList<Point2D.Double>();
            while ((line = br.readLine()) != null) {
                if (line.contains("#LineStyle00")) {
                    pp = redLines;
                }
                if (line.contains("#LineStyle01")) {
                    pp = greenLines;
                }
                if (line.contains("#LineStyle071")) {
                    pp = blueLines;
                }
                if (line.contains("#LineStyle054")) {
                    pp = whiteLines;
                }
                if (!line.contains("<coordinates>")) continue;
                String[] sarr = line.split("\\s+");
                pts.clear();
                boolean add360 = false;
                for (String s : sarr) {
                    String[] triplet = s.split(",");
                    if (triplet.length != 3) continue;
                    try {
                        double x = Double.parseDouble(triplet[0]);
                        double y = Double.parseDouble(triplet[1]);
                        pts.add(new Point2D.Double(x, y));
                        if (!(x < 0.0)) continue;
                        add360 = true;
                    }
                    catch (NumberFormatException nfe) {
                        log.log(Level.SEVERE, "trouble parsing plates", nfe);
                    }
                }
                if (add360) {
                    for (Point2D.Double pt : pts) {
                        pt.x += 360.0;
                    }
                }
                if (pts.size() <= 0) continue;
                Point2D.Double pt = (Point2D.Double)pts.get(0);
                pp.moveTo(pt.x, pt.y);
                for (int i = 1; i < pts.size(); ++i) {
                    pt = (Point2D.Double)pts.get(i);
                    pp.lineTo(pt.x, pt.y);
                }
            }
        }
        TopoShape ts = new TopoShape(greenLines);
        ts.setDraw(true);
        ts.setDrawColor(Color.GREEN);
        shapeList.add(ts);
        ts = new TopoShape(blueLines);
        ts.setDraw(true);
        ts.setDrawColor(Color.BLUE);
        shapeList.add(ts);
        ts = new TopoShape(redLines);
        ts.setDraw(true);
        ts.setDrawColor(Color.RED);
        shapeList.add(ts);
        ts = new TopoShape(whiteLines);
        ts.setDraw(true);
        ts.setDrawColor(Color.WHITE);
        shapeList.add(ts);
    }
}

