/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Graphics;

public class PlotMark {
    protected int mark_;
    protected int tableSize_ = 51;
    protected int firstPoint_;
    protected int lastPoint_;
    protected double markHeight_;
    protected int fillMark_ = 44;
    protected boolean fill_ = false;
    protected boolean circle_ = false;
    protected static final int[][] markTable = new int[][]{{5, 9}, {11, 15}, {14, 15}, {11, 12}, {26, 31}, {32, 37}, {38, 43}, {44, 49}, {1, 5}, {64, 67}, {5, 15}, {50, 54}, {1, 9}, {55, 63}, {15, 19}, {21, 25}, {50, 53}, {51, 54}, {72, 77}, {84, 98}, {18, 22}, {11, 19}, {64, 66}, {68, 71}, {68, 70}, {78, 83}, {102, 106}, {113, 118}, {119, 124}, {125, 130}, {131, 136}, {105, 110}, {107, 112}, {137, 139}, {99, 106}, {103, 108}, {140, 144}, {140, 147}, {156, 163}, {148, 155}, {170, 183}, {184, 189}, {188, 193}, {164, 169}, {1, 5}, {64, 67}, {55, 63}, {15, 19}, {68, 71}, {164, 169}, {164, 169}};
    protected static final int[] table = new int[]{9, 41, 45, 13, 9, 45, 0, 13, 41, 0, 25, 29, 0, 11, 43, 29, 11, 25, 43, 11, 25, 29, 11, 43, 29, 18, 27, 34, 0, 27, 24, 20, 27, 36, 0, 27, 30, 20, 27, 18, 0, 3, 27, 36, 27, 34, 0, 27, 51, 41, 13, 45, 9, 41, 4, 2, 16, 32, 50, 52, 38, 22, 4, 9, 29, 41, 9, 13, 25, 45, 13, 13, 27, 31, 0, 27, 45, 9, 27, 29, 0, 27, 41, 13, 20, 18, 9, 0, 18, 34, 0, 20, 36, 0, 45, 36, 34, 41, 19, 35, 0, 21, 17, 33, 37, 21, 19, 35, 33, 17, 21, 37, 20, 29, 25, 0, 17, 33, 21, 37, 35, 19, 17, 33, 21, 37, 19, 35, 33, 17, 21, 19, 43, 0, 37, 33, 21, 37, 25, 12, 44, 0, 42, 10, 0, 17, 37, 26, 30, 0, 12, 44, 0, 8, 40, 13, 45, 0, 43, 11, 0, 9, 41, 4, 41, 30, 9, 52, 4, 12, 20, 21, 13, 12, 0, 9, 45, 0, 33, 41, 42, 34, 33, 14, 44, 10, 0, 9, 41, 0, 42, 12, 46, 0, 0, 0, 0, 0, 0, 0};

    public PlotMark(int mark) {
        this.setMark(mark);
        this.markHeight_ = 0.08;
    }

    public void setMark(int mark) {
        if (mark <= 0) {
            mark = 0;
        }
        this.fill_ = mark > this.fillMark_;
        boolean bl = this.circle_ = mark >= 50;
        if (this.circle_) {
            boolean bl2 = this.fill_ = mark == 51;
        }
        if (mark > this.tableSize_) {
            mark = this.tableSize_;
        }
        this.firstPoint_ = markTable[mark - 1][0] - 1;
        this.lastPoint_ = markTable[mark - 1][1];
        this.mark_ = mark;
    }

    public int getMark() {
        return this.mark_;
    }

    public void setMarkHeightP(double mHeight) {
        this.markHeight_ = mHeight / 8.0;
    }

    public double getMarkHeightP() {
        return this.markHeight_ * 8.0;
    }

    public void paintMark(Graphics g, int xp, int yp) {
        int xdOld = 0;
        int ydOld = 0;
        double xscl = this.markHeight_;
        double yscl = this.markHeight_;
        if (this.circle_) {
            int xt = (int)(xscl * -2.0) + xp;
            int yt = (int)(xscl * -2.0) + yp;
            int w = (int)(xscl * 4.0) - 1;
            if (this.fill_) {
                g.fillOval(xt, yt, w, w);
            } else {
                g.drawOval(xt, yt, w, w);
            }
            return;
        }
        int[] xl = new int[this.lastPoint_ - this.firstPoint_];
        int[] yl = new int[this.lastPoint_ - this.firstPoint_];
        boolean penf = false;
        int i = 0;
        for (int count = this.firstPoint_; count < this.lastPoint_; ++count) {
            int ib = table[count];
            if (ib == 0) {
                penf = false;
                continue;
            }
            int movex = (ib >> 3) - 3;
            int movey = -((ib & 7) - 3);
            int xt = (int)(xscl * (double)movex) + xp;
            int yt = (int)(yscl * (double)movey) + yp;
            if (penf) {
                if (this.fill_) {
                    xl[i] = xt;
                    yl[i] = yt;
                    ++i;
                } else {
                    g.drawLine(xdOld, ydOld, xt, yt);
                }
            }
            penf = true;
            xdOld = xt;
            ydOld = yt;
        }
        if (this.fill_) {
            g.fillPolygon(xl, yl, i);
        }
    }

    public static void main(String[] args) {
    }

    public String toString() {
        return "PlotMark: " + this.mark_;
    }
}

