/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.util.Arrays;

public class PolyPoints {
    public static final int EXPAND_COORDS = 500;
    double[] lons = new double[npoints];
    double[] lats = new double[npoints];
    public static int npoints = 100;
    private int pcount = 0;

    public void setLons(double[] lons) {
        this.lons = lons;
        this.pcount = npoints = lons.length;
    }

    public void addLonLat(double lon, double lat) {
        if (this.pcount >= npoints) {
            this.lons = PolyPoints.expandCoords(this.lons);
            this.lats = PolyPoints.expandCoords(this.lats);
            System.gc();
        }
        this.lons[this.pcount] = lon;
        this.lats[this.pcount] = lat;
        ++this.pcount;
    }

    private static double[] expandCoords(double[] oldCoords) {
        npoints = oldCoords.length + 500;
        return Arrays.copyOf(oldCoords, npoints);
    }

    public void addLons(double[] somelons) {
        if (this.lons == null) {
            this.setLons(somelons);
            return;
        }
        int aLen = this.lons.length;
        int bLen = somelons.length;
        double[] c = new double[aLen + bLen];
        System.arraycopy(this.lons, 0, c, 0, aLen);
        System.arraycopy(somelons, 0, c, aLen, bLen);
        this.lons = c;
        this.pcount = npoints = this.lons.length;
    }

    public double[] getLons() {
        return Arrays.copyOf(this.lons, this.pcount);
    }

    public void setLats(double[] lats) {
        this.lats = lats;
        this.pcount = npoints = lats.length;
    }

    public void addLats(double[] somelats) {
        if (this.lats == null) {
            this.setLats(somelats);
            return;
        }
        int aLen = this.lats.length;
        int bLen = somelats.length;
        double[] c = new double[aLen + bLen];
        System.arraycopy(this.lats, 0, c, 0, aLen);
        System.arraycopy(somelats, 0, c, aLen, bLen);
        this.lats = c;
        this.pcount = npoints = this.lats.length;
    }

    public double[] getLats() {
        return Arrays.copyOf(this.lats, this.pcount);
    }

    public int getNumberOfPoints() {
        return this.pcount;
    }
}

