/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.Component;
import java.awt.Font;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class SourceTableAlphaEditor
extends DefaultCellEditor {
    private JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
    private NumberFormatter aFormatterEdit;

    public SourceTableAlphaEditor() {
        super(new JFormattedTextField());
        NumberFormat aForEdit = NumberFormat.getNumberInstance();
        aForEdit.setMaximumFractionDigits(5);
        aForEdit.setMinimumFractionDigits(5);
        aForEdit.setMinimumIntegerDigits(1);
        this.aFormatterEdit = new NumberFormatter(aForEdit);
        this.aFormatterEdit.setCommitsOnValidEdit(true);
        this.aFormatterEdit.setAllowsInvalid(false);
        this.ftf.setColumns(10);
        this.ftf.setHorizontalAlignment(11);
        this.ftf.setFormatterFactory(new DefaultFormatterFactory(this.aFormatterEdit, this.aFormatterEdit, this.aFormatterEdit));
        this.ftf.setFocusLostBehavior(3);
        this.ftf.setFont(new Font("Lucida Grande", 0, 12));
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JFormattedTextField ftf = (JFormattedTextField)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        ftf.setValue(value);
        return ftf;
    }

    @Override
    public Object getCellEditorValue() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        Object o = ftf.getValue();
        if (o instanceof Double) {
            return o;
        }
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return null;
    }

    @Override
    public boolean stopCellEditing() {
        JFormattedTextField ftf = (JFormattedTextField)this.getComponent();
        if (ftf.isEditValid()) {
            try {
                ftf.commitEdit();
            }
            catch (ParseException parseException) {}
        } else {
            return false;
        }
        return super.stopCellEditing();
    }
}

