/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class SourceTableModel
extends AbstractTableModel {
    protected static int NUM_COLUMNS = 3;
    protected static int START_NUM_ROWS = 0;
    protected int numRows = 0;
    private int[] editableColumns = new int[]{2};
    protected Vector<UnitSource> data = null;
    private SourceCombo sourceCombo = null;
    private DecimalFormat dfx = new DecimalFormat("0.0");

    public SourceTableModel() {
        this.sourceCombo = new SourceCombo();
        this.data = this.sourceCombo.getSources();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "% Mag";
            }
            case 2: {
                return "Alpha";
            }
        }
        return "";
    }

    @Override
    public int getColumnCount() {
        return NUM_COLUMNS;
    }

    @Override
    public synchronized int getRowCount() {
        if (this.numRows < START_NUM_ROWS) {
            return START_NUM_ROWS;
        }
        return this.numRows;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        boolean isEditable = false;
        for (int i = 0; i < this.editableColumns.length; ++i) {
            if (col != this.editableColumns[i]) continue;
            isEditable = true;
        }
        return isEditable;
    }

    public void setEditableColumns(int[] ic) {
        this.editableColumns = ic;
    }

    public Class getColumnClass(int c) {
        Class cl = null;
        switch (c) {
            case 0: {
                cl = String.class;
                break;
            }
            case 1: {
                cl = String.class;
                break;
            }
            case 2: {
                cl = Double.class;
            }
        }
        return cl;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            UnitSource s = this.data.elementAt(row);
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    s.setAlpha((Double)value);
                    this.sourceCombo.sourcesChanged();
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized Object getValueAt(int row, int column) {
        try {
            UnitSource s = this.data.elementAt(row);
            switch (column) {
                case 0: {
                    return s.getName();
                }
                case 1: {
                    return this.dfx.format(s.getFraction());
                }
                case 2: {
                    return s.getAlpha();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public Vector getData() {
        return this.data;
    }

    public double getMomentMagnitude() {
        return this.sourceCombo.getMomentMagnitude();
    }

    public SourceCombo getSourceCombo() {
        return this.sourceCombo;
    }

    public void setSourceCombo(SourceCombo sc) {
        this.sourceCombo = sc;
        this.data = this.sourceCombo.getSources();
        Collections.sort(this.data);
        this.numRows = this.data.size();
        this.fireTableDataChanged();
    }

    public synchronized void addSource(UnitSource aSource) {
        if (this.data.indexOf(aSource) != -1) {
            return;
        }
        this.sourceCombo.addSource(aSource);
        Collections.sort(this.data);
        ++this.numRows;
        this.fireTableDataChanged();
    }

    public int getRow(String sourceName) {
        int ret = -1;
        for (int i = 0; i < this.numRows; ++i) {
            UnitSource us = this.data.get(i);
            if (!sourceName.equals(us.getName())) continue;
            ret = i;
        }
        return ret;
    }

    public synchronized void addSourceOld(UnitSource aSource) {
        String sn = aSource.getName();
        UnitSource p = null;
        int index = -1;
        boolean found = false;
        boolean addedRow = false;
        int i = 0;
        while (!found && i < this.numRows) {
            p = this.data.elementAt(i);
            if (p.getName().equals(sn)) {
                found = true;
                index = i;
                continue;
            }
            ++i;
        }
        if (found) {
            this.data.setElementAt(aSource, index);
            this.sourceCombo.sourcesChanged();
        } else {
            ++this.numRows;
            addedRow = true;
            index = this.numRows;
            this.sourceCombo.addSource(aSource);
        }
        if (addedRow) {
            this.fireTableRowsInserted(index, index);
        } else {
            this.fireTableRowsUpdated(index, index);
        }
    }

    public synchronized void deleteSource(String sn) {
        UnitSource p = null;
        for (int i = 0; i < this.numRows; ++i) {
            p = this.data.elementAt(i);
            if (!p.getName().equals(sn)) continue;
            this.sourceCombo.removeSource(p);
            --this.numRows;
            this.fireTableRowsDeleted(i, i);
        }
    }

    public synchronized void clear() {
        this.data.clear();
        this.fireTableRowsDeleted(1, this.numRows);
        this.numRows = 0;
    }
}

