/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StarShape
implements Shape {
    private float[] xpoints;
    private float[] ypoints;
    private double centerX;
    private double centerY;
    private double radius;
    private double innerRadius;
    private int numVertex;
    private double angle;
    private double aspectRatio;

    public StarShape(double x, double y, double r, double innerR, int vertexCount) {
        this(x, y, r, innerR, vertexCount, 0.0, 1.0);
    }

    public StarShape(double x, double y, double r, double innerR, int vertexCount, double startAngle) {
        this(x, y, r, innerR, vertexCount, startAngle, 1.0);
    }

    public StarShape(double x, double y, double r, double innerR, int vertexCount, double startAngle, double aspect) {
        this.xpoints = StarShape.getXCoordinates(x, y, r, innerR, vertexCount, startAngle, aspect);
        this.ypoints = StarShape.getYCoordinates(x, y, r, innerR, vertexCount, startAngle, aspect);
        this.centerX = x;
        this.centerY = y;
        this.radius = r;
        this.innerRadius = innerR;
        this.numVertex = vertexCount;
        this.angle = startAngle;
        this.aspectRatio = aspect;
    }

    public void setRaDius(double r) {
        this.radius = r;
        this.innerRadius = r / 2.5;
        this.xpoints = StarShape.getXCoordinates(this.centerX, this.centerY, this.innerRadius, this.radius, this.numVertex, this.angle, this.aspectRatio);
        this.ypoints = StarShape.getYCoordinates(this.centerX, this.centerY, this.innerRadius, this.radius, this.numVertex, this.angle, this.aspectRatio);
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.centerX, this.centerY);
    }

    protected static float[] getXCoordinates(double x, double y, double r, double innerR, int vertexCount, double startAngle, double aspect) {
        float[] res = new float[vertexCount * 2];
        double addAngle = Math.PI * 2 / (double)vertexCount;
        double angle = startAngle;
        double innerAngle = startAngle + Math.PI / (double)vertexCount;
        for (int i = 0; i < vertexCount; ++i) {
            res[i * 2] = (float)(r * Math.cos(angle) * aspect + x);
            angle += addAngle;
            res[i * 2 + 1] = (float)(innerR * Math.cos(innerAngle) * aspect + x);
            innerAngle += addAngle;
        }
        return res;
    }

    protected static float[] getYCoordinates(double x, double y, double r, double innerR, int vertexCount, double startAngle, double aspect) {
        float[] res = new float[vertexCount * 2];
        double addAngle = Math.PI * 2 / (double)vertexCount;
        double angle = startAngle;
        double innerAngle = startAngle + Math.PI / (double)vertexCount;
        for (int i = 0; i < vertexCount; ++i) {
            res[i * 2] = (float)(r * Math.sin(angle) + y);
            angle += addAngle;
            res[i * 2 + 1] = (float)(innerR * Math.sin(innerAngle) + y);
            innerAngle += addAngle;
        }
        return res;
    }

    @Override
    public Rectangle getBounds() {
        float xMin = Float.MAX_VALUE;
        float xMax = Float.MIN_VALUE;
        float yMin = Float.MAX_VALUE;
        float yMax = Float.MIN_VALUE;
        for (int i = 0; i < this.xpoints.length; ++i) {
            xMin = xMin < this.xpoints[i] ? xMin : this.xpoints[i];
            xMax = xMax > this.xpoints[i] ? xMax : this.xpoints[i];
            yMin = yMin < this.ypoints[i] ? yMin : this.ypoints[i];
            yMax = yMax > this.ypoints[i] ? yMax : this.ypoints[i];
        }
        return new Rectangle((int)xMin, (int)yMin, (int)(xMax - xMin), (int)(yMax - yMin));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean crossPositive(float x_a, float y_a, float x_b, float y_b, double x_d, double y_d) {
        return (x_d - (double)x_a) * (double)(y_b - y_a) - (y_d - (double)y_a) * (double)(x_b - x_a) > 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        for (int i = 0; i < this.xpoints.length - 1; ++i) {
            if (!this.crossPositive(this.xpoints[i], this.ypoints[i], this.xpoints[i + 1], this.ypoints[i + 1], x, y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new StarShapePathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new StarShapePathIterator(at);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                frame.getContentPane().setLayout(new BorderLayout());
                frame.setDefaultCloseOperation(3);
                RenderPanel renderPanel = new RenderPanel();
                renderPanel.setPreferredSize(new Dimension(50, 50));
                frame.getContentPane().add(renderPanel);
                frame.pack();
                frame.setVisible(true);
                BufferedImage bi = new BufferedImage(renderPanel.getWidth(), renderPanel.getHeight(), 2);
                Graphics2D g2 = bi.createGraphics();
                renderPanel.paintAll(g2);
                try {
                    if (ImageIO.write((RenderedImage)bi, "png", new File("./output_image.png"))) {
                        System.out.println("-- saved");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static class RenderPanel
    extends JPanel {
        private static StarShape epicenter = new StarShape(25.0, 25.0, 0.5, 0.25, 5, 0.3141592653589793);
        private static final BasicStroke thinStroke = new BasicStroke(0.5f);

        @Override
        public void paintComponent(Graphics g) {
            epicenter.setRaDius(15.0);
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.YELLOW);
            g2.fill(epicenter);
            g2.setColor(Color.BLACK);
            g2.setStroke(thinStroke);
            g2.draw(epicenter);
        }
    }

    class StarShapePathIterator
    implements PathIterator {
        AffineTransform transform;
        int index;

        public StarShapePathIterator(AffineTransform at) {
            this.transform = at;
        }

        @Override
        public int getWindingRule() {
            return 0;
        }

        @Override
        public boolean isDone() {
            return this.index > StarShape.this.xpoints.length;
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.index >= StarShape.this.xpoints.length) {
                return 4;
            }
            coords[0] = StarShape.this.xpoints[this.index];
            coords[1] = StarShape.this.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.index >= StarShape.this.xpoints.length) {
                return 4;
            }
            coords[0] = StarShape.this.xpoints[this.index];
            coords[1] = StarShape.this.ypoints[this.index];
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, 1);
            }
            return this.index == 0 ? 0 : 1;
        }
    }
}

