/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.GSHHSReader;
import gov.noaa.tsunami.websift.ee.LandMass;
import gov.noaa.tsunami.websift.ee.PolyPoints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;

public class TileCreator {
    ArrayList<PolyPoints> ppList = new ArrayList();
    BufferedImage image = null;

    public TileCreator() {
        try {
            String fn = "/Users/cmoore/tsunami/Coastline/gshhs/wdb_borders_i.b";
            ArrayList<LandMass> masses = GSHHSReader.readIt(new File(fn).toURI().toURL(), true);
            this.saveAsBorderNetCDF(masses, fn.replace(".b", ".nc"));
        }
        catch (IOException | InvalidRangeException ex) {
            ex.printStackTrace();
        }
    }

    public void saveAsNetCDF(ArrayList<Area> areas, String fn) throws IOException, InvalidRangeException {
        int type;
        int npts = 0;
        int npolys = 0;
        float[] coords = new float[2];
        for (Area a : areas) {
            PathIterator it = a.getPathIterator(null);
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                ++npts;
                if (type == 0) {
                    ++npolys;
                }
                it.next();
            }
        }
        float[] lons = new float[npts];
        float[] lats = new float[npts];
        int[] nsegs = new int[npolys];
        System.out.println("npts: " + npts + " npolys: " + npolys);
        NetcdfFileWriter nc = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, fn);
        Dimension n_ptsDim = nc.addDimension(null, "n_pts", npts);
        Dimension n_polysDim = nc.addDimension(null, "n_polys", npolys);
        AffineTransform stx = AffineTransform.getTranslateInstance(0.0, 0.0);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(n_polysDim);
        Variable nsegsVar = nc.addVariable(null, "nsegs", DataType.INT, dims);
        dims.clear();
        dims.add(n_ptsDim);
        Variable latsVar = nc.addVariable(null, "lat", DataType.FLOAT, dims);
        Variable lonsVar = nc.addVariable(null, "lon", DataType.FLOAT, dims);
        nc.create();
        int ptcount = 0;
        int polycount = -1;
        for (Area a : areas) {
            PathIterator it = a.getPathIterator(null);
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                lons[ptcount] = coords[0];
                lats[ptcount] = coords[1];
                ++ptcount;
                if (type == 0) {
                    // empty if block
                }
                int n = ++polycount;
                nsegs[n] = nsegs[n] + 1;
                it.next();
            }
        }
        nc.write(nsegsVar, Array.factory(nsegs));
        nc.write(latsVar, Array.factory(lats));
        nc.write(lonsVar, Array.factory(lons));
        nc.close();
    }

    public void saveAsBorderNetCDF(ArrayList<LandMass> areas, String fn) throws IOException, InvalidRangeException {
        int type;
        int npts = 0;
        int npolys = 0;
        float[] coords = new float[2];
        for (LandMass a : areas) {
            PathIterator it = a.getPathIterator(null);
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                ++npts;
                if (type == 0) {
                    ++npolys;
                }
                it.next();
            }
        }
        float[] lons = new float[npts];
        float[] lats = new float[npts];
        int[] nsegs = new int[npolys];
        System.out.println("npts: " + npts + " npolys: " + npolys);
        NetcdfFileWriter nc = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, fn);
        Dimension n_ptsDim = nc.addDimension(null, "n_pts", npts);
        Dimension n_polysDim = nc.addDimension(null, "n_polys", npolys);
        AffineTransform stx = AffineTransform.getTranslateInstance(0.0, 0.0);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(n_polysDim);
        Variable nsegsVar = nc.addVariable(null, "nsegs", DataType.INT, dims);
        dims.clear();
        dims.add(n_ptsDim);
        Variable latsVar = nc.addVariable(null, "lat", DataType.FLOAT, dims);
        Variable lonsVar = nc.addVariable(null, "lon", DataType.FLOAT, dims);
        nc.create();
        int ptcount = 0;
        int polycount = -1;
        for (LandMass a : areas) {
            PathIterator it = a.getPathIterator(null);
            while (!it.isDone()) {
                type = it.currentSegment(coords);
                lons[ptcount] = coords[0];
                lats[ptcount] = coords[1];
                ++ptcount;
                if (type == 0) {
                    // empty if block
                }
                int n = ++polycount;
                nsegs[n] = nsegs[n] + 1;
                it.next();
            }
        }
        nc.write(nsegsVar, Array.factory(nsegs));
        nc.write(latsVar, Array.factory(lats));
        nc.write(lonsVar, Array.factory(lons));
        nc.close();
    }

    public void readGSHHS() throws IOException {
        boolean count_polygons = false;
        boolean count_points = false;
        byte[] header = new byte[44];
        Rectangle2D.Double rec = new Rectangle2D.Double(-180.0, -60.0, 540.0, 150.0);
        File f = new File("/Volumes/big/cmoore/tsunami/Coastline/gshhs2.3.6/gshhs_i.b");
        try (FileInputStream fis = new FileInputStream(f);){
            while (44 == fis.read(header)) {
                ByteBuffer wrapped = ByteBuffer.wrap(header);
                int id = wrapped.getInt();
                int npoints = wrapped.getInt();
                int flag = wrapped.getInt();
                int mag_p = flag >> 26;
                int west = wrapped.getInt();
                int east = wrapped.getInt();
                int south = wrapped.getInt();
                int north = wrapped.getInt();
                double area = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                double area_full = (double)wrapped.getInt() / Math.pow(10.0, mag_p);
                int level = flag & 0xFF;
                int greenwich = flag >> 16 & 1;
                int nbytes = 8 * npoints;
                byte[] points = new byte[nbytes];
                if (nbytes != fis.read(points)) {
                    throw new IOException("Could not read the required bytes.");
                }
                if (level > 1 || npoints < 2 || area_full > 0.0 && area_full < 2.4) continue;
                PolyPoints pp = new PolyPoints();
                ArrayList<Double> extraLons = new ArrayList<Double>();
                ArrayList<Double> extraLats = new ArrayList<Double>();
                for (int pt = 0; pt < npoints; ++pt) {
                    double lon = (double)TileCreator.fromByteArray(points, 8 * pt) / 1000000.0;
                    double lat = (double)TileCreator.fromByteArray(points, 4 + 8 * pt) / 1000000.0;
                    double d = lon = lon < 0.0 ? lon + 360.0 : lon;
                    if (greenwich == 1 && lon > 200.0) {
                        extraLons.add(lon);
                        extraLats.add(lat);
                        lon -= 360.0;
                    }
                    pp.addLonLat(lon, lat);
                }
                if (pp.getNumberOfPoints() > 100) {
                    this.ppList.add(pp);
                }
                if (extraLons.size() <= 3) continue;
                pp = new PolyPoints();
                for (int i = 0; i < extraLons.size(); ++i) {
                    pp.addLonLat((Double)extraLons.get(i), (Double)extraLats.get(i));
                }
                this.ppList.add(pp);
            }
            fis.close();
        }
    }

    public static int fromByteArray(byte[] bytes, int offset) {
        return bytes[0 + offset] << 24 | (bytes[1 + offset] & 0xFF) << 16 | (bytes[2 + offset] & 0xFF) << 8 | bytes[3 + offset] & 0xFF;
    }

    public BufferedImage makeImage() {
        int nx = 1024;
        int ny = 512;
        double dy = 180.0 / (double)(ny - 1);
        double dx = 360.0 / (double)(nx - 1);
        double perc = 0.0;
        BufferedImage im = new BufferedImage(nx, ny, 2);
        System.out.println("creating image");
        System.out.print("percent complete:");
        for (int i = 0; i < nx; ++i) {
            double imlon = (double)i * dx;
            perc = 100.0 * (double)i / (double)nx;
            System.out.println(String.format(" %2.1f%%", perc));
            for (int j = 0; j < ny; ++j) {
                double imlat = -90.0 + (double)j * dy;
                im.setRGB(i, ny - j - 1, -1);
                for (PolyPoints pp : this.ppList) {
                    if (!this.pointInPoly(pp.getLons(), pp.getLats(), imlon, imlat)) continue;
                    im.setRGB(i, ny - j - 1, -7829368);
                }
            }
        }
        return im;
    }

    public boolean pointInPoly(double[] vx, double[] vy, double ptx, double pty) {
        int npts = vx.length;
        boolean inside = false;
        int i = 0;
        int j = npts - 1;
        while (i < npts) {
            if (vy[i] > pty != vy[j] > pty && ptx < (vx[j] - vx[i]) * (pty - vy[i]) / (vy[j] - vy[i]) + vx[i]) {
                inside = !inside;
            }
            j = i++;
        }
        return inside;
    }

    public static void main(String[] args) {
        new TileCreator();
    }
}

