/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.TopoCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class TileDownloader
implements Runnable {
    private Logger log = Logger.getLogger(TopoCanvas.class.getName());
    private static int provider = 0;
    public static final int PROVIDER_OSM = 0;
    public static final int PROVIDER_OSMHOT = 1;
    public static final int PROVIDER_ESRI_WORLD = 2;
    public static final int PROVIDER_ESRI_NATGEO = 3;
    public static final int PROVIDER_USGS_NATMAP = 4;
    public static final int PROVIDER_NASA_LANDSAT = 5;
    public static final int PROVIDER_CARTO_LIGHT = 6;
    public static final int PROVIDER_CARTO_DARK = 7;
    public static final int XY = 0;
    public static final int YX = 1;
    public static int xy = 0;
    private static String providerUrlPre = "http://b.tile.openstreetmap.org/";
    private String ext = ".png";
    private boolean isRunning = false;
    private static File cacheBaseDir = new File("tileCache");
    private static File cacheDir = new File("OSM");
    private static BufferedImage cantReachImage;
    private static Rectangle2D.Double windowExtents;
    private int tileLevel = 5;
    private static AffineTransform worldToPixel;
    private HashMap<Image, Rectangle2D.Double> newTileExtents = new HashMap();
    private HashMap<Image, AffineTransform> newTileTransforms = new HashMap();
    private TopoCanvas topoCanvas;
    private Random rand = new Random();
    private long requestTime = 0L;

    public TileDownloader(TopoCanvas topoCanvas) {
        this.topoCanvas = topoCanvas;
        cantReachImage = this.createErrorImage();
    }

    public void setTileLevel(int tileLevel) {
        this.tileLevel = tileLevel;
    }

    public void setLogger(Logger l) {
        this.log = l;
    }

    public void setCacheDir(File c) {
        cacheBaseDir = c;
    }

    public void setWorldTransform(AffineTransform at) {
        worldToPixel = at;
    }

    private BufferedImage createErrorImage() {
        BufferedImage bi = new BufferedImage(256, 256, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setPaint(Color.red);
        g2.setFont(new Font("Serif", 1, 20));
        g2.drawString("Can't reach internet", 10, 10);
        g2.dispose();
        return bi;
    }

    public HashMap<Image, Rectangle2D.Double> getTileExtents() {
        return this.newTileExtents;
    }

    public HashMap<Image, AffineTransform> getTileTransforms() {
        return this.newTileTransforms;
    }

    public String setProvider(int i, boolean cleanCache) {
        provider = i;
        String copyText = "";
        switch (provider) {
            case 0: {
                providerUrlPre = "https://b.tile.openstreetmap.org/";
                copyText = "Tiles \u00a9OpenStreetMap - NOAA";
                cacheDir = new File(cacheBaseDir, "OSM");
                this.ext = ".png";
                xy = 0;
                break;
            }
            case 1: {
                providerUrlPre = "https://b.tile.openstreetmap.fr/hot/";
                copyText = "Tiles \u00a9OpenStreetMap, Tiles courtesy of Humanitarian OpenStreetMap Team - NOAA";
                cacheDir = new File(cacheBaseDir, "OSMHOT");
                this.ext = ".png";
                xy = 0;
                break;
            }
            case 2: {
                providerUrlPre = "https://server.arcgisonline.com/ArcGIS/rest/services/World_Topo_Map/MapServer/tile/";
                copyText = "Tiles \u00a9ESRI - ESRI, DeLorme, NOAA";
                cacheDir = new File(cacheBaseDir, "ESRI_WORLD");
                this.ext = ".jpg";
                xy = 1;
                break;
            }
            case 3: {
                providerUrlPre = "https://server.arcgisonline.com/ArcGIS/rest/services/NatGeo_World_Map/MapServer/tile/";
                copyText = "Tiles \u00a9ESRI - National Geographic ESRI, DeLorme, NOAA";
                cacheDir = new File(cacheBaseDir, "ESRI_NATGEO");
                this.ext = ".jpg";
                xy = 1;
                break;
            }
            case 4: {
                providerUrlPre = "https://basemap.nationalmap.gov/arcgis/rest/services/USGSImageryOnly/MapServer/tile/";
                copyText = "Tiles \u00a9USGS - National Map";
                cacheDir = new File(cacheBaseDir, "USGS_NATMAP");
                this.ext = ".jpg";
                xy = 1;
                break;
            }
            case 5: {
                providerUrlPre = "https://gibs.earthdata.nasa.gov/wmts/epsg4326/best/Landsat_WELD_CorrectedReflectance_TrueColor_Global_Annual/default/2010-04-09/31.25m/";
                copyText = "Tiles \u00a9NASA - Landsat WELD";
                cacheDir = new File(cacheBaseDir, "NASA_WELD");
                this.ext = ".jpg";
                xy = 1;
                break;
            }
            case 6: {
                providerUrlPre = "https://cartodb-basemaps-a.global.ssl.fastly.net/light_all/";
                copyText = "Tiles \u00a9OpenStreetMap contributors, \u00a9CARTO";
                cacheDir = new File(cacheBaseDir, "CARTO_LIGHT");
                this.ext = ".png";
                xy = 1;
                break;
            }
            case 7: {
                providerUrlPre = "https://cartodb-basemaps-a.global.ssl.fastly.net/dark_all/";
                copyText = "Tiles \u00a9OpenStreetMap contributors, \u00a9CARTO";
                cacheDir = new File(cacheBaseDir, "CARTO_DARK");
                this.ext = ".png";
                xy = 1;
            }
        }
        this.log.info("Setting tile provider to: " + providerUrlPre);
        if (cleanCache) {
            this.log.info("Clearing tile cache");
            TileDownloader.deleteDir(cacheBaseDir);
        }
        if (cacheDir.mkdirs()) {
            this.log.severe("Can't make tile cache dir: " + cacheDir);
        }
        return copyText;
    }

    public int getProvider() {
        return provider;
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TileDownloader.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public String getTileUrl(int x, int y, int z) {
        String s = providerUrlPre;
        switch (provider) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                char c = (char)(this.rand.nextInt(3) + 97);
                s = s.replaceFirst("b.tile", c + ".tile");
                s = s + z + "/" + x + "/" + y + this.ext;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                s = s + z + "/" + y + "/" + x;
                break;
            }
            case 5: {
                s = s + z + "/" + y + "/" + x + this.ext;
            }
        }
        return s;
    }

    private Image loadTile(int x, int y, int z) {
        if (z > 13) {
            this.log.info("Limiting zoom level to 13");
            z = 13;
        }
        File imfile = null;
        File xydir = null;
        try {
            File zdir = new File(cacheDir, Integer.toString(z));
            zdir.mkdirs();
            if (xy == 0) {
                xydir = new File(zdir, Integer.toString(y));
                imfile = new File(xydir, x + this.ext);
            } else {
                xydir = new File(zdir, Integer.toString(x));
                imfile = new File(xydir, y + this.ext);
            }
            xydir.mkdirs();
            if (!imfile.exists()) {
                if (this.requestTime == -1L) {
                    this.requestTime = System.currentTimeMillis();
                } else {
                    while (System.currentTimeMillis() - this.requestTime < 100L) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            this.log.log(Level.WARNING, "Interrupted while waiting for image tile", e);
                        }
                    }
                    this.requestTime = System.currentTimeMillis();
                }
                URL url = new URL(this.getTileUrl(x, y, z));
                this.log.info("Downloading tile (x,y,z): " + x + ", " + y + ", " + z + " from: " + url.toString() + " to: " + imfile);
                HttpURLConnection c = (HttpURLConnection)url.openConnection();
                c.setConnectTimeout(4000);
                c.setReadTimeout(1500);
                int statusCode = c.getResponseCode();
                if (statusCode != 200) {
                    this.log.warning("problem downloading basemap tile: " + c.getResponseMessage());
                }
                ReadableByteChannel rbc = Channels.newChannel(c.getInputStream());
                FileOutputStream fos = new FileOutputStream(imfile);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                fos.getChannel().close();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignore) {
                    this.log.info("sleeeeeeepy");
                }
            }
            BufferedImage im = ImageIO.read(imfile);
            return im;
        }
        catch (IOException ioe) {
            this.log.log(Level.INFO, "Can't load tiles", ioe);
            if (imfile != null) {
                imfile.delete();
            }
            return cantReachImage;
        }
    }

    private Rectangle2D.Double getTileExtents(int x, int y, int z) {
        double west = TileDownloader.tile2lon(x, z);
        double east = TileDownloader.tile2lon(x + 1, z);
        double south = TileDownloader.tile2lat(y + 1, z);
        double north = TileDownloader.tile2lat(y, z);
        double width = east - west;
        double height = north - south;
        west = west < 0.0 ? west + 360.0 : west;
        return new Rectangle2D.Double(west, south, width, height);
    }

    @Override
    public void run() {
        int x;
        this.log.info("in tdl.run()!!!!");
        this.isRunning = true;
        this.newTileExtents = new HashMap();
        this.newTileTransforms = new HashMap();
        windowExtents = this.topoCanvas.getWindowExtents();
        this.log.info("window extents for tiles: " + windowExtents);
        int n = (int)Math.pow(2.0, this.tileLevel);
        int startx = TileDownloader.lon2tile(TileDownloader.windowExtents.x, this.tileLevel);
        int endx = TileDownloader.lon2tile(TileDownloader.windowExtents.x + TileDownloader.windowExtents.width, this.tileLevel);
        int endy = TileDownloader.lat2tile(TileDownloader.windowExtents.y, this.tileLevel);
        int starty = TileDownloader.lat2tile(TileDownloader.windowExtents.y + TileDownloader.windowExtents.height, this.tileLevel);
        int count = 0;
        ArrayList<Integer> xes = new ArrayList<Integer>();
        if (startx > endx) {
            for (x = startx; x < n; ++x) {
                xes.add(x);
            }
            for (x = 0; x <= endx; ++x) {
                xes.add(x);
            }
        } else {
            for (x = startx; x <= endx; ++x) {
                xes.add(x);
            }
        }
        this.requestTime = -1L;
        Iterator iterator = xes.iterator();
        while (iterator.hasNext()) {
            int x2 = (Integer)iterator.next();
            for (int y = starty; y <= endy; ++y) {
                Rectangle2D.Double ex = this.getTileExtents(x2, y, this.tileLevel);
                Image im = this.loadTile(x2, y, this.tileLevel);
                if (Thread.interrupted()) {
                    this.isRunning = false;
                    this.log.info("interrupted in tld.run()!!!!");
                    return;
                }
                if (im != null) {
                    this.newTileExtents.put(im, ex);
                    this.newTileTransforms.put(im, this.getImageTransform(im, ex));
                    ++count;
                }
                if (count <= 64) continue;
                this.log.info("exceeded max image count: " + count);
                this.topoCanvas.setTileImages(this.newTileExtents, this.newTileTransforms);
                return;
            }
        }
        this.log.info("added " + count + " tile images");
        this.topoCanvas.setTileImages(this.newTileExtents, this.newTileTransforms);
    }

    private AffineTransform getImageTransform(Image im, Rectangle2D.Double rec) {
        Point2D ul = new Point2D.Double(rec.x, rec.y + rec.height);
        Point2D lr = new Point2D.Double(rec.x + rec.width, rec.y);
        ul = worldToPixel.transform(ul, ul);
        lr = worldToPixel.transform(lr, lr);
        double sx = (lr.getX() - ul.getX()) / (double)im.getWidth(this.topoCanvas);
        double sy = (lr.getY() - ul.getY()) / (double)im.getHeight(this.topoCanvas);
        double tx = ul.getX();
        double ty = ul.getY();
        return new AffineTransform(sx, 0.0, 0.0, sy, tx, ty);
    }

    public static double tile2lon(int x, int z) {
        double lon = (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
        return lon;
    }

    public static double tile2lat(int y, int z) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static int lon2tile(double lon, int z) {
        int n = 1 << z;
        if (lon < 0.0) {
            return n / 2;
        }
        if (lon > 360.0) {
            return n / 2 - 1;
        }
        if (lon > 180.0) {
            lon -= 360.0;
        }
        int x = (int)Math.floor((lon + 180.0) / 360.0 * (double)n);
        return x;
    }

    public static int lat2tile(double lat, int z) {
        int n = 1 << z;
        int y = (int)Math.floor((1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0 * (double)n);
        if (lat < -90.0) {
            return n - 1;
        }
        if (lat > 90.0) {
            return 0;
        }
        return y;
    }

    static {
        worldToPixel = new AffineTransform();
    }
}

