/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.websift.ee;

import gov.noaa.tsunami.websift.ee.EventEditor2;
import gov.noaa.tsunami.websift.ee.GSHHSReader;
import gov.noaa.tsunami.websift.ee.LandMass;
import gov.noaa.tsunami.websift.ee.StarShape;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class TiledMapCanvas
extends JComponent {
    Image[][] imArray = new Image[3][3];
    private double currentX = 0.0;
    private double currentY = 0.0;
    private double previousX = 0.0;
    private double previousY = 0.0;
    private int currentTileI = 1;
    private int currentTileJ = 1;
    private int numTileI = 0;
    private int numTileJ = 0;
    private int tileImageWidth = 0;
    private int tileImageHeight = 0;
    private int imWidth = 0;
    private int imHeight = 0;
    private double[] zoom = new double[]{0.4, 0.6, 0.8, 1.0, 2.0, 4.0, 8.0, 16.0, 32.0, 64.0, 128.0};
    private int zoomLevel = 3;
    private String zoomRes = "";
    private AffineTransform worldToUser;
    private Point2D epi;
    private StarShape epicenter = new StarShape(0.0, 0.0, 15.0, 5.0, 4);
    private Color epiColor = new Color(250, 250, 15);
    private ArrayList<LandMass> massesCoast = new ArrayList();
    private ArrayList<LandMass> massesBorder = new ArrayList();
    private static final Color ColorLand = new Color(245, 202, 81);
    private Rectangle2D dateline = new Rectangle2D.Double();
    private Rectangle2D equator = new Rectangle2D.Double();
    private Rectangle2D outline = new Rectangle2D.Double();
    private static final PropagationDatabase propdb = PropagationDatabase.getInstance();
    private final ArrayList<UnitSource> boxes = new ArrayList();

    public TiledMapCanvas() {
        ImageIO.setUseCache(false);
        this.loadBackground();
        this.addMouseMotionListener(new MapMouseMotionListener());
        this.addMouseListener(new MapMouseListener());
        this.addMouseWheelListener(new MapMouseWheelListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                AffineTransform at = new AffineTransform(this.getCurrentTransform());
                at.translate(this.tileImageWidth * (this.currentTileI + i - 1), this.tileImageHeight * (this.currentTileJ + j - 1));
                g2.drawImage(this.imArray[i][j], at, null);
            }
        }
        g2.setColor(Color.RED);
        g2.draw(this.getCurrentTransform().createTransformedShape(this.outline));
        g2.draw(this.getCurrentTransform().createTransformedShape(this.dateline));
        g2.draw(this.getCurrentTransform().createTransformedShape(this.equator));
        Iterator<LandMass> iterator = this.boxes;
        synchronized (iterator) {
            for (UnitSource us : this.boxes) {
                g2.draw(this.getCurrentTransform().createTransformedShape(this.worldToUser.createTransformedShape(us)));
            }
        }
        g2.setColor(ColorLand);
        for (LandMass lm : this.massesCoast) {
            g2.draw(this.getCurrentTransform().createTransformedShape(this.worldToUser.createTransformedShape(lm)));
        }
        g2.setColor(Color.CYAN);
        for (LandMass lm : this.massesBorder) {
            g2.draw(this.getCurrentTransform().createTransformedShape(this.worldToUser.createTransformedShape(lm)));
        }
        g2.setColor(this.epiColor);
        g2.fill(this.getCurrentTransform().createTransformedShape(this.worldToUser.createTransformedShape(this.epicenter)));
        g2.setColor(Color.BLACK);
        g2.draw(this.getCurrentTransform().createTransformedShape(this.worldToUser.createTransformedShape(this.epicenter)));
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    public void loadBackground() {
        int j;
        int i;
        int startidx = this.currentTileI;
        int startjdx = this.currentTileJ;
        int count = 0;
        int oldImageHeight = this.imHeight;
        int oldImageWidth = this.imWidth;
        String test = "";
        switch (this.zoomLevel) {
            case 0: 
            case 1: 
            case 2: {
                this.numTileI = 3;
                this.numTileJ = 3;
                this.imWidth = 1350;
                this.imHeight = 675;
                this.tileImageWidth = 450;
                this.tileImageHeight = 225;
                test = "32km";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.numTileI = 9;
                this.numTileJ = 5;
                this.imWidth = 2700;
                this.imHeight = 1350;
                this.tileImageWidth = 300;
                this.tileImageHeight = 300;
                test = "16km";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.numTileI = 18;
                this.numTileJ = 9;
                this.imWidth = 5400;
                this.imHeight = 2700;
                this.tileImageWidth = 300;
                this.tileImageHeight = 300;
                test = "8km";
                break;
            }
        }
        System.out.println("here1");
        if (this.zoomRes.equals(test)) {
            return;
        }
        this.zoomRes = test;
        System.out.println(this.zoomRes);
        if (startidx <= 0) {
            startidx = 1;
        }
        if (startidx >= this.numTileI - 1) {
            startidx = this.numTileI - 1;
        }
        if (startjdx <= 0) {
            startjdx = 1;
        }
        if (startjdx >= this.numTileJ - 1) {
            startjdx = this.numTileJ - 1;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.imArray[i][j] = null;
            }
        }
        System.gc();
        try {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    count = startidx + i - 1 + this.numTileI * (startjdx + j - 1);
                    System.out.println("count: " + count);
                    if (ImageIO.getUseCache()) {
                        System.out.println("CACHING!!!!!!!!!!!!!");
                    }
                    this.imArray[i][j] = ImageIO.read(new URL(String.format("file:///Users/cmoore/tsunami/GlobalImages/BlueMarble/tiles_%s/tile_%03d.jpg", this.zoomRes, count)));
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.updateWorldTransform(this.imWidth, this.imHeight);
        this.currentX = this.currentX * (double)oldImageWidth / (double)this.imWidth;
        this.currentY = this.currentY * (double)oldImageHeight / (double)this.imHeight;
        this.outline = new Rectangle2D.Double(0.0, 0.0, this.imWidth, this.imHeight);
        this.dateline = new Rectangle2D.Double(0.0, 0.0, (double)this.imWidth / 2.0, this.imHeight);
        this.equator = new Rectangle2D.Double(0.0, 0.0, this.imWidth, (double)this.imHeight / 2.0);
    }

    public void updateWorldTransform(int imageWidth, int imageHeight) {
        double sx = (double)imageWidth / 360.0;
        double sy = -((double)imageHeight) / 180.0;
        this.worldToUser = new AffineTransform(sx, 0.0, 0.0, sy, 0.0, -90.0 * sy);
    }

    public void setLandMass(URL url) {
        this.massesCoast = GSHHSReader.readIt(url, false);
        this.repaint();
    }

    public void removeLandMass() {
        this.massesCoast = new ArrayList();
        this.repaint();
    }

    public void setBorders(URL url) {
        this.massesBorder = GSHHSReader.readIt(url, true);
        this.repaint();
    }

    public void removeBorders() {
        this.massesBorder = new ArrayList();
        this.repaint();
    }

    public void setEpicenter(double lon, double lat) {
        this.epicenter = new StarShape(lon, lat, 1.0, 0.33, 5, 1.5707963267948966);
    }

    private Point2D getTranslatedPoint(double panelX, double panelY) {
        AffineTransform tx = this.getCurrentTransform();
        Point2D.Double point2d = new Point2D.Double(panelX, panelY);
        try {
            return tx.inverseTransform(point2d, null);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private AffineTransform getCurrentTransform() {
        AffineTransform tx = new AffineTransform();
        double centerX = (double)this.getWidth() / 2.0;
        double centerY = (double)this.getHeight() / 2.0;
        tx.translate(centerX, centerY);
        tx.scale(this.zoom[this.zoomLevel], this.zoom[this.zoomLevel]);
        tx.translate(this.currentX, this.currentY);
        return tx;
    }

    public void panTo(double lon, double lat) {
        Point2D.Double pt = new Point2D.Double(lon, lat);
        this.worldToUser.transform(pt, pt);
        this.currentX = -((Point2D)pt).getX();
        this.currentY = -((Point2D)pt).getY();
        this.repaint();
    }

    private void pan(int x, int y) {
        Point2D lxy = this.getTranslatedPoint(this.previousX, this.previousY);
        Point2D xy = this.getTranslatedPoint(x, y);
        this.previousX = x;
        this.previousY = y;
        this.currentX += xy.getX() - lxy.getX();
        this.currentY += xy.getY() - lxy.getY();
        this.repaint();
    }

    public void addDatabaseLocation(String location, String proxy) {
        try {
            propdb.addDatabaseLocation(location, proxy, false);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.setSources(propdb.getUnitSources());
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSources(Collection<UnitSource> sources) {
        ArrayList<UnitSource> arrayList = this.boxes;
        synchronized (arrayList) {
            this.boxes.clear();
            this.boxes.addAll(sources);
        }
    }

    public void getCurrentFocus() {
        Point2D.Double pt = new Point2D.Double(-this.currentX, -this.currentY);
        try {
            this.worldToUser.inverseTransform(pt, pt);
        }
        catch (NoninvertibleTransformException ex) {
            ex.printStackTrace();
        }
        if (EventEditor2.DEBUG) {
            System.out.println("cx: " + -this.currentX + " cy: " + -this.currentY);
            System.out.println(" lon: " + ((Point2D)pt).getX() + " lat: " + ((Point2D)pt).getY());
        }
    }

    public void setZoomLevel(int zl) {
        if (zl < 0) {
            zl = 0;
        }
        if (zl >= this.zoom.length) {
            zl = this.zoom.length - 1;
        }
        this.zoomLevel = zl;
        if (EventEditor2.DEBUG) {
            System.out.println("zoomLevel: " + zl);
        }
        this.loadBackground();
        this.repaint();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("EventEditor");
                f.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                TiledMapCanvas tmc = new TiledMapCanvas();
                try {
                    tmc.setLandMass(new URL("file:///Users/cmoore/Downloads/test/gshhs_i.b"));
                    tmc.setBorders(new URL("file:///Users/cmoore/Downloads/test/wdb_borders_i.b"));
                }
                catch (MalformedURLException ex) {
                    ex.printStackTrace();
                }
                tmc.addDatabaseLocation("http://sift.pmel.noaa.gov/ComMIT/compressed", null);
                tmc.setEpicenter(238.0, 47.0);
                tmc.panTo(204.0, 20.0);
                f.getContentPane().add("Center", tmc);
                f.setBounds(200, 200, 800, 600);
                f.setVisible(true);
            }
        });
    }

    private class MapMouseWheelListener
    extends MouseAdapter {
        private MapMouseWheelListener() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getScrollType() == 0) {
                int ticks = e.getWheelRotation();
                TiledMapCanvas.this.setZoomLevel(TiledMapCanvas.this.zoomLevel + ticks);
            }
        }
    }

    private class MapMouseListener
    extends MouseAdapter {
        private MapMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TiledMapCanvas.this.previousX = e.getX();
            TiledMapCanvas.this.previousY = e.getY();
            try {
                Point2D pt = TiledMapCanvas.this.worldToUser.inverseTransform(TiledMapCanvas.this.getTranslatedPoint(e.getX(), e.getY()), null);
                if (EventEditor2.DEBUG && TiledMapCanvas.this.epicenter.contains(pt)) {
                    System.out.println("Epicenter clicked");
                }
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                Point2D pt = TiledMapCanvas.this.getTranslatedPoint(e.getX(), e.getY());
                TiledMapCanvas.this.currentX = -pt.getX();
                TiledMapCanvas.this.currentY = -pt.getY();
                TiledMapCanvas.this.setZoomLevel(TiledMapCanvas.this.zoomLevel + 1);
            }
        }
    }

    private class MapMouseMotionListener
    extends MouseAdapter {
        private MapMouseMotionListener() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            TiledMapCanvas.this.pan(e.getX(), e.getY());
        }
    }
}

